/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTSplashDialog;
import ro.amiq.dvt.ui.ButtonFactory;

public class DVTSplashNotification
extends PopupDialog {
    private final String icon;
    private final String title;
    private final String message;
    private final boolean hasButton;
    private Button button;
    private static DVTSplashNotification lastNotification;

    private DVTSplashNotification(Shell parentShell, String icon, String title, String message, boolean hasButton) {
        super(parentShell, 540676, false, false, false, false, false, null, null);
        this.icon = icon;
        this.title = title;
        this.message = message;
        this.hasButton = hasButton;
    }

    public int open() {
        this.create();
        this.getShell().setData("org.eclipse.e4.ui.ignoreDialog", (Object)Boolean.TRUE);
        return super.open();
    }

    protected Point getDefaultLocation(Point initialSize) {
        Shell parentShell = (Shell)this.getShell().getParent();
        if (parentShell != null) {
            Rectangle bounds = parentShell.getBounds();
            return new Point(bounds.x + bounds.width - initialSize.x - 8, bounds.y + bounds.height - initialSize.y - 36);
        }
        return super.getDefaultLocation(initialSize);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayoutFactory.fillDefaults().margins(5, 5).spacing(2, 2).applyTo(composite);
        CLabel titleLabel = new CLabel(composite, 0);
        titleLabel.setText(this.title);
        titleLabel.setFont(JFaceResources.getBannerFont());
        titleLabel.setImage(JFaceResources.getImage((String)this.icon));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)titleLabel);
        Label separator = new Label(composite, 258);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)separator);
        Text messageText = new Text(composite, 2);
        messageText.setText(this.message);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)messageText);
        if (this.hasButton) {
            this.button = ButtonFactory.INSTANCE.create(composite, 0, 0.75);
            this.button.setText("Show info...");
            this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DVTSplashDialog.show();
                }
            });
            GridDataFactory.swtDefaults().align(0x1000008, 0x1000000).indent(0, 10).applyTo((Control)this.button);
        }
        return composite;
    }

    protected Color getForeground() {
        return JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.foregroundColor");
    }

    protected Color getBackground() {
        return JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.notification.backgroundColor");
    }

    protected List<Control> getForegroundColorExclusions() {
        return this.addToExcludeList(super.getForegroundColorExclusions(), (Control)this.button);
    }

    protected List<Control> getBackgroundColorExclusions() {
        return this.addToExcludeList(super.getBackgroundColorExclusions(), (Control)this.button);
    }

    private List<Control> addToExcludeList(List<Control> list, Control control) {
        if (control != null) {
            list.add(control);
        }
        return list;
    }

    public static void show(String icon, String title, String message, boolean hasButton) {
        Display.getDefault().asyncExec(() -> {
            if (lastNotification != null) {
                lastNotification.close();
            }
            lastNotification = new DVTSplashNotification(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), icon, title, message, hasButton);
            lastNotification.open();
        });
    }

    public static void closeLast() {
        Display.getDefault().asyncExec(() -> {
            if (lastNotification != null) {
                lastNotification.close();
            }
        });
    }
}

