/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTUpdatePersistentJob
extends Job {
    private static final long SCHEDULE_DELAY = 100L;
    private final ConcurrentLinkedQueue<Runnable> fUpdateQueue;

    public DVTUpdatePersistentJob(String jobName, ConcurrentLinkedQueue<Runnable> updateQueue) {
        super(jobName);
        this.fUpdateQueue = updateQueue;
        this.setPriority(10);
        this.setSystem(true);
    }

    public boolean shouldRun() {
        if (this.fUpdateQueue.isEmpty()) {
            this.schedule(100L);
            return false;
        }
        return true;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            IWorkspaceRunnable action = ignoredMonitor -> {
                while (!this.fUpdateQueue.isEmpty()) {
                    Runnable next = this.fUpdateQueue.poll();
                    if (next == null) continue;
                    next.run();
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(action, null, 1, null);
            }
            catch (IllegalStateException illegalStateException) {
                action.run(monitor);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        this.schedule(100L);
        return Status.OK_STATUS;
    }
}

