/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.lang.reflect.Method;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.TextChangeListener;
import org.eclipse.swt.custom.TextChangedEvent;
import org.eclipse.swt.custom.TextChangingEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public enum DisableWordWrapFix {
    INSTANCE;

    private final IPartListener partListener = new IPartListener(){

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof IEditorPart) {
                DisableWordWrapFix.this.instalOnEditor((IEditorPart)part);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private final IWindowListener windowListener = new IWindowListener(){

        public void windowOpened(IWorkbenchWindow window) {
            DisableWordWrapFix.this.installOnWindow(window);
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }
    };

    public void install() {
        this.installOnWorkbench(PlatformUI.getWorkbench());
    }

    private void installOnWorkbench(IWorkbench workbench) {
        IWorkbenchWindow[] windows;
        workbench.addWindowListener(this.windowListener);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            this.installOnWindow(window);
            ++n2;
        }
    }

    private void installOnWindow(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        window.getPartService().addPartListener(this.partListener);
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference[] editorReferences;
            IWorkbenchPage workbenchPage = iWorkbenchPageArray[n2];
            IEditorReference[] iEditorReferenceArray = editorReferences = workbenchPage.getEditorReferences();
            int n3 = editorReferences.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference editor = iEditorReferenceArray[n4];
                IEditorPart editorPart = editor.getEditor(false);
                if (editorPart != null) {
                    this.instalOnEditor(editorPart);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public AbstractTextEditor getTextEditor(IEditorPart editorPart) {
        ITextEditor textEditor;
        block8: {
            try {
                if (editorPart != null) break block8;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (editorPart instanceof MultiPageEditorPart) {
            Method getActiveEditorMethod = MultiPageEditorPart.class.getDeclaredMethod("getActiveEditor", new Class[0]);
            getActiveEditorMethod.setAccessible(true);
            IEditorPart multiPageEditorPartActivePage = (IEditorPart)getActiveEditorMethod.invoke((Object)editorPart, new Object[0]);
            if (multiPageEditorPartActivePage instanceof AbstractTextEditor) {
                return (AbstractTextEditor)multiPageEditorPartActivePage;
            }
        } else if (editorPart instanceof AbstractTextEditor) {
            return (AbstractTextEditor)editorPart;
        }
        if ((textEditor = (ITextEditor)editorPart.getAdapter(ITextEditor.class)) instanceof AbstractTextEditor) {
            return (AbstractTextEditor)textEditor;
        }
        return null;
    }

    private ISourceViewer getSourceViewer(AbstractTextEditor textEditor) {
        block3: {
            try {
                if (textEditor != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Method getSourceViewerMethod = AbstractTextEditor.class.getDeclaredMethod("getSourceViewer", new Class[0]);
        getSourceViewerMethod.setAccessible(true);
        return (ISourceViewer)getSourceViewerMethod.invoke((Object)textEditor, new Object[0]);
    }

    public TextEditorAction getWordWrapAction(AbstractTextEditor textEditor) {
        if (textEditor == null) {
            return null;
        }
        IAction action = textEditor.getAction("WordWrap");
        if (action instanceof TextEditorAction) {
            return (TextEditorAction)action;
        }
        return null;
    }

    public void installWordWrapListeners(final StyledText styledText, final Action wordWrapAction) {
        final String initialToolTipText = wordWrapAction.getToolTipText();
        this.disableWordWrap(styledText, wordWrapAction, initialToolTipText);
        final TextChangeListener textChangeListener = new TextChangeListener(){

            public void textSet(TextChangedEvent event) {
                DisableWordWrapFix.this.disableWordWrap(styledText, wordWrapAction, initialToolTipText);
            }

            public void textChanged(TextChangedEvent event) {
                DisableWordWrapFix.this.disableWordWrap(styledText, wordWrapAction, initialToolTipText);
            }

            public void textChanging(TextChangingEvent event) {
            }
        };
        styledText.getContent().addTextChangeListener(textChangeListener);
        final Listener resizeListener = event -> this.disableWordWrap(styledText, wordWrapAction, initialToolTipText);
        styledText.addListener(11, resizeListener);
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                styledText.getContent().removeTextChangeListener(textChangeListener);
                styledText.removeListener(11, resizeListener);
                styledText.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    private void instalOnEditor(IEditorPart editorPart) {
        AbstractTextEditor textEditor = this.getTextEditor(editorPart);
        if (textEditor == null) {
            return;
        }
        TextEditorAction wordWrapAction = this.getWordWrapAction(textEditor);
        if (wordWrapAction == null) {
            return;
        }
        ISourceViewer sourceViewer = this.getSourceViewer(textEditor);
        if (sourceViewer == null) {
            return;
        }
        StyledText styledText = sourceViewer.getTextWidget();
        if (styledText == null) {
            return;
        }
        this.installWordWrapListeners(styledText, (Action)wordWrapAction);
    }

    private void disableWordWrap(StyledText styledText, Action wordWrapAction, String initialWordWrapToolTipMessage) {
        GC gc = null;
        try {
            gc = new GC((Drawable)styledText);
            int charCount = styledText.getCharCount();
            int lineCount = styledText.getLineCount();
            float meanCharCountPerLine = (float)charCount / (float)lineCount;
            int averageCharWidth = gc.getFontMetrics().getAverageCharWidth();
            float averageLineWidth = meanCharCountPerLine * (float)averageCharWidth;
            int editorWidth = styledText.getSize().x;
            float ratio = averageLineWidth / (float)editorWidth;
            if (ratio > 1.0f && charCount > 22000) {
                if (wordWrapAction.isChecked()) {
                    wordWrapAction.setChecked(false);
                    wordWrapAction.run();
                }
                wordWrapAction.setEnabled(false);
                wordWrapAction.setToolTipText("Toggle Word Wrap (currently disabled due to content size)");
            } else if (!wordWrapAction.isEnabled()) {
                wordWrapAction.setEnabled(true);
                wordWrapAction.setToolTipText(initialWordWrapToolTipMessage);
            }
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }
}

