/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;
import ro.amiq.dvt.utils.Utils;

public class EclipseConfigurationChecker {
    private static final String REPLACEMENT_STRING = "@@@";
    private static final String RULE_VLOG_RFDEFELEMENT_VISIT = "-XX:CompileCommand=exclude,ro/amiq/vlogdt/model/reflection/RfDefElement@@@visit";
    private static final String RULE_SWT_WIDGET_DESTROY = "-XX:CompileCommand=exclude,org/eclipse/swt/widgets/Widget@@@destroyWidget";
    private static final String RULE_E_METHOD_RULE = "-XX:CompileCommand=exclude,ro/amiq/edt/ui/editor/rules/EMethodRule@@@evaluate";
    private static final String RULE_E_COMMENT_TASK_RULE = "-XX:CompileCommand=exclude,ro/amiq/edt/ui/editor/rules/ECommentTaskRule@@@evaluate";
    private static final String RULE_VLOG_COMMENT_TASK_RULE = "-XX:CompileCommand=exclude,ro/amiq/vlogdt/ui/editor/rules/VlogCommentTaskRule@@@evaluate";
    private static final String RULE_VLOG_COMBINED_WORD_RULE = "-XX:CompileCommand=exclude,ro/amiq/vlogdt/ui/editor/rules/VlogCombinedWordRule@@@evaluate";
    private static final String RULE_VHDL_COMMENT_TASK_RULE = "-XX:CompileCommand=exclude,ro/amiq/vhdldt/ui/editor/rules/VhdlCommentTaskRule@@@evaluate";
    private static final String RULE_VLOG_PARSER = "-XX:CompileCommand=exclude,ro/amiq/vlogdt/parser/VlogParser@@@class_declaration";
    private static final String RULE_DATA_TREE_NODE = "-XX:CompileCommand=exclude,org/eclipse/core/internal/dtree/DataTreeNode@@@forwardDeltaWith";
    private static final String RULE_E_DETERMINANT_NODE = "-XX:CompileCommand=exclude,ro/amiq/edt/model/reflection/Determinant@@@contains";
    private static final String RULE_JAVA_ZIP_GET_ENTRY = "-XX:CompileCommand=exclude,java/util/zip/ZipFile@@@getEntry";
    private static final String RULE_DVT_GUI_FILTER_MATCHER = "-XX:CompileCommand=exclude,ro/amiq/dvt/ui/guifilters/DVTNamedElementGUIFilterMatcher@@@filterElement";
    private static String[] ALL_RULES = new String[]{"-XX:CompileCommand=exclude,ro/amiq/vlogdt/model/reflection/RfDefElement@@@visit", "-XX:CompileCommand=exclude,org/eclipse/swt/widgets/Widget@@@destroyWidget", "-XX:CompileCommand=exclude,org/eclipse/core/internal/dtree/DataTreeNode@@@forwardDeltaWith", "-XX:CompileCommand=exclude,ro/amiq/edt/ui/editor/rules/ECommentTaskRule@@@evaluate", "-XX:CompileCommand=exclude,ro/amiq/edt/ui/editor/rules/EMethodRule@@@evaluate", "-XX:CompileCommand=exclude,ro/amiq/vhdldt/ui/editor/rules/VhdlCommentTaskRule@@@evaluate", "-XX:CompileCommand=exclude,ro/amiq/vlogdt/ui/editor/rules/VlogCombinedWordRule@@@evaluate", "-XX:CompileCommand=exclude,ro/amiq/vlogdt/ui/editor/rules/VlogCommentTaskRule@@@evaluate", "-XX:CompileCommand=exclude,ro/amiq/vlogdt/parser/VlogParser@@@class_declaration", "-XX:CompileCommand=exclude,ro/amiq/edt/model/reflection/Determinant@@@contains", "-XX:CompileCommand=exclude,java/util/zip/ZipFile@@@getEntry", "-XX:CompileCommand=exclude,ro/amiq/dvt/ui/guifilters/DVTNamedElementGUIFilterMatcher@@@filterElement"};

    public static void excludeDirectivesInEclipseIni() {
        RuntimeMXBean RuntimemxBean = ManagementFactory.getRuntimeMXBean();
        List<String> arguments = RuntimemxBean.getInputArguments();
        StringBuilder returnMessage = new StringBuilder();
        if (!arguments.isEmpty()) {
            String[] stringArray = ALL_RULES;
            int n = ALL_RULES.length;
            int n2 = 0;
            while (n2 < n) {
                String rule = stringArray[n2];
                boolean found = false;
                for (String argument : arguments) {
                    if (!argument.matches(EclipseConfigurationChecker.getRegexString(rule))) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    returnMessage.append(EclipseConfigurationChecker.getNormalString(rule)).append("\n");
                }
                ++n2;
            }
        }
        if (returnMessage.length() > 0) {
            try {
                Display display = PlatformUI.getWorkbench().getDisplay();
                final String mess = returnMessage.toString();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        new WarningDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), mess).open();
                    }
                });
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    private static String getRegexString(String rule) {
        return rule.replace(REPLACEMENT_STRING, "(,|\\.)");
    }

    private static String getNormalString(String rule) {
        return rule.replace(REPLACEMENT_STRING, ",");
    }

    private static class WarningDialog
    extends MessageDialog {
        private static final String ECLIPSE_INI_PATH;
        private String fMessage;
        private Text fText;

        static {
            String launcherPath = System.getProperty("eclipse.launcher");
            String eclipseIniPath = "eclipse.ini";
            eclipseIniPath = launcherPath == null ? "eclipse.ini" : (launcherPath.endsWith(".exe") ? launcherPath.replace(".exe", ".ini") : (!"macosx".equals(Platform.getOS()) && EclipseUtils.isAtLeastEclipse46() ? String.valueOf(new File(launcherPath).getParentFile().getParentFile().getAbsolutePath()) + File.separatorChar + "Eclipse" + File.separatorChar + "eclipse.ini" : String.valueOf(launcherPath) + ".ini"));
            ECLIPSE_INI_PATH = eclipseIniPath;
        }

        public WarningDialog(Shell shell, String message) {
            super(shell, "Java Compiler Directives Missing!", null, "Some -XX:CompileCommand commands are missing from the eclipse.ini configuration.\n\nPlease append the following lines to '" + ECLIPSE_INI_PATH + "', after the '-vmargs' line:", 4, new String[]{"Copy to Clipboard", IDialogConstants.OK_LABEL}, 1);
            this.fMessage = message;
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 0) {
                Utils.copyToClipboard(this.fText.getText(), 3);
                return;
            }
            super.buttonPressed(buttonId);
        }

        protected Control createCustomArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new FillLayout());
            this.fText = new Text(composite, 2050);
            this.fText.setEditable(false);
            this.fText.setText(this.fMessage);
            return composite;
        }
    }
}

