/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.Arrays;
import java.util.Optional;

public enum LanguageKind {
    UNKNOWN(null, "unknown", "unknown", "unknown", "unknown", "unknown", "unknown", "unknown"),
    E("ro.amiq.edt.enature", "ro.amiq.edt.contextbuilder", "ro.amiq.edt", "e Language", "e Language", "e Language", "ro.amiq.edt.ui.editor.EEditor", "ro.amiq.edt.ui.perspectives.EDTPerspective"),
    SLN("ro.amiq.slndt.slnnature", "ro.amiq.slndt.contextbuilder", "ro.amiq.slndt", "SLN", "SLN Language", "SLN Language", "ro.amiq.slndt.ui.editor.SLNEditor", "ro.amiq.slndt.ui.perspectives.SLNDTPerspective"),
    MSDL("ro.amiq.msdldt.msdlnature", "ro.amiq.msdldt.contextbuilder", "ro.amiq.msdldt", "M-SDL", "M-SDL Language", "M-SDL Language", "ro.amiq.msdldt.ui.editor.MSDLEditor", "ro.amiq.msdldt.ui.perspectives.MSDLPerspective"),
    PSS("ro.amiq.pssdt.pssnature", "ro.amiq.pssdt.contextbuilder", "ro.amiq.pssdt", "PSS", "PSS Language", "PSS Language", "ro.amiq.pssdt.ui.editor.PSSEditor", "ro.amiq.pssdt.ui.perspectives.PSSPerspective"),
    VLOG("ro.amiq.vlogdt.VlogNature", "ro.amiq.vlogdt.VlogBuilder", "ro.amiq.vlogdt", "Verilog", "Verilog/SystemVerilog Language", "SystemVerilog", "ro.amiq.vlogdt.ui.editor.VlogEditor", "ro.amiq.vlogdt.ui.perspectives.VlogPerspective"),
    VHDL("ro.amiq.vhdldt.VhdlNature", "ro.amiq.vhdldt.VhdlBuilder", "ro.amiq.vhdldt", "VHDL", "VHDL Language", "VHDL", "ro.amiq.vhdldt.ui.editor.VhdlEditor", "ro.amiq.vhdldt.ui.perspectives.VhdlPerspective"),
    CPP("ro.amiq.dvt.cdt.cppnature", null, "ro.amiq.dvt.cdt", "C/C++", "C/C++ Language", "C/C++ Language", "org.eclipse.cdt.ui.editor.CEditor", "ro.amiq.dvt.cdt.ui.perspectives.CPPPerspective"),
    CPP_EXT("ro.amiq.dvt.cdt.cppextnature", null, "ro.amiq.dvt.cdt", "C/C++ Ext.", "C/C++ Language Extended", "C/C++ Language", "org.eclipse.cdt.ui.editor.CEditor", "ro.amiq.dvt.cdt.ui.perspectives.CPPPerspective"),
    TCL(null, null, null, "TCL", "Tool Command Language", "TCL", "org.eclipse.dltk.tcl.ui.editor.TclEditor", null),
    PF("ro.amiq.dvt.pfnature", null, null, "UPF/CPF", "UPF/CPF Language", "UPF/CPF", "ro.amiq.dvt.tcl.ui.editor.DVTTclEditor", null),
    SO(null, null, null, "Shared Object", "Shared Object", "SO", null, "ro.amiq.dvt.cdt.ui.perspectives.CPPPerspective"),
    BC(null, null, "ro.amiq.dvt", "Build Config", "Build Config", "BC", "ro.amiq.dvt.ui.editor.BuildConfigEditor", "ro.amiq.dvt.ui.perspectives.DVTPerspective");

    public final String NATURE_ID;
    public final String BUILDER_ID;
    public final String PLUGIN_ID;
    public final String DISPLAY_NAME;
    public final String LONG_NAME;
    public final String VIEW_NAME;
    public final String EDITOR_ID;
    public final String PERSPECTIVE_ID;

    private LanguageKind(String natureId, String builderId, String pluginId, String displayName, String longName, String viewName, String editorId, String perspectiveId) {
        this.NATURE_ID = natureId;
        this.BUILDER_ID = builderId;
        this.PLUGIN_ID = pluginId;
        this.DISPLAY_NAME = displayName;
        this.LONG_NAME = longName;
        this.VIEW_NAME = viewName;
        this.EDITOR_ID = editorId;
        this.PERSPECTIVE_ID = perspectiveId;
    }

    public static LanguageKind from(String natureID) {
        LanguageKind[] languageKindArray = LanguageKind.values();
        int n = languageKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageKind lk = languageKindArray[n2];
            if (lk.NATURE_ID != null && lk.NATURE_ID.equals(natureID)) {
                return lk;
            }
            ++n2;
        }
        return null;
    }

    public static LanguageKind fromEditorID(String editorID) {
        LanguageKind[] languageKindArray = LanguageKind.values();
        int n = languageKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageKind lk = languageKindArray[n2];
            if (lk.EDITOR_ID != null && lk.EDITOR_ID.equals(editorID)) {
                return lk;
            }
            ++n2;
        }
        return null;
    }

    public static LanguageKind[] valuesWithNature() {
        return (LanguageKind[])Arrays.asList(LanguageKind.values()).stream().filter(lk -> lk.NATURE_ID != null).toArray(LanguageKind[]::new);
    }

    public static LanguageKind valueWithName(String name) {
        Optional<LanguageKind> optional = Arrays.asList(LanguageKind.values()).stream().filter(lk -> lk.name().equalsIgnoreCase(name)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    public String getViewName() {
        return this.VIEW_NAME;
    }

    public String getLongName() {
        return this.LONG_NAME;
    }
}

