/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectView;

public enum MarkerSelectionManager implements ISelectionListener
{
    INSTANCE;

    private static final long TRIGGER_JOB_DELAY = 300L;
    private static final boolean INSPECT_DISABLED;
    private TriggerInspectUpdateJob job = new TriggerInspectUpdateJob();

    static {
        INSPECT_DISABLED = System.getenv("DISABLE_INSPECT_VIEW") != null;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (!(element instanceof IAdaptable)) {
            return;
        }
        IMarker marker = (IMarker)((IAdaptable)element).getAdapter(IMarker.class);
        if (marker == null) {
            return;
        }
        this.updateInspectView(marker);
    }

    private void updateInspectView(IMarker marker) {
        if (INSPECT_DISABLED) {
            return;
        }
        IResource resource = marker.getResource();
        if (resource == null) {
            return;
        }
        Map<String, Object> result = DVTInspectViewUtils.getInstance().getProblemMarkerInfo(marker);
        if (result == null) {
            return;
        }
        InspectViewUpdateEvent inspectViewEvent = new InspectViewUpdateEvent(result, resource.getProject(), false);
        this.job.cancel();
        this.job.setTriggerEvent(inspectViewEvent);
        this.job.schedule(300L);
    }

    void start() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        ISelectionService selectionService = activeWorkbenchWindow.getSelectionService();
        if (selectionService == null) {
            return;
        }
        selectionService.addSelectionListener((ISelectionListener)this);
    }

    void stop() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return;
        }
        ISelectionService selectionService = activeWorkbenchWindow.getSelectionService();
        if (selectionService == null) {
            return;
        }
        selectionService.removeSelectionListener((ISelectionListener)this);
    }

    private class TriggerInspectUpdateJob
    extends Job {
        private InspectViewUpdateEvent triggerEvent;

        public TriggerInspectUpdateJob() {
            super("Trigger Inspect Marker Update Job");
            this.triggerEvent = null;
        }

        public void setTriggerEvent(InspectViewUpdateEvent event) {
            this.triggerEvent = event;
        }

        public IStatus run(IProgressMonitor monitor) {
            if (!InspectView.isActive()) {
                return this.returnCancel();
            }
            InspectView.getInstance().update(this.triggerEvent);
            this.triggerEvent = null;
            return Status.OK_STATUS;
        }

        private IStatus returnCancel() {
            this.triggerEvent = null;
            return Status.CANCEL_STATUS;
        }
    }
}

