/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;

public class OpenLocalFileActionFix {
    private static final String ORG_ECLIPSE_UI_INTERNAL_IDE_ACTIONS_OPEN_LOCAL_FILE_ACTION = "org.eclipse.ui.internal.ide.actions.OpenLocalFileAction";
    private static final String ORG_ECLIPSE_UI_INTERNAL_PLUGIN_ACTION = "org.eclipse.ui.internal.PluginAction";
    private static final String ORG_ECLIPSE_UI_INTERNAL_W_WIN_PLUGIN_ACTION = "org.eclipse.ui.internal.WWinPluginAction";
    private static final String FILTER_PATH = "filterPath";
    private static final String ORG_ECLIPSE_UI_OPEN_LOCAL_FILE = "org.eclipse.ui.openLocalFile";
    private static final String GET_DELEGATE = "getDelegate";
    private static final String STATIC_ACTION_LIST = "staticActionList";
    private static AtomicReference<Object> openLocalFileActionReference;
    private static Field wWinPluginAction_staticActionListField;
    private static Method pluginAction_getDelegateMethod;
    private static Field openLocalFileAction_filterPathField;

    public static void setOpenLocalFilePath(IResource resource) {
        try {
            Object openLocalFileAction;
            if (openLocalFileActionReference == null) {
                openLocalFileActionReference = new AtomicReference();
                if (!OpenLocalFileActionFix.computePrerequisites()) {
                    return;
                }
                OpenLocalFileActionFix.computeAction();
            }
            if ((openLocalFileAction = openLocalFileActionReference.get()) == null) {
                return;
            }
            if (resource == null) {
                return;
            }
            if (resource instanceof IFile) {
                resource = resource.getParent();
            }
            if (!(resource instanceof IContainer)) {
                return;
            }
            String path = DVTFileUtils.getInstance().resolveAutoLinkPath(resource).toOSString();
            if (path == null) {
                return;
            }
            openLocalFileAction_filterPathField.set(openLocalFileAction, path);
        }
        catch (Throwable e) {
            openLocalFileActionReference = new AtomicReference();
            DVTLogger.INSTANCE.logError(e);
        }
    }

    private static void computeAction() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object staticActionList = wWinPluginAction_staticActionListField.get(null);
        if (!(staticActionList instanceof ArrayList)) {
            return;
        }
        for (Object action : (ArrayList)staticActionList) {
            if (!(action instanceof Action) || !ORG_ECLIPSE_UI_OPEN_LOCAL_FILE.equals(((Action)action).getId())) continue;
            openLocalFileActionReference.set(pluginAction_getDelegateMethod.invoke(action, new Object[0]));
            break;
        }
    }

    private static boolean computePrerequisites() throws ClassNotFoundException, NoSuchMethodException, SecurityException, NoSuchFieldException {
        Class<?> wWinPluginActionClass = Class.forName(ORG_ECLIPSE_UI_INTERNAL_W_WIN_PLUGIN_ACTION);
        if (wWinPluginActionClass == null) {
            DVTLogger.INSTANCE.logError("Unable to load class: org.eclipse.ui.internal.WWinPluginAction");
            return false;
        }
        wWinPluginAction_staticActionListField = wWinPluginActionClass.getDeclaredField(STATIC_ACTION_LIST);
        if (wWinPluginAction_staticActionListField == null) {
            DVTLogger.INSTANCE.logError("No field: org.eclipse.ui.internal.WWinPluginAction.staticActionList");
            return false;
        }
        wWinPluginAction_staticActionListField.setAccessible(true);
        Class<?> pluginActionClass = Class.forName(ORG_ECLIPSE_UI_INTERNAL_PLUGIN_ACTION);
        if (pluginActionClass == null) {
            DVTLogger.INSTANCE.logError("Unable to load class: org.eclipse.ui.internal.PluginAction");
            return false;
        }
        pluginAction_getDelegateMethod = pluginActionClass.getDeclaredMethod(GET_DELEGATE, new Class[0]);
        if (pluginAction_getDelegateMethod == null) {
            DVTLogger.INSTANCE.logError("No method: org.eclipse.ui.internal.PluginAction.getDelegate");
            return false;
        }
        pluginAction_getDelegateMethod.setAccessible(true);
        Class<?> openLocalFileActionClass = Class.forName(ORG_ECLIPSE_UI_INTERNAL_IDE_ACTIONS_OPEN_LOCAL_FILE_ACTION);
        if (openLocalFileActionClass == null) {
            DVTLogger.INSTANCE.logError("Unable to load class: org.eclipse.ui.internal.ide.actions.OpenLocalFileAction");
            return false;
        }
        openLocalFileAction_filterPathField = openLocalFileActionClass.getDeclaredField(FILTER_PATH);
        if (openLocalFileAction_filterPathField == null) {
            DVTLogger.INSTANCE.logError("No field: org.eclipse.ui.internal.ide.actions.OpenLocalFileAction.filterPath");
            return false;
        }
        openLocalFileAction_filterPathField.setAccessible(true);
        return true;
    }
}

