/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.projectcolors.ProjectColorUtils;

public class SplitEditorFix {
    public static void install() {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            return;
        }
        SplitPartListener pageListener = new SplitPartListener(activePage);
        pageListener.addListenerOnExistingEditors();
        activePage.addPartListener((IPartListener)pageListener);
    }

    private static class SplitPartListener
    implements IPartListener {
        private final Map<IWorkbenchPartReference, SplitPropertyListener> splitListeners = new HashMap<IWorkbenchPartReference, SplitPropertyListener>();
        private final IWorkbenchPage activePage;

        public SplitPartListener(IWorkbenchPage activePage) {
            this.activePage = activePage;
        }

        public void addListenerOnExistingEditors() {
            for (IEditorReference editorRef : Utils.getCurrentlyOpenEditorReferences()) {
                if (this.splitListeners.containsKey(editorRef)) {
                    return;
                }
                IEditorPart editor = editorRef.getEditor(false);
                if (editor == null || !(editor instanceof DVTEditor)) continue;
                SplitPropertyListener splitListener = new SplitPropertyListener((IWorkbenchPartReference)editorRef);
                editorRef.addPropertyListener((IPropertyListener)splitListener);
                this.splitListeners.put((IWorkbenchPartReference)editorRef, splitListener);
            }
        }

        public void partOpened(IWorkbenchPart part) {
            if (part == null || !(part instanceof DVTEditor)) {
                return;
            }
            IWorkbenchPartSite site = part.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPart sitePart = site.getPart();
            if (sitePart == null) {
                return;
            }
            IWorkbenchPartReference reference = this.activePage.getReference(sitePart);
            if (reference == null) {
                return;
            }
            if (this.splitListeners.containsKey(reference)) {
                return;
            }
            SplitPropertyListener splitListener = new SplitPropertyListener(reference);
            reference.addPropertyListener((IPropertyListener)splitListener);
            this.splitListeners.put(reference, splitListener);
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == null || !(part instanceof DVTEditor)) {
                return;
            }
            IWorkbenchPartSite site = part.getSite();
            if (site == null) {
                return;
            }
            IWorkbenchPart sitePart = site.getPart();
            if (sitePart == null) {
                return;
            }
            IWorkbenchPartReference reference = this.activePage.getReference(sitePart);
            if (reference == null) {
                return;
            }
            if (this.splitListeners.containsKey(reference)) {
                reference.removePropertyListener((IPropertyListener)this.splitListeners.get(reference));
                this.splitListeners.remove(reference);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    }

    private static class SplitPropertyListener
    implements IPropertyListener {
        private static final String parentClass = "org.eclipse.e4.ui.model.application.ui.basic.impl.PartSashContainerImpl";
        private static final String grandParentClass = "org.eclipse.e4.ui.model.application.ui.basic.impl.CompositePartImpl";
        private final IWorkbenchPartReference editorReference;

        public SplitPropertyListener(IWorkbenchPartReference editorReference) {
            this.editorReference = editorReference;
        }

        public void propertyChanged(Object source, int propId) {
            try {
                if (propId != 1) {
                    return;
                }
                if (!(source instanceof DVTEditor)) {
                    return;
                }
                DVTEditor editor = (DVTEditor)source;
                Method getModelMethod = ProjectColorUtils.getDeclaredMethodRecursive(this.editorReference, "getModel", new Class[0]);
                if (getModelMethod == null) {
                    return;
                }
                Object model = getModelMethod.invoke((Object)this.editorReference, new Object[0]);
                if (model == null) {
                    return;
                }
                Method getParentMethod = ProjectColorUtils.getDeclaredMethodRecursive(model, "getParent", new Class[0]);
                if (getParentMethod == null) {
                    return;
                }
                Object parent = getParentMethod.invoke(model, new Object[0]);
                if (parent == null) {
                    return;
                }
                if (!SplitPropertyListener.isClass(parent, parentClass)) {
                    return;
                }
                getParentMethod = ProjectColorUtils.getDeclaredMethodRecursive(parent, "getParent", new Class[0]);
                if (getParentMethod == null) {
                    return;
                }
                Object grandParent = getParentMethod.invoke(parent, new Object[0]);
                if (grandParent == null) {
                    return;
                }
                if (!SplitPropertyListener.isClass(grandParent, grandParentClass)) {
                    return;
                }
                Method getTransientDataMethod = ProjectColorUtils.getDeclaredMethodRecursive(grandParent, "getTransientData", new Class[0]);
                if (getTransientDataMethod == null) {
                    return;
                }
                Object transientDataObj = getTransientDataMethod.invoke(grandParent, new Object[0]);
                if (transientDataObj == null || !(transientDataObj instanceof Map)) {
                    return;
                }
                Map transientData = (Map)transientDataObj;
                transientData.put("e4_override_icon_image_key", editor.getTitleImage());
            }
            catch (Throwable t) {
                DVTLogger.INSTANCE.logError(t);
            }
        }

        private static boolean isClass(Object object, String className) {
            Class<?> objectClass = object.getClass();
            return objectClass.getName().equals(className);
        }
    }
}

