/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.altera.autoconfig;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.altera.autoconfig.AlteraFileType;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AlteraAutoconfigModel {
    private static final String NEW_LINE = System.lineSeparator();
    private static final String QUARTUS_INI = "quartus2.ini";
    private static final String VLOG_NATURE = "verilog";
    private static final String VHDL_NATURE = "vhdl";
    private static final String SV_NATURE = "systemverilog";
    private static final String VLOG_NATURE_PARAM = "-lang vlog";
    private static final String VHDL_NATURE_PARAM = "-lang vhdl";
    private static final String HOME = System.getenv("HOME");
    private static final String USERPROFILE = System.getenv("USERPROFILE");
    private static final String TMP = System.getenv("TMP");
    private static final String TEMP = System.getenv("TEMP");
    private static final Pattern LINE_SPLIT_PATTERN = Pattern.compile("\\s+\\t*");
    private String VLOG_SYNTAX_SETTINGS = "SYSTEMVERILOG_2005";
    private String VHDL_SYNTAX_SETTINGS = "VHDL_1993";
    private String LANG_PARAM = "";
    private IProject project;
    private String projectDir;
    private String revisionName;
    private String tempBuildFilePath;
    private BuildConfigParser.AutoConfigParameters parameters;
    private Map<String, List<String>> vlogFilesByConfigFile;
    private Map<String, List<String>> vhdlFilesByConfigFile;
    private Map<String, List<String>> svFilesByConfigFile;
    private List<IPath> searchPaths;
    private List<IPath> userLibraries;
    private Map<String, Queue<IPath>> qipFiles;
    private Map<String, Queue<IPath>> qsfFiles;
    private Map<String, Map<String, IPath>> searchedQipFiles;
    private Map<String, String> fGlobalAssignments;
    private Map<String, String> fInstanceAssignment;
    private Map<String, String> fLocationAssignment;
    private DVTBuildConsole buildConsole;
    private boolean isQuartusDebugEnabled;

    public AlteraAutoconfigModel(String revisionName, IProject project, String projectDir, String tempBuildFilePath, BuildConfigParser.AutoConfigParameters parameters, boolean isQuartusDebugEnabled) {
        this.project = project;
        this.projectDir = projectDir;
        this.revisionName = revisionName;
        this.tempBuildFilePath = tempBuildFilePath;
        this.parameters = parameters;
        this.isQuartusDebugEnabled = isQuartusDebugEnabled;
        this.buildConsole = DVTBuildConsoleRegistry.getConsole(this.getProject());
    }

    public boolean isQuartusDebugEnabled() {
        return this.isQuartusDebugEnabled;
    }

    public IProject getProject() {
        return this.project;
    }

    public Queue<IPath> getQipFiles(String file) {
        if (this.qipFiles == null) {
            return null;
        }
        return this.qipFiles.get(file);
    }

    public Queue<IPath> getQsfFiles(String file) {
        if (this.qsfFiles == null) {
            return null;
        }
        return this.qsfFiles.get(file);
    }

    public Map<String, IPath> getSearchedQipFiles(String file) {
        if (this.searchedQipFiles == null) {
            return null;
        }
        return this.searchedQipFiles.get(file);
    }

    public void addQipFile(IPath path, String file) {
        Queue<IPath> paths;
        if (this.qipFiles == null) {
            this.qipFiles = new LinkedHashMap<String, Queue<IPath>>();
        }
        if ((paths = this.qipFiles.get(file)) == null) {
            paths = new LinkedList<IPath>();
        }
        paths.add(path);
        this.qipFiles.put(file, paths);
    }

    public void addQsfFile(IPath path, String file) {
        Queue<IPath> paths;
        if (this.qsfFiles == null) {
            this.qsfFiles = new LinkedHashMap<String, Queue<IPath>>();
        }
        if ((paths = this.qsfFiles.get(file)) == null) {
            paths = new LinkedList<IPath>();
        }
        paths.add(path);
        this.qsfFiles.put(file, paths);
    }

    public void addSearchedQipFile(String searchedName, String file) {
        Map<String, IPath> paths;
        if (this.searchedQipFiles == null) {
            this.searchedQipFiles = new LinkedHashMap<String, Map<String, IPath>>();
        }
        if ((paths = this.searchedQipFiles.get(file)) == null) {
            paths = new LinkedHashMap<String, IPath>();
        }
        paths.put(searchedName, null);
        this.searchedQipFiles.put(file, paths);
    }

    public void addVlogFileForScript(String key, String vlogFile) {
        List<String> vlogFiles;
        if (this.vlogFilesByConfigFile == null) {
            this.vlogFilesByConfigFile = new LinkedHashMap<String, List<String>>();
        }
        if ((vlogFiles = this.vlogFilesByConfigFile.get(key)) == null) {
            vlogFiles = new ArrayList<String>();
        }
        vlogFiles.add(vlogFile);
        this.vlogFilesByConfigFile.put(key, vlogFiles);
    }

    public void addSVFileForScript(String key, String svFile) {
        List<String> svFiles;
        if (this.svFilesByConfigFile == null) {
            this.svFilesByConfigFile = new LinkedHashMap<String, List<String>>();
        }
        if ((svFiles = this.svFilesByConfigFile.get(key)) == null) {
            svFiles = new ArrayList<String>();
        }
        svFiles.add(svFile);
        this.svFilesByConfigFile.put(key, svFiles);
    }

    public void addVHDLFileForScript(String key, String vhdlFile) {
        List<String> vhdlFiles;
        if (this.vhdlFilesByConfigFile == null) {
            this.vhdlFilesByConfigFile = new LinkedHashMap<String, List<String>>();
        }
        if ((vhdlFiles = this.vhdlFilesByConfigFile.get(key)) == null) {
            vhdlFiles = new ArrayList<String>();
        }
        vhdlFiles.add(vhdlFile);
        this.vhdlFilesByConfigFile.put(key, vhdlFiles);
    }

    public void registerGlobalAssignment(String name, String value) {
        if (this.fGlobalAssignments == null) {
            this.fGlobalAssignments = new HashMap<String, String>();
        }
        this.fGlobalAssignments.put(name, value);
    }

    public void registerInstanceAssignment(String name, String value) {
        if (this.fInstanceAssignment == null) {
            this.fInstanceAssignment = new HashMap<String, String>();
        }
        this.fInstanceAssignment.put(name, value);
    }

    public void registerLocationAssignment(String name, String value) {
        if (this.fLocationAssignment == null) {
            this.fLocationAssignment = new HashMap<String, String>();
        }
        this.fLocationAssignment.put(name, value);
    }

    public void addSearchPath(IPath path) {
        if (this.searchPaths == null) {
            this.searchPaths = new LinkedList<IPath>();
        }
        this.searchPaths.add(path);
    }

    public void addUserLibraries(IPath path) {
        if (this.userLibraries == null) {
            this.userLibraries = new LinkedList<IPath>();
        }
        this.userLibraries.add(path);
    }

    public String getProjectDir() {
        return this.projectDir;
    }

    public String getBuildFilePath() {
        return this.tempBuildFilePath;
    }

    public void writeBuildFile() {
        this.getSyntaxForFiles();
        String top = this.fGlobalAssignments == null ? "" : this.fGlobalAssignments.get("TOP_LEVEL_ENTITY");
        File file = new File(this.tempBuildFilePath);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter fr = new BufferedWriter(new FileWriter(file, true));){
                StringBuilder messageVer = new StringBuilder("Writing build file...");
                DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getProject(), 6, DVTDebugKind.QUARTUS_DEBUG_INFO, this.isQuartusDebugEnabled());
                fr.write("// Generated build file - " + this.revisionName + NEW_LINE);
                if (top != null && !top.isEmpty()) {
                    fr.write(String.valueOf(NEW_LINE) + "-top " + top.trim() + NEW_LINE);
                }
                fr.write(String.valueOf(NEW_LINE) + "+dvt_prepend_init" + NEW_LINE);
                fr.write("<additional_prepend_init_directives>");
                this.writeSyntaxMappings(fr);
                this.processGlobalSettings(fr, this.buildConsole);
                this.writeSearchPathsToBuild(fr);
                this.writeBuildForNature(fr, VLOG_NATURE, this.vlogFilesByConfigFile, VLOG_NATURE_PARAM, this.buildConsole);
                this.writeBuildForNature(fr, VHDL_NATURE, this.vhdlFilesByConfigFile, VHDL_NATURE_PARAM, this.buildConsole);
                this.writeBuildForNature(fr, SV_NATURE, this.svFilesByConfigFile, VLOG_NATURE_PARAM, this.buildConsole);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void getSyntaxForFiles() {
        if (this.fGlobalAssignments == null) {
            return;
        }
        String vlogInputVersion = this.fGlobalAssignments.get("VERILOG_INPUT_VERSION");
        this.VLOG_SYNTAX_SETTINGS = vlogInputVersion != null ? vlogInputVersion : (!this.verilogFilesFound() ? "" : this.VLOG_SYNTAX_SETTINGS);
        String vhdlInputVersion = this.fGlobalAssignments.get("VHDL_INPUT_VERSION");
        this.VHDL_SYNTAX_SETTINGS = vhdlInputVersion != null ? vhdlInputVersion : (!this.vhdlFilesFound() ? "" : this.VHDL_SYNTAX_SETTINGS);
    }

    private void writeSyntaxMappings(Writer fr) throws IOException {
        StringBuilder messageVer = new StringBuilder("Writing syntax mapping to build file...");
        DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getProject(), 6, DVTDebugKind.QUARTUS_DEBUG_INFO, this.isQuartusDebugEnabled());
        if (this.VHDL_SYNTAX_SETTINGS.equals("VHDL_1987")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+VHDL_87+.vhd+.vhdl" + NEW_LINE);
        } else if (this.VHDL_SYNTAX_SETTINGS.equals("VHDL_1993")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+VHDL_93+.vhd+.vhdl" + NEW_LINE);
        } else if (this.VHDL_SYNTAX_SETTINGS.equals("VHDL_2008")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+VHDL_2008+.vhd+.vhdl" + NEW_LINE);
        }
        if (this.VLOG_SYNTAX_SETTINGS.equals("SYSTEMVERILOG_2005")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+SystemVerilog+.v+.vh+.vp+.vs+.vsh+.v95+.v95p+.sv+.svh+.svp+.svi+.sva" + NEW_LINE);
        } else if (this.VLOG_SYNTAX_SETTINGS.equals("VERILOG_1995")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+Verilog_95++.v+.vh+.vp+.vs+.vsh+.v95+.v95p+.sv+.svh+.svp+.svi+.sva" + NEW_LINE);
        } else if (this.VLOG_SYNTAX_SETTINGS.equals("VERILOG_2001")) {
            fr.write(String.valueOf(NEW_LINE) + "+dvt_ext_map+Verilog_2001+.v+.vh+.vp+.vs+.vsh+.v95+.v95p+.sv+.svh+.svp+.svi+.sva" + NEW_LINE);
        }
    }

    private void processGlobalSettings(Writer fr, DVTBuildConsole buildConsole) throws IOException {
        File file;
        if (!this.verilogFilesFound()) {
            return;
        }
        StringBuilder messageVer = new StringBuilder("Writing global settings to build file...");
        DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getProject(), 6, DVTDebugKind.QUARTUS_DEBUG_INFO, this.isQuartusDebugEnabled());
        fr.write(String.valueOf(NEW_LINE) + "// -------------------------- Included global library paths -------------------------" + NEW_LINE);
        fr.write("+libext+.v+.sv" + NEW_LINE);
        fr.write("-y $QUARTUS_ROOTDIR/eda/sim_lib" + NEW_LINE);
        File file2 = file = HOME != null ? Path.fromOSString((String)HOME).append(".altera.quartus").append(QUARTUS_INI).toFile() : null;
        if (file != null && file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        File file3 = file = HOME != null ? Path.fromOSString((String)HOME).append(QUARTUS_INI).toFile() : null;
        if (file != null && file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        File file4 = file = USERPROFILE != null ? Path.fromOSString((String)USERPROFILE).append(QUARTUS_INI).toFile() : null;
        if (file != null && file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        File file5 = file = TMP != null ? Path.fromOSString((String)TMP).append(QUARTUS_INI).toFile() : null;
        if (file != null && file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        File file6 = file = TEMP != null ? Path.fromOSString((String)TEMP).append(QUARTUS_INI).toFile() : null;
        if (file != null && file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        file = Path.fromOSString((String)"C:/").append(QUARTUS_INI).toFile();
        if (file.exists()) {
            this.writeGlobalSettings(file, fr, buildConsole);
            return;
        }
        buildConsole.print("No global settings file found!");
    }

    private void writeGlobalSettings(File file, Writer fr, DVTBuildConsole buildConsole) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                if (!this.verilogFilesFound()) {
                    return;
                }
                buildConsole.print("Processing global settings");
                String line = "";
                while ((line = reader.readLine()) != null) {
                    String[] globalUserLibrariesLines;
                    String globalUserLibraries;
                    String[] lineSplit;
                    if (!line.contains("USER_LIBRARIES") || (lineSplit = DVTStringUtil.split(LINE_SPLIT_PATTERN, line)) == null || line.length() < 3 || (globalUserLibraries = lineSplit[2]) == null || (globalUserLibrariesLines = globalUserLibraries.split(";")) == null) continue;
                    String[] stringArray = globalUserLibrariesLines;
                    int n = globalUserLibrariesLines.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String globalLibray = stringArray[n2];
                        if (!globalLibray.trim().isEmpty()) {
                            fr.write("-y " + globalLibray + NEW_LINE);
                        }
                        ++n2;
                    }
                }
                fr.write(String.valueOf(NEW_LINE) + NEW_LINE);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void writeSearchPathsToBuild(Writer fr) throws IOException {
        if (!this.verilogFilesFound() || this.searchPaths == null) {
            return;
        }
        StringBuilder messageVer = new StringBuilder("Writing search paths to build file...");
        DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getProject(), 6, DVTDebugKind.QUARTUS_DEBUG_INFO, this.isQuartusDebugEnabled());
        fr.write("// -------------------------- Included project library paths -------------------------" + NEW_LINE);
        for (IPath file : this.searchPaths) {
            this.writePathToBuild(fr, file, true, false);
        }
        fr.write(NEW_LINE);
    }

    private void writePathToBuild(Writer fr, IPath file, boolean searchPath, boolean natureFile) throws IOException {
        String path;
        String string = path = file.isAbsolute() ? file.toOSString() : Path.fromOSString((String)this.projectDir).append(file).toOSString();
        if (searchPath) {
            this.writeSearchPath(fr, path);
        }
        if (natureFile) {
            this.writeNatureFile(fr, path);
        }
    }

    private void writeSearchPath(Writer fr, String path) throws IOException {
        if (path.contains(" ")) {
            fr.write("-y \"" + path + "\"" + NEW_LINE);
        } else {
            fr.write("-y " + path + NEW_LINE);
        }
    }

    private void writeBuildForNature(Writer fr, String nature, Map<String, List<String>> libraryToFilesMap, String natureParam, DVTBuildConsole buildConsole) throws IOException {
        if (libraryToFilesMap == null) {
            buildConsole.print("No " + nature + " files found");
            return;
        }
        if (libraryToFilesMap.isEmpty()) {
            buildConsole.print("No " + nature + " files found");
            return;
        }
        StringBuilder messageVer = new StringBuilder("Writing ").append(nature).append(" files to build file...");
        DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getProject(), 6, DVTDebugKind.QUARTUS_DEBUG_INFO, this.isQuartusDebugEnabled());
        this.LANG_PARAM = String.valueOf(this.LANG_PARAM) + " " + natureParam;
        fr.write(String.valueOf(NEW_LINE) + "// -------------------------- " + nature + " files --------------------------" + NEW_LINE);
        ArrayList<String> libraries = new ArrayList<String>(libraryToFilesMap.keySet());
        Collections.sort(libraries);
        for (String lib : libraries) {
            fr.write("+dvt_init -work " + lib + NEW_LINE);
            LinkedHashSet uniqueFiles = new LinkedHashSet(libraryToFilesMap.get(lib));
            for (String file : uniqueFiles) {
                IPath natureFile = Path.fromOSString((String)file);
                this.writePathToBuild(fr, natureFile, false, true);
            }
            fr.write(NEW_LINE);
        }
        fr.write(NEW_LINE);
    }

    private void writeNatureFile(Writer fr, String natFile) throws IOException {
        if (natFile.contains(" ")) {
            fr.write("\"" + Paths.get(natFile, new String[0]).normalize() + "\"" + NEW_LINE);
        } else {
            fr.write(Paths.get(natFile, new String[0]).normalize() + NEW_LINE);
        }
    }

    private boolean verilogFilesFound() {
        return this.vlogFilesByConfigFile != null && !this.vlogFilesByConfigFile.isEmpty() || this.svFilesByConfigFile != null && !this.svFilesByConfigFile.isEmpty();
    }

    private boolean vhdlFilesFound() {
        return this.vhdlFilesByConfigFile != null && !this.vhdlFilesByConfigFile.isEmpty();
    }

    public String getAutoconfigResult() {
        try {
            String quartusRootdirDirective = AutoConfig.getQuartusRootdirDirective(this.parameters.invocation);
            if (!quartusRootdirDirective.isEmpty()) {
                this.parameters.reuseText = String.valueOf(this.parameters.reuseText) + NEW_LINE + quartusRootdirDirective + NEW_LINE;
            }
            String autoconfigContent = new String(Files.readAllBytes(Paths.get(this.tempBuildFilePath, new String[0])));
            autoconfigContent = autoconfigContent.replace("<additional_prepend_init_directives>", this.parameters.reuseText);
            return autoconfigContent;
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public Queue<IPath> getAlteraFiles(String file, AlteraFileType fileType) {
        switch (fileType) {
            case QIP_FILE: {
                return this.getQipFiles(file);
            }
            case QSF_FILE: {
                return this.getQsfFiles(file);
            }
        }
        return null;
    }

    public boolean reportErrorsToConsole() {
        return this.isQuartusDebugEnabled;
    }
}

