/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.altera.autoconfig;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigModel;
import ro.amiq.dvt.altera.autoconfig.AlteraFileType;
import ro.amiq.dvt.altera.autoconfig.DVTQuartusCommandType;
import ro.amiq.dvt.altera.autoconfig.DVTQuartusMonitorFileVisitor;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.problems.Severity;
import ro.amiq.dvt.model.problems.TclProblemKinds;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import tcl.lang.TclException;

public class AlteraAutoconfigTCLInterp
extends DVTTclInterp {
    private static final String QUARTUS_QSF_PATH_VAR = "::quartus(qsf_path)";
    private static final String QUARTUS_QIP_PATH_VAR = "::quartus(qip_path)";
    private IProject project;
    private AlteraAutoconfigModel model;
    private String alteraCurrentInterpretedFile = "";

    public AlteraAutoconfigTCLInterp(IProgressMonitor monitor, IProject project, AlteraAutoconfigModel model) {
        super(monitor);
        this.project = project;
        this.model = model;
    }

    public void processFile(String file, String path, BuildConfigParser.AutoConfigParameters parameters) {
        try {
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(this.getProject());
            buildConsole.print("Processing file " + (new File(file).isAbsolute() ? file : Path.fromOSString((String)path).append(file)));
            this.evalDVTScript(file, path, this.project);
            Map<String, IPath> searchedQipFiles = this.model.getSearchedQipFiles(file);
            String compilationRoot = BuildConfigManager.getCompilationRoot(this.project, parameters.invocation);
            List<String> qipSearchPaths = BuildConfigManager.getAlteraAutoconfigQipSearchPaths(this.project, parameters.invocation);
            if (qipSearchPaths != null && !qipSearchPaths.isEmpty()) {
                if (searchedQipFiles != null && !searchedQipFiles.isEmpty()) {
                    this.addSeachedQipFiles(file, searchedQipFiles, qipSearchPaths, compilationRoot);
                }
                if (searchedQipFiles != null) {
                    for (String qipFile : searchedQipFiles.keySet()) {
                        if (this.monitor.isCanceled()) {
                            return;
                        }
                        String activeBuildConfig = BuildConfigManager.getActiveBuildConfigRelPath(this.project);
                        buildConsole.print("*** Warning: The following .qip file couldn't be found:\n\t" + qipFile + ".qip" + System.lineSeparator() + "Either manually specify it " + activeBuildConfig + " using:\n\t" + "+dvt_autoconfig_quartus_qip+/path/to/qip_dir/" + file + ".qip\n" + "or add the appropriate search directory in " + activeBuildConfig + " using:\n\t" + "+dvt_autoconfig_quartus_qip_search_path+/path/to/qip_dir \n");
                    }
                }
            }
            this.processAlteraFiles(file, path, parameters, AlteraFileType.QSF_FILE);
            this.processAlteraFiles(file, path, parameters, AlteraFileType.QIP_FILE);
        }
        catch (IOException e) {
            String message = "DVTTclInterp: " + e.getMessage();
            DVTTclUtils.printToConsole(message, this.getProject(), this.getBuildKind(), DVTDebugKind.TCL_ERROR, false);
        }
    }

    public void printProgress(DVTBuildConsole buildConsole, String message) {
        buildConsole.print(String.valueOf(message) + "\n");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processAlteraFiles(String parentConfigFile, String path, BuildConfigParser.AutoConfigParameters parameters, AlteraFileType fileType) {
        try {
            Queue<IPath> alteraFiles = this.model.getAlteraFiles(parentConfigFile, fileType);
            if (alteraFiles == null) {
                return;
            }
            while (true) {
                if (alteraFiles.isEmpty()) {
                    return;
                }
                IPath alteraFile = alteraFiles.poll();
                IPath fileFullPath = alteraFile.toFile().isAbsolute() ? alteraFile : Path.fromOSString((String)path).append(alteraFile);
                IPath parentDir = fileFullPath.removeLastSegments(1);
                String alteraFileName = alteraFile.lastSegment();
                this.setVar(this.getVariableName(fileType), parentDir.toOSString(), 131072);
                this.setAlteraCurrentInterpretedFile(alteraFileName);
                this.processFile(alteraFile.toOSString(), path, parameters);
            }
        }
        catch (TclException e) {
            String message = "DVTTclInterp: " + e.getMessage();
            DVTTclUtils.printToConsole(message, this.getProject(), this.getBuildKind(), DVTDebugKind.TCL_ERROR, false);
        }
    }

    private void addSeachedQipFiles(String parentFile, Map<String, IPath> searchedQipFiles, List<String> qipSearchPaths, String compilationRoot) throws IOException {
        Set<String> searchedFilesNames = searchedQipFiles.keySet();
        if (searchedFilesNames == null || searchedFilesNames.isEmpty()) {
            return;
        }
        DVTQuartusMonitorFileVisitor visitor = new DVTQuartusMonitorFileVisitor(parentFile, Path.fromOSString((String)compilationRoot), searchedQipFiles, this.model, this.monitor);
        DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(this.getProject());
        String messagePrefix = "Searching for the following qip files: ";
        buildConsole.print(String.valueOf(messagePrefix) + searchedFilesNames.stream().limit(5L).collect(Collectors.joining(", ")) + (searchedQipFiles.size() > 5 ? ", ..." : ""));
        DVTLogger.INSTANCE.logInfo(String.valueOf(messagePrefix) + searchedFilesNames.stream().collect(Collectors.joining(", ")));
        for (String qipSearchPath : qipSearchPaths) {
            if (this.monitor.isCanceled()) {
                return;
            }
            if ("COMPILATION_ROOT".equals(qipSearchPath)) {
                qipSearchPath = compilationRoot;
            }
            if (searchedQipFiles.isEmpty()) {
                return;
            }
            Files.walkFileTree(Paths.get(qipSearchPath, new String[0]), EnumSet.noneOf(FileVisitOption.class), Integer.MAX_VALUE, visitor);
            Iterator<Map.Entry<String, IPath>> it = searchedQipFiles.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IPath> entry = it.next();
                IPath qipPath = entry.getValue();
                if (qipPath == null) continue;
                this.model.addQipFile(qipPath, parentFile);
                it.remove();
            }
        }
    }

    @Override
    protected boolean validateInitialConditions() {
        return this.model != null;
    }

    @Override
    protected void addCommands() {
        DVTQuartusCommandType[] dVTQuartusCommandTypeArray = DVTQuartusCommandType.values();
        int n = dVTQuartusCommandTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DVTQuartusCommandType command = dVTQuartusCommandTypeArray[n2];
            this.addCommand(command.makeCommand(this.model));
            ++n2;
        }
    }

    @Override
    protected void postEvalScriptActions() {
    }

    @Override
    protected void addTCLProblem(String message, int lineNumber, String fileName) {
        if (this.model == null) {
            return;
        }
        DVTProblem prob = new DVTProblem(this.model.getProject(), TclProblemKinds.TCL_GENERIC, fileName, false, lineNumber + 1, message);
        prob.setSeverity(Severity.ERROR);
        prob.setToConsole(true);
        DVTProblemManager.getInstance().reportProblem(prob);
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    @Override
    public int getBuildKind() {
        return 6;
    }

    @Override
    public void handleException(Exception e, String filePath, int errorLine, String message) {
    }

    public String getVariableName(AlteraFileType fileType) {
        switch (fileType) {
            case QIP_FILE: {
                return QUARTUS_QIP_PATH_VAR;
            }
            case QSF_FILE: {
                return QUARTUS_QSF_PATH_VAR;
            }
        }
        return "";
    }

    public String getAlteraCurrentInterpretedFile() {
        return this.alteraCurrentInterpretedFile;
    }

    public void setAlteraCurrentInterpretedFile(String scriptPath) {
        this.alteraCurrentInterpretedFile = scriptPath;
    }

    @Override
    public boolean isDebugMode() {
        return this.model == null ? false : this.model.isQuartusDebugEnabled();
    }
}

