/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.altera.autoconfig;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigModel;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;

public class DVTQuartusMonitorFileVisitor
implements FileVisitor<java.nio.file.Path> {
    static final String QIP_SUFFIX = ".qip";
    private final IProgressMonitor monitor;
    private IPath pathToRelativizeTo;
    private Map<String, IPath> searchedQipFiles;
    private AlteraAutoconfigModel model;
    private String parentFile;
    private Set<java.nio.file.Path> visited;

    DVTQuartusMonitorFileVisitor(String parentFile, IPath pathToRelativizeTo, Map<String, IPath> searchedQipFiles, AlteraAutoconfigModel model, IProgressMonitor monitor) {
        this.pathToRelativizeTo = pathToRelativizeTo;
        this.searchedQipFiles = searchedQipFiles;
        this.model = model;
        this.parentFile = parentFile;
        this.monitor = monitor;
        this.visited = new HashSet<java.nio.file.Path>();
    }

    @Override
    public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.visited.contains(dir)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        this.visited.add(dir);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
        if (this.monitor.isCanceled()) {
            return FileVisitResult.TERMINATE;
        }
        if (file == null) {
            return FileVisitResult.CONTINUE;
        }
        String fileName = file.toString();
        if (!fileName.endsWith(QIP_SUFFIX)) {
            return FileVisitResult.CONTINUE;
        }
        IPath path = Path.fromOSString((String)fileName);
        String name = path.removeFileExtension().lastSegment();
        if (this.searchedQipFiles.containsKey(name)) {
            IPath pathToQip = path.makeRelativeTo(this.pathToRelativizeTo);
            this.searchedQipFiles.put(name, pathToQip);
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(this.model.getProject());
            buildConsole.print("Found qip file: " + path + " included by " + this.parentFile);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

