/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.altera.autoconfig;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigCommand;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigTCLInterp;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.tcl.model.DVTCommandResult;
import ro.amiq.dvt.tcl.model.DVTDebugKind;
import ro.amiq.dvt.tcl.model.DVTTclInterp;
import ro.amiq.dvt.tcl.model.DVTTclUtils;
import ro.amiq.dvt.tcl.model.IDVTCommandType;
import tcl.lang.TclException;
import tcl.lang.TclObject;

public class DVTQuartusSetGlobalAssignment
extends AlteraAutoconfigCommand {
    private static final String VHDL_INPUT_VERSION = "VHDL_INPUT_VERSION";
    private static final String VERILOG_INPUT_VERSION = "VERILOG_INPUT_VERSION";
    private static final String VHDL_FILE = "VHDL_FILE";
    private static final String SYSTEMVERILOG_FILE = "SYSTEMVERILOG_FILE";
    private static final String VERILOG_FILE = "VERILOG_FILE";
    private static final String QIP_FILE = "QIP_FILE";
    private static final String IP_FILE = "IP_FILE";
    private static final String PBIP_FILE = "PBIP_FILE";
    private static final String QSYS_FILE = "QSYS_FILE";
    private static final String USER_LIBRARIES = "USER_LIBRARIES";
    private static final String SEARCH_PATH = "SEARCH_PATH";
    private static final String TOP_LEVEL_ENTITY = "TOP_LEVEL_ENTITY";
    private static final String WORK = "work";
    private static final String LIBRARY = "library";
    private static final String NAME = "name";

    protected DVTQuartusSetGlobalAssignment(IDVTCommandType type) {
        super(type);
    }

    @Override
    public void dvtCmdProc(DVTTclInterp interp, TclObject[] objv) throws TclException {
        if (this.args == null || this.args.length == 0) {
            return;
        }
        DVTBuildConsoleRegistry.getConsole(this.getModel().getProject());
        DVTCommandResult commandArguments = this.parseCommandArguments();
        if (commandArguments == null) {
            return;
        }
        String commandArg = commandArguments.getCommandArg();
        if (commandArg == null) {
            return;
        }
        StringBuilder messageVer = new StringBuilder("set_global_assignment ").append(commandArguments.getOptionValue(NAME)).append(" ").append(commandArg).append(" ...");
        if (TOP_LEVEL_ENTITY.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            this.getModel().registerGlobalAssignment(TOP_LEVEL_ENTITY, commandArg);
        } else if (SEARCH_PATH.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            this.getModel().addSearchPath(Path.fromOSString((String)commandArg));
        } else if (USER_LIBRARIES.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            this.getModel().addUserLibraries(Path.fromOSString((String)commandArg));
        } else if (QIP_FILE.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            this.getModel().addQipFile(Path.fromOSString((String)commandArg), ((AlteraAutoconfigTCLInterp)interp).getAlteraCurrentInterpretedFile());
        } else if (IP_FILE.equals(commandArguments.getOptionValue(NAME)) || PBIP_FILE.equals(commandArguments.getOptionValue(NAME)) || QSYS_FILE.equals(commandArguments.getOptionValue(NAME))) {
            IPath commandArgPath = Path.fromOSString((String)commandArg);
            String fileName = commandArgPath.removeFileExtension().lastSegment();
            this.getModel().addSearchedQipFile(fileName, ((AlteraAutoconfigTCLInterp)interp).getAlteraCurrentInterpretedFile());
        } else if (VERILOG_FILE.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            String library = this.getLibFromArg(commandArguments);
            this.getModel().addVlogFileForScript(library, commandArg);
        } else if (SYSTEMVERILOG_FILE.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            String library = this.getLibFromArg(commandArguments);
            this.getModel().addSVFileForScript(library, commandArg);
        } else if (VHDL_FILE.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            String library = this.getLibFromArg(commandArguments);
            this.getModel().addVHDLFileForScript(library, commandArg);
        } else if (VERILOG_INPUT_VERSION.equals(commandArguments.getOptionValue(NAME)) || VHDL_INPUT_VERSION.equals(commandArguments.getOptionValue(NAME))) {
            DVTTclUtils.printToConsole("[Quartus] " + messageVer, this.getModel().getProject(), interp.getBuildKind(), DVTDebugKind.QUARTUS_DEBUG_INFO, interp.isDebugMode());
            this.registerInputVersion(interp, commandArguments);
        } else {
            this.getModel().registerGlobalAssignment(commandArguments.getOptionValue(NAME), commandArg);
        }
    }

    private String getLibFromArg(DVTCommandResult commandArguments) {
        return commandArguments.getOptionValue(LIBRARY) != null ? commandArguments.getOptionValue(LIBRARY) : WORK;
    }

    private void registerInputVersion(DVTTclInterp interp, DVTCommandResult commandArguments) {
        if (((AlteraAutoconfigTCLInterp)interp).getAlteraCurrentInterpretedFile().endsWith(".qip")) {
            return;
        }
        this.getModel().registerGlobalAssignment(commandArguments.getOptionValue(NAME), commandArguments.getCommandArg());
    }
}

