/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AdditiveValueEnumList<T extends Enum>
implements Serializable,
Iterable<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> type;
    private final List<T> data;

    public AdditiveValueEnumList(Class<T> type) {
        this.data = new ArrayList<T>();
        this.type = type;
    }

    public AdditiveValueEnumList(List<T> initialData, Class<T> type) {
        this.data = new ArrayList<T>(initialData);
        this.type = type;
    }

    public int length() {
        return this.data.size();
    }

    public List<T> getData() {
        return this.data;
    }

    public Class<T> getType() {
        return this.type;
    }

    @Override
    public Iterator<T> iterator() {
        return this.data.iterator();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.data == null ? 0 : this.data.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AdditiveValueEnumList other = (AdditiveValueEnumList)obj;
        if (this.data == null ? other.data != null : !this.data.equals(other.data)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        return "{" + this.data.stream().map(Enum::name).collect(Collectors.joining(", ")) + "}";
    }

    public String getPossibleValues() {
        return DVTStringUtil.join((Enum[])this.type.getEnumConstants(), ", ");
    }
}

