/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigModel;
import ro.amiq.dvt.altera.autoconfig.AlteraAutoconfigTCLInterp;
import ro.amiq.dvt.altera.autoconfig.AlteraFileType;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.startup.core.DVTLogger;

public class AlteraAutoconfigUtils {
    private static final String NEW_LINE = System.lineSeparator();
    static final String QPF_SUFFIX = ".qpf";
    static final String QSF_SUFFIX = ".qsf";
    private static final String TEMP_FILE_NAME = "build_file";
    private static final String PROJECT_REVISION_REGEX = "(PROJECT_REVISION\\s*=\\s*)(\\\"?)(\\w+)(\\\"?)(\\s*)";

    public static String getRevisionNameFromProjectConfigFile(File projectConfigFile) throws Exception {
        try (BufferedReader input = new BufferedReader(new FileReader(projectConfigFile));){
            Stream<String> fileLines = input.lines();
            Stream<String> revisionLines = fileLines.filter(new Predicate<String>(){

                @Override
                public boolean test(String s) {
                    return s.matches(AlteraAutoconfigUtils.PROJECT_REVISION_REGEX);
                }
            });
            if (revisionLines == null) {
                return null;
            }
            Optional<String> firstRevision = revisionLines.findFirst();
            if (!firstRevision.isPresent()) {
                return null;
            }
            Pattern pattern = Pattern.compile(PROJECT_REVISION_REGEX);
            Matcher matcher = pattern.matcher(firstRevision.get());
            if (!matcher.matches()) {
                return null;
            }
            String string = matcher.group(3);
            return string;
        }
    }

    public static AutoConfigResult getAlteraAutoConfigResultWithTclInterp(IProject project, String rootDirPath, String revisionName, List<String> additionalQIPFiles, BuildConfigParser.AutoConfigParameters parameters, boolean debugInfo, IProgressMonitor buildConfigMonitor) throws Exception {
        File tempBuildFile = null;
        AutoConfigResult result = new AutoConfigResult(AutoConfigResult.Status.EMPTY, AutoConfigResult.AlgorithmKind.ALTERA);
        try {
            try {
                String tclScriptPath = Path.fromOSString((String)rootDirPath).append(String.valueOf(revisionName) + QSF_SUFFIX).toOSString();
                tempBuildFile = File.createTempFile(TEMP_FILE_NAME, null);
                String tempBuildFilePath = tempBuildFile.getAbsolutePath();
                AlteraAutoconfigModel model = new AlteraAutoconfigModel(revisionName, project, rootDirPath, tempBuildFilePath, parameters, debugInfo);
                AlteraAutoconfigTCLInterp tclInterp = new AlteraAutoconfigTCLInterp(buildConfigMonitor, project, model);
                tclInterp.setAlteraCurrentInterpretedFile(Paths.get(tclScriptPath, new String[0]).toFile().getName());
                tclInterp.setVar(tclInterp.getVariableName(AlteraFileType.QSF_FILE), rootDirPath, 131072);
                tclInterp.processFile(Paths.get(tclScriptPath, new String[0]).toFile().getName(), rootDirPath, parameters);
                for (String file : additionalQIPFiles) {
                    File qipFile = new File(file);
                    tclInterp.setVar(tclInterp.getVariableName(AlteraFileType.QIP_FILE), qipFile.isAbsolute() ? qipFile.getParent() : String.valueOf(rootDirPath) + File.separator + qipFile.getParent(), 131072);
                    tclInterp.setAlteraCurrentInterpretedFile(file);
                    tclInterp.processFile(file, rootDirPath, parameters);
                }
                model.writeBuildFile();
                result.append(model.getAutoconfigResult());
                result.setResultKind(AutoConfigResult.Status.OK);
            }
            catch (Exception e) {
                result.setResultKind(AutoConfigResult.Status.ERROR);
                DVTLogger.INSTANCE.logError("Auto-config - Quartus: ", (Throwable)e);
                if (tempBuildFile != null && tempBuildFile.exists()) {
                    tempBuildFile.delete();
                }
            }
        }
        finally {
            if (tempBuildFile != null && tempBuildFile.exists()) {
                tempBuildFile.delete();
            }
        }
        return result;
    }

    public static AutoConfigResult getIPFilesAutoConfigResult(IProject project, String rootDirPath, List<String> additionalQIPFiles, BuildConfigParser.AutoConfigParameters parameters, boolean debugInfo, IProgressMonitor buildConfigMonitor) {
        File tempBuildFile = null;
        AutoConfigResult result = new AutoConfigResult(AutoConfigResult.Status.EMPTY, AutoConfigResult.AlgorithmKind.ALTERA);
        try {
            try {
                tempBuildFile = File.createTempFile(TEMP_FILE_NAME, null);
                String tempBuildFilePath = tempBuildFile.getAbsolutePath();
                AlteraAutoconfigModel model = new AlteraAutoconfigModel(null, project, rootDirPath, tempBuildFilePath, parameters, debugInfo);
                AlteraAutoconfigTCLInterp tclInterp = new AlteraAutoconfigTCLInterp(buildConfigMonitor, project, model);
                for (String file : additionalQIPFiles) {
                    IPath fileFullPath = Path.fromOSString((String)rootDirPath).append(file);
                    IPath parentDir = fileFullPath.removeLastSegments(1);
                    String alteraFileName = fileFullPath.lastSegment();
                    tclInterp.setVar(tclInterp.getVariableName(AlteraFileType.QIP_FILE), parentDir.toOSString(), 131072);
                    tclInterp.setAlteraCurrentInterpretedFile(alteraFileName);
                    tclInterp.processFile(alteraFileName, parentDir.toOSString(), parameters);
                }
                model.writeBuildFile();
                result.append(model.getAutoconfigResult());
                result.setResultKind(AutoConfigResult.Status.OK);
            }
            catch (Exception e) {
                result.setResultKind(AutoConfigResult.Status.ERROR);
                DVTLogger.INSTANCE.logError("Auto-config - Quartus: ", (Throwable)e);
                if (tempBuildFile != null && tempBuildFile.exists()) {
                    tempBuildFile.delete();
                }
            }
        }
        finally {
            if (tempBuildFile != null && tempBuildFile.exists()) {
                tempBuildFile.delete();
            }
        }
        return result;
    }

    public static class QuartusProjectInfo {
        public String projectName;
        public File[] projectFiles;
        private Map<String, File> quartusRevisionNamesToFiles;
        public String[] dvtNatures;

        public QuartusProjectInfo(File[] quartusProjectFiles, Set<File> quartusRevisionFiles) {
            this.projectName = FilenameUtils.getBaseName((String)quartusProjectFiles[0].getName());
            this.projectFiles = quartusProjectFiles;
            this.quartusRevisionNamesToFiles = quartusRevisionFiles.stream().collect(Collectors.toMap(File::getName, Function.identity()));
        }

        public void setProjectNatures(String[] dvtNatureIds) {
            this.dvtNatures = dvtNatureIds;
        }
    }
}

