/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AlteraAutoconfigUtils;
import ro.amiq.dvt.buildconfig.AutoConfigE;
import ro.amiq.dvt.buildconfig.AutoConfigFileScan;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.AutoConfigVhdl;
import ro.amiq.dvt.buildconfig.AutoConfigVlog;
import ro.amiq.dvt.buildconfig.AutoconfigCompilationRootInfo;
import ro.amiq.dvt.buildconfig.AutoconfigDebugKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.buildconfig.TimeoutTimer;
import ro.amiq.dvt.buildconfig.XilinxAutoconfigUtils;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTProfilingUtils;

public abstract class AutoConfig {
    private static final String ALL_LINE_SEPARATORS = "\n\r|\n|\r|\n\r";
    protected static final Pattern MULTIPLE_BLANK_LINE_PATTERN = Pattern.compile("([\\n\\r]+\\s*){3,}");
    protected static final Pattern WORK_REGEX_PATTERN = Pattern.compile("-work\\s+\\w+");
    private static final String QUARTUS_FAIL_MESSAGE = "Could not perform Quartus project autoconfig, running default autoconfig...";
    private static final String QUARTUS_EMPTY_MESSAGE = "Quartus project autoconfig found no source files, running default autoconfig...";
    private static final String QUARTUS_DETECTED_MESSAGE = "Detected Quartus project root, running Quartus project autoconfig...";
    private static final String QUARTUS_QIPS_MESSAGE = "+" + IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_FORCE_QUARTUS + " specified, running Quartus autoconfig for *.qip files...";
    private static final String QUARTUS_EXECUTABLE = "quartus";
    protected static final String QUARTUS_DEBUG_PREFIX = "Auto-config - Quartus: ";
    protected static final String QUARTUS_ROOTDIR = "QUARTUS_ROOTDIR";
    protected static final String VIVADO = "vivado";
    protected static final String VIVADO_LIBS_DIR = "";
    protected static final String DVT_XILINX_HOME = "DVT_XILINX_HOME";
    protected static final String DVT_INIT_XILINX = "DVT_INIT_XILINX";
    protected static final String XILINX_ISE = "ise";
    protected static final String XILINX_LIBS_DIR = "";
    private static final String CANNOT_DETECT_HOME = "Unable to infer Xilinx installation location because no vivado or ise executable found in $PATH environment variable.\n";
    private static final String CANNOT_DETECT_QUARTUS_INSTALLATION = "Unable to infer Quartus installation location because no quartus executable was found in $PATH environment variable.\n";
    private static final String MESSAGE = "message";
    private static final String COMMENTED = "commented";
    private static final String XILINX_TEMPLATE = "\n${message}${commented}+dvt_init_xilinx+${DVT_INIT_XILINX}\n${commented}+dvt_env+DVT_XILINX_HOME=${DVT_XILINX_HOME}\n";
    private static final String QUARTUS_TEMPLATE = "\n${message}${commented}+dvt_setenv+QUARTUS_ROOTDIR=${QUARTUS_ROOTDIR}\n";
    public static final String NEWLINE = System.lineSeparator();
    public static final String COMMENT_PREFIX = "### ";
    public static final String COMMENT_PREFIX_AUTOCONFIG = "### AUTOCONFIG ";
    public static final String TAG_SEPARATOR = ":";
    public static final String COMMENT_FORMAT = "### AUTOCONFIG {0}: {1}";
    public static final String AUTO_CONFIG_MSG_PREFIX = String.valueOf(BuildConfigManager.isBatchMode() ? "INFO: " : "") + "Auto-config - ";
    private static final Map<LanguageKind, Class<? extends AutoConfig>> CONTRIBUTORS = new LinkedHashMap<LanguageKind, Class<? extends AutoConfig>>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(LanguageKind.VLOG, AutoConfigVlog.class);
            this.put(LanguageKind.VHDL, AutoConfigVhdl.class);
            this.put(LanguageKind.E, AutoConfigE.class);
        }
    };
    public static final Comparator<IPath> REVERSE_IPATH_COMPARATOR = new Comparator<IPath>(){

        @Override
        public int compare(IPath o1, IPath o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String o1String = new StringBuilder(o1.toOSString()).reverse().toString();
            String o2String = new StringBuilder(o2.toOSString()).reverse().toString();
            return o1String.compareTo(o2String);
        }
    };
    public static final Comparator<IPath> NORMAL_IPATH_COMPARATOR = new Comparator<IPath>(){

        @Override
        public int compare(IPath o1, IPath o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String o1String = o1.toOSString();
            String o2String = o2.toOSString();
            return o1String.compareTo(o2String);
        }
    };
    private IProject fProject;
    private BuildConfigParser.AutoConfigParameters fParameters;
    private LanguageKind fLanguage;
    private static SkipCompileFilter fSkipCompileFilter;
    private Set<IPath> fIncdirs;
    protected static final TimeoutTimer scanningTimer;
    protected static final TimeoutTimer creatingResultTimer;

    static {
        scanningTimer = new TimeoutTimer();
        creatingResultTimer = new TimeoutTimer();
    }

    public static void scanAndSortFilePaths(IProject project, BuildConfigParser.AutoConfigParameters parameters, List<IPath> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        try {
            Map<LanguageKind, AutoConfig> contributors = AutoConfig.initContributors(project, parameters);
            EnumMap scannedFiles = new EnumMap(LanguageKind.class);
            ArrayList<IPath> notScannedFiles = new ArrayList<IPath>();
            for (IPath iPath : paths) {
                boolean wasScanned = false;
                for (AutoConfig autoConfig : contributors.values()) {
                    ArrayList<IPath> scannedFileList;
                    if (!AutoConfig.validExtension(iPath.toOSString(), autoConfig.getExtensions()) && !autoConfig.shouldScanFile(iPath)) continue;
                    wasScanned = true;
                    autoConfig.scan(iPath);
                    List<Object> list = scannedFileList = scannedFiles.containsKey((Object)autoConfig.fLanguage) ? (List)scannedFiles.get((Object)autoConfig.fLanguage) : new ArrayList<IPath>();
                    if (!scannedFiles.containsKey((Object)autoConfig.fLanguage)) {
                        scannedFiles.put(autoConfig.fLanguage, scannedFileList);
                    }
                    scannedFileList.add(iPath);
                    break;
                }
                if (wasScanned) continue;
                notScannedFiles.add(iPath);
            }
            paths.clear();
            for (Map.Entry entry : scannedFiles.entrySet()) {
                LanguageKind lk = (LanguageKind)((Object)entry.getKey());
                List scannedFileList = (List)entry.getValue();
                contributors.get((Object)lk).sortGraphUsingDegree(scannedFileList);
                paths.addAll(scannedFileList);
            }
            paths.addAll(notScannedFiles);
        }
        catch (IllegalAccessException | InstantiationException | CoreException e) {
            DVTLogger.INSTANCE.logError(e);
        }
    }

    public static AutoConfigResult getAutoConfigResult(IProject project, BuildConfigParser.AutoConfigParameters parameters) {
        try {
            IProgressMonitor buildConfigMonitor = BuildConfigManager.getProgressMonitor(project);
            scanningTimer.schedule(1000L * (long)parameters.timeoutSeconds * 9L / 10L);
            String compilationRootPath = parameters.compilationRoot.toOSString();
            String scanMessage = String.valueOf(AUTO_CONFIG_MSG_PREFIX) + "Scanning: " + compilationRootPath;
            DVTBuildConsoleRegistry.getConsole(project).buildAutoConfigStart();
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(project);
            buildConsole.print(scanMessage);
            buildConfigMonitor.subTask(scanMessage);
            AutoconfigCompilationRootInfo infoForDirectory = AutoconfigCompilationRootInfo.computeInfoForDirectory(parameters.compilationRoot.toFile(), scanningTimer);
            boolean alteraAutoconfigDisabled = (Boolean)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_DISABLE_QUARTUS);
            boolean debugInfo = (Boolean)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.QUARTUS_DEBUG);
            boolean initQuartus = (Boolean)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_FORCE_QUARTUS);
            if (!alteraAutoconfigDisabled && infoForDirectory != null) {
                if (infoForDirectory.isQuartusProject) {
                    buildConsole.printSection(QUARTUS_DETECTED_MESSAGE);
                    Object quartusProjectRevision = BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_QUARTUS_PROJECT_REVISION);
                    List<String> qipFiles = BuildConfigManager.getAlteraAutoconfigQipFiles(project, parameters.invocation);
                    String revisionName = null;
                    revisionName = quartusProjectRevision instanceof String && !((String)quartusProjectRevision).isEmpty() ? (String)quartusProjectRevision : AlteraAutoconfigUtils.getRevisionNameFromProjectConfigFile(infoForDirectory.quartusProjectInfo.projectFiles[0]);
                    if (revisionName != null) {
                        File projectRevisionFile = new File(compilationRootPath, String.valueOf(revisionName) + ".qsf");
                        if (!projectRevisionFile.exists()) {
                            buildConsole.print("Auto-config - Quartus: Could not find project revision file: " + projectRevisionFile.getAbsolutePath());
                            buildConsole.print("Auto-config - Quartus: Could not perform Quartus project autoconfig, running default autoconfig...");
                        } else {
                            AutoConfigResult result;
                            List<String> qipSearchPaths = BuildConfigManager.getAlteraAutoconfigQipSearchPaths(project, parameters.invocation);
                            if (qipSearchPaths != null && !qipSearchPaths.isEmpty()) {
                                buildConsole.print("Auto-config - Quartus: Scan roots:\n\t" + qipSearchPaths.stream().collect(Collectors.joining("\n\t")));
                            }
                            if ((result = AlteraAutoconfigUtils.getAlteraAutoConfigResultWithTclInterp(project, compilationRootPath, revisionName, qipFiles, parameters, debugInfo, buildConfigMonitor)).getResultKind() == AutoConfigResult.Status.OK || result.getResultKind() == AutoConfigResult.Status.CANCELED) {
                                return result;
                            }
                            if (result.getResultKind() == AutoConfigResult.Status.EMPTY) {
                                buildConsole.print("Auto-config - Quartus: Quartus project autoconfig found no source files, running default autoconfig...");
                            } else {
                                buildConsole.print("Auto-config - Quartus: Could not perform Quartus project autoconfig, running default autoconfig...");
                            }
                        }
                    } else {
                        buildConsole.print("Auto-config - Quartus: Could not find project revision.");
                        buildConsole.print("Auto-config - Quartus: Could not perform Quartus project autoconfig, running default autoconfig...");
                    }
                } else if (initQuartus) {
                    buildConsole.printSection(QUARTUS_QIPS_MESSAGE);
                    List<String> qipFiles = BuildConfigManager.getAlteraAutoconfigQipFiles(project, parameters.invocation);
                    AutoConfigResult result = AlteraAutoconfigUtils.getIPFilesAutoConfigResult(project, compilationRootPath, qipFiles, parameters, debugInfo, buildConfigMonitor);
                    if (result.getResultKind() == AutoConfigResult.Status.OK || result.getResultKind() == AutoConfigResult.Status.CANCELED) {
                        return result;
                    }
                    if (result.getResultKind() == AutoConfigResult.Status.EMPTY) {
                        buildConsole.print("Auto-config - Quartus: Quartus project autoconfig found no source files, running default autoconfig...");
                    } else {
                        buildConsole.print("Auto-config - Quartus: Could not perform Quartus project autoconfig, running default autoconfig...");
                    }
                }
            }
            if (buildConfigMonitor.isCanceled()) {
                return AutoConfigResult.CANCELED;
            }
            boolean xilinxAutoconfigDisabled = (Boolean)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_DISABLE_XILINX);
            if (!xilinxAutoconfigDisabled && infoForDirectory != null) {
                XilinxAutoconfigUtils.XilinxProjectInfo xilinxProjectInfo = null;
                if (infoForDirectory.isVivadoProject) {
                    xilinxProjectInfo = infoForDirectory.vivadoProjectInfo;
                } else if (infoForDirectory.isISEProject) {
                    xilinxProjectInfo = infoForDirectory.iseProjectInfo;
                }
                if (xilinxProjectInfo != null) {
                    String xilinxToolName = xilinxProjectInfo.projectType.getXilinxTool();
                    buildConsole.printSection("Detected Xilinx " + xilinxToolName + " project root, running Xilinx project autoconfig");
                    AutoConfigResult result = XilinxAutoconfigUtils.getXilinxAutoConfigResult(project, compilationRootPath, xilinxProjectInfo, parameters, buildConsole, buildConfigMonitor);
                    if (result.getResultKind() == AutoConfigResult.Status.OK || result.getResultKind() == AutoConfigResult.Status.CANCELED) {
                        return result;
                    }
                    if (result.getResultKind() == AutoConfigResult.Status.EMPTY) {
                        buildConsole.print("Xilinx " + xilinxToolName + " project autoconfig found no source files, running default autoconfig...");
                    } else {
                        buildConsole.print("Could not perform Xilinx " + xilinxToolName + " project autoconfig, running default autoconfig...");
                    }
                }
            }
            if (buildConfigMonitor.isCanceled()) {
                return AutoConfigResult.CANCELED;
            }
            Map<LanguageKind, AutoConfig> contributors = AutoConfig.initContributors(project, parameters);
            int followSymlinksDepth = (Integer)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.FOLLOW_SYMLINKS);
            boolean disableScanUsingBfs = (Boolean)BuildConfigManager.getDVTConfig(project, parameters.invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_DISABLE_BFS_SCAN);
            if (!disableScanUsingBfs) {
                AutoConfigFileScan autoConfigFileScan = new AutoConfigFileScan(parameters, buildConfigMonitor, buildConsole, contributors, followSymlinksDepth);
                autoConfigFileScan.start();
            } else {
                AutoConfig.scanUsingDFS(parameters, buildConfigMonitor, buildConsole, contributors, followSymlinksDepth);
            }
            long remainingTimeFromScanning = scanningTimer.stop();
            int deltaStep = 1000 / (contributors.keySet().size() + 1);
            buildConfigMonitor.worked(deltaStep);
            if (buildConfigMonitor.isCanceled()) {
                return AutoConfigResult.CANCELED;
            }
            AutoConfigResult globalResult = new AutoConfigResult(AutoConfigResult.Status.EMPTY);
            creatingResultTimer.schedule(1000L * (long)parameters.timeoutSeconds * 1L / 10L + remainingTimeFromScanning);
            for (Map.Entry<LanguageKind, AutoConfig> entry : contributors.entrySet()) {
                if (buildConfigMonitor.isCanceled()) {
                    return AutoConfigResult.CANCELED;
                }
                LanguageKind langKind = entry.getKey();
                AutoConfig langAutoConfig = entry.getValue();
                String langMessage = String.valueOf(AUTO_CONFIG_MSG_PREFIX) + (Object)((Object)langKind) + ": " + compilationRootPath;
                buildConsole.print(langMessage);
                buildConfigMonitor.subTask(langMessage);
                AutoConfigResult langResult = langAutoConfig.getResult(parameters);
                globalResult.merge(langResult);
                buildConfigMonitor.worked(deltaStep);
            }
            creatingResultTimer.stop();
            return globalResult;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return new AutoConfigResult(AutoConfigResult.Status.ERROR).append("# ").append(e.getClass().getName()).append(e.getMessage() == null ? "" : ": " + e.getMessage()).append(NEWLINE).append("# More details are available in the logfile.");
        }
    }

    private static void scanUsingDFS(final BuildConfigParser.AutoConfigParameters parameters, final IProgressMonitor buildConfigMonitor, final DVTBuildConsole buildConsole, final Map<LanguageKind, AutoConfig> contributors, final int followSymlinksDepth) {
        FileVisitor<java.nio.file.Path> fv = new FileVisitor<java.nio.file.Path>(){
            private long enterDirectoryTimeStamp;
            private long leaveDirectoryTimeStamp;
            private int nrOfNestedSymlinks;

            @Override
            public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                IPath sourcePath = null;
                if (!Files.isSymbolicLink(file)) {
                    sourcePath = Path.fromOSString((String)file.toRealPath(new LinkOption[0]).toString());
                }
                for (AutoConfig autoConfig : contributors.values()) {
                    IPath filePath;
                    if (sourcePath != null && autoConfig.getScannedFiles() != null && autoConfig.getScannedFiles().contains(sourcePath) || AutoConfig.shouldSkip(filePath = Path.fromOSString((String)file.toString()), true)) break;
                    if (AutoConfig.validExtension(file.getFileName().toString(), autoConfig.getExtensions()) || autoConfig.shouldScanFile(filePath)) {
                        autoConfig.scan(filePath);
                        if (sourcePath == null) continue;
                        autoConfig.addScannedFiles(sourcePath);
                        continue;
                    }
                    autoConfig.addSkippedPath(filePath);
                }
                if (scanningTimer.isTimeout()) {
                    return FileVisitResult.TERMINATE;
                }
                return buildConfigMonitor.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(java.nio.file.Path dir, BasicFileAttributes attrs) throws IOException {
                IPath dirPath = Path.fromOSString((String)dir.toString());
                if (parameters.autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN)) {
                    buildConsole.print("Scanning " + dir.toString());
                    this.enterDirectoryTimeStamp = System.currentTimeMillis();
                }
                buildConfigMonitor.subTask(dir.toString());
                if (AutoConfig.shouldSkip(dirPath, false)) {
                    return buildConfigMonitor.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.SKIP_SUBTREE;
                }
                if (contributors.containsKey((Object)LanguageKind.VLOG)) {
                    ((AutoConfigVlog)contributors.get((Object)LanguageKind.VLOG)).addVisitedDirectory(dir);
                }
                if (Files.isSymbolicLink(dir)) {
                    ++this.nrOfNestedSymlinks;
                    if (followSymlinksDepth <= 0) {
                        return buildConfigMonitor.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.SKIP_SUBTREE;
                    }
                    if (this.nrOfNestedSymlinks > followSymlinksDepth) {
                        --this.nrOfNestedSymlinks;
                        return buildConfigMonitor.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.SKIP_SUBTREE;
                    }
                }
                return buildConfigMonitor.isCanceled() ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(java.nio.file.Path dir, IOException exc) throws IOException {
                if (Files.isSymbolicLink(dir)) {
                    --this.nrOfNestedSymlinks;
                }
                if (parameters.autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN)) {
                    this.leaveDirectoryTimeStamp = System.currentTimeMillis();
                    buildConsole.print("Done " + dir.toString() + " [" + (this.leaveDirectoryTimeStamp - this.enterDirectoryTimeStamp) + " ms]");
                }
                return FileVisitResult.CONTINUE;
            }
        };
        List<Object> result = new ArrayList();
        List<String> autoconfigScanDirs = parameters.autoconfigScanDirs;
        if (autoconfigScanDirs == null || autoconfigScanDirs.isEmpty()) {
            result = Collections.emptyList();
        } else {
            List autoconfigPaths = autoconfigScanDirs.stream().map(x -> Paths.get(x, new String[0]).toAbsolutePath().normalize()).collect(Collectors.toList());
            autoconfigPaths.sort(new Comparator<java.nio.file.Path>(){

                @Override
                public int compare(java.nio.file.Path o1, java.nio.file.Path o2) {
                    return o1.toString().compareTo(o2.toString());
                }
            });
            java.nio.file.Path basePath = (java.nio.file.Path)autoconfigPaths.get(0);
            int i = 1;
            while (i < autoconfigPaths.size()) {
                java.nio.file.Path path = (java.nio.file.Path)autoconfigPaths.get(i);
                if (path.startsWith(basePath)) {
                    autoconfigPaths.set(i, null);
                } else {
                    basePath = path;
                }
                ++i;
            }
            result = autoconfigPaths.stream().filter(x -> x != null).collect(Collectors.toList());
        }
        try {
            for (java.nio.file.Path dirName : result) {
                EnumSet<FileVisitOption> options = EnumSet.of(FileVisitOption.FOLLOW_LINKS);
                Files.walkFileTree(dirName, options, Integer.MAX_VALUE, (FileVisitor<? super java.nio.file.Path>)fv);
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    protected String getDirectives() {
        List<String> linesReuseText = Arrays.asList(this.getParameters().reuseText.split(ALL_LINE_SEPARATORS));
        ArrayList<BuildConfigProperty> properties = new ArrayList<BuildConfigProperty>();
        properties.addAll(BuildConfigManager.getTopFiles(this.getParameters().invocation, LanguageKind.VLOG));
        properties.addAll(BuildConfigManager.getTopFiles(this.getParameters().invocation, LanguageKind.VHDL));
        for (BuildConfigProperty property : properties) {
            String line;
            int lineIndex;
            BuildConfigToken token = (BuildConfigToken)property.getAttribute("ATTRIBUTE_TOKEN");
            if (token == null) continue;
            String filenameContainingInvocation = this.getParameters().invocation.getFilename();
            String filenameContainingFile = token.getFilename();
            if (filenameContainingFile == null || !filenameContainingFile.equals(filenameContainingInvocation) || (lineIndex = token.getLine() - this.getParameters().invocation.getLine()) >= linesReuseText.size() || lineIndex < 0 || (line = linesReuseText.get(lineIndex)).contains("-uvm") || line.contains("-ovm")) continue;
            linesReuseText.set(lineIndex, line.replace(token.getText(), ""));
        }
        String headerDirectives = String.valueOf(NEWLINE) + linesReuseText.stream().collect(Collectors.joining(NEWLINE)) + NEWLINE;
        return headerDirectives;
    }

    protected String getTokenOrPath(BuildConfigProperty e) {
        Object token = e.getAttribute("ATTRIBUTE_TOKEN");
        String path = e.getValue();
        if (!(token instanceof BuildConfigToken)) {
            return path;
        }
        String text = ((BuildConfigToken)token).getText();
        if (text != null) {
            return text;
        }
        return path;
    }

    protected Map<IPath, String> computeUserSpecifiedTopFiles(LanguageKind languageKind, Predicate<? super BuildConfigProperty> predicate) {
        List filteredTopProperties = BuildConfigManager.getTopFiles(this.getParameters().invocation, languageKind).stream().filter(predicate).collect(Collectors.toList());
        LinkedHashMap<IPath, String> userSpecifiedTops = new LinkedHashMap<IPath, String>();
        for (BuildConfigProperty property : filteredTopProperties) {
            Path pathUserSpecifiedTop = new Path(property.getValue());
            String stringUserSpecifiedTop = this.getTokenOrPath(property);
            userSpecifiedTops.put((IPath)pathUserSpecifiedTop, stringUserSpecifiedTop);
        }
        return userSpecifiedTops;
    }

    private static Map<LanguageKind, AutoConfig> initContributors(IProject project, BuildConfigParser.AutoConfigParameters parameters) throws CoreException, InstantiationException, IllegalAccessException {
        LinkedHashMap<LanguageKind, AutoConfig> contributors = new LinkedHashMap<LanguageKind, AutoConfig>();
        for (Map.Entry<LanguageKind, Class<? extends AutoConfig>> entry : CONTRIBUTORS.entrySet()) {
            LanguageKind language = entry.getKey();
            if (!project.hasNature(language.NATURE_ID)) continue;
            AutoConfig instance = entry.getValue().newInstance();
            instance.init(project, parameters, language);
            contributors.put(language, instance);
        }
        return contributors;
    }

    public static boolean validExtension(String filename, Set<String> extensions) {
        if (extensions == null) {
            return false;
        }
        for (String extension : extensions) {
            if (!filename.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    private void init(IProject project, BuildConfigParser.AutoConfigParameters parameters, LanguageKind language) {
        this.fParameters = parameters;
        this.fProject = project;
        this.fLanguage = language;
        fSkipCompileFilter = BuildConfigManager.getSkipCompileFilter(project, parameters.invocation);
        List<String> incdirs = BuildConfigManager.getIncdirs(project, parameters.invocation);
        this.fIncdirs = new HashSet<IPath>(incdirs.size());
        if (!incdirs.isEmpty()) {
            for (String incdir : incdirs) {
                this.fIncdirs.add(Path.fromOSString((String)incdir));
            }
        }
    }

    public boolean isWildcardSortingAutoconfig() {
        return this.fParameters != null ? this.fParameters.isWildcardSortingAutoconfig : false;
    }

    public BuildConfigParser.AutoConfigParameters getParameters() {
        return this.fParameters;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public IPath getCompilationRoot() {
        return this.fParameters.compilationRoot;
    }

    protected Set<String> getExtensions() {
        return this.fParameters.extensionsMap.get((Object)this.fLanguage);
    }

    protected abstract void scan(IPath var1);

    protected abstract void addScannedFiles(IPath var1);

    protected abstract Set<IPath> getScannedFiles();

    protected abstract void sortGraphUsingDegree(List<IPath> var1);

    protected abstract AutoConfigResult getResult(BuildConfigParser.AutoConfigParameters var1);

    public static boolean shouldSkip(IPath path, boolean isFile) {
        return fSkipCompileFilter != null && fSkipCompileFilter.shouldSkip(new ParserPath(path.toOSString()), isFile);
    }

    public boolean isUserDefinedIncdir(IPath path) {
        return this.fIncdirs.contains(path);
    }

    public boolean isFileInUserDefinedIncdir(String filename) {
        for (IPath path : this.fIncdirs) {
            java.nio.file.Path fullPath = Paths.get(path.toOSString(), filename);
            if (!fullPath.toFile().exists()) continue;
            return true;
        }
        return false;
    }

    protected static String comment(CommentType commentType, String message) {
        return MessageFormat.format(COMMENT_FORMAT, commentType.toString(), message);
    }

    public abstract void addSkippedPath(IPath var1);

    public abstract boolean shouldScanFile(IPath var1);

    public static String getXilinxDirectives(Set<String> requiredXilinxLibs, Invocation invocation) {
        if (requiredXilinxLibs.isEmpty()) {
            return "";
        }
        String xilinxLibsHome = BuildConfigManager.getenv(invocation, DVT_XILINX_HOME);
        if (xilinxLibsHome == null || xilinxLibsHome.isEmpty()) {
            xilinxLibsHome = AutoConfig.getXilinxLibsHome(VIVADO);
        }
        if (xilinxLibsHome.isEmpty()) {
            xilinxLibsHome = AutoConfig.getXilinxLibsHome(XILINX_ISE);
        }
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (xilinxLibsHome.isEmpty()) {
            varMap.put(COMMENTED, "#");
            varMap.put(MESSAGE, AutoConfig.comment(CommentType.ERROR, CANNOT_DETECT_HOME));
            varMap.put(DVT_XILINX_HOME, "/path/to/xilinx/ISE");
        } else {
            varMap.put(COMMENTED, "");
            varMap.put(MESSAGE, "");
            varMap.put(DVT_XILINX_HOME, xilinxLibsHome);
        }
        varMap.put(DVT_INIT_XILINX, AutoConfig.joinUppercase(requiredXilinxLibs));
        return StrSubstitutor.replace((Object)XILINX_TEMPLATE, varMap);
    }

    protected static String joinUppercase(Collection<String> c) {
        StringBuilder result = new StringBuilder();
        for (String xilinxLib : c) {
            result.append(xilinxLib.toUpperCase()).append("+");
        }
        result.deleteCharAt(result.lastIndexOf("+"));
        return result.toString();
    }

    protected static String getXilinxLibsHome(String progName) {
        String result = "";
        String pathVariable = System.getenv("PATH");
        String[] stringArray = pathVariable.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String candidatePath = String.valueOf(path) + File.separator + progName;
            if (AutoConfig.executableExists(candidatePath)) {
                Path exePath = new Path(path);
                String trimmedPath = exePath.removeLastSegments(1).toOSString();
                if (progName.equals(VIVADO)) {
                    trimmedPath = String.valueOf(trimmedPath) + File.separator;
                }
                if (progName.equals(XILINX_ISE)) {
                    trimmedPath = String.valueOf(trimmedPath) + File.separator;
                }
                result = trimmedPath;
                break;
            }
            ++n2;
        }
        return result;
    }

    public static String getQuartusRootdirDirective(Invocation invocation) {
        String quartusLocation = BuildConfigManager.getenv(invocation, QUARTUS_ROOTDIR);
        if (quartusLocation != null && !quartusLocation.isEmpty()) {
            return "";
        }
        quartusLocation = AutoConfig.getQuartusRootDir();
        HashMap<String, String> varMap = new HashMap<String, String>();
        if (quartusLocation.isEmpty()) {
            varMap.put(COMMENTED, "#");
            varMap.put(MESSAGE, AutoConfig.comment(CommentType.ERROR, CANNOT_DETECT_QUARTUS_INSTALLATION));
            varMap.put(QUARTUS_ROOTDIR, "/path/to/quartus");
        } else {
            varMap.put(COMMENTED, "");
            varMap.put(MESSAGE, "");
            varMap.put(QUARTUS_ROOTDIR, quartusLocation);
        }
        return StrSubstitutor.replace((Object)QUARTUS_TEMPLATE, varMap);
    }

    protected static String getQuartusRootDir() {
        String result = "";
        String pathVariable = System.getenv("PATH");
        String[] stringArray = pathVariable.split(File.pathSeparator);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            String candidatePath = String.valueOf(path) + File.separator + QUARTUS_EXECUTABLE;
            if (AutoConfig.executableExists(candidatePath)) {
                Path exePath = new Path(path);
                result = exePath.removeLastSegments(1).toOSString();
                break;
            }
            ++n2;
        }
        return result;
    }

    protected static boolean executableExists(String fileName) {
        File executable = new File(fileName);
        if (executable.exists() && executable.canExecute()) {
            return true;
        }
        return DVTProfilingUtils.isWinOS() && !fileName.endsWith(".bat") && (executable = new File(String.valueOf(fileName) + ".bat")).exists() && executable.canExecute();
    }

    protected boolean invocationContainsUserDefinedLib(BuildConfigParser.AutoConfigParameters parameters) {
        String reuseText = parameters.reuseText;
        Matcher m = WORK_REGEX_PATTERN.matcher(reuseText);
        return m.find();
    }

    public static TimeoutTimer getCreatingResultTimer() {
        return creatingResultTimer;
    }

    public static TimeoutTimer getScanningTimer() {
        return scanningTimer;
    }

    public static enum CommentType {
        ERROR,
        WARNING;

    }
}

