/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.AutoConfigVlog;
import ro.amiq.dvt.buildconfig.AutoconfigDebugKind;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.startup.core.DVTLogger;

public class AutoConfigFileScan {
    private Map<LanguageKind, AutoConfig> contributors;
    private IProgressMonitor buildConfigMonitor;
    private DVTBuildConsole buildConsole;
    private final boolean consoleDebugFlag;
    private int followSymlinksDepth;
    private List<java.nio.file.Path> roots;
    private long enterDirectoryTimeStamp;
    private long leaveDirectoryTimeStamp;
    private int validFilesInDirCount;
    private int skippedFilesInDirCount;
    private int skippedFilesLimit;
    private List<java.nio.file.Path> queuedScanningDirs;
    private Set<java.nio.file.Path> allQueuedScanningDirs;
    private Map<java.nio.file.Path, Integer> cachedPositionInDirs;
    private static final int BASE_SKIPPED_FILES_LIMIT = 100;
    private static final int INCRESING_FACTOR_SKIPPED_FILES = 2;

    public AutoConfigFileScan(BuildConfigParser.AutoConfigParameters parameters, IProgressMonitor buildConfigMonitor, DVTBuildConsole buildConsole, Map<LanguageKind, AutoConfig> contributors, int followSymlinksDepth) {
        this.contributors = contributors;
        this.buildConsole = buildConsole;
        this.buildConfigMonitor = buildConfigMonitor;
        this.followSymlinksDepth = followSymlinksDepth;
        this.consoleDebugFlag = parameters.autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN);
        this.roots = this.getAutoConfigScanDirsWithSkippedDirs(parameters);
        this.skippedFilesLimit = 100;
        this.queuedScanningDirs = new ArrayList<java.nio.file.Path>();
        this.allQueuedScanningDirs = new HashSet<java.nio.file.Path>();
        this.cachedPositionInDirs = new HashMap<java.nio.file.Path, Integer>();
    }

    private List<java.nio.file.Path> getAutoConfigScanDirsWithSkippedDirs(BuildConfigParser.AutoConfigParameters parameters) {
        List<String> autoconfigScanDirs = parameters.autoconfigScanDirs;
        if (autoconfigScanDirs == null || autoconfigScanDirs.isEmpty()) {
            return Collections.emptyList();
        }
        List autoconfigPaths = autoconfigScanDirs.stream().map(x -> Paths.get(x, new String[0]).toAbsolutePath().normalize()).collect(Collectors.toList());
        autoconfigPaths.sort(new Comparator<java.nio.file.Path>(){

            @Override
            public int compare(java.nio.file.Path o1, java.nio.file.Path o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        java.nio.file.Path basePath = (java.nio.file.Path)autoconfigPaths.get(0);
        int i = 1;
        while (i < autoconfigPaths.size()) {
            java.nio.file.Path path = (java.nio.file.Path)autoconfigPaths.get(i);
            if (path.startsWith(basePath)) {
                autoconfigPaths.set(i, null);
            } else {
                basePath = path;
            }
            ++i;
        }
        return autoconfigPaths.stream().filter(x -> x != null).collect(Collectors.toList());
    }

    public void start() {
        if (this.roots == null || this.roots.isEmpty()) {
            return;
        }
        ArrayList<java.nio.file.Path> scanningDirs = new ArrayList<java.nio.file.Path>();
        scanningDirs.addAll(this.roots);
        do {
            this.queuedScanningDirs.clear();
            for (java.nio.file.Path root : scanningDirs) {
                this.walkFileTree(root);
            }
            if (this.buildConfigMonitor.isCanceled() || AutoConfig.getScanningTimer().isTimeout()) {
                return;
            }
            if (!Collections.disjoint(this.allQueuedScanningDirs, this.queuedScanningDirs)) {
                this.increaseSkipLimitSize();
            }
            this.allQueuedScanningDirs.addAll(this.queuedScanningDirs);
            scanningDirs.clear();
            scanningDirs.addAll(this.queuedScanningDirs);
        } while (!this.queuedScanningDirs.isEmpty());
        this.allQueuedScanningDirs.clear();
        this.queuedScanningDirs.clear();
        this.cachedPositionInDirs.clear();
    }

    private void walkFileTree(java.nio.file.Path root) {
        try {
            LinkedList<java.nio.file.Path> paths = new LinkedList<java.nio.file.Path>();
            HashSet<java.nio.file.Path> visitedPaths = new HashSet<java.nio.file.Path>();
            HashMap<java.nio.file.Path, Integer> symlinkToDepthMap = new HashMap<java.nio.file.Path, Integer>();
            boolean enqueueDirBack = false;
            visitedPaths.add(root);
            paths.add(root);
            while (!paths.isEmpty()) {
                java.nio.file.Path currentDir = (java.nio.file.Path)paths.poll();
                Integer currentDepth = 0;
                if (Files.isSymbolicLink(currentDir)) {
                    if (this.followSymlinksDepth <= 0) continue;
                    if (!symlinkToDepthMap.containsKey(currentDir)) {
                        symlinkToDepthMap.put(currentDir, 0);
                    } else {
                        currentDepth = (Integer)symlinkToDepthMap.get(currentDir);
                    }
                    if (currentDepth > this.followSymlinksDepth) continue;
                }
                this.preVisitDirectory(currentDir);
                if (AutoConfig.shouldSkip(Path.fromOSString((String)currentDir.toString()), false)) continue;
                enqueueDirBack = false;
                if (AutoConfig.getScanningTimer().isTimeout()) {
                    return;
                }
                List<java.nio.file.Path> filesInDir = this.getFilesInDir(currentDir);
                int i = this.getStartingIndex(currentDir);
                while (i < filesInDir.size()) {
                    java.nio.file.Path entry = filesInDir.get(i);
                    if (this.buildConfigMonitor.isCanceled() || AutoConfig.getScanningTimer().isTimeout()) {
                        return;
                    }
                    if (entry.toFile().isDirectory()) {
                        if (!visitedPaths.contains(Paths.get(entry.toRealPath(new LinkOption[0]).toString(), new String[0]))) {
                            if (Files.isSymbolicLink(entry)) {
                                symlinkToDepthMap.put(entry, currentDepth + 1);
                            }
                            paths.add(entry);
                        }
                    } else {
                        this.scanFile(entry);
                        if (this.shouldEnqueueDir()) {
                            this.cachedPositionInDirs.put(currentDir, i + 1);
                            enqueueDirBack = true;
                            this.enqueueDir(currentDir);
                            break;
                        }
                    }
                    ++i;
                }
                if (enqueueDirBack) continue;
                this.postVisitDirectory(currentDir);
                if (Files.isSymbolicLink(currentDir)) {
                    visitedPaths.add(Paths.get(currentDir.toRealPath(new LinkOption[0]).toString(), new String[0]));
                    continue;
                }
                visitedPaths.add(currentDir);
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private int getStartingIndex(java.nio.file.Path currentDir) {
        Integer position = this.cachedPositionInDirs.get(currentDir);
        if (position == null) {
            return 0;
        }
        return position;
    }

    private List<java.nio.file.Path> getFilesInDir(java.nio.file.Path currentDir) {
        ArrayList<java.nio.file.Path> filesInDir = new ArrayList<java.nio.file.Path>();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<java.nio.file.Path> stream = Files.newDirectoryStream(currentDir);){
                for (java.nio.file.Path path : stream) {
                    filesInDir.add(path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logDebug("Error while retrieving files in scanning phase!");
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        Collections.sort(filesInDir);
        return filesInDir;
    }

    private void scanFile(java.nio.file.Path file) {
        for (AutoConfig autoConfig : this.contributors.values()) {
            IPath filePath = Path.fromOSString((String)file.toString());
            if (AutoConfig.shouldSkip(filePath, true)) break;
            if (AutoConfig.validExtension(file.getFileName().toString(), autoConfig.getExtensions()) || autoConfig.shouldScanFile(filePath)) {
                autoConfig.scan(filePath);
                ++this.validFilesInDirCount;
                continue;
            }
            autoConfig.addSkippedPath(filePath);
            ++this.skippedFilesInDirCount;
        }
    }

    private void increaseSkipLimitSize() {
        this.skippedFilesLimit *= 2;
    }

    private boolean shouldEnqueueDir() {
        if (this.validFilesInDirCount > 0) {
            return false;
        }
        return this.skippedFilesInDirCount >= this.skippedFilesLimit;
    }

    private void enqueueDir(java.nio.file.Path currentDir) {
        if (this.consoleDebugFlag) {
            this.leaveDirectoryTimeStamp = System.currentTimeMillis();
            this.buildConsole.print("Queued scanning " + currentDir.toString() + "  because of large number of unrelated project files! [" + (this.leaveDirectoryTimeStamp - this.enterDirectoryTimeStamp) + " ms]");
        }
        this.queuedScanningDirs.add(currentDir);
    }

    public void preVisitDirectory(java.nio.file.Path dir) {
        if (this.consoleDebugFlag) {
            this.buildConsole.print("Scanning " + dir.toString());
            this.enterDirectoryTimeStamp = System.currentTimeMillis();
        }
        this.validFilesInDirCount = 0;
        this.skippedFilesInDirCount = 0;
        this.buildConfigMonitor.subTask(dir.toString());
    }

    public void postVisitDirectory(java.nio.file.Path dir) {
        if (this.consoleDebugFlag) {
            this.leaveDirectoryTimeStamp = System.currentTimeMillis();
            this.buildConsole.print("Done " + dir.toString() + " [" + (this.leaveDirectoryTimeStamp - this.enterDirectoryTimeStamp) + " ms]");
        }
        if (this.contributors.containsKey((Object)LanguageKind.VLOG)) {
            ((AutoConfigVlog)this.contributors.get((Object)LanguageKind.VLOG)).addVisitedDirectory(dir);
        }
    }
}

