/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;

public class AutoConfigResult {
    private static final String LANGUAGE_SEPARATOR = "################";
    public static final String TIMEOUT_MESSAGE = "# Auto-Config timed out, the results below may be incomplete!";
    public static final AutoConfigResult CANCELED = new AutoConfigResult(Status.CANCELED);
    public static final AutoConfigResult EMPTY = new AutoConfigResult(Status.EMPTY);
    private StringBuilder directives = new StringBuilder();
    private Status resultKind = Status.EMPTY;
    private List<String> errorMessages = new ArrayList<String>();
    private LanguageKind langKind = LanguageKind.UNKNOWN;
    private AlgorithmKind algorithmKind = AlgorithmKind.UNKNOWN;

    public AutoConfigResult(Status resultKind) {
        this.resultKind = resultKind;
    }

    public AutoConfigResult(Status resultKind, LanguageKind langKind) {
        this.resultKind = resultKind;
        this.langKind = langKind;
    }

    public AutoConfigResult(Status resultKind, AlgorithmKind algorithmKind) {
        this.resultKind = resultKind;
        this.algorithmKind = algorithmKind;
    }

    public StringBuilder getDirectives() {
        return this.directives;
    }

    public void setDirectives(StringBuilder directives) {
        this.directives = directives;
    }

    public Status getResultKind() {
        return this.resultKind;
    }

    public void setResultKind(Status resultKind) {
        this.resultKind = resultKind;
    }

    public List<String> getErrorMessages() {
        return this.errorMessages;
    }

    public AutoConfigResult addErrorMessage(String errorMessage) {
        this.errorMessages.add(errorMessage);
        return this;
    }

    public AutoConfigResult merge(AutoConfigResult with) {
        if (with.getResultKind() == Status.OK) {
            if (with.langKind != LanguageKind.UNKNOWN) {
                this.append("################ " + with.langKind.DISPLAY_NAME + " Auto-config Directives " + LANGUAGE_SEPARATOR).append(IBuildConfigParserConstants.NEWLINE);
            } else if (with.algorithmKind != AlgorithmKind.UNKNOWN) {
                this.append("################ " + (Object)((Object)with.algorithmKind) + " Auto-config Directives " + LANGUAGE_SEPARATOR).append(IBuildConfigParserConstants.NEWLINE);
            }
        }
        if (with.getResultKind() == Status.TIMEOUT) {
            if (with.langKind != LanguageKind.UNKNOWN) {
                this.append("################ " + with.langKind.DISPLAY_NAME + " Auto-config Directives " + LANGUAGE_SEPARATOR).append(IBuildConfigParserConstants.NEWLINE).append(TIMEOUT_MESSAGE).append(IBuildConfigParserConstants.NEWLINE);
            } else if (with.algorithmKind != AlgorithmKind.UNKNOWN) {
                this.append("################ " + (Object)((Object)with.algorithmKind) + " Auto-config Directives " + LANGUAGE_SEPARATOR).append(IBuildConfigParserConstants.NEWLINE).append(TIMEOUT_MESSAGE).append(IBuildConfigParserConstants.NEWLINE);
            }
        }
        if (with.getResultKind() != Status.EMPTY) {
            this.directives = this.directives.append((CharSequence)with.directives);
        } else {
            this.append("################ No files found. ################").append(IBuildConfigParserConstants.NEWLINE);
        }
        this.resultKind = Collections.max(Arrays.asList(this.resultKind, with.resultKind));
        this.errorMessages.addAll(with.errorMessages);
        return this;
    }

    public AutoConfigResult append(CharSequence string) {
        this.directives.append(string);
        return this;
    }

    public String toString() {
        return "[" + (Object)((Object)this.resultKind) + "] " + this.directives.substring(0, 10);
    }

    public LanguageKind getLangKind() {
        return this.langKind;
    }

    public void setLangKind(LanguageKind langKind) {
        this.langKind = langKind;
    }

    public AlgorithmKind getAlgorithmKind() {
        return this.algorithmKind;
    }

    public void setAlgorithmKind(AlgorithmKind algorithmKind) {
        this.algorithmKind = algorithmKind;
    }

    public static enum AlgorithmKind {
        UNKNOWN,
        ALTERA,
        XILINX;

    }

    public static enum Status {
        EMPTY,
        OK,
        ERROR,
        CANCELED,
        TIMEOUT;

    }
}

