/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.AutoConfigTimedOutException;
import ro.amiq.dvt.buildconfig.AutoconfigDebugKind;
import ro.amiq.dvt.buildconfig.AutoconfigFileGraph;
import ro.amiq.dvt.buildconfig.AutoconfigFileGraphNode;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class AutoConfigVhdl
extends AutoConfig {
    private static final String SINGLE_LINE_COMMENT = "--";
    private static final String LIBRARY = "LIBRARYNAME";
    private static final String PACKAGE = "PACKAGENAME";
    private static final String COMPONENT = "COMPONENTNAME";
    private static final String ENTITY = "ENTITYNAME";
    private static final String CONFIGURATION = "CONFIGURATIONNAME";
    private static final String USE_CONTENT = "USECONTENT";
    private static final String DUMMY_LIB = "__dvt__dummy_lib";
    private static final String INIT_LIB = " -work ";
    private static final String WORK_LIB_NAME = "work";
    private static final String EMPTY_STRING = "";
    private static final String MULTIPLE_ENTITIES = "Multiple entity declarations";
    private static final String MULTIPLE_ENTITY_DEFS = "Entity {0} in {1} also has declarations in: {2}";
    private static final Map<String, List<String>> LIB_DEPENDENCY = ImmutableMap.of((Object)"secureip", Arrays.asList("unisim"), (Object)"unimacro", Arrays.asList("unisim"));
    private static final Set<String> VHDL_XILINX_LIBRARIES = new HashSet<String>();
    private static final Set<String> VHDL_STD_LIBRARIES;
    private static final Set<String> VHDL_LIBRARIES;
    private Map<IPath, Set<String>> fPackagesProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fPackagesRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fComponentsProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fComponentsRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fEntitiesProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fEntitiesRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fConfigurationsProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fConfigurationsRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<String, TreeSet<IPath>> fElementsByFile = new HashMap<String, TreeSet<IPath>>();
    private Map<String, Set<String>> fElementsByLibrary = new HashMap<String, Set<String>>();
    private Map<String, TreeSet<IPath>> fPathsByLibrary = new TreeMap<String, TreeSet<IPath>>();
    private Set<String> fRequiredXilinxLibs = new HashSet<String>();
    private Set<IPath> fScannedSources = new TreeSet<IPath>(NORMAL_IPATH_COMPARATOR);
    private Set<IPath> fScannedFilesRealPaths = new TreeSet<IPath>(NORMAL_IPATH_COMPARATOR);
    private Map<String, TreeSet<String>> fMessagesByLibrary = new LinkedHashMap<String, TreeSet<String>>();
    private static final Matcher USE_MATCHER;
    private static final Matcher USE_CONTENT_PACKAGE_PATTERN;
    private static final Matcher USE_CONTENT_ENTITY_PATTERN;
    private static final Matcher PACKAGE_DEFINE_PATTERN;
    private static final Matcher ENTITY_DEFINE_PATTERN;
    private static final Matcher ENTITY_INSTANTIATION_PATTERN;
    private static final Matcher ENTITY_IN_ARCHITECTURE_DEF_PATTERN;
    private static final Matcher COMPONENT_ENTITY_BINDING_PATTERN;
    private static final Matcher COMPONENT_DEFINE_PATTERN;
    private static final Matcher COMPONENT_INSTANTIATION_PATTERN;
    private static final Matcher CONFIGURATION_DEFINE_PATTERN;
    private static final Matcher CONFIGURATION_USE_ENTITY;
    private static final Matcher CONFIGURATION_USE_CONFIG;
    private static final Map<String, String> VHDL_KEYWORDS_SET;

    static {
        IBuildConfigParserConstants.XilinxLibName[] xilinxLibNameArray = IBuildConfigParserConstants.XilinxLibName.values();
        int n = xilinxLibNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigParserConstants.XilinxLibName xl = xilinxLibNameArray[n2];
            VHDL_XILINX_LIBRARIES.add(xl.name().toLowerCase());
            ++n2;
        }
        VHDL_STD_LIBRARIES = ImmutableSet.of((Object)"ieee", (Object)"std");
        VHDL_LIBRARIES = new ImmutableSet.Builder().addAll(VHDL_STD_LIBRARIES).addAll(VHDL_XILINX_LIBRARIES).build();
        USE_MATCHER = Pattern.compile("\\buse\\s+(?<USECONTENT>.*;)", 2).matcher(EMPTY_STRING);
        USE_CONTENT_PACKAGE_PATTERN = Pattern.compile("\\b(?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?((?<PACKAGENAME>\\w+)(\\s+)?\\.(\\s+)?)?.*", 2).matcher(EMPTY_STRING);
        USE_CONTENT_ENTITY_PATTERN = Pattern.compile("\\b(?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?((?<ENTITYNAME>\\w+)(\\s+)?(\\s+)?)?;", 2).matcher(EMPTY_STRING);
        PACKAGE_DEFINE_PATTERN = Pattern.compile("\\bpackage\\s+(?<PACKAGENAME>\\w+)\\s+is", 2).matcher(EMPTY_STRING);
        ENTITY_DEFINE_PATTERN = Pattern.compile("\\bentity\\s+(?<ENTITYNAME>\\w+)\\s+is", 2).matcher(EMPTY_STRING);
        ENTITY_INSTANTIATION_PATTERN = Pattern.compile("\\w+(\\s+)?:(\\s+)?(entity\\s+)?((?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?)?(?<ENTITYNAME>\\w+);?", 2).matcher(EMPTY_STRING);
        ENTITY_IN_ARCHITECTURE_DEF_PATTERN = Pattern.compile("\\barchitecture\\s+(\\w+)\\s+of\\s+((?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?)?(?<ENTITYNAME>\\w+)").matcher(EMPTY_STRING);
        COMPONENT_ENTITY_BINDING_PATTERN = Pattern.compile("\\bcomponent\\s+(?<ENTITYNAME>\\w+\\s+is)", 2).matcher(EMPTY_STRING);
        COMPONENT_DEFINE_PATTERN = Pattern.compile("(?<!:\\s?)\\bcomponent\\s+(?<COMPONENTNAME>\\w+)", 2).matcher(EMPTY_STRING);
        COMPONENT_INSTANTIATION_PATTERN = Pattern.compile("\\w+(\\s+)?:(\\s+)?(component\\s+)?((?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?)?(?<COMPONENTNAME>\\w+);?", 2).matcher(EMPTY_STRING);
        CONFIGURATION_DEFINE_PATTERN = Pattern.compile("\\bconfiguration\\s+(?<CONFIGURATIONNAME>\\w+)\\s+of\\s+((?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?)?(?<ENTITYNAME>\\w+)\\s+is", 2).matcher(EMPTY_STRING);
        CONFIGURATION_USE_ENTITY = Pattern.compile("\\buse\\s+entity\\s+\\b(?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?(?<ENTITYNAME>\\w+)", 2).matcher(EMPTY_STRING);
        CONFIGURATION_USE_CONFIG = Pattern.compile("\\buse\\s+configuration\\s+\\b(?<LIBRARYNAME>\\w+)(\\s+)?\\.(\\s+)?(?<CONFIGURATIONNAME>\\w+)", 2).matcher(EMPTY_STRING);
        VHDL_KEYWORDS_SET = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String keyword : Arrays.asList("all", "out", "inout", "in", "process")) {
            VHDL_KEYWORDS_SET.put(keyword, EMPTY_STRING);
        }
    }

    @Override
    protected void scan(IPath path) {
        this.fScannedSources.add(path);
        if (BuildConfigManager.isProgressMonitorCanceled(this.getProject())) {
            if (this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN) && !this.isWildcardSortingAutoconfig()) {
                DVTBuildConsoleRegistry.getConsole(this.getProject()).print("Cancelled while scanning '" + path + "'");
            }
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader br = new BufferedReader(new FileReader(path.toOSString()));){
                String line = null;
                while ((line = br.readLine()) != null) {
                    if (BuildConfigManager.isProgressMonitorCanceled(this.getProject())) {
                        if (this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN) && !this.isWildcardSortingAutoconfig()) {
                            DVTBuildConsoleRegistry.getConsole(this.getProject()).print("Cancelled while scanning '" + path + "'");
                        }
                        return;
                    }
                    String lineWithoutComments = line;
                    int commentIndex = line.indexOf(SINGLE_LINE_COMMENT);
                    if (commentIndex != -1) {
                        lineWithoutComments = line.substring(0, commentIndex);
                    }
                    if (lineWithoutComments.isEmpty()) continue;
                    this.scanForElementsDefinition(lineWithoutComments, path);
                    this.scanForUseAndElementInstantiation(lineWithoutComments, path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void scanForElementsDefinition(String line, IPath path) {
        this.searchForMatchedPatternAndAddToMap(PACKAGE_DEFINE_PATTERN.reset(line), EMPTY_STRING, PACKAGE, true, path);
        this.searchForMatchedPatternAndAddToMap(ENTITY_DEFINE_PATTERN.reset(line), EMPTY_STRING, ENTITY, true, path);
        this.searchForMatchedPatternAndAddToMap(COMPONENT_DEFINE_PATTERN.reset(line), EMPTY_STRING, COMPONENT, true, path);
        this.searchForMatchedPatternAndAddToMap(CONFIGURATION_DEFINE_PATTERN.reset(line), EMPTY_STRING, CONFIGURATION, true, path);
    }

    public void scanForUseAndElementInstantiation(String line, IPath path) {
        Matcher useMatcher = USE_MATCHER.reset(line);
        while (useMatcher.find()) {
            String useContent = useMatcher.group(USE_CONTENT);
            if (useContent == null) continue;
            String[] splitUseContent = useContent.split(",");
            if (splitUseContent == null) {
                Matcher useContentPackageMatcher = USE_CONTENT_PACKAGE_PATTERN.reset(useContent);
                this.searchForMatchedPatternAndAddToMap(useContentPackageMatcher, LIBRARY, PACKAGE, false, path);
                Matcher useContentEntityMatcher = USE_CONTENT_ENTITY_PATTERN.reset(useContent);
                this.searchForMatchedPatternAndAddToMap(useContentEntityMatcher, LIBRARY, ENTITY, false, path);
                continue;
            }
            String[] stringArray = splitUseContent;
            int n = splitUseContent.length;
            int useContentEntityMatcher = 0;
            while (useContentEntityMatcher < n) {
                String splitContent = stringArray[useContentEntityMatcher];
                Matcher useContentPackageMatcher = USE_CONTENT_PACKAGE_PATTERN.reset(splitContent);
                this.searchForMatchedPatternAndAddToMap(useContentPackageMatcher, LIBRARY, PACKAGE, false, path);
                Matcher useContentEntityMatcher2 = USE_CONTENT_ENTITY_PATTERN.reset(useContent);
                this.searchForMatchedPatternAndAddToMap(useContentEntityMatcher2, LIBRARY, ENTITY, false, path);
                ++useContentEntityMatcher;
            }
        }
        Matcher entityInstantiation = ENTITY_INSTANTIATION_PATTERN.reset(line);
        this.searchForMatchedPatternAndAddToMap(entityInstantiation, LIBRARY, ENTITY, false, path);
        Matcher componentEntityBind = COMPONENT_ENTITY_BINDING_PATTERN.reset(line);
        this.resolveComponentBinding(componentEntityBind, ENTITY, path);
        Matcher componentInstantiation = COMPONENT_INSTANTIATION_PATTERN.reset(line);
        this.searchForMatchedPatternAndAddToMap(componentInstantiation, LIBRARY, COMPONENT, false, path);
        Matcher entityUsedInArchitecture = ENTITY_IN_ARCHITECTURE_DEF_PATTERN.reset(line);
        this.searchForMatchedPatternAndAddToMap(entityUsedInArchitecture, LIBRARY, ENTITY, false, path);
        Matcher configUsedInConfiguration = CONFIGURATION_USE_CONFIG.reset(line);
        this.searchForMatchedPatternAndAddToMap(configUsedInConfiguration, LIBRARY, CONFIGURATION, false, path);
        Matcher entityUsedInConfiguration = CONFIGURATION_USE_ENTITY.reset(line);
        this.searchForMatchedPatternAndAddToMap(entityUsedInConfiguration, LIBRARY, ENTITY, false, path);
    }

    /*
     * Unable to fully structure code
     */
    private void resolveComponentBinding(Matcher matcher, String elementGroup, IPath path) {
        if (matcher != null && path != null && elementGroup != null && !elementGroup.equals("")) ** GOTO lbl12
        return;
lbl-1000:
        // 1 sources

        {
            libName = "__dvt__dummy_lib";
            elementName = matcher.group(elementGroup);
            libName = libName.toLowerCase();
            elementName = elementName.toLowerCase();
            if (!this.fElementsByLibrary.containsKey(libName)) {
                this.fElementsByLibrary.put(libName, new LinkedHashSet<E>());
            }
            this.fElementsByLibrary.get(libName).add(elementName);
lbl12:
            // 2 sources

            ** while (matcher.find())
        }
lbl13:
        // 1 sources

    }

    /*
     * Unable to fully structure code
     */
    private void searchForMatchedPatternAndAddToMap(Matcher customMatcher, String libraryGroup, String elementGroup, boolean isElementDef, IPath path) {
        block15: {
            if (customMatcher == null || path == null || elementGroup == null || elementGroup.equals("")) {
                return;
            }
            if (!isElementDef) ** GOTO lbl100
            while (customMatcher.find()) {
                elementDef = customMatcher.group(elementGroup);
                if (elementDef == null) continue;
                elementDef = elementDef.toLowerCase();
                if (customMatcher != AutoConfigVhdl.COMPONENT_DEFINE_PATTERN) {
                    if (!this.fElementsByFile.containsKey(elementDef)) {
                        this.fElementsByFile.put(elementDef, new TreeSet<E>(AutoConfigVhdl.NORMAL_IPATH_COMPARATOR));
                    }
                    this.fElementsByFile.get(elementDef).add(path);
                }
                if (customMatcher == AutoConfigVhdl.PACKAGE_DEFINE_PATTERN) {
                    containsKey = this.fPackagesProvidedByFiles.containsKey(path);
                    set = containsKey != false ? this.fPackagesProvidedByFiles.get(path) : new LinkedHashSet<String>();
                    set.add(elementDef);
                    if (containsKey) continue;
                    this.fPackagesProvidedByFiles.put(path, set);
                    continue;
                }
                if (customMatcher == AutoConfigVhdl.COMPONENT_DEFINE_PATTERN) {
                    containsKey = this.fComponentsProvidedByFiles.containsKey(path);
                    set = containsKey != false ? this.fComponentsProvidedByFiles.get(path) : new LinkedHashSet<E>();
                    set.add(elementDef);
                    if (containsKey) continue;
                    this.fComponentsProvidedByFiles.put(path, set);
                    continue;
                }
                if (customMatcher == AutoConfigVhdl.CONFIGURATION_DEFINE_PATTERN) {
                    containsKey = this.fConfigurationsProvidedByFiles.containsKey(path);
                    set = containsKey != false ? this.fConfigurationsProvidedByFiles.get(path) : new LinkedHashSet<E>();
                    set.add(elementDef);
                    if (containsKey) continue;
                    this.fConfigurationsProvidedByFiles.put(path, set);
                    continue;
                }
                containsKey = this.fEntitiesProvidedByFiles.containsKey(path);
                set = containsKey != false ? this.fEntitiesProvidedByFiles.get(path) : new LinkedHashSet<E>();
                set.add(elementDef);
                if (containsKey) continue;
                this.fEntitiesProvidedByFiles.put(path, set);
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                libName = customMatcher.group(libraryGroup);
                if (libName == null || libName.equalsIgnoreCase("work")) {
                    libName = "__dvt__dummy_lib";
                }
                if (AutoConfigVhdl.VHDL_LIBRARIES.contains(libName = libName.toLowerCase())) {
                    if (AutoConfigVhdl.VHDL_STD_LIBRARIES.contains(libName)) continue;
                    this.fRequiredXilinxLibs.add(libName);
                    if (!AutoConfigVhdl.LIB_DEPENDENCY.containsKey(libName)) continue;
                    this.fRequiredXilinxLibs.addAll((Collection<String>)AutoConfigVhdl.LIB_DEPENDENCY.get(libName));
                    continue;
                }
                elementName = customMatcher.group(elementGroup);
                if (elementName == null || AutoConfigVhdl.VHDL_KEYWORDS_SET.containsKey(elementName)) continue;
                elementName = elementName.toLowerCase();
                if (customMatcher != AutoConfigVhdl.COMPONENT_INSTANTIATION_PATTERN && customMatcher != AutoConfigVhdl.ENTITY_IN_ARCHITECTURE_DEF_PATTERN) {
                    if (!this.fElementsByLibrary.containsKey(libName)) {
                        this.fElementsByLibrary.put(libName, new LinkedHashSet<E>());
                    }
                    this.fElementsByLibrary.get(libName).add(elementName);
                }
                if (customMatcher == AutoConfigVhdl.USE_CONTENT_PACKAGE_PATTERN) {
                    set = this.fPackagesRequiredByFiles.containsKey(path) != false ? this.fPackagesRequiredByFiles.get(path) : new LinkedHashSet<String>();
                    set.add(elementName);
                    if (this.fPackagesRequiredByFiles.containsKey(path)) continue;
                    this.fPackagesRequiredByFiles.put(path, set);
                    continue;
                }
                if (customMatcher == AutoConfigVhdl.COMPONENT_INSTANTIATION_PATTERN) {
                    set = this.fComponentsRequiredByFiles.containsKey(path) != false ? this.fComponentsRequiredByFiles.get(path) : new LinkedHashSet<E>();
                    set.add(elementName);
                    if (this.fComponentsRequiredByFiles.containsKey(path)) continue;
                    this.fComponentsRequiredByFiles.put(path, set);
                    continue;
                }
                if (customMatcher == AutoConfigVhdl.CONFIGURATION_USE_CONFIG) {
                    set = this.fConfigurationsRequiredByFiles.containsKey(path) != false ? this.fConfigurationsRequiredByFiles.get(path) : new LinkedHashSet<E>();
                    set.add(elementName);
                    if (this.fConfigurationsRequiredByFiles.containsKey(path)) continue;
                    this.fConfigurationsRequiredByFiles.put(path, set);
                    continue;
                }
                set = this.fEntitiesRequiredByFiles.containsKey(path) != false ? this.fEntitiesRequiredByFiles.get(path) : new LinkedHashSet<E>();
                set.add(elementName);
                if (this.fEntitiesRequiredByFiles.containsKey(path)) continue;
                this.fEntitiesRequiredByFiles.put(path, set);
lbl100:
                // 13 sources

                ** while (customMatcher.find())
            }
        }
    }

    private void computePathsByLibraries(String entity, Set<IPath> entityPaths, String lib) {
        if (entityPaths == null || entityPaths.isEmpty()) {
            return;
        }
        if (!this.fPathsByLibrary.containsKey(lib)) {
            this.fPathsByLibrary.put(lib, new TreeSet(NORMAL_IPATH_COMPARATOR));
        }
        IPath firstPathFound = entityPaths.iterator().next();
        this.fPathsByLibrary.get(lib).add(firstPathFound);
        this.fScannedSources.removeAll(entityPaths);
        if (entityPaths.size() == 1) {
            return;
        }
        Iterator<IPath> entityPathsIterator = entityPaths.iterator();
        entityPathsIterator.next();
        entityPathsIterator.remove();
        ArrayList remaining = new ArrayList();
        entityPathsIterator.forEachRemaining(t -> {
            boolean bl = remaining.add(t.makeRelativeTo(this.getCompilationRoot()));
        });
        TreeSet<String> libMessages = this.fMessagesByLibrary.get(lib);
        if (libMessages == null) {
            libMessages = new TreeSet();
            this.fMessagesByLibrary.put(lib, libMessages);
        }
        libMessages.add(MessageFormat.format(MULTIPLE_ENTITY_DEFS, entity, firstPathFound.makeRelativeTo(this.getCompilationRoot()), DVTStringUtil.join(remaining, ", ")));
    }

    @Override
    protected AutoConfigResult getResult(BuildConfigParser.AutoConfigParameters parameters) {
        StringBuilder allFilesVHDL = new StringBuilder();
        StringBuilder directives = new StringBuilder();
        String headerDirectives = this.getDirectives();
        Map<IPath, String> userSpecifiedTopFiles = this.computeUserSpecifiedTopFiles(LanguageKind.VHDL, e -> true);
        block0: for (Map.Entry<String, Set<String>> entry : this.fElementsByLibrary.entrySet()) {
            if (AutoConfigVhdl.getCreatingResultTimer().isTimeout()) break;
            String library = entry.getKey();
            for (String entity : entry.getValue()) {
                if (BuildConfigManager.isProgressMonitorCanceled(this.getProject())) {
                    return AutoConfigResult.CANCELED;
                }
                if (AutoConfigVhdl.getCreatingResultTimer().isTimeout()) continue block0;
                if (!this.fElementsByFile.containsKey(entity)) continue;
                Set libContentPaths = this.fElementsByFile.get(entity);
                this.computePathsByLibraries(entity, libContentPaths, library);
            }
        }
        String xilinxDirectives = AutoConfigVhdl.getXilinxDirectives(this.fRequiredXilinxLibs, parameters.invocation);
        if (!xilinxDirectives.isEmpty()) {
            directives.append(xilinxDirectives).append(NEWLINE);
        }
        this.convertDummyLib(parameters, userSpecifiedTopFiles.keySet());
        Map<String, List<IPath>> sortedPathsByLibrary = this.getSortedPathsByLibrary();
        for (Map.Entry<String, List<IPath>> entry : sortedPathsByLibrary.entrySet()) {
            String libName = entry.getKey();
            List<IPath> filesInLib = entry.getValue();
            String currentInvocationVhdlFiles = this.writeLibDirectives(headerDirectives, directives, userSpecifiedTopFiles, libName, filesInLib);
            allFilesVHDL.append(currentInvocationVhdlFiles);
        }
        if (allFilesVHDL.toString().trim().isEmpty()) {
            return AutoConfigResult.EMPTY;
        }
        String result = DVTStringUtil.replaceAll(MULTIPLE_BLANK_LINE_PATTERN, directives.append(NEWLINE), String.valueOf(NEWLINE) + NEWLINE);
        if (AutoConfigVhdl.getCreatingResultTimer().isTimeout() || AutoConfigVhdl.getScanningTimer().isTimeout()) {
            return new AutoConfigResult(AutoConfigResult.Status.TIMEOUT, LanguageKind.VHDL).append(result);
        }
        return new AutoConfigResult(AutoConfigResult.Status.OK, LanguageKind.VHDL).append(result);
    }

    private void convertDummyLib(BuildConfigParser.AutoConfigParameters parameters, Set<IPath> userSpecifiedTops) {
        String libName;
        boolean invocationContainsUserLib = this.invocationContainsUserDefinedLib(this.getParameters());
        String string = libName = invocationContainsUserLib ? parameters.invocation.getLibName().toLowerCase() : WORK_LIB_NAME;
        if (!this.fPathsByLibrary.containsKey(libName)) {
            this.fPathsByLibrary.put(libName, new TreeSet(NORMAL_IPATH_COMPARATOR));
            this.fMessagesByLibrary.put(libName, new TreeSet());
        }
        if (this.fPathsByLibrary.get(DUMMY_LIB) != null) {
            this.fPathsByLibrary.get(libName).addAll((Collection<IPath>)this.fPathsByLibrary.get(DUMMY_LIB));
        }
        this.fPathsByLibrary.get(libName).addAll(this.fScannedSources);
        userSpecifiedTops.forEach(top -> {
            boolean bl = this.fPathsByLibrary.get(libName).add((IPath)top);
        });
        if (this.fMessagesByLibrary.get(DUMMY_LIB) != null) {
            this.fMessagesByLibrary.get(libName).addAll((Collection<String>)this.fMessagesByLibrary.get(DUMMY_LIB));
        }
        this.fScannedSources.clear();
        this.fPathsByLibrary.remove(DUMMY_LIB);
        this.fMessagesByLibrary.remove(DUMMY_LIB);
    }

    private Map<String, List<IPath>> getSortedPathsByLibrary() {
        List<IPath> allFiles = this.fPathsByLibrary.values().stream().flatMap(Collection::stream).distinct().collect(Collectors.toList());
        this.sortGraphUsingDegree(allFiles);
        ArrayList<Map.Entry<String, TreeSet<IPath>>> pathByLibrary = new ArrayList<Map.Entry<String, TreeSet<IPath>>>(this.fPathsByLibrary.entrySet());
        pathByLibrary.sort((e1, e2) -> ((String)e1.getKey()).compareTo((String)e2.getKey()));
        this.fPathsByLibrary.clear();
        LinkedHashMap<String, List<IPath>> result = new LinkedHashMap<String, List<IPath>>();
        String libName = EMPTY_STRING;
        for (IPath file : allFiles) {
            for (Map.Entry entry : pathByLibrary) {
                if (!((TreeSet)entry.getValue()).contains(file)) continue;
                libName = (String)entry.getKey();
                if (result.get(libName) == null) {
                    result.put(libName, new ArrayList());
                }
                ((List)result.get(libName)).add(file);
            }
        }
        return result;
    }

    @Override
    protected void sortGraphUsingDegree(List<IPath> topFiles) {
        try {
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(this.getProject());
            boolean flagDebug = this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SORT);
            long sortingStartTimestamp = System.currentTimeMillis();
            if (flagDebug) {
                buildConsole.print(String.valueOf(System.lineSeparator()) + "Sorting files begin");
            }
            AutoconfigFileGraph topFilesGraph = new AutoconfigFileGraph();
            topFilesGraph.setCanceler(() -> BuildConfigManager.isProgressMonitorCanceled(this.getProject()));
            for (IPath topFile : topFiles) {
                AutoconfigFileGraphNode node = new AutoconfigFileGraphNode(topFile);
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.ENTITY, this.fEntitiesProvidedByFiles.get(topFile), this.fEntitiesRequiredByFiles.get(topFile));
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.VHDL_PACKAGE, this.fPackagesProvidedByFiles.get(topFile), this.fPackagesRequiredByFiles.get(topFile));
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.COMPONENT, this.fComponentsProvidedByFiles.get(topFile), this.fComponentsRequiredByFiles.get(topFile));
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.CONFIGURATION, this.fConfigurationsProvidedByFiles.get(topFile), this.fConfigurationsRequiredByFiles.get(topFile));
                topFilesGraph.addVertex(node);
            }
            topFilesGraph.createGraph();
            if (flagDebug) {
                buildConsole.print("Step 1: Dependencies between files" + System.lineSeparator() + topFilesGraph.debugPrintGraphString());
            }
            topFiles.clear();
            if (topFilesGraph.isCyclic()) {
                if (flagDebug) {
                    buildConsole.print("Step 2: Circular dependencies found in given files.");
                    buildConsole.print("Solving them and sorting files...");
                }
                List<IPath> orderedTopFiles = topFilesGraph.sortFilesUsingDegreeMethod();
                topFiles.addAll(orderedTopFiles);
            } else {
                if (flagDebug) {
                    buildConsole.print("Step 2: No circular dependencies found in given files.");
                    buildConsole.print("Sorting files...");
                }
                topFiles.addAll(topFilesGraph.topologicalSort());
            }
            if (flagDebug) {
                buildConsole.print(EMPTY_STRING);
            }
            if (flagDebug) {
                buildConsole.print("Step 3: Printing files in order (" + topFiles.size() + " files)");
                for (IPath file : topFiles) {
                    buildConsole.print(file.lastSegment());
                }
                long sortingEndTimestamp = System.currentTimeMillis();
                buildConsole.print("Done sorting. [" + (sortingEndTimestamp - sortingStartTimestamp) + " ms]");
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            topFiles.clear();
        }
        catch (AutoConfigTimedOutException e) {
            DVTLogger.INSTANCE.logInfo(e.getMessage());
            topFiles = e.getPartialResult();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private String writeLibDirectives(String headerDirectives, StringBuilder directives, Map<IPath, String> userSpecifiedTopFiles, String internalLibName, Collection<IPath> libPaths) {
        boolean invocationContainsUserLib;
        if (libPaths == null) {
            return EMPTY_STRING;
        }
        StringBuilder currentInvocationVhdlFiles = new StringBuilder();
        String initText = this.getParameters().initText;
        String reuseText = DVTStringUtil.replaceAll(WORK_REGEX_PATTERN, headerDirectives, EMPTY_STRING);
        directives.append(initText).append(INIT_LIB).append(internalLibName).append(NEWLINE).append(reuseText).append(NEWLINE);
        boolean bl = invocationContainsUserLib = internalLibName.equals(WORK_LIB_NAME) || internalLibName.equals(this.getParameters().invocation.getLibName().toLowerCase());
        if (invocationContainsUserLib) {
            for (Map.Entry<IPath, String> entry : userSpecifiedTopFiles.entrySet()) {
                currentInvocationVhdlFiles.append(entry.getValue()).append(NEWLINE);
                libPaths.remove(entry.getKey());
            }
        }
        Set<IPath> userSpecifiedTopFilesSet = userSpecifiedTopFiles.keySet();
        for (IPath path : libPaths) {
            if (userSpecifiedTopFilesSet.contains(path)) continue;
            String relativeToCompRootPathString = path.makeRelativeTo(this.getCompilationRoot()).toOSString();
            if (relativeToCompRootPathString.contains(" ")) {
                currentInvocationVhdlFiles.append("\"" + relativeToCompRootPathString + "\"").append(NEWLINE);
                continue;
            }
            currentInvocationVhdlFiles.append(relativeToCompRootPathString).append(NEWLINE);
        }
        Set libMessages = this.fMessagesByLibrary.get(internalLibName);
        if (libMessages != null && !libMessages.isEmpty()) {
            currentInvocationVhdlFiles.append(AutoConfigVhdl.comment(AutoConfig.CommentType.WARNING, MULTIPLE_ENTITIES)).append(NEWLINE);
            currentInvocationVhdlFiles.append("# ").append(DVTStringUtil.join(libMessages, String.valueOf(NEWLINE) + "# "));
        }
        directives.append(currentInvocationVhdlFiles.toString()).append(NEWLINE);
        return currentInvocationVhdlFiles.toString();
    }

    @Override
    public void addSkippedPath(IPath filePath) {
    }

    @Override
    public boolean shouldScanFile(IPath filePath) {
        return false;
    }

    @Override
    protected void addScannedFiles(IPath path) {
        if (!this.fScannedFilesRealPaths.contains(path)) {
            this.fScannedFilesRealPaths.add(path);
        }
    }

    @Override
    protected Set<IPath> getScannedFiles() {
        return this.fScannedFilesRealPaths;
    }
}

