/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import antlr.Token;
import antlr.TokenStreamException;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.AutoConfigResult;
import ro.amiq.dvt.buildconfig.AutoConfigTimedOutException;
import ro.amiq.dvt.buildconfig.AutoConfigVlogLexer;
import ro.amiq.dvt.buildconfig.AutoconfigDebugKind;
import ro.amiq.dvt.buildconfig.AutoconfigFileGraph;
import ro.amiq.dvt.buildconfig.AutoconfigFileGraphNode;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class AutoConfigVlog
extends AutoConfig {
    private static final String INCDIR = "+incdir+";
    private static final String QUOTE_MARK = "\"";
    private static final String OVM_MACROS_FILENAME = "ovm_macros.svh";
    private static final String OVM_FILENAME = "ovm.svh";
    private static final String OVM_H_FILENAME = "ovm.sv";
    private static final String OVM_PKG_FILENAME = "ovm_pkg.sv";
    private static final Set<String> OVM_FILENAMES = new HashSet<String>(Arrays.asList("ovm_macros.svh", "ovm.svh", "ovm.sv", "ovm_pkg.sv"));
    private static final String UVM_MACROS_FILENAME = "uvm_macros.svh";
    private static final String UVM_H_FILENAME = "uvm.svh";
    private static final String UVM_FILENAME = "uvm.sv";
    private static final String UVM_PKG_FILENAME = "uvm_pkg.sv";
    private static final Set<String> UVM_FILENAMES = new HashSet<String>(Arrays.asList("uvm_macros.svh", "uvm.svh", "uvm.sv", "uvm_pkg.sv"));
    private static final String OVM_PKG = "ovm_pkg";
    private static final String UVM_PKG = "uvm_pkg";
    private static final Set<String> PREPROCESSOR_DIRECTIVES = new HashSet<String>(Arrays.asList("define", "undef", "resetall", "undefineall", "unconnected_drive", "include", "timescale", "ifdef", "ifndef", "elsif", "else", "endif", "line", "begin_keywords", "end_keywords", "default_nettype", "pragma", "protect", "protected", "endprotect", "endprotected", "suppress_faults", "enable_portfaults", "disable_portfaults", "nosuppress_faults", "suppress_faults", "enable_portfaults", "disable_portfaults", "nosuppress_faults", "default_decay_time", "default_trireg_strength", "delay_mode_distributed", "delay_mode_path", "delay_mode_unit", "delay_mode_zero", "uselib", "celldefine", "endcelldefine"));
    private static final String INCLUDE_FORMAT = "`include \"{0}\" in {1} ({2})";
    private static final Set<String> PREDEFINED_MACROS = new HashSet<String>(Arrays.asList("__FILE__", "__LINE__", "timescale", "default_nettype"));
    public static final Set<String> UVM_MACROS = new HashSet<String>(Arrays.asList("uvm_info", "uvm_warning", "uvm_error", "uvm_fatal", "uvm_info_context", "uvm_warning_context", "uvm_error_context", "uvm_fatal_context", "uvm_field_utils_begin", "uvm_field_utils_end", "uvm_object_utils", "uvm_object_param_utils", "uvm_object_utils_begin", "uvm_object_param_utils_begin", "uvm_object_utils_end", "uvm_update_sequence_lib_and_item", "uvm_component_utils", "uvm_component_param_utils", "uvm_component_utils_begin", "uvm_component_param_utils_begin", "uvm_component_utils_end", "uvm_add_to_seq_lib", "uvm_object_registry", "uvm_component_registry", "uvm_field_int", "uvm_field_object", "uvm_field_string", "uvm_field_enum", "uvm_field_real", "uvm_field_event", "uvm_field_sarray_int", "uvm_field_sarray_object", "uvm_field_sarray_string", "uvm_field_sarray_enum", "uvm_field_array_int", "uvm_field_array_object", "uvm_field_array_string", "uvm_field_array_enum", "uvm_field_queue_int", "uvm_field_queue_object", "uvm_field_queue_string", "uvm_field_queue_enum", "uvm_field_aa_int_string", "uvm_field_aa_object_string", "uvm_field_aa_string_string", "uvm_field_aa_object_int", "uvm_field_aa_int_int", "uvm_field_aa_int_int_unsigned", "uvm_field_aa_int_integer", "uvm_field_aa_int_integer_unsigned", "uvm_field_aa_int_byte", "uvm_field_aa_int_byte_unsigned", "uvm_field_aa_int_shortint", "uvm_field_aa_int_shortint_unsigned", "uvm_field_aa_int_longint", "uvm_field_aa_int_longint_unsigned", "uvm_field_aa_int_key", "uvm_field_aa_int_enumkey", "uvm_record_attribute", "uvm_record_field", "uvm_pack_intN", "uvm_pack_enumN", "uvm_pack_sarrayN", "uvm_pack_arrayN", "uvm_pack_queueN", "uvm_pack_int", "uvm_pack_enum", "uvm_pack_string", "uvm_pack_real", "uvm_pack_sarray", "uvm_pack_array", "uvm_pack_queue", "uvm_unpack_intN", "uvm_unpack_enumN", "uvm_unpack_sarrayN", "uvm_unpack_arrayN", "uvm_unpack_queueN", "uvm_unpack_int", "uvm_unpack_enum", "uvm_unpack_string", "uvm_unpack_real", "uvm_unpack_sarray", "uvm_unpack_array", "uvm_unpack_queue", "uvm_create", "uvm_do", "uvm_do_pri", "uvm_do_with", "uvm_do_pri_with", "uvm_create_on", "uvm_do_on", "uvm_do_on_pri", "uvm_do_on_with", "uvm_do_on_pri_with", "uvm_send", "uvm_send_pri", "uvm_rand_send", "uvm_rand_send_pri", "uvm_rand_send_with", "uvm_rand_send_pri_with", "uvm_declare_p_sequencer", "uvm_register_cb", "uvm_set_super_type", "uvm_do_callbacks", "uvm_do_obj_callbacks", "uvm_do_callbacks_exit_on", "uvm_do_obj_callbacks_exit_on", "uvm_blocking_put_imp_decl", "uvm_nonblocking_put_imp_decl", "uvm_put_imp_decl", "uvm_blocking_get_imp_decl", "uvm_nonblocking_get_imp_decl", "uvm_get_imp_decl", "uvm_blocking_peek_imp_decl", "uvm_nonblocking_peek_imp_decl", "uvm_peek_imp_decl", "uvm_blocking_get_peek_imp_decl", "uvm_nonblocking_get_peek_imp_decl", "uvm_get_peek_imp_decl", "uvm_blocking_master_imp_decl", "uvm_nonblocking_master_imp_decl", "uvm_master_imp_decl", "uvm_blocking_slave_imp_decl", "uvm_nonblocking_slave_imp_decl", "uvm_slave_imp_decl", "uvm_blocking_transport_imp_decl", "uvm_nonblocking_transport_imp_decl", "uvm_transport_imp_decl", "uvm_analysis_imp_decl", "UVM_REG_ADDR_WIDTH", "UVM_REG_DATA_WIDTH", "UVM_REG_BYTENABLE_WIDTH", "UVM_REG_CVR_WIDTH", "UVM_DEFAULT_TIMEOUT", "UVM_MAX_STREAMBITS", "UVM_PACKER_MAX_BYTES", "UVM_TLM_B_MASK", "UVM_TLM_B_TRANSPORT_IMP", "UVM_TLM_FUNCTION_ERROR", "UVM_TLM_NB_BW_MASK", "UVM_TLM_NB_FW_MASK", "UVM_TLM_NB_TRANSPORT_BW_IMP", "UVM_TLM_NB_TRANSPORT_FW_IMP", "UVM_TLM_TASK_ERROR", "UVM_TLM_ANALYSIS_MASK", "uvm_sequence_utils", "uvm_sequencer_param_utils"));
    public static final Set<String> OVM_MACROS = new HashSet<String>(Arrays.asList("ovm_phase_func_decl", "ovm_phase_task_decl", "ovm_phase_func_topdown_decl", "ovm_phase_func_bottomup_decl", "ovm_phase_task_topdown_decl", "ovm_phase_task_bottomup_decl", "ovm_info", "ovm_warning", "ovm_error", "ovm_fatal", "ovm_field_utils_begin", "ovm_field_utils_end", "ovm_object_utils", "ovm_object_param_utils", "ovm_object_utils_begin", "ovm_object_param_utils_begin", "ovm_object_utils_end", "ovm_component_utils", "ovm_component_param_utils", "ovm_component_utils_begin", "ovm_component_param_utils_begin", "ovm_component_utils_end", "ovm_field_int", "ovm_field_object", "ovm_field_string", "ovm_field_enum", "ovm_field_real", "ovm_field_event", "ovm_field_sarray_int", "ovm_field_sarray_object", "ovm_field_sarray_string", "ovm_field_sarray_enum", "ovm_field_array_int", "ovm_field_array_object", "ovm_field_array_string", "ovm_field_array_enum", "ovm_field_queue_int", "ovm_field_queue_object", "ovm_field_queue_string", "ovm_field_queue_enum", "ovm_field_aa_int_string", "ovm_field_aa_object_string", "ovm_field_aa_string_string", "ovm_field_aa_object_int", "ovm_field_aa_int_int", "ovm_field_aa_int_int_unsigned", "ovm_field_aa_int_integer", "ovm_field_aa_int_integer_unsigned", "ovm_field_aa_int_byte", "ovm_field_aa_int_byte_unsigned", "ovm_field_aa_int_shortint", "ovm_field_aa_int_shortint_unsigned", "ovm_field_aa_int_longint", "ovm_field_aa_int_longint_unsigned", "ovm_field_aa_int_key", "ovm_field_aa_int_enumkey", "ovm_declare_p_sequencer", "ovm_sequence_utils_begin", "ovm_sequence_utils_end", "ovm_sequence_utils", "ovm_update_sequence_lib", "ovm_update_sequence_lib_and_item", "ovm_sequencer_utils", "ovm_sequencer_utils_begin", "ovm_sequencer_param_utils", "ovm_sequencer_param_utils_begin", "ovm_sequencer_utils_end", "ovm_create", "ovm_do", "ovm_do_pri", "ovm_do_with", "ovm_do_pri_with", "ovm_send", "ovm_send_pri", "ovm_rand_send", "ovm_rand_send_pri", "ovm_rand_send_with", "ovm_rand_send_pri_with", "ovm_create_on", "ovm_do_on", "ovm_do_on_pri", "ovm_do_on_with", "ovm_do_on_pri_with", "ovm_blocking_put_imp_decl", "ovm_nonblocking_put_imp_decl", "ovm_put_imp_decl", "ovm_blocking_get_imp_decl", "ovm_nonblocking_get_imp_decl", "ovm_get_imp_decl", "ovm_blocking_peek_imp_decl", "ovm_nonblocking_peek_imp_decl", "ovm_peek_imp_decl", "ovm_blocking_get_peek_imp_decl", "ovm_nonblocking_get_peek_imp_decl", "ovm_get_peek_imp_decl", "ovm_blocking_master_imp_decl", "ovm_nonblocking_master_imp_decl", "ovm_master_imp_decl", "ovm_blocking_slave_imp_decl", "ovm_nonblocking_slave_imp_decl", "ovm_slave_imp_decl", "ovm_blocking_transport_imp_decl", "ovm_nonblocking_transport_imp_decl", "ovm_transport_imp_decl", "ovm_analysis_imp_decl", "ovm_do_callbacks", "ovm_do_obj_callbacks", "ovm_do_callbacks_exit_on", "ovm_do_obj_callbacks_exit_on", "ovm_do_task_callbacks", "ovm_do_ext_task_callbacks"));
    private TreeSet<IPath> fScannedSources = new TreeSet(REVERSE_IPATH_COMPARATOR);
    private Set<IPath> fScannedFilesRealPaths = new TreeSet<IPath>(REVERSE_IPATH_COMPARATOR);
    private Map<IPath, Set<String>> fDefinesProvidedByTopFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fDefinesProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fDefinesRequiredByTopFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fDefinesRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fDefinesIfdefedByTopFiles = new LinkedHashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fDefinesIfdefedByFiles = new LinkedHashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fPkgsProvidedByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fPkgsRequiredByFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fPkgsProvidedByTopFiles = new HashMap<IPath, Set<String>>();
    private Map<IPath, Set<String>> fPkgsRequiredByTopFiles = new HashMap<IPath, Set<String>>();
    private Map<List<String>, List<IPath>> fComputedIncdirs = new LinkedHashMap<List<String>, List<IPath>>();
    private Map<IPath, List<String>> fIncludes = new TreeMap<IPath, List<String>>(NORMAL_IPATH_COMPARATOR);
    private Map<IPath, List<IPath>> fIncludedPaths = new TreeMap<IPath, List<IPath>>(NORMAL_IPATH_COMPARATOR);
    private Set<IPath> fComputedTopFiles = new TreeSet<IPath>(NORMAL_IPATH_COMPARATOR);
    private Set<String> fUnresolvedMacros = new LinkedHashSet<String>();
    private boolean fIsUVMContained;
    private boolean fIsOVMContained;
    private boolean fIncludesUVM;
    private boolean fIncludesOVM;
    private Set<String> fUnmatchableIncludes = new LinkedHashSet<String>();
    private Set<String> fInvalidIncludes = new LinkedHashSet<String>();
    private TreeSet<IPath> fVisitedDirectories = new TreeSet(NORMAL_IPATH_COMPARATOR);
    private Set<IPath> fAppendedIncdirs = new HashSet<IPath>();
    private TreeSet<IPath> fSkippedFilePaths = new TreeSet(REVERSE_IPATH_COMPARATOR);
    private TreeSet<IPath> fIncludedPathsToBeScanned = new TreeSet(REVERSE_IPATH_COMPARATOR);
    private Set<String> fUserDefines;

    private boolean isXvmSpecified(Invocation invocation, String topTailString) {
        ArrayList<BuildConfigProperty> xvmTopProperties = new ArrayList<BuildConfigProperty>();
        List<BuildConfigProperty> topProps = BuildConfigManager.getTopFiles(invocation, LanguageKind.VLOG);
        for (BuildConfigProperty property : topProps) {
            if (!property.getValue().endsWith(topTailString)) continue;
            xvmTopProperties.add(property);
        }
        if (xvmTopProperties.isEmpty()) {
            return false;
        }
        HashSet incdirs = new HashSet();
        BuildConfigManager.getIncdirs(null, invocation).stream().map(e -> Path.fromOSString((String)e)).forEach(p -> {
            boolean bl = incdirs.add(p);
        });
        for (BuildConfigProperty xvmTopProperty : xvmTopProperties) {
            IPath requiredIncdir = Path.fromOSString((String)xvmTopProperty.getValue()).removeLastSegments(1);
            if (!incdirs.contains(requiredIncdir)) continue;
            return true;
        }
        return false;
    }

    private boolean isUVMorOVMbuildConfigProperty(BuildConfigProperty e) {
        String reuseText = this.getParameters().reuseText;
        boolean isUvmShortcutInReuseText = reuseText.contains("-uvm") || reuseText.contains("-uvmhome") || reuseText.contains("-ml_uvm") || reuseText.contains("-uvmexthome");
        boolean isOvmShortcutInReuseText = reuseText.contains("-ovm") || reuseText.contains("-ovmhome");
        boolean isUvmPkg = IBuildConfigParserConstants.ALL_UVM_PKG_SV.stream().anyMatch(uvmPkg -> e.getValue().contains((CharSequence)uvmPkg));
        boolean isOvmPkg = IBuildConfigParserConstants.ALL_OVM_PKG_SV.stream().anyMatch(ovmPkg -> e.getValue().contains((CharSequence)ovmPkg));
        return isUvmPkg && isUvmShortcutInReuseText || isOvmPkg && isOvmShortcutInReuseText;
    }

    @Override
    protected AutoConfigResult getResult(BuildConfigParser.AutoConfigParameters parameters) {
        List allIfdefControls;
        this.fUserDefines = parameters.defines == null ? Collections.emptySet() : parameters.defines;
        StringBuilder vlogFiles = new StringBuilder();
        String headerDirectives = parameters.initText;
        Map<IPath, String> userSpecifiedTopFiles = this.computeUserSpecifiedTopFiles(LanguageKind.VLOG, e -> !this.isUVMorOVMbuildConfigProperty((BuildConfigProperty)e));
        vlogFiles.append(String.valueOf(userSpecifiedTopFiles.values().stream().collect(Collectors.joining(NEWLINE))) + NEWLINE);
        this.computeIncdirs();
        boolean isUVMInReuseText = this.isXvmSpecified(parameters.invocation, "/uvm_pkg.sv");
        boolean isOVMInReuseText = this.isXvmSpecified(parameters.invocation, "/ovm_pkg.sv");
        StringBuilder directives = new StringBuilder();
        if (this.fIncludesUVM && !this.fIsUVMContained && !isUVMInReuseText) {
            directives.append("-uvm").append(NEWLINE);
        }
        if (this.fIncludesOVM && !this.fIsOVMContained && !isOVMInReuseText) {
            directives.append("-ovm").append(NEWLINE);
        }
        this.appendIncdirs(directives);
        directives.append(NEWLINE);
        this.computeTopFileIncludes(this.fComputedTopFiles);
        ArrayList<IPath> topFiles = new ArrayList<IPath>(this.fComputedTopFiles);
        this.sortGraphUsingDegree(topFiles);
        this.computeUnresolvedMacros(topFiles);
        if (!this.fUnresolvedMacros.isEmpty()) {
            directives.append(AutoConfigVlog.comment(AutoConfig.CommentType.WARNING, "Missing macro definitions\n# The following macros are used but not defined:")).append(NEWLINE);
            for (String unresolvedMacro : this.fUnresolvedMacros) {
                directives.append("# +define+" + unresolvedMacro).append(NEWLINE);
            }
            directives.append(NEWLINE);
        }
        if (!(allIfdefControls = this.fDefinesIfdefedByFiles.values().stream().flatMap(Collection::stream).distinct().sorted().collect(Collectors.toList())).isEmpty()) {
            directives.append("# Available `ifdef / `ifndef controls:").append(NEWLINE);
            for (String unresolvedMacro : allIfdefControls) {
                directives.append("# +define+" + unresolvedMacro).append(NEWLINE);
            }
            directives.append(NEWLINE);
        }
        List<IPath> potentialInternalUnorderedTopFiles = this.getPotentialUnorderedTopFiles(topFiles);
        this.addRequiredTopFilesForMacros(potentialInternalUnorderedTopFiles, topFiles);
        Set<IPath> userSpecifiedTopFilesSet = userSpecifiedTopFiles.keySet();
        for (IPath top : topFiles) {
            if (userSpecifiedTopFilesSet.contains(top)) continue;
            if (top.makeRelativeTo(this.getCompilationRoot()).toOSString().contains(" ")) {
                vlogFiles.append(QUOTE_MARK + top.makeRelativeTo(this.getCompilationRoot()) + QUOTE_MARK).append(NEWLINE);
                continue;
            }
            vlogFiles.append(top.makeRelativeTo(this.getCompilationRoot())).append(NEWLINE);
        }
        if (vlogFiles.toString().trim().isEmpty()) {
            return AutoConfigResult.EMPTY;
        }
        headerDirectives = String.valueOf(headerDirectives) + this.getDirectives();
        String result = String.valueOf(headerDirectives) + directives.toString() + vlogFiles.toString() + NEWLINE;
        result = DVTStringUtil.replaceAll(MULTIPLE_BLANK_LINE_PATTERN, result, String.valueOf(NEWLINE) + NEWLINE);
        if (AutoConfigVlog.getCreatingResultTimer().isTimeout() || AutoConfigVlog.getScanningTimer().isTimeout()) {
            return new AutoConfigResult(AutoConfigResult.Status.TIMEOUT, LanguageKind.VLOG).append(result);
        }
        return new AutoConfigResult(AutoConfigResult.Status.OK, LanguageKind.VLOG).append(result);
    }

    private void aggregatePackageDataByTops() {
        for (IPath topFile : this.fComputedTopFiles) {
            List<IPath> included;
            HashSet<String> pkgsProvidedByTopFile = new HashSet<String>();
            this.fPkgsProvidedByTopFiles.put(topFile, pkgsProvidedByTopFile);
            Set<String> providedByTopItself = this.fPkgsProvidedByFiles.get(topFile);
            if (providedByTopItself != null) {
                pkgsProvidedByTopFile.addAll(providedByTopItself);
            }
            HashSet<String> pkgsRequiredByTopFile = new HashSet<String>();
            this.fPkgsRequiredByTopFiles.put(topFile, pkgsRequiredByTopFile);
            Set<String> requiredByTopItself = this.fPkgsRequiredByFiles.get(topFile);
            if (requiredByTopItself != null) {
                pkgsRequiredByTopFile.addAll(requiredByTopItself);
            }
            if ((included = this.fIncludedPaths.get(topFile)) == null) continue;
            for (IPath includedByTop : included) {
                Set<String> requiredByIncluded;
                Set<String> providedByIncluded = this.fPkgsProvidedByFiles.get(includedByTop);
                if (providedByIncluded != null) {
                    pkgsProvidedByTopFile.addAll(providedByIncluded);
                }
                if ((requiredByIncluded = this.fPkgsRequiredByFiles.get(includedByTop)) == null) continue;
                pkgsRequiredByTopFile.addAll(requiredByIncluded);
            }
        }
    }

    private void appendIncdirs(StringBuilder directives) {
        IProject project = this.getProject();
        block0: for (Map.Entry<List<String>, List<IPath>> entry : this.fComputedIncdirs.entrySet()) {
            Object relativePathIncdir;
            if (BuildConfigManager.isProgressMonitorCanceled(project) || AutoConfigVlog.getCreatingResultTimer().isTimeout()) {
                return;
            }
            List<String> includes = entry.getKey();
            List<IPath> incdirs = entry.getValue();
            incdirs.remove(this.getCompilationRoot());
            if (incdirs.isEmpty()) continue;
            if (incdirs.size() == 1) {
                IPath incdir = incdirs.get(0);
                if (this.fAppendedIncdirs.contains(incdir)) continue;
                relativePathIncdir = this.getQuotedProjectRelativePath(incdir);
                directives.append(INCDIR).append((String)relativePathIncdir).append(NEWLINE);
                this.fAppendedIncdirs.add(incdir);
                continue;
            }
            for (IPath incdir : incdirs) {
                if (this.fAppendedIncdirs.contains(incdir)) continue block0;
            }
            directives.append(NEWLINE);
            directives.append(AutoConfigVlog.comment(AutoConfig.CommentType.WARNING, "Multiple incdir candidates.\n# The following includes have multiple incdir candidates:")).append(NEWLINE);
            for (String include : includes) {
                directives.append("#" + include).append(NEWLINE);
            }
            directives.append("# The list of incdir candidates is:").append(NEWLINE);
            incdirs = this.getOrderedIncdirs(includes, incdirs);
            int i = 0;
            while (i < incdirs.size()) {
                relativePathIncdir = this.getQuotedProjectRelativePath(incdirs.get(i));
                if (i == 0) {
                    directives.append(INCDIR).append((String)relativePathIncdir).append(NEWLINE);
                } else {
                    directives.append("# +incdir+").append((String)relativePathIncdir).append(NEWLINE);
                }
                ++i;
            }
            directives.append(NEWLINE);
        }
        if (!this.fUnmatchableIncludes.isEmpty()) {
            directives.append(NEWLINE).append(AutoConfigVlog.comment(AutoConfig.CommentType.ERROR, "Unresolved includes\n# The following includes could not be resolved:"));
            for (String include : this.fUnmatchableIncludes) {
                directives.append(String.valueOf(NEWLINE) + "#" + include);
            }
            directives.append(NEWLINE);
        }
        if (!this.fInvalidIncludes.isEmpty()) {
            directives.append(NEWLINE).append(AutoConfigVlog.comment(AutoConfig.CommentType.ERROR, "Bad `include format\n# Unable to process the following includes:"));
            for (String include : this.fInvalidIncludes) {
                directives.append(String.valueOf(NEWLINE) + "#" + include);
            }
            directives.append(NEWLINE);
        }
    }

    private List<IPath> getOrderedIncdirs(List<String> includes, List<IPath> incdirs) {
        if (incdirs == null) {
            return Collections.emptyList();
        }
        ArrayList<String> includesFiles = new ArrayList<String>();
        for (String include : includes) {
            Matcher m = Pattern.compile("\\((.+)\\)").matcher(include);
            if (!m.find()) continue;
            includesFiles.add(m.group(1));
        }
        HashMap<IPath, Integer> incdirsMap = new HashMap<IPath, Integer>();
        for (String include : includesFiles) {
            for (IPath incdir : incdirs) {
                java.nio.file.Path pathIncdir = Paths.get(incdir.toOSString(), new String[0]).toAbsolutePath().normalize();
                int numberOfSegmentsInRelativePath = DVTFileUtils.getInstance().relativize(Paths.get(include, new String[0]), pathIncdir).getNameCount();
                if (incdirsMap.containsKey(incdir)) {
                    incdirsMap.put(incdir, numberOfSegmentsInRelativePath + (Integer)incdirsMap.get(incdir));
                    continue;
                }
                incdirsMap.put(incdir, numberOfSegmentsInRelativePath);
            }
        }
        List<IPath> sortedIncdirs = incdirsMap.entrySet().stream().sorted((o1, o2) -> {
            int cmpValue = (Integer)o1.getValue() - (Integer)o2.getValue();
            if (cmpValue == 0) {
                return ((IPath)o1.getKey()).toOSString().compareTo(((IPath)o2.getKey()).toOSString());
            }
            return cmpValue;
        }).map(x -> (IPath)x.getKey()).collect(Collectors.toList());
        return sortedIncdirs;
    }

    private String getQuotedProjectRelativePath(IPath path) {
        String relativePath = path.makeRelativeTo(this.getCompilationRoot()).toOSString();
        return relativePath.contains(" ") ? QUOTE_MARK + relativePath + QUOTE_MARK : relativePath;
    }

    private void computeTopFileIncludes(Set<IPath> topFiles) {
        Iterator<IPath> mapIterator = this.fIncludedPaths.keySet().iterator();
        block0: while (mapIterator.hasNext()) {
            IPath includeParent = mapIterator.next();
            if (topFiles.contains(includeParent)) continue;
            Iterator<IPath> innerIterator = this.fIncludedPaths.keySet().iterator();
            while (innerIterator.hasNext()) {
                if (BuildConfigManager.isProgressMonitorCanceled(this.getProject()) || AutoConfigVlog.getCreatingResultTimer().isTimeout()) {
                    return;
                }
                IPath innerParent = innerIterator.next();
                List<IPath> innerIncludeList = this.fIncludedPaths.get(innerParent);
                if (!innerIncludeList.contains(includeParent)) continue;
                if (innerIncludeList.indexOf(includeParent) + 1 < innerIncludeList.size()) {
                    innerIncludeList.addAll(innerIncludeList.indexOf(includeParent) + 1, (Collection<IPath>)this.fIncludedPaths.get(includeParent));
                } else {
                    innerIncludeList.addAll((Collection<IPath>)this.fIncludedPaths.get(includeParent));
                }
                mapIterator.remove();
                continue block0;
            }
        }
    }

    private void addRequiredTopFilesForMacros(List<IPath> potentialInternalUnorderedTopFiles, List<IPath> topFiles) {
        for (IPath top : potentialInternalUnorderedTopFiles) {
            ArrayList<IPath> addedTops = new ArrayList<IPath>();
            HashSet providedDefines = new HashSet();
            HashSet<String> necessaryDefines = new HashSet<String>();
            for (IPath includedFilePath : this.fIncludedPaths.get(top)) {
                Set<String> requiredDefines;
                if (this.fDefinesProvidedByFiles.get(includedFilePath) != null) {
                    providedDefines.addAll(this.fDefinesProvidedByFiles.get(includedFilePath));
                }
                if ((requiredDefines = this.fDefinesRequiredByFiles.get(includedFilePath)) == null || providedDefines.containsAll(requiredDefines)) continue;
                requiredDefines.removeAll(providedDefines);
                necessaryDefines.addAll(requiredDefines);
            }
            for (IPath includedFilePath : this.fIncludedPaths.get(top)) {
                Set<String> definedMacros = this.fDefinesProvidedByFiles.get(includedFilePath);
                if (necessaryDefines.isEmpty()) break;
                if (definedMacros == null || !necessaryDefines.removeAll(definedMacros)) continue;
                addedTops.add(includedFilePath);
            }
            if (addedTops.isEmpty()) continue;
            topFiles.addAll(topFiles.indexOf(top), addedTops);
        }
    }

    private List<IPath> getPotentialUnorderedTopFiles(List<IPath> topFiles) {
        ArrayList<IPath> result = new ArrayList<IPath>();
        for (IPath top : topFiles) {
            Set<String> provided = this.fDefinesProvidedByTopFiles.get(top);
            Set<String> required = this.fDefinesRequiredByTopFiles.get(top);
            if (provided == null || required == null || this.fIncludes.get(top) == null) continue;
            provided.retainAll(required);
            if (provided.isEmpty()) continue;
            result.add(top);
        }
        return result;
    }

    @Override
    protected void sortGraphUsingDegree(List<IPath> topFiles) {
        try {
            DVTBuildConsole buildConsole = DVTBuildConsoleRegistry.getConsole(this.getProject());
            boolean flagDebug = this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SORT);
            long sortingStartTimestamp = System.currentTimeMillis();
            if (flagDebug) {
                buildConsole.print(String.valueOf(System.lineSeparator()) + "Sorting files begin");
            }
            this.aggregatePackageDataByTops();
            AutoconfigFileGraph topFilesGraph = new AutoconfigFileGraph();
            topFilesGraph.setCanceler(() -> BuildConfigManager.isProgressMonitorCanceled(this.getProject()));
            for (IPath topFile : topFiles) {
                AutoconfigFileGraphNode node = new AutoconfigFileGraphNode(topFile);
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.IFDEF, this.fDefinesProvidedByTopFiles.get(topFile), this.fDefinesIfdefedByTopFiles.get(topFile));
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.PACKAGE, this.fPkgsProvidedByTopFiles.get(topFile), this.fPkgsRequiredByTopFiles.get(topFile));
                node.addProvideRequirePair(AutoconfigFileGraphNode.FileDependencyType.MACRO, this.fDefinesProvidedByTopFiles.get(topFile), this.fDefinesRequiredByTopFiles.get(topFile));
                topFilesGraph.addVertex(node);
            }
            topFilesGraph.createGraph();
            if (flagDebug) {
                buildConsole.print("Step 1: Dependencies between files" + System.lineSeparator() + topFilesGraph.debugPrintGraphString());
            }
            topFiles.clear();
            if (topFilesGraph.isCyclic()) {
                if (flagDebug) {
                    buildConsole.print("Step 2: Circular dependencies found in given files.");
                    buildConsole.print("Solving them and sorting files...");
                }
                List<IPath> orderedTopFiles = topFilesGraph.sortFilesUsingDegreeMethod();
                topFiles.addAll(orderedTopFiles);
            } else {
                if (flagDebug) {
                    buildConsole.print("Step 2: No circular dependencies found in given files.");
                    buildConsole.print("Sorting files...");
                }
                topFiles.addAll(topFilesGraph.topologicalSort());
            }
            if (flagDebug) {
                buildConsole.print("");
            }
            if (flagDebug) {
                buildConsole.print("Step 3: Printing files in order (" + topFiles.size() + " files)");
                for (IPath file : topFiles) {
                    buildConsole.print(file.lastSegment());
                }
                long sortingEndTimestamp = System.currentTimeMillis();
                buildConsole.print("Done sorting. [" + (sortingEndTimestamp - sortingStartTimestamp) + " ms]");
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            topFiles.clear();
        }
        catch (AutoConfigTimedOutException e) {
            DVTLogger.INSTANCE.logInfo(e.getMessage());
            topFiles = e.getPartialResult();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void computeUnresolvedMacros(List<IPath> topFiles) {
        HashSet<String> allProvidedMacros = new HashSet<String>();
        if (this.fUserDefines != null) {
            allProvidedMacros.addAll(this.fUserDefines);
        }
        allProvidedMacros.addAll(PREDEFINED_MACROS);
        if (this.fIncludesUVM && !this.fIsUVMContained) {
            allProvidedMacros.addAll(UVM_MACROS);
        }
        if (this.fIncludesOVM && !this.fIsOVMContained) {
            allProvidedMacros.addAll(OVM_MACROS);
        }
        for (IPath top : topFiles) {
            Set<String> required;
            Set<String> offered = this.fDefinesProvidedByTopFiles.get(top);
            if (offered != null) {
                allProvidedMacros.addAll(offered);
            }
            if ((required = this.fDefinesRequiredByTopFiles.get(top)) == null) continue;
            required.removeAll(allProvidedMacros);
            this.fUnresolvedMacros.addAll(required);
        }
    }

    @Override
    protected void scan(IPath path) {
        if (this.fScannedSources.contains(path)) {
            return;
        }
        this.fScannedSources.add(path);
        this.fComputedTopFiles.add(path);
        this.scanFileLexer(path);
        this.fIsUVMContained = this.fIsUVMContained || UVM_FILENAMES.contains(path.lastSegment());
        this.fIsOVMContained = this.fIsOVMContained || OVM_FILENAMES.contains(path.lastSegment());
    }

    private void scanFileLexer(IPath path) {
        block24: {
            if (BuildConfigManager.isProgressMonitorCanceled(this.getProject())) {
                if (this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN) && !this.isWildcardSortingAutoconfig()) {
                    DVTBuildConsoleRegistry.getConsole(this.getProject()).print("Cancelled while scanning '" + path + "'");
                }
                return;
            }
            BufferedInputStream inputStream = null;
            try {
                inputStream = new BufferedInputStream(new FileInputStream(path.toFile()));
                LinkedHashSet<String> definedMacros = new LinkedHashSet<String>();
                LinkedHashSet<String> calledMacros = new LinkedHashSet<String>();
                HashSet<String> ifdefedMacros = new HashSet<String>();
                AutoConfigVlogLexer lexer = new AutoConfigVlogLexer(inputStream);
                Token nextToken = null;
                while ((nextToken = lexer.nextToken()).getType() != 1) {
                    if (BuildConfigManager.isProgressMonitorCanceled(this.getProject())) {
                        if (this.getParameters().autoconfigDebugKind.contains(AutoconfigDebugKind.SCAN) && !this.isWildcardSortingAutoconfig()) {
                            DVTBuildConsoleRegistry.getConsole(this.getProject()).print("Cancelled while scanning '" + path + "'");
                        }
                        DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                        break;
                    }
                    String tokenText = nextToken.getText();
                    int tokenType = nextToken.getType();
                    if (tokenType == 5) {
                        this.fIncludesUVM = this.fIncludesUVM || UVM_PKG.equals(tokenText);
                        this.fIncludesOVM = this.fIncludesOVM || OVM_PKG.equals(tokenText);
                        Set<String> pkgsRequiredByFile = this.fPkgsRequiredByFiles.get(path);
                        if (pkgsRequiredByFile == null) {
                            pkgsRequiredByFile = new HashSet<String>();
                            this.fPkgsRequiredByFiles.put(path, pkgsRequiredByFile);
                        }
                        pkgsRequiredByFile.add(tokenText);
                        continue;
                    }
                    if (tokenType == 24) {
                        Set<String> pkgsProvidedByFile = this.fPkgsProvidedByFiles.get(path);
                        if (pkgsProvidedByFile == null) {
                            pkgsProvidedByFile = new HashSet<String>();
                            this.fPkgsProvidedByFiles.put(path, pkgsProvidedByFile);
                        }
                        pkgsProvidedByFile.add(tokenText);
                        continue;
                    }
                    if (tokenType == 6) {
                        String includedFilename = tokenText;
                        IPath includedPath = Path.fromOSString((String)tokenText);
                        boolean includeUvm = UVM_FILENAMES.contains(includedPath.lastSegment());
                        this.fIncludesUVM = this.fIncludesUVM || includeUvm;
                        boolean includeOvm = OVM_FILENAMES.contains(includedPath.lastSegment());
                        boolean bl = this.fIncludesOVM = this.fIncludesOVM || includeOvm;
                        if (includeUvm || includeOvm || this.lookupInExistingIncdirsOutsideCompilationRoot(includedPath)) continue;
                        List<String> included = this.fIncludes.get(path);
                        List<IPath> includedPaths = this.fIncludedPaths.get(path);
                        if (included == null) {
                            included = new ArrayList<String>();
                        }
                        if (includedPaths == null) {
                            includedPaths = new ArrayList<IPath>();
                        }
                        included.add(includedFilename);
                        includedPaths.add(includedPath);
                        this.fIncludes.put(path, included);
                        this.fIncludedPaths.put(path, includedPaths);
                        if (AutoConfigVlog.validExtension(includedFilename, this.getExtensions())) continue;
                        List<Object> candidates = new ArrayList();
                        String includedString = includedPath.toOSString();
                        candidates = this.getCandidates(this.fSkippedFilePaths, includedPath, includedString);
                        for (IPath iPath : candidates) {
                            this.scan(iPath);
                            this.fSkippedFilePaths.remove(iPath);
                        }
                        this.fIncludedPathsToBeScanned.add(includedPath);
                        continue;
                    }
                    if (tokenType == 4) {
                        definedMacros.add(tokenText);
                        continue;
                    }
                    if (tokenType == 7) {
                        if (PREPROCESSOR_DIRECTIVES.contains(tokenText)) continue;
                        calledMacros.add(tokenText);
                        continue;
                    }
                    if (tokenType != 23 || PREPROCESSOR_DIRECTIVES.contains(tokenText)) continue;
                    ifdefedMacros.add(tokenText);
                }
                calledMacros.removeAll(definedMacros);
                ifdefedMacros.removeAll(definedMacros);
                if (!definedMacros.isEmpty()) {
                    this.fDefinesProvidedByTopFiles.put(path, definedMacros);
                }
                if (!calledMacros.isEmpty()) {
                    this.fDefinesRequiredByTopFiles.put(path, calledMacros);
                }
                if (!ifdefedMacros.isEmpty()) {
                    this.fDefinesIfdefedByTopFiles.put(path, ifdefedMacros);
                }
                DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                break block24;
            }
            catch (TokenStreamException tokenStreamException) {
                try {
                    DVTLogger.INSTANCE.logInfo(String.valueOf(AUTO_CONFIG_MSG_PREFIX) + "A problem occurred during scanning: " + path.toOSString());
                    DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                    break block24;
                }
                catch (Throwable throwable) {
                    DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
                    throw throwable;
                }
            }
            DVTUtilsCommon.INSTANCE.closeClosable(inputStream);
        }
    }

    private boolean lookupInExistingIncdirsOutsideCompilationRoot(IPath includedPath) {
        List<String> existingIncdirs = BuildConfigManager.getIncdirs(this.getProject(), this.getParameters().invocation);
        for (String incdir : existingIncdirs) {
            IPath incdirPath = Path.fromOSString((String)incdir);
            if (this.getCompilationRoot().isPrefixOf(incdirPath) || !DVTAutoLinkManager.getInstance().fetchFileInfo(incdirPath.append(includedPath)).exists()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void computeIncdirs() {
        HashSet value;
        for (Map.Entry<IPath, Set<String>> entry : this.fDefinesProvidedByTopFiles.entrySet()) {
            value = new HashSet();
            value.addAll(entry.getValue());
            this.fDefinesProvidedByFiles.put(entry.getKey(), value);
        }
        for (Map.Entry<IPath, Set<String>> entry : this.fDefinesRequiredByTopFiles.entrySet()) {
            value = new HashSet();
            value.addAll(entry.getValue());
            this.fDefinesRequiredByFiles.put(entry.getKey(), value);
        }
        for (Map.Entry<IPath, Set<String>> entry : this.fDefinesIfdefedByTopFiles.entrySet()) {
            value = new HashSet();
            value.addAll(entry.getValue());
            this.fDefinesIfdefedByFiles.put(entry.getKey(), value);
        }
        for (Map.Entry<IPath, Collection<String>> entry : this.fIncludes.entrySet()) {
            IPath parentFile = entry.getKey();
            block4: for (String included : (List)entry.getValue()) {
                if (BuildConfigManager.isProgressMonitorCanceled(this.getProject()) || AutoConfigVlog.getCreatingResultTimer().isTimeout()) {
                    return;
                }
                List<Object> candidates = new ArrayList();
                IPath firstCandidate = null;
                ArrayList<IPath> incdirs = new ArrayList<IPath>();
                IPath includedPath = Path.fromOSString((String)included);
                String[] segments = includedPath.segments();
                String usablePath = "";
                boolean hasBack = false;
                int nonBackSegmentCount = 0;
                int i = segments.length - 1;
                while (i >= 0) {
                    if (!includedPath.isValidSegment(segments[i])) {
                        this.fInvalidIncludes.add(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile));
                        continue block4;
                    }
                    if (segments[i].equals("..")) {
                        hasBack = true;
                        break;
                    }
                    usablePath = String.valueOf('/') + segments[i] + usablePath;
                    ++nonBackSegmentCount;
                    --i;
                }
                IPath canonicalPath = Path.fromOSString((String)usablePath);
                if (canonicalPath == null || canonicalPath.isEmpty()) {
                    this.fInvalidIncludes.add(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile));
                    continue;
                }
                if (includedPath.isAbsolute() && includedPath.toFile().exists()) {
                    this.computeIncludeInfo(includedPath, parentFile, included, entry);
                    continue;
                }
                String includedString = canonicalPath.toOSString();
                candidates = this.getCandidates(this.fScannedSources, includedPath, includedString);
                if (candidates.isEmpty()) {
                    if (this.isFileInUserDefinedIncdir(includedString)) continue;
                    this.fUnmatchableIncludes.add(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile));
                    continue;
                }
                boolean isUserDefinedIncdir = false;
                IPath compilationRoot = this.getCompilationRoot();
                block6: for (IPath iPath : candidates) {
                    IPath candidateIncdir = iPath.removeLastSegments(includedPath.segmentCount());
                    IBuildConfigParserConstants.ToolCompat toolCompat = this.getParameters().invocation.getToolCompat();
                    if ((toolCompat == IBuildConfigParserConstants.ToolCompat.QUESTA_VLOG || toolCompat == IBuildConfigParserConstants.ToolCompat.QUESTA_QRUN) && candidateIncdir.equals((Object)parentFile.removeLastSegments(1))) {
                        this.computeIncludeInfo(iPath, parentFile, included, entry);
                        continue block4;
                    }
                    if (this.isUserDefinedIncdir(candidateIncdir = candidateIncdir.addTrailingSeparator()) || this.isUserDefinedIncdir(candidateIncdir.makeRelativeTo(compilationRoot))) {
                        isUserDefinedIncdir = true;
                        firstCandidate = iPath;
                        break;
                    }
                    if (!hasBack && !AutoConfigVlog.shouldSkip(candidateIncdir, false)) {
                        incdirs.add(candidateIncdir.removeTrailingSeparator());
                        if (firstCandidate != null) continue;
                        firstCandidate = iPath;
                        continue;
                    }
                    int backSegmentCount = includedPath.segmentCount() - nonBackSegmentCount;
                    int requiredSegmentNumber = iPath.segmentCount() - nonBackSegmentCount + backSegmentCount;
                    IPath prefixDir = iPath.uptoSegment(Math.min(iPath.segmentCount() - 1, requiredSegmentNumber));
                    SortedSet<IPath> dirTailSet = this.fVisitedDirectories.tailSet(prefixDir);
                    for (IPath dir : dirTailSet) {
                        if (!prefixDir.isPrefixOf(dir)) continue block6;
                        if (dir.segmentCount() != requiredSegmentNumber) continue;
                        if (this.isUserDefinedIncdir(dir = dir.addTrailingSeparator()) || this.isUserDefinedIncdir(dir.makeRelativeTo(compilationRoot))) {
                            isUserDefinedIncdir = true;
                            firstCandidate = iPath;
                            break block6;
                        }
                        if (!dir.append(includedPath).toOSString().equals(iPath.toOSString()) || AutoConfigVlog.shouldSkip(dir, false)) continue;
                        incdirs.add(dir.removeTrailingSeparator());
                        if (firstCandidate != null) continue;
                        firstCandidate = iPath;
                    }
                }
                if (!isUserDefinedIncdir) {
                    if (incdirs.isEmpty()) {
                        this.fUnmatchableIncludes.add(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile));
                        continue;
                    }
                    if (this.fComputedIncdirs.containsValue(incdirs)) {
                        void var18_29;
                        Object var18_27 = null;
                        for (Map.Entry<List<String>, List<IPath>> incdirEntry : this.fComputedIncdirs.entrySet()) {
                            if (!incdirEntry.getValue().equals(incdirs)) continue;
                            List<String> list = incdirEntry.getKey();
                            break;
                        }
                        if (var18_29 != null) {
                            ArrayList<String> newKey = new ArrayList<String>();
                            newKey.addAll((Collection<String>)var18_29);
                            newKey.add(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile));
                            this.fComputedIncdirs.remove(var18_29);
                            this.fComputedIncdirs.put(newKey, incdirs);
                        }
                    } else {
                        this.fComputedIncdirs.put(Arrays.asList(MessageFormat.format(INCLUDE_FORMAT, included, parentFile.lastSegment(), parentFile)), incdirs);
                    }
                }
                if (firstCandidate == null) continue;
                this.computeIncludeInfo(firstCandidate, parentFile, included, entry);
            }
        }
        this.fDefinesIfdefedByTopFiles.keySet().retainAll(this.fComputedTopFiles);
        this.fDefinesRequiredByTopFiles.keySet().retainAll(this.fComputedTopFiles);
        this.fDefinesProvidedByTopFiles.keySet().retainAll(this.fComputedTopFiles);
    }

    private void computeIncludeInfo(IPath candidate, IPath parentFile, String included, Map.Entry<IPath, List<String>> includeEntry) {
        this.fComputedTopFiles.remove(candidate);
        List<String> includes = includeEntry.getValue();
        this.fIncludedPaths.get(includeEntry.getKey()).set(includes.indexOf(included), candidate);
        includes.set(includes.indexOf(included), candidate.toOSString());
        Set<String> ifdefedDefines = this.fDefinesIfdefedByTopFiles.get(candidate);
        Set<String> requiredDefines = this.fDefinesRequiredByTopFiles.get(candidate);
        Set<String> providedDefines = this.fDefinesProvidedByTopFiles.get(candidate);
        if (requiredDefines != null) {
            if (this.fDefinesRequiredByTopFiles.get(parentFile) != null) {
                Set<String> existingRequiredDefines = this.fDefinesRequiredByTopFiles.get(parentFile);
                existingRequiredDefines.addAll(requiredDefines);
            } else {
                this.fDefinesRequiredByTopFiles.put(parentFile, requiredDefines);
            }
        }
        if (ifdefedDefines != null) {
            if (this.fDefinesIfdefedByTopFiles.get(parentFile) != null) {
                Set<String> existingIfdefedDefines = this.fDefinesIfdefedByTopFiles.get(parentFile);
                existingIfdefedDefines.addAll(ifdefedDefines);
            } else {
                this.fDefinesIfdefedByTopFiles.put(parentFile, ifdefedDefines);
            }
        }
        if (providedDefines != null) {
            if (this.fDefinesProvidedByTopFiles.get(parentFile) != null) {
                Set<String> existingProvidedDefines = this.fDefinesProvidedByTopFiles.get(parentFile);
                existingProvidedDefines.addAll(providedDefines);
            } else {
                this.fDefinesProvidedByTopFiles.put(parentFile, providedDefines);
            }
        }
    }

    public void addVisitedDirectory(java.nio.file.Path dir) {
        this.fVisitedDirectories.add(Path.fromOSString((String)dir.toString()));
    }

    private List<IPath> getCandidates(TreeSet<IPath> resources, IPath includedPath, String includedString) {
        ArrayList<IPath> candidates = new ArrayList<IPath>();
        SortedSet<IPath> tailSet = resources.tailSet(includedPath);
        for (IPath candidate : tailSet) {
            String candidateString = candidate.toOSString();
            if (!candidateString.endsWith(includedString)) break;
            candidates.add(candidate);
        }
        return candidates;
    }

    @Override
    public void addSkippedPath(IPath filePath) {
        this.fSkippedFilePaths.add(filePath);
    }

    @Override
    public boolean shouldScanFile(IPath filePath) {
        SortedSet<IPath> tailSet = this.fIncludedPathsToBeScanned.tailSet(Path.fromOSString((String)filePath.lastSegment()));
        String filePathString = filePath.toOSString();
        for (IPath path : tailSet) {
            String pathString = path.toOSString();
            if (!filePathString.endsWith(pathString)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void addScannedFiles(IPath path) {
        if (!this.fScannedFilesRealPaths.contains(path)) {
            this.fScannedFilesRealPaths.add(path);
        }
    }

    @Override
    protected Set<IPath> getScannedFiles() {
        return this.fScannedFilesRealPaths;
    }
}

