/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import ro.amiq.dvt.buildconfig.AlteraAutoconfigUtils;
import ro.amiq.dvt.buildconfig.TimeoutTimer;
import ro.amiq.dvt.buildconfig.XilinxAutoconfigUtils;
import ro.amiq.dvt.buildconfig.XilinxProjectConfigParser;

public class AutoconfigCompilationRootInfo {
    private static final int DEPTH_ONE = 1;
    public AlteraAutoconfigUtils.QuartusProjectInfo quartusProjectInfo;
    public XilinxAutoconfigUtils.XilinxProjectInfo vivadoProjectInfo;
    public XilinxAutoconfigUtils.XilinxProjectInfo iseProjectInfo;
    public boolean isQuartusProject;
    public boolean isISEProject;
    public boolean isVivadoProject;

    private AutoconfigCompilationRootInfo() {
    }

    private void setVivadoProjectInfo(XilinxAutoconfigUtils.XilinxProjectInfo vivadoProjectInfo) {
        this.isVivadoProject = vivadoProjectInfo != null;
        this.vivadoProjectInfo = vivadoProjectInfo;
    }

    private void setISEProjectInfo(XilinxAutoconfigUtils.XilinxProjectInfo iseProjectInfo) {
        this.isISEProject = iseProjectInfo != null;
        this.iseProjectInfo = iseProjectInfo;
    }

    private void setQuartusProjectInfo(AlteraAutoconfigUtils.QuartusProjectInfo quartusProjectInfo) {
        this.isQuartusProject = quartusProjectInfo != null;
        this.quartusProjectInfo = quartusProjectInfo;
    }

    public static AutoconfigCompilationRootInfo computeInfoForDirectory(File directory, final TimeoutTimer scanningtimer) throws Exception {
        if (!(directory != null && directory.exists() && directory.isDirectory() && directory.canRead() && directory.canExecute())) {
            return null;
        }
        AutoconfigCompilationRootInfo result = new AutoconfigCompilationRootInfo();
        final TreeSet<File> quartusProjectFiles = new TreeSet<File>();
        final HashSet<File> quartusRevisionFiles = new HashSet<File>();
        final TreeSet<File> vivadoProjectFiles = new TreeSet<File>();
        final TreeSet<File> iseProjectFiles = new TreeSet<File>();
        final LinkedHashSet failedFiles = new LinkedHashSet();
        Files.walkFileTree(directory.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (scanningtimer != null && scanningtimer.isTimeout()) {
                    return FileVisitResult.TERMINATE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (scanningtimer != null && scanningtimer.isTimeout()) {
                    return FileVisitResult.TERMINATE;
                }
                String fileName = file.toString();
                if (fileName.endsWith(".qpf")) {
                    quartusProjectFiles.add(file.toFile());
                }
                if (fileName.endsWith(".qsf")) {
                    quartusRevisionFiles.add(file.toFile());
                }
                if (fileName.endsWith(XilinxAutoconfigUtils.XilinxProjectType.ISE_PROJECT.projectFileSuffix)) {
                    iseProjectFiles.add(file.toFile());
                }
                if (fileName.endsWith(XilinxAutoconfigUtils.XilinxProjectType.VIVADO_PROJECT.projectFileSuffix)) {
                    vivadoProjectFiles.add(file.toFile());
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                failedFiles.add(file.toAbsolutePath().toString());
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        result.setQuartusProjectInfo(AutoconfigCompilationRootInfo.getQuartusProjectInfo(quartusProjectFiles, quartusRevisionFiles));
        result.setISEProjectInfo(AutoconfigCompilationRootInfo.getXilinxProjectInfo(iseProjectFiles, XilinxAutoconfigUtils.XilinxProjectType.ISE_PROJECT));
        result.setVivadoProjectInfo(AutoconfigCompilationRootInfo.getXilinxProjectInfo(vivadoProjectFiles, XilinxAutoconfigUtils.XilinxProjectType.VIVADO_PROJECT));
        return result;
    }

    private static AlteraAutoconfigUtils.QuartusProjectInfo getQuartusProjectInfo(Set<File> quartusProjectFiles, Set<File> quartusRevisionFiles) {
        if (quartusProjectFiles.isEmpty() || quartusRevisionFiles.isEmpty()) {
            return null;
        }
        return new AlteraAutoconfigUtils.QuartusProjectInfo(quartusProjectFiles.toArray(new File[quartusProjectFiles.size()]), quartusRevisionFiles);
    }

    private static XilinxAutoconfigUtils.XilinxProjectInfo getXilinxProjectInfo(Set<File> xilinxProjectFiles, XilinxAutoconfigUtils.XilinxProjectType xilinxProjectType) throws Exception {
        if (xilinxProjectFiles.isEmpty()) {
            return null;
        }
        XilinxAutoconfigUtils.XilinxProjectInfo projectInfo = new XilinxAutoconfigUtils.XilinxProjectInfo(xilinxProjectFiles.toArray(new File[xilinxProjectFiles.size()]), xilinxProjectType);
        File xilinxProjectFile = projectInfo.projectFiles[0];
        XilinxProjectConfigParser configParser = xilinxProjectType.getConfigParser(projectInfo.projectName, xilinxProjectFile, xilinxProjectFile.getParent(), null, null, null);
        projectInfo.setProjectNatures(configParser.getProjectNatures());
        return projectInfo;
    }
}

