/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import ro.amiq.dvt.buildconfig.AutoConfig;
import ro.amiq.dvt.buildconfig.AutoConfigTimedOutException;
import ro.amiq.dvt.buildconfig.AutoconfigFileGraphNode;
import ro.amiq.dvt.buildconfig.Edge;

public class AutoconfigFileGraph {
    private static final String TIMEDOUT_EXCEPTION_MESSAGE = "Auto-Config timed out while sorting, returning partial result!";
    private Map<AutoconfigFileGraphNode, List<Edge>> fileGraph = new LinkedHashMap<AutoconfigFileGraphNode, List<Edge>>();
    private ICanceler canceler;

    public void setCanceler(ICanceler canceler) {
        this.canceler = canceler;
    }

    public void createGraph() throws AutoConfigTimedOutException {
        List<AutoconfigFileGraphNode> vertices = this.getVertices(SortingCriteria.NONE);
        for (AutoconfigFileGraphNode node1 : vertices) {
            for (AutoconfigFileGraphNode node2 : vertices) {
                int totalScore;
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (AutoConfig.getCreatingResultTimer().isTimeout()) {
                    throw new AutoConfigTimedOutException(this.convertNodesToPaths(vertices), TIMEDOUT_EXCEPTION_MESSAGE);
                }
                if (node1.equals(node2) || (totalScore = this.computeTotalScore(node1, node2)) == 0) continue;
                this.fileGraph.get(node1).add(new Edge(node1, node2, totalScore));
                this.fileGraph.get(node2).add(new Edge(node1, node2, totalScore));
                ++node1.outDegree;
                ++node2.inDegree;
            }
        }
    }

    private List<IPath> convertNodesToPaths(List<AutoconfigFileGraphNode> nodes) {
        return nodes.stream().map(node -> node.getPath()).collect(Collectors.toList());
    }

    public boolean addVertex(AutoconfigFileGraphNode node) {
        if (this.fileGraph.containsKey(node)) {
            return false;
        }
        this.fileGraph.put(node, new LinkedList());
        return true;
    }

    private int computeIntersectionScore(Set<String> set1, Set<String> set2, int value) {
        if (set1 == null || set2 == null) {
            return 0;
        }
        HashSet<String> intersection = new HashSet<String>();
        intersection.addAll(set1);
        intersection.retainAll(set2);
        return -(intersection.size() * value);
    }

    private int computeTotalScore(AutoconfigFileGraphNode node1, AutoconfigFileGraphNode node2) {
        int score = 0;
        AutoconfigFileGraphNode.FileDependencyType[] fileDependencyTypeArray = AutoconfigFileGraphNode.FileDependencyType.values();
        int n = fileDependencyTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AutoconfigFileGraphNode.FileDependencyType dependency = fileDependencyTypeArray[n2];
            score += this.computeIntersectionScore(node1.getProvide(dependency), node2.getRequire(dependency), dependency.getWeight());
            ++n2;
        }
        return score;
    }

    public boolean addEdge(Edge edge) {
        if (!this.fileGraph.containsKey(edge.tail)) {
            this.addVertex(edge.tail);
        }
        if (!this.fileGraph.containsKey(edge.head)) {
            this.addVertex(edge.head);
        }
        return this.fileGraph.get(edge.head).add(edge) && this.fileGraph.get(edge.tail).add(edge);
    }

    public boolean removeVertex(AutoconfigFileGraphNode node) {
        if (!this.fileGraph.containsKey(node)) {
            return false;
        }
        this.fileGraph.get(node).clear();
        this.fileGraph.remove(node);
        return true;
    }

    public boolean removeEdge(AutoconfigFileGraphNode node, Edge edge) {
        if (!this.fileGraph.containsKey(node)) {
            return false;
        }
        return this.fileGraph.get(node).remove(edge);
    }

    public List<Edge> getAdjacencyList(AutoconfigFileGraphNode node) {
        if (this.fileGraph.get(node) == null) {
            return Collections.emptyList();
        }
        return this.fileGraph.get(node);
    }

    public List<AutoconfigFileGraphNode> getVertices(SortingCriteria sortingCriteria) {
        LinkedList<AutoconfigFileGraphNode> vertices = new LinkedList<AutoconfigFileGraphNode>(this.fileGraph.keySet());
        if (sortingCriteria != SortingCriteria.NUM_REQUIRED_DEPENDENCIES) {
            return vertices;
        }
        vertices.sort((v1, v2) -> {
            if (v1.getRequiredCount() == v2.getRequiredCount()) {
                if (v1.getProvidedCount() == v2.getProvidedCount()) {
                    return v2.getPath().toOSString().compareTo(v1.getPath().toOSString());
                }
                return v2.getProvidedCount() - v1.getProvidedCount();
            }
            return v1.getRequiredCount() - v2.getRequiredCount();
        });
        return vertices;
    }

    private void topologicalSortUtil(AutoconfigFileGraphNode node, Set<AutoconfigFileGraphNode> visited, List<IPath> orderFiles) throws AutoConfigTimedOutException {
        visited.add(node);
        for (Edge edge : this.getAdjacencyList(node)) {
            if (this.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (AutoConfig.getCreatingResultTimer().isTimeout()) {
                throw new AutoConfigTimedOutException(orderFiles, TIMEDOUT_EXCEPTION_MESSAGE);
            }
            if (!edge.tail.equals(node) || visited.contains(edge.head)) continue;
            this.topologicalSortUtil(edge.head, visited, orderFiles);
        }
        orderFiles.add(0, node.getPath());
    }

    public List<IPath> topologicalSort() throws AutoConfigTimedOutException {
        LinkedList<IPath> orderFiles = new LinkedList<IPath>();
        HashSet<AutoconfigFileGraphNode> visited = new HashSet<AutoconfigFileGraphNode>();
        List<AutoconfigFileGraphNode> vertices = this.getVertices(SortingCriteria.NUM_REQUIRED_DEPENDENCIES);
        for (AutoconfigFileGraphNode node : vertices) {
            if (visited.contains(node)) continue;
            this.topologicalSortUtil(node, visited, orderFiles);
        }
        return orderFiles;
    }

    public String debugPrintGraphString() {
        StringBuilder sb = new StringBuilder();
        for (AutoconfigFileGraphNode node : this.getVertices(SortingCriteria.NONE)) {
            sb.append(node + " :");
            sb.append(this.getAdjacencyList(node) + System.lineSeparator());
        }
        return sb.toString();
    }

    private boolean isCyclicUtil(AutoconfigFileGraphNode node, Set<AutoconfigFileGraphNode> visited, Set<AutoconfigFileGraphNode> recStack) throws AutoConfigTimedOutException {
        if (this.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (AutoConfig.getCreatingResultTimer().isTimeout()) {
            throw new AutoConfigTimedOutException(this.convertNodesToPaths(this.getVertices(SortingCriteria.NONE)), TIMEDOUT_EXCEPTION_MESSAGE);
        }
        if (recStack.contains(node)) {
            return true;
        }
        if (visited.contains(node)) {
            return false;
        }
        visited.add(node);
        recStack.add(node);
        for (Edge edge : this.getAdjacencyList(node)) {
            if (!edge.head.equals(node) || !this.isCyclicUtil(edge.tail, visited, recStack)) continue;
            return true;
        }
        recStack.remove(node);
        return false;
    }

    public boolean isCyclic() throws AutoConfigTimedOutException {
        HashSet<AutoconfigFileGraphNode> visited = new HashSet<AutoconfigFileGraphNode>();
        HashSet<AutoconfigFileGraphNode> recStack = new HashSet<AutoconfigFileGraphNode>();
        for (AutoconfigFileGraphNode node : this.getVertices(SortingCriteria.NONE)) {
            if (!this.isCyclicUtil(node, visited, recStack)) continue;
            return true;
        }
        return false;
    }

    public List<IPath> sortFilesUsingDegreeMethod() throws AutoConfigTimedOutException {
        List<AutoconfigFileGraphNode> vertices = this.getVertices(SortingCriteria.NUM_REQUIRED_DEPENDENCIES);
        LinkedList<AutoconfigFileGraphNode> s1 = new LinkedList<AutoconfigFileGraphNode>();
        LinkedList<AutoconfigFileGraphNode> s2 = new LinkedList<AutoconfigFileGraphNode>();
        AutoconfigFileGraphNode node = null;
        while (!vertices.isEmpty()) {
            while (true) {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (AutoConfig.getCreatingResultTimer().isTimeout()) {
                    s1.addAll(s2);
                    throw new AutoConfigTimedOutException(this.convertNodesToPaths(s1), TIMEDOUT_EXCEPTION_MESSAGE);
                }
                node = this.getSinkIfExists(vertices);
                if (node == null) break;
                s2.add(0, node);
            }
            while (true) {
                if (this.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (AutoConfig.getCreatingResultTimer().isTimeout()) {
                    s1.addAll(s2);
                    throw new AutoConfigTimedOutException(this.convertNodesToPaths(s1), TIMEDOUT_EXCEPTION_MESSAGE);
                }
                node = this.getSourceIfExists(vertices);
                if (node == null) break;
                s1.add(node);
            }
            node = this.getBestVertex(vertices);
            if (node == null) break;
            s1.add(node);
        }
        s1.addAll(s2);
        List<IPath> orderedFiles = s1.stream().map(e -> e.getPath()).collect(Collectors.toList());
        return orderedFiles;
    }

    private boolean isCanceled() {
        return this.canceler != null && this.canceler.isCanceled();
    }

    private AutoconfigFileGraphNode getBestVertex(List<AutoconfigFileGraphNode> vertices) {
        long maxScore = Integer.MIN_VALUE;
        long maxDegreeDiff = Integer.MIN_VALUE;
        AutoconfigFileGraphNode bestVertex = null;
        for (AutoconfigFileGraphNode node : vertices) {
            long score = (long)(node.outDegree * node.getProvidedCount()) * 1L - (long)(node.inDegree * node.getRequiredCount()) * 1L;
            long degreeDiff = (long)node.outDegree * 1L - (long)node.inDegree * 1L;
            if (degreeDiff <= maxDegreeDiff || score <= maxScore) continue;
            bestVertex = node;
            maxScore = score;
            maxDegreeDiff = degreeDiff;
        }
        if (bestVertex != null) {
            this.updateGraph(vertices, bestVertex);
        }
        return bestVertex;
    }

    private AutoconfigFileGraphNode getSourceIfExists(List<AutoconfigFileGraphNode> vertices) {
        for (AutoconfigFileGraphNode node : vertices) {
            if (node.inDegree != 0) continue;
            this.updateGraph(vertices, node);
            return node;
        }
        return null;
    }

    private AutoconfigFileGraphNode getSinkIfExists(List<AutoconfigFileGraphNode> vertices) {
        for (AutoconfigFileGraphNode node : vertices) {
            if (node.outDegree != 0) continue;
            this.updateGraph(vertices, node);
            return node;
        }
        return null;
    }

    private void updateGraph(List<AutoconfigFileGraphNode> vertices, AutoconfigFileGraphNode node) {
        for (Edge edge : this.getAdjacencyList(node)) {
            if (edge.tail.equals(node)) {
                --node.outDegree;
                if (vertices.contains(edge.head)) {
                    --edge.head.inDegree;
                }
            }
            if (!edge.head.equals(node)) continue;
            --node.inDegree;
            if (!vertices.contains(edge.tail)) continue;
            --edge.tail.outDegree;
        }
        vertices.remove(node);
        this.removeVertex(node);
    }

    public static interface ICanceler {
        public boolean isCanceled();
    }

    static enum SortingCriteria {
        NUM_REQUIRED_DEPENDENCIES,
        NONE;

    }
}

