/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;

public class AutoconfigFileGraphNode {
    private Map<FileDependencyType, ProvideRequirePair> provideAndRequire;
    private final IPath path;
    private int requiredCount = 0;
    private int providedCount = 0;
    public int inDegree = 0;
    public int outDegree = 0;

    public AutoconfigFileGraphNode(IPath path) {
        this.path = path;
        this.provideAndRequire = new EnumMap<FileDependencyType, ProvideRequirePair>(FileDependencyType.class);
    }

    public IPath getPath() {
        return this.path;
    }

    public void addProvideRequirePair(FileDependencyType type, Set<String> provide, Set<String> require) {
        int requireSize = require == null ? 0 : require.size();
        int provideSize = provide == null ? 0 : provide.size();
        this.provideAndRequire.put(type, new ProvideRequirePair(provide, require));
        this.requiredCount += requireSize * type.getWeight();
        this.providedCount += provideSize * type.getWeight();
    }

    public Set<String> getProvide(FileDependencyType type) {
        ProvideRequirePair provideRequirePair = this.provideAndRequire.get((Object)type);
        return provideRequirePair != null ? provideRequirePair.getProvide() : null;
    }

    public Set<String> getRequire(FileDependencyType type) {
        ProvideRequirePair provideRequirePair = this.provideAndRequire.get((Object)type);
        return provideRequirePair != null ? provideRequirePair.getRequire() : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AutoconfigFileGraphNode)) {
            return false;
        }
        AutoconfigFileGraphNode node = (AutoconfigFileGraphNode)obj;
        return this.getPath().equals((Object)node.getPath());
    }

    public String toString() {
        return this.getPath().lastSegment();
    }

    public int getRequiredCount() {
        return this.requiredCount;
    }

    public int getProvidedCount() {
        return this.providedCount;
    }

    public int hashCode() {
        return super.hashCode();
    }

    static enum FileDependencyType {
        MACRO(10000),
        PACKAGE(100),
        IFDEF(1),
        VHDL_PACKAGE(10000),
        ENTITY(10000),
        COMPONENT(10000),
        CONFIGURATION(10000);

        private final Integer weight;

        public Integer getWeight() {
            return this.weight;
        }

        private FileDependencyType(Integer weight) {
            this.weight = weight;
        }
    }

    private static class ProvideRequirePair {
        private Set<String> provide;
        private Set<String> require;

        public ProvideRequirePair(Set<String> provide, Set<String> require) {
            this.provide = provide;
            this.require = require;
        }

        public Set<String> getProvide() {
            return this.provide;
        }

        public Set<String> getRequire() {
            return this.require;
        }
    }
}

