/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import antlr.Token;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigBuilderCommon;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.Svp2SvDirectMap;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsole;
import ro.amiq.dvt.builders.DVTBuildConsoleCommon;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.DVTMixedLangBuilder;
import ro.amiq.dvt.model.FileCompileInfo;
import ro.amiq.dvt.model.IDVTBuildContributor;
import ro.amiq.dvt.model.compilewaivers.CompileWaiversManager;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDirtyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalDummyFile;
import ro.amiq.dvt.model.floatingwidgets.FIncrementalNotificationTracker;
import ro.amiq.dvt.model.floatingwidgets.FNotificationDirtyReason;
import ro.amiq.dvt.model.preproc.PreprocUtils;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.precompiled.PrecompiledDBUtils;
import ro.amiq.dvt.resourcefilters.IFiltersManager;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resources.properties.LazyPersistentPropertiesManager;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTStartupConstants;
import ro.amiq.dvt.ui.DeprecatedBuildConfigurationDialog;
import ro.amiq.dvt.ui.decorators.DVTAbstractDecorator;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdater;
import ro.amiq.dvt.ui.problems.DVTProblemsUiUpdaterRegistry;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class BuildConfigBuilder
extends BuildConfigBuilderCommon {
    private static final String BC_BUILDER_CALLER_NAME = "Build Config Builder";
    private List<IResource> fParsedResources = new ArrayList<IResource>();
    private List<IResource> fUserSpecifiedAutoLinkResources = new ArrayList<IResource>();
    private boolean fAutoLinkedResourcesEnable;
    private Map<String, AutoLinkRoot> fAutoLinkedRoots;
    private Set<IPath> changedBcFiles = new HashSet<IPath>();

    static {
        DVTProblemsUiUpdaterRegistry.register(new DVTProblemsUiUpdater(DVTProblemCategories.BUILDCONFIG));
    }

    @Override
    public IProject[] build(int kind, Map args, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        IProject project = this.getProject();
        BuildConfigManager.setProgressMonitor(project, monitor);
        this.checkActiveBuildConfigContentChanges(project);
        IProject[] result = this.monitoredBuild(kind, args, monitor);
        monitor.done();
        BuildConfigManager.removeProgressMonitor(project);
        return result;
    }

    private void checkActiveBuildConfigContentChanges(IProject project) {
        if (project == null) {
            return;
        }
        if (this.changedBcFiles.isEmpty()) {
            return;
        }
        if (this.changedBcFiles.size() == 1 && this.changedBcFiles.contains(Path.fromOSString((String)".dvt/build.config.xml"))) {
            return;
        }
        FIncrementalNotificationTracker.INSTANCE.addDirtyResource(project, new FIncrementalDirtyFile(new FIncrementalDummyFile(), FNotificationDirtyReason.BUILD_CONFIG_CHANGED, this.getFNotificationProvider()));
    }

    private IProject[] monitoredBuild(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (this.changedBcFiles.contains(Path.fromOSString((String)(".dvt/" + DVTSFiles.CUSTOM_PRAGMAS.getName())))) {
            BuildConfigManager.loadCustomPragmas(this.getProject());
            if (this.changedBcFiles.size() == 1) {
                this.changedBcFiles.clear();
                return null;
            }
        }
        monitor.subTask("Analyzing build configuration");
        IProject project = this.getProject();
        this.cleanInternal(project, kind);
        if (!DVTPlugin.getDefault().collect().c(project, "F636F7265")) {
            return null;
        }
        if (!this.performActiveBuildConfigCheck()) {
            return null;
        }
        BuildConfigManager.parse(project, kind == 6);
        if (!this.switchToSplitBuildConfiguration(project, kind)) {
            return null;
        }
        PrecompiledDBUtils.checkForPrecompileInfiniteLoop(project);
        if (kind == 6) {
            PrecompiledDBUtils.checkManualPrecompiledLibrariesIntegrity(project);
            boolean descriptionContainsAutoLinked = DVTAutoLinkManager.getInstance().projectDescriptionContainsAutolink(project);
            boolean buildAutolinkUsingLinks = BuildConfigManager.autolinkUsingLinks(project);
            boolean cachedAutolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
            DVTAutoLinkManager.getInstance().setProjectAutolinkUsingLinks(project, buildAutolinkUsingLinks);
            if (cachedAutolinkUsingLinks && !buildAutolinkUsingLinks || !cachedAutolinkUsingLinks && buildAutolinkUsingLinks || !buildAutolinkUsingLinks && descriptionContainsAutoLinked) {
                IFile projectFile = project.getFile(".project");
                if (projectFile.isReadOnly()) {
                    ro.amiq.dvt.ui.Utils.popMessage(2, "Cannot Update The DVT Auto-Linked", "DVT was unable to update the DVT Auto-Linked folder for project '" + project.getName() + "' because project description" + " file '.project' is read only. Please make the '.project' file writable and issue a full build.");
                } else {
                    DVTAutoLinkManager.getInstance().removeAutolink(project);
                }
            }
            if (IFiltersManager.isDbOutOfSync(project)) {
                BuildConfigManager.reapplyIncludeAutoFilters(project, BuildConfigParseMode.NO_PARSE);
            }
            DVTAutoLinkManager.getInstance().prepareFullBuildAutoLink(project);
            this.printIncludeTreeAndInvocations(project);
            this.refreshDotDVT(monitor, project);
        }
        this.fAutoLinkedResourcesEnable = BuildConfigManager.isAutoLinkedResources(project);
        this.fAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
        this.markDirtyAutoLinked(this.fParsedResources);
        this.markDirtyAutoLinked(this.fUserSpecifiedAutoLinkResources);
        this.collectAndMarkParsedFiles(project);
        this.collectAndMarkUserSpecifiedAutoLinkFiles(project);
        CompileWaiversManager.INSTANCE.loadWaivers(project);
        DVTProblemManager.getInstance().applyWaivers(project);
        PrecompiledDBUtils.createPrecompiledDbDirectory(kind, this.getProject());
        BuildConfigBuilder.reportProblems(project, kind == 6);
        this.changedBcFiles.clear();
        return null;
    }

    private boolean performActiveBuildConfigCheck() {
        IProject project = this.getProject();
        try {
            if (BuildConfigManager.updateActiveBuildConfig(project)) {
                BuildConfigBuilder.refreshActiveBuildConfig(project);
                BuildConfigManager.clean(project, 6);
            }
            if (!BuildConfigManager.hasActiveBuildConfig(project)) {
                DeprecatedBuildConfigurationDialog.runCheck();
                IMarker noBuildConfigMarker = project.createMarker(DVTProblemCategories.BUILDCONFIG.getMarkerId());
                noBuildConfigMarker.setAttribute("message", (Object)("DVT project '" + project.getName() + "' does not have a Build Configuration"));
                noBuildConfigMarker.setAttribute("severity", 2);
                return false;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return true;
    }

    private void printIncludeTreeAndInvocations(IProject project) {
        List<Invocation> activeBuildConfigCachedInfo;
        DVTBuildConsole console = DVTBuildConsoleRegistry.getConsole(project);
        List<BuildConfigProperty> cmdFileCalls = BuildConfigManager.getIncludeProperties(project);
        if (!cmdFileCalls.isEmpty()) {
            console.printSection("List of included argument files", DVTBuildConsoleCommon.MessageSink.CONSOLE);
            for (BuildConfigProperty cmdFileCall : cmdFileCalls) {
                Integer callDepth = (Integer)cmdFileCall.getAttribute("ATTRIBUTE_CALL_DEPTH");
                String directive = (String)cmdFileCall.getAttribute("ATTRIBUTE_CMD_FILE_CALL_DIRECTIVE");
                Token token = (Token)cmdFileCall.getAttribute("ATTRIBUTE_TOKEN");
                directive = directive == null ? "Build configuration file: " : directive;
                String spacing = directive.startsWith("+dvt_include_config+") ? "" : " ";
                String indent = DVTStringUtil.makeIndent("", "    ", callDepth);
                StringBuilder message = new StringBuilder(indent);
                message.append(String.valueOf(directive) + spacing + cmdFileCall.getValue());
                if (token != null && DVTLogger.INSTANCE.isDebugMode()) {
                    message.append("\n").append("    " + indent);
                    message.append("included by " + token.getFilename() + " at line " + token.getLine());
                }
                console.print(message.toString(), DVTBuildConsoleCommon.MessageSink.REPORT);
            }
        }
        if ((activeBuildConfigCachedInfo = BuildConfigManager.getInvocations(project)) != null && activeBuildConfigCachedInfo.size() > 1) {
            console.printSection("List of invocations");
            int invocationCounter = 0;
            for (Invocation invocation : activeBuildConfigCachedInfo) {
                if (invocation.getState().fKind == BuildConfigParser.InvocationKind.REGULAR && invocationCounter == 0) {
                    ++invocationCounter;
                    continue;
                }
                console.print(MessageFormat.format("Invocation #{0} {1} in {2} at line {3}", invocationCounter, invocation.getState().fKind == BuildConfigParser.InvocationKind.MAKELIB ? "-makelib " + invocation.getLibName() : (invocation.getState().fKind == BuildConfigParser.InvocationKind.MAKELIBPOST ? "-makelibpost " + invocation.getLibName() : (invocation.getState().fKind == BuildConfigParser.InvocationKind.MAKELIB_UVM ? "-uvm (makelib)" : (invocation.getState().fKind == BuildConfigParser.InvocationKind.PRECOMPILED_DB_LOAD || invocation.getState().fKind == BuildConfigParser.InvocationKind.PRECOMPILED_DB_LOAD_GLUE ? "+dvt_init_precompiled_db_load" : (invocation.getState().fKind == BuildConfigParser.InvocationKind.REUSE_CONFIG ? "+dvt_include_config" : "+dvt_init+" + (Object)((Object)invocation.getToolCompat()))))), invocation.getFilename(), invocation.getLine()), DVTBuildConsoleCommon.MessageSink.REPORT);
                ++invocationCounter;
            }
        }
    }

    private void markDirtyAutoLinked(List<IResource> resources) throws CoreException {
        for (IResource resource : resources) {
            if (resource == null || !resource.exists()) continue;
            resource.setSessionProperty(DVTAutoLinkManager.QN_DIRTY_AUTOLINKED_FILE, (Object)true);
        }
    }

    private void collectAndMarkUserSpecifiedAutoLinkFiles(final IProject project) throws CoreException {
        this.fUserSpecifiedAutoLinkResources.clear();
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            @Override
            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                List<String> autoLinkFiles = BuildConfigManager.getAutoLinkFiles(project);
                if (autoLinkFiles != null) {
                    this.createAndAddResource(autoLinkFiles, cachedLinksMap);
                }
                this.createAndAddPVerilogResources(project, cachedLinksMap);
                Set<File> bcFileList = BuildConfigManager.getCompileWaiversFiles(project);
                if (bcFileList == null || bcFileList.isEmpty()) {
                    return;
                }
                ArrayList<String> buildConfigFilePaths = new ArrayList<String>(5);
                for (File file : bcFileList) {
                    buildConfigFilePaths.add(file.getAbsolutePath());
                }
                if (buildConfigFilePaths != null) {
                    this.createAndAddResource(buildConfigFilePaths, cachedLinksMap);
                }
            }

            private void createAndAddResource(Collection<String> filesToBeLinked, Map<IPath, LinkDescription> cachedLinksMap) {
                for (String file : filesToBeLinked) {
                    IFile resource = BuildConfigBuilder.this.createResource(Path.fromOSString((String)file), cachedLinksMap);
                    BuildConfigBuilder.this.fUserSpecifiedAutoLinkResources.add((IResource)resource);
                }
            }

            private void createAndAddPVerilogResources(IProject project2, Map<IPath, LinkDescription> cachedLinksMap) {
                if (PreprocUtils.getInstance().isPreprocSupportEnabled(project2)) {
                    return;
                }
                Svp2SvDirectMap svp2SvDirectMap = BuildConfigManager.getSvp2SvDirectMap(project2);
                Set<String> preprocAutoLinkFiles = svp2SvDirectMap.getAllSvps();
                if (preprocAutoLinkFiles != null) {
                    this.createAndAddResource(preprocAutoLinkFiles, cachedLinksMap);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, BC_BUILDER_CALLER_NAME, op, true);
    }

    private void collectAndMarkParsedFiles(final IProject project) throws CoreException {
        this.fParsedResources.clear();
        DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

            @Override
            public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                List<BuildConfigProperty> includeProperties = BuildConfigManager.getIncludeProperties(project);
                for (BuildConfigProperty cmdFileCall : includeProperties) {
                    DVTProblemManager.getInstance().removeProblemsWithCategoryAndPath(BuildConfigBuilder.this.getProject(), DVTProblemCategories.BUILDCONFIG, Utils.canonicPath(Path.fromOSString((String)cmdFileCall.getValue())));
                    IFile resource = BuildConfigBuilder.this.createResource(Path.fromOSString((String)cmdFileCall.getValue()), cachedLinksMap);
                    PropertiesManager.addSessionProperty((IResource)resource, PropertyTypes.QN_IMPORTED_FILE, "ro.amiq.dvt.ui.editor.BuildConfigEditor");
                    if (resource == null) continue;
                    IFile parent = resource;
                    while ((parent = parent.getParent()) != null && PropertiesManager.getSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE) == null) {
                        PropertiesManager.addSessionProperty((IResource)parent, PropertyTypes.QN_IMPORTED_FILE, "ro.amiq.dvt.ui.editor.BuildConfigEditor");
                    }
                    BuildConfigBuilder.this.fParsedResources.add((IResource)resource);
                }
            }
        };
        DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, BC_BUILDER_CALLER_NAME, op, false);
    }

    public static void reportProblems(IProject project, boolean reportToConsole) {
        BuildConfigBuilderCommon.reportProblems(project, reportToConsole);
        DVTProblemsUiUpdaterRegistry.get(DVTProblemCategories.BUILDCONFIG.getId()).update(project);
        DVTProblemsUiUpdaterRegistry.get(DVTProblemCategories.BUILDCONFIG.getId()).scheduleObjectionsClear(project);
    }

    private void refreshDotDVT(IProgressMonitor monitor, IProject project) {
        try {
            project.getFolder(".dvt").refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean notifyAfterIncremental() {
        return true;
    }

    @Override
    public void clean(IProgressMonitor monitor) throws CoreException {
        this.cleanInternal(this.getProject(), 15);
    }

    public static void deleteMarkersAndProperties(IProject project) {
        try {
            if (project == null) {
                return;
            }
            project.deleteMarkers(DVTProblemCategories.BUILDCONFIG.getMarkerId(), true, 2);
            DVTProblemManager.getInstance().removeProblemsWithCategory(project, DVTProblemCategories.BUILDCONFIG);
            final ArrayList refreshList = new ArrayList();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (PropertiesManager.getSessionProperty(resource, PropertyTypes.QN_IMPORTED_FILE) != null) {
                        refreshList.add(resource);
                        return true;
                    }
                    return false;
                }
            });
            DVTAbstractDecorator.refresh("ro.amiq.dvt.CompiledFileDecorator", refreshList.toArray());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public boolean isEnabled(IProject project) {
        try {
            return Utils.hasDvtNature(project);
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public boolean hasNature(String natureID) {
        return true;
    }

    @Override
    public int analyzeDelta(IResourceDelta delta, IProgressMonitor monitor, Map<LanguageKind, Set<FileCompileInfo>> changedFiles) throws CoreException {
        this.changedBcFiles.clear();
        if (delta == null) {
            return 0;
        }
        ArrayList<IPath> managedProjectRelativePaths = new ArrayList<IPath>();
        managedProjectRelativePaths.add(Path.fromOSString((String)(".dvt/" + DVTSFiles.CUSTOM_PRAGMAS.getName())));
        if (BuildConfigManager.getInvocations(this.getProject()) != null) {
            for (BuildConfigProperty p : BuildConfigManager.getIncludeProperties(this.getProject())) {
                IFile pFile = DVTFileUtils.getInstance().findProjectFile(this.getProject(), p.getValue());
                if (pFile == null) continue;
                managedProjectRelativePaths.add(pFile.getProjectRelativePath());
            }
        }
        for (IPath managedPath : managedProjectRelativePaths) {
            int deltaFlags;
            IResourceDelta pDelta = delta.findMember(managedPath);
            if (pDelta == null || (deltaFlags = pDelta.getFlags()) == 0x100000 || (deltaFlags & 0x100) == 0) continue;
            this.changedBcFiles.add(managedPath);
        }
        IPath buildConfigPath = Path.fromOSString((String)".dvt/build.config.xml");
        IResourceDelta buildConfigDelta = delta.findMember(buildConfigPath);
        if (buildConfigDelta != null && buildConfigDelta.getFlags() != 0x100000) {
            this.changedBcFiles.add(buildConfigPath);
        }
        return this.changedBcFiles.size();
    }

    public static void refreshActiveBuildConfig(IProject project) {
        BuildConfigBuilder.deleteMarkersAndProperties(project);
        List<IDVTBuildContributor> contributors = DVTMixedLangBuilder.getEnabledContributors(project);
        if (contributors != null && !contributors.isEmpty()) {
            for (IDVTBuildContributor contributor : contributors) {
                if (!(contributor instanceof BuildConfigBuilder)) continue;
                try {
                    contributor.build(9, null, (IProgressMonitor)new NullProgressMonitor(), null);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        }
        LazyPersistentPropertiesManager.INSTANCE.reload(project);
        BuildConfigBuilder.refreshAutoLinkedResources(project);
        DVTProblemManager.getInstance().reload(project);
        for (DVTProblemsUiUpdater updater : DVTProblemsUiUpdaterRegistry.getAll()) {
            updater.clean(project);
            updater.update(project);
        }
        RfMixedLangManager.getInstance().getRfMixedLangProject(project, false).changeBuildConfig();
    }

    public static void refreshAutoLinkedResources(final IProject project) {
        try {
            DVTAutoLinkManager.getInstance().dirtyAutoLink(project, "DVT Auto-Linked");
            DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                @Override
                public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                    LazyPersistentPropertiesManager.INSTANCE.accept(project, (filesystemPath, projectRelativePath) -> {
                        if (filesystemPath == null || filesystemPath.isEmpty() || projectRelativePath == null || projectRelativePath.isEmpty()) {
                            return null;
                        }
                        try {
                            IFile file = project.getFile(projectRelativePath);
                            if (!file.exists() || file.getLocation() == null) {
                                Map<String, AutoLinkRoot> currAutoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
                                file = DVTAutoLinkManager.getInstance().createAutoLink(project, (IPath)new Path(filesystemPath), currAutoLinkedRoots, cachedLinksMap, true);
                            }
                            DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
                        }
                        catch (CoreException e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                        return projectRelativePath;
                    });
                    DVTAutoLinkManager.getInstance().removeDirtyAutoLink(project, "DVT Auto-Linked", cachedLinksMap);
                }
            };
            DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, BC_BUILDER_CALLER_NAME, op, true);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private boolean switchToSplitBuildConfiguration(IProject project, int kind) {
        if (kind != 6 || !SplitInvocationUtils.shouldSwitchToSplitBuildConfiguration(project)) {
            return true;
        }
        try {
            project.setSessionProperty(DVTStartupConstants.QN_DVT_DONT_RESTORE, (Object)true);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
        this.cleanInternal(project, kind);
        if (!this.performActiveBuildConfigCheck()) {
            return false;
        }
        BuildConfigManager.parseAfterSplit(project, kind == 6);
        return true;
    }

    @Override
    public IRfSingleLangProject getIRfProject() {
        return null;
    }

    @Override
    public boolean hasNothingToCompile() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IFile createResource(IPath filePath, Map<IPath, LinkDescription> cachedLinksMap) {
        try {
            String parserPath = filePath.toOSString();
            IFile file = DVTFileUtils.getInstance().findProjectFileAndRegister(this.getProject(), parserPath, "createResource");
            if (file != null && file.exists() && file.getLocation() != null) {
                if (this.fAutoLinkedResourcesEnable) {
                    DVTAutoLinkManager.getInstance().validateAutoLink(this.getProject(), file);
                    return file;
                }
                if (!file.getProjectRelativePath().segment(0).equals("DVT Auto-Linked")) return file;
                return null;
            }
            if (!this.fAutoLinkedResourcesEnable) {
                return null;
            }
            IProject project = this.getProject();
            if (DVTAutoLinkManager.getInstance().hasError(project, 2)) return null;
            if (DVTAutoLinkManager.getInstance().hasError(project, 1)) {
                return null;
            }
            file = DVTFileUtils.getInstance().findProjectFileAndRegister(project, parserPath, "createResource");
            if (file == null || file.getLocation() == null) {
                IFile projectFile = this.getProject().getFile(".project");
                boolean autolinkUsingLinks = DVTAutoLinkManager.getInstance().autolinkUsingLinksForProject(project);
                boolean readOnly = projectFile.getResourceAttributes().isReadOnly();
                if (readOnly && autolinkUsingLinks) {
                    DVTAutoLinkManager.getInstance().reportError(project, 1);
                } else {
                    file = DVTAutoLinkManager.getInstance().createAutoLink(project, filePath, this.fAutoLinkedRoots, cachedLinksMap, true);
                }
            } else {
                DVTAutoLinkManager.getInstance().validateAutoLink(project, file);
            }
            if (file == null) return file;
            String resourcePath = file.getProjectRelativePath().toOSString();
            PropertiesManager.addParser2ResourceMapProperty(this.getProject(), parserPath, resourcePath);
            return file;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            DVTAutoLinkManager.getInstance().reportError(this.getProject(), 2);
            return null;
        }
    }

    @Override
    public String getDisplayName() {
        return "Build Configuration";
    }
}

