/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigBuilder;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.model.AbstractBuildContributor;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.problems.DVTProblemManager;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public abstract class BuildConfigBuilderCommon
extends AbstractBuildContributor {
    public static final String INVOCATION_LOG_LINE = "Invocation #{0} {1} in {2} at line {3}";

    protected void cleanInternal(IProject project, int kind) {
        DVTUtilsCommon.INSTANCE.cleanFileSubstituteCache();
        BuildConfigManager.clean(project, kind);
        BuildConfigBuilder.deleteMarkersAndProperties(project);
    }

    public static void reportProblems(IProject project, boolean reportToConsole) {
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        if (invocations == null) {
            return;
        }
        for (Invocation invocation : invocations) {
            for (DVTProblem problem : invocation.getProblems()) {
                DVTProblemManager.getInstance().reportProblem(problem, reportToConsole);
            }
        }
    }
}

