/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.UvmReuseEnum;
import ro.amiq.dvt.builders.DVTAutoLinkManager;

public class BuildConfigFile
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> fRecursives = new ArrayList<String>();
    protected String fPath;
    private transient IProject fProject;
    private List<BuildConfigProperty> fCompactedProperties;
    private List<Invocation> fInvocations;
    private transient Object fLastCacheUpdate;
    private IBuildConfigParserConstants.ToolCompat fToolCompat;
    private Set<UvmReuseEnum> fUvmReuse;
    private Map<String, String> fFileMappings;

    @Deprecated
    protected BuildConfigFile(IProject project, IBuildConfigParserConstants.ToolCompat toolCompat, String path, String recurs) {
        this.fProject = project;
        this.fPath = path;
        if (recurs != null && !recurs.isEmpty()) {
            String[] stringArray = recurs.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String recur = stringArray[n2];
                this.fRecursives.add(recur);
                ++n2;
            }
        }
        this.fToolCompat = toolCompat;
    }

    public List<String> getRecurs() {
        return this.fRecursives;
    }

    public String getPath() {
        return this.fPath;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public synchronized List<Invocation> getCachedInfo() {
        return this.fInvocations;
    }

    public synchronized List<BuildConfigProperty> getCompactedCachedInfo() {
        return this.fCompactedProperties;
    }

    public synchronized void setCache(List<Invocation> properties) {
        this.fLastCacheUpdate = new Object();
        this.fInvocations = properties;
        this.fCompactedProperties = BuildConfigParser.compact(properties, null);
    }

    public Object getLastCacheUpdate() {
        return this.fLastCacheUpdate;
    }

    public void setLastCacheUpdate(Object fLastCacheUpdate) {
        this.fLastCacheUpdate = fLastCacheUpdate;
    }

    public boolean exists() {
        if (this.fProject == null || !this.fProject.isAccessible()) {
            return false;
        }
        IPath filePath = Path.fromOSString((String)this.fPath);
        if (filePath.isAbsolute()) {
            return DVTAutoLinkManager.getInstance().fetchFileInfo(filePath).exists();
        }
        IPath location = this.fProject.getLocation();
        if (location == null) {
            return false;
        }
        filePath = location.append(this.fPath);
        return DVTAutoLinkManager.getInstance().fetchFileInfo(filePath).exists();
    }

    public String toString() {
        return "[Compat : " + (Object)((Object)this.fToolCompat) + "][Proj: " + this.fProject.getName() + "]" + this.fPath;
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fToolCompat;
    }

    public Set<UvmReuseEnum> getUVMReuse() {
        if (this.fUvmReuse == null) {
            this.fUvmReuse = EnumSet.noneOf(UvmReuseEnum.class);
        }
        return this.fUvmReuse;
    }

    public void setFileMappings(Map<String, String> fileMappings) {
        this.fFileMappings = fileMappings;
    }

    public Map<String, String> getFileMappings() {
        return this.fFileMappings;
    }

    public void addUVMReuse(Set<UvmReuseEnum> uvmReuse) {
        if (this.fUvmReuse == null) {
            this.fUvmReuse = EnumSet.noneOf(UvmReuseEnum.class);
        }
        this.fUvmReuse.addAll(uvmReuse);
    }

    public void clearUVMReuse() {
        this.fUvmReuse = EnumSet.noneOf(UvmReuseEnum.class);
    }

    public void setProject(IProject fProject) {
        this.fProject = fProject;
    }
}

