/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManagerCommon;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.resourcefilters.autofilters.BuildConfigParseMode;
import ro.amiq.dvt.resourcefilters.autofilters.ReapplyIncludeAutoFiltersJob;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.Utils;

public class BuildConfigManager
extends BuildConfigManagerCommon {
    public static String getModelPersistenceLocation(IProject project, String subpathToFile, boolean read, BuildConfigManagerCommon.PersistenceModeWrapper persistenceMode) {
        String lockFile;
        if (project == null) {
            return null;
        }
        if (persistenceMode != null && persistenceMode.libraryName != null) {
            subpathToFile = subpathToFile.isEmpty() ? persistenceMode.libraryName : String.valueOf(persistenceMode.libraryName) + File.separator + subpathToFile;
        }
        if (persistenceMode != null && persistenceMode.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_LOAD) {
            return BuildConfigManager.getPrecompiledDbLoadPersistenceLocation(project, persistenceMode.invocation, subpathToFile);
        }
        if (persistenceMode != null && persistenceMode.persistenceMode == BuildConfigManagerCommon.PersistenceMode.PRECOMPILED_DB_SAVE) {
            return BuildConfigManager.getPrecompiledDbSavePersistenceLocation(project, subpathToFile);
        }
        File defaultLocation = BuildConfigManager.getDefaultModelPersistenceFile(project);
        if (defaultLocation == null) {
            return null;
        }
        if (BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project) == null) {
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
        }
        String activeBuildConfigPrefix = BuildConfigManager.getActiveBuildConfigPrefix(project);
        String dbLocation = BuildConfigManager.getDbLocation(project);
        if (dbLocation == null || dbLocation.isEmpty()) {
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
        }
        File userLocation = new Path(dbLocation).append("dvt_db").append(project.getName()).append(activeBuildConfigPrefix).toFile();
        IPath workspaceLocation = Utils.getWorkspaceLocation();
        if (workspaceLocation == null) {
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
        }
        String myLockFile = workspaceLocation.append(".metadata/.lock").toOSString();
        if (new File(userLocation, ".lock").exists() && (lockFile = DVTFileUtils.getInstance().readFileContent(new File(userLocation, ".lock")).trim()).length() != 0 && !lockFile.equals(myLockFile) && new File(lockFile).exists()) {
            DVTLogger.INSTANCE.logInfo("DVT database location '" + userLocation.getAbsolutePath() + "' is locked by another DVT instance: '" + lockFile + "'. Falling back to default location: '" + defaultLocation.getAbsolutePath() + "'");
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
        }
        if (read) {
            if (!userLocation.exists()) {
                DVTLogger.INSTANCE.logInfo("[READ] DVT database location '" + userLocation.getAbsolutePath() + "' does not exist. Falling back to default location: '" + defaultLocation.getAbsolutePath() + "'");
                return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
            }
            if (!userLocation.canWrite() && new File(defaultLocation, subpathToFile).exists()) {
                DVTLogger.INSTANCE.logInfo("[READ] DVT database location '" + userLocation.getAbsolutePath() + "' is read only, and there is a snapshot saved in the default location. Falling back to default location: '" + defaultLocation.getAbsolutePath() + "'");
                return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
            }
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, userLocation);
        }
        if (!userLocation.exists()) {
            userLocation.mkdirs();
        }
        if (!(userLocation.exists() && userLocation.isDirectory() && userLocation.canWrite())) {
            DVTLogger.INSTANCE.logInfo("Could not write DVT database in '" + userLocation.getAbsolutePath() + "'. Falling back to default location: '" + defaultLocation.getAbsolutePath() + "'");
            return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, defaultLocation);
        }
        DVTFileUtils.getInstance().writeStringToFile(new File(userLocation, ".lock"), myLockFile, false);
        File f = new File(defaultLocation, subpathToFile);
        if (f.exists()) {
            Utils.deleteFileRecursively(f);
        }
        return BuildConfigManager.postProcessModelPersistenceLocation(subpathToFile, userLocation);
    }

    public static void updateActiveBuildConfigFileMappings(List<Invocation> invocations) {
    }

    public static void reapplyIncludeAutoFilters(IProject project, BuildConfigParseMode parseMode) {
        ReapplyIncludeAutoFiltersJob job = new ReapplyIncludeAutoFiltersJob(project, parseMode);
        job.setUser(false);
        job.schedule();
    }
}

