/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import antlr.Token;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.DVTExternalProgramOutputCache;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ActiveBuildConfig;
import ro.amiq.dvt.buildconfig.AdditiveValueEnumList;
import ro.amiq.dvt.buildconfig.AdditiveValueStringList;
import ro.amiq.dvt.buildconfig.AmsMode;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.AutoconfigDebugKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.BuildConfigXml;
import ro.amiq.dvt.buildconfig.CdtBuildKind;
import ro.amiq.dvt.buildconfig.CdtFileTypeAutoMapKind;
import ro.amiq.dvt.buildconfig.Cflags;
import ro.amiq.dvt.buildconfig.CheckIdKind;
import ro.amiq.dvt.buildconfig.ElabLiblist;
import ro.amiq.dvt.buildconfig.ElaborationControl;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.buildconfig.ElaborationKind;
import ro.amiq.dvt.buildconfig.ElaborationSkipInstanceFilter;
import ro.amiq.dvt.buildconfig.ElaborationSkipModuleFilter;
import ro.amiq.dvt.buildconfig.ElaborationSkipPathFilter;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoDefineByNameFilter;
import ro.amiq.dvt.buildconfig.EncryptedCodeAutoFilter;
import ro.amiq.dvt.buildconfig.FullChecksAndLibs;
import ro.amiq.dvt.buildconfig.IBuildConfigChangeListener;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IncrementalChecksKind;
import ro.amiq.dvt.buildconfig.IncrementalElaborationKind;
import ro.amiq.dvt.buildconfig.IncrementalProfilingWrapper;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.buildconfig.MemoryConsumptionDebugKind;
import ro.amiq.dvt.buildconfig.MinTypMax;
import ro.amiq.dvt.buildconfig.OverrideEditor;
import ro.amiq.dvt.buildconfig.PSSPrintRadix;
import ro.amiq.dvt.buildconfig.PVlogCompilePreprocDebugKind;
import ro.amiq.dvt.buildconfig.ResolvedDirective;
import ro.amiq.dvt.buildconfig.ShallowCompileFilter;
import ro.amiq.dvt.buildconfig.ShallowCompileMode;
import ro.amiq.dvt.buildconfig.SkipCompileFilter;
import ro.amiq.dvt.buildconfig.Svp2SvCommentMap;
import ro.amiq.dvt.buildconfig.Svp2SvDirectMap;
import ro.amiq.dvt.buildconfig.Svp2SvExtMap;
import ro.amiq.dvt.buildconfig.Svp2SvPathMap;
import ro.amiq.dvt.buildconfig.Svp2SvPatternTagMap;
import ro.amiq.dvt.buildconfig.UnelaboratedChecksKind;
import ro.amiq.dvt.buildconfig.VerissimoCompilationChecks;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationConfig;
import ro.amiq.dvt.buildconfig.splitinvocation.SplitInvocationUtils;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.elaboration.core.ELBuildConfigOverriddenParameter;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.precompiled.PrecompiledDBManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.custompragma.CustomPragma;
import ro.amiq.dvt.ui.custompragma.CustomPragmaStoreUtil;
import ro.amiq.dvt.ui.preferences.PreferenceUtils;
import ro.amiq.dvt.ui.reportissue.DVTThreadDumpCollectorAttributes;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.StringMatcher;
import ro.amiq.dvt.utils.Utils;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;

public abstract class BuildConfigManagerCommon {
    public static final String SPECMAN_PATH = "SPECMAN_PATH";
    public static final String DVT_SPECMAN_PATH = "DVT_SPECMAN_PATH";
    public static final String PERSPEC_PATH = "PERSPEC_PATH";
    public static final String SVR_PATH = "SVR_PATH";
    private static final String SPECMAN_H = "specman.h";
    public static final String BUILD_CONFIG_DICT = ".build_config_dict";
    public static final String DOT_BUILD = ".build";
    public static final String DEFAULT = "default";
    public static final String DEFAULT_BUILD = "default.build";
    public static final String DOT_PROJECT = ".project";
    private static final Pattern PATHSEPARATOR_PATTERN = Pattern.compile(File.pathSeparator);
    private static final Pattern IUS_INSTALL_LOCATION_PATTERN = Pattern.compile("<IUS_install_location>");
    private static Map<IProject, ActiveBuildConfig> fBuildConfigMap = new HashMap<IProject, ActiveBuildConfig>();
    private static Map<IProject, IProgressMonitor> fProgressMonitorMap = new HashMap<IProject, IProgressMonitor>();
    private static HashMap<IProject, HashMap<ParserPath, Boolean>> fSkipCompileMap = new HashMap();
    private static HashMap<IProject, List<CustomPragma>> fCustomPragmaMap = new HashMap();
    private static HashMap<IProject, Set<String>> fTranslatePragmaMap = new HashMap();
    private static Map<IProject, SkipCompileFilter> fSkipCompileFilters = new HashMap<IProject, SkipCompileFilter>();
    private static Map<IProject, Map<String, ELBuildConfigOverriddenParameter>> fOverriddenParameters = new HashMap<IProject, Map<String, ELBuildConfigOverriddenParameter>>();
    private static Map<IProject, EncryptedCodeAutoFilter> fEncryptedCodeAutoCloseFilters = new HashMap<IProject, EncryptedCodeAutoFilter>();
    private static Map<IProject, EncryptedCodeAutoFilter> fEncryptedCodeAutoDefineFilters = new HashMap<IProject, EncryptedCodeAutoFilter>();
    private static Map<IProject, EncryptedCodeAutoDefineByNameFilter> fEncryptedCodeAutoDefineNameFilters = new HashMap<IProject, EncryptedCodeAutoDefineByNameFilter>();
    private static Map<IProject, ElaborationSkipModuleFilter> fElaborationSkipModuleFilters = new HashMap<IProject, ElaborationSkipModuleFilter>();
    private static Map<IProject, ElaborationSkipPathFilter> fElaborationSkipPathFilters = new HashMap<IProject, ElaborationSkipPathFilter>();
    private static Map<IProject, ElaborationSkipInstanceFilter> fElaborationSkipInstanceFilters = new HashMap<IProject, ElaborationSkipInstanceFilter>();
    private static Map<IProject, ElaborationSkipModuleFilter> fElaborationBBoxModuleFilters = new HashMap<IProject, ElaborationSkipModuleFilter>();
    private static Map<IProject, ElaborationSkipPathFilter> fElaborationBBoxPathFilters = new HashMap<IProject, ElaborationSkipPathFilter>();
    private static Map<IProject, ElaborationSkipInstanceFilter> fElaborationBBoxInstanceFilters = new HashMap<IProject, ElaborationSkipInstanceFilter>();
    private static Map<IProject, IncrementalProfilingWrapper> fIncrementalProfilingWrappers = new HashMap<IProject, IncrementalProfilingWrapper>();
    private static Map<IProject, PrecompileGlobalMode> fPrecompileMode = new HashMap<IProject, PrecompileGlobalMode>();
    private static Map<IProject, List<ResolvedDirective>> fDirectiveMap = new HashMap<IProject, List<ResolvedDirective>>();
    private static Set<Integer> hyperlinkableKinds = new HashSet<Integer>(Arrays.asList(17, 0, 12, 19, 23));
    private static List<IBuildConfigChangeListener> fBuildConfigChangeListeners = new ArrayList<IBuildConfigChangeListener>();
    private static boolean fBatchMode;
    private static final Map<String, String> canonicalPathCache;

    static {
        canonicalPathCache = new HashMap<String, String>();
    }

    public static void clean(IProject project, int kind) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (buildConfig == null) {
            return;
        }
        buildConfig.setCache(null);
        fSkipCompileFilters.clear();
        fOverriddenParameters.clear();
        fEncryptedCodeAutoCloseFilters.clear();
        fEncryptedCodeAutoDefineFilters.clear();
        fEncryptedCodeAutoDefineNameFilters.clear();
        fElaborationSkipModuleFilters.clear();
        fElaborationSkipPathFilters.clear();
        fElaborationSkipInstanceFilters.clear();
        fElaborationBBoxModuleFilters.clear();
        fElaborationBBoxPathFilters.clear();
        fElaborationBBoxInstanceFilters.clear();
        fIncrementalProfilingWrappers.clear();
        fCustomPragmaMap.put(project, null);
        fTranslatePragmaMap.put(project, null);
        if (kind == 6 || kind == 15) {
            fSkipCompileMap.remove(project);
        }
        fPrecompileMode.clear();
        PrecompiledDBManager.getInstance().clear();
        fDirectiveMap.put(project, null);
    }

    public static List<ResolvedDirective> getDirectiveList(IProject project) {
        if (project == null) {
            return null;
        }
        List<ResolvedDirective> directiveList = fDirectiveMap.get(project);
        if (directiveList != null) {
            return directiveList;
        }
        directiveList = new ArrayList<ResolvedDirective>();
        fDirectiveMap.put(project, directiveList);
        return directiveList;
    }

    public static void addDirectiveToList(IProject project, ResolvedDirective directive) {
        if (project == null) {
            return;
        }
        List<ResolvedDirective> directiveList = BuildConfigManagerCommon.getDirectiveList(project);
        directiveList.add(directive);
    }

    public static ActiveBuildConfig getBuildConfig(IProject project) {
        if (project == null) {
            return null;
        }
        ActiveBuildConfig buildConfig = fBuildConfigMap.get(project);
        if (buildConfig != null) {
            return buildConfig;
        }
        String recursives = "-f,-F,-file";
        recursives = String.valueOf(recursives) + ",-svr,-psf";
        recursives = String.valueOf(recursives) + ",+dvt_include_build+";
        buildConfig = new ActiveBuildConfig(project, IBuildConfigParserConstants.ToolCompat.DVT, BuildConfigManagerCommon.computeActiveBuildConfig(project), recursives);
        fBuildConfigMap.put(project, buildConfig);
        return buildConfig;
    }

    public static List<BuildConfigProperty> getHyperlinkedProperties(IProject project) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (buildConfig == null) {
            return result;
        }
        if (buildConfig.getCompactedCachedInfo() == null) {
            return result;
        }
        for (BuildConfigProperty p : buildConfig.getCompactedCachedInfo()) {
            if (!p.hasAttribute("ATTRIBUTE_TOKEN") || !hyperlinkableKinds.contains(p.getKind())) continue;
            result.add(p);
        }
        return result;
    }

    public static List<BuildConfigProperty> getIncludeProperties(IProject project) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        if (BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project) == null) {
            return result;
        }
        for (BuildConfigProperty p : BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project)) {
            if (p.getKind() != 12) continue;
            result.add(p);
        }
        return result;
    }

    public static List<Invocation> getInvocations(IProject project) {
        ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (activeBuildConfig == null) {
            return null;
        }
        if (activeBuildConfig.exists()) {
            return activeBuildConfig.getCachedInfo();
        }
        return null;
    }

    public static void initBatch(IProject dummyProject, String commandFile, Set<LanguageKind> languageKinds) {
        if (fBuildConfigMap.containsKey(dummyProject)) {
            return;
        }
        DVTExternalProgramOutputCache.batchInit(languageKinds);
        String recursives = "-f,-F,-file";
        ActiveBuildConfig batchActiveBuildConfig = new ActiveBuildConfig(dummyProject, IBuildConfigParserConstants.ToolCompat.DVT, DEFAULT, recursives, commandFile){
            {
                this.fPath = new File(string).getAbsolutePath();
            }

            @Override
            public void setName(String name) {
            }

            @Override
            public String getName() {
                IPath path = Path.fromOSString((String)this.fPath);
                if ("build".equals(path.getFileExtension())) {
                    return path.removeFileExtension().lastSegment();
                }
                return null;
            }
        };
        fBuildConfigMap.put(dummyProject, batchActiveBuildConfig);
    }

    public static List<BuildConfigProperty> getActiveBuildConfigCompactedCachedInfo(IProject project) {
        ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (activeBuildConfig == null) {
            return Collections.emptyList();
        }
        if (!activeBuildConfig.exists()) {
            return Collections.emptyList();
        }
        List<BuildConfigProperty> compactedCachedInfo = activeBuildConfig.getCompactedCachedInfo();
        if (compactedCachedInfo == null) {
            return Collections.emptyList();
        }
        return compactedCachedInfo;
    }

    public static ActiveBuildConfig getActiveBuildConfig(IProject project) {
        return BuildConfigManagerCommon.getBuildConfig(project);
    }

    public static Object getActiveBuildConfigLastCacheUpdate(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (buildConfig == null) {
            return null;
        }
        return buildConfig.getLastCacheUpdate();
    }

    public static List<String> getAvailableBuildConfigs(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return result;
        }
        File dotDVT = new File(projectLocation.toFile(), ".dvt");
        if (!dotDVT.exists() && dotDVT.canRead()) {
            return result;
        }
        dotDVT.listFiles(pathname -> {
            String name = pathname.getName();
            if (name.endsWith(DOT_BUILD)) {
                result.add(name.substring(0, name.length() - DOT_BUILD.length()));
            }
            return false;
        });
        Collections.sort(result);
        return result;
    }

    public static boolean updateActiveBuildConfig(IProject project) {
        ActiveBuildConfig activeBuildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (activeBuildConfig == null) {
            return false;
        }
        String oldName = activeBuildConfig.getName();
        String newName = BuildConfigManagerCommon.computeActiveBuildConfig(project);
        if (newName.equals(oldName)) {
            ObjectionManager.getInstance().clear(Objection.ACTIVE_BUILD_CONFIG);
            return false;
        }
        activeBuildConfig.setName(newName);
        for (IBuildConfigChangeListener l : fBuildConfigChangeListeners) {
            l.buildConfigListenerChanged(project, oldName, newName);
        }
        ObjectionManager.getInstance().clear(Objection.ACTIVE_BUILD_CONFIG);
        return true;
    }

    public static void registerBuildConfigChangeListener(IBuildConfigChangeListener listener) {
        fBuildConfigChangeListeners.add(listener);
    }

    public static void unregisterBuildConfigChangeListener(IBuildConfigChangeListener listener) {
        fBuildConfigChangeListeners.remove(listener);
    }

    public static String getActiveBuildConfigName(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        return buildConfig == null ? null : buildConfig.getName();
    }

    public static String getActiveBuildConfigRelPath(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        return buildConfig == null ? null : buildConfig.getPath();
    }

    public static IFile getActiveBuildConfigIFile(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        return buildConfig == null ? null : project.getFile(buildConfig.getPath());
    }

    public static String computeActiveBuildConfig(IProject project) {
        String name = BuildConfigXml.load(project).getActiveBuildConfigName();
        if (name != null && !name.isEmpty() && new File(project.getLocation().toFile(), ".dvt/" + name + DOT_BUILD).exists()) {
            return name;
        }
        List<String> availableBuildConfigs = BuildConfigManagerCommon.getAvailableBuildConfigs(project);
        if (availableBuildConfigs.contains(DEFAULT)) {
            return DEFAULT;
        }
        if (!availableBuildConfigs.isEmpty()) {
            return availableBuildConfigs.get(0);
        }
        return DEFAULT;
    }

    public static boolean hasActiveBuildConfig(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        return buildConfig != null && buildConfig.exists();
    }

    public static Map<String, String> getUserDefinedEnvVars(IProject project) {
        HashMap<String, String> result = new HashMap<String, String>();
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        if (allProperties == null) {
            return Collections.unmodifiableMap(result);
        }
        for (BuildConfigProperty property : allProperties) {
            if (property.getKind() != 13) continue;
            for (String key : property.getAttributes().keySet()) {
                result.put(key, (String)property.getAttribute(key));
            }
        }
        return Collections.unmodifiableMap(result);
    }

    public static String getUserDefinedEnvVar(Invocation invocation, String name) {
        return invocation.getEnvVarCache().get(name);
    }

    public static String getUserDefinedEnvVar(IProject project, String name, EnvVarReplacementPriorityPolicy policy) {
        if (policy == EnvVarReplacementPriorityPolicy.NO_INVOCATION) {
            return System.getenv(name);
        }
        List<Invocation> invocations = BuildConfigManager.getInvocations(project);
        if (invocations == null || invocations.isEmpty()) {
            return System.getenv(name);
        }
        if (policy == EnvVarReplacementPriorityPolicy.LAST_INVOCATION) {
            int i = invocations.size() - 1;
            while (i > -1) {
                String result = BuildConfigManager.getUserDefinedEnvVar(invocations.get(i), name);
                if (result != null) {
                    return result;
                }
                --i;
            }
        } else {
            int i = 0;
            while (i < invocations.size()) {
                String result = BuildConfigManager.getUserDefinedEnvVar(invocations.get(i), name);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return System.getenv(name);
    }

    public static String getenv(Invocation invocation, String name) {
        String result = BuildConfigManagerCommon.getUserDefinedEnvVar(invocation, name);
        if (result == null) {
            result = System.getenv(name);
        }
        return result;
    }

    public static Map<String, String> getenv(IProject project) {
        HashMap<String, String> result = new HashMap<String, String>(System.getenv());
        Map<String, String> userDefindedEnvVars = BuildConfigManagerCommon.getUserDefinedEnvVars(project);
        for (Map.Entry<String, String> entry : userDefindedEnvVars.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static HashMap<ParserPath, Boolean> getfSkipCompileMapForProject(IProject project) {
        return fSkipCompileMap.get(project);
    }

    public static PrecompileGlobalMode getPrecompiledDbMode(IProject project) {
        return BuildConfigManagerCommon.getPrecompiledDbMode(project, false);
    }

    public static PrecompileGlobalMode getPrecompiledDbMode(IProject project, boolean disableCache) {
        PrecompileGlobalMode mode = fPrecompileMode.get(project);
        if (mode != null && !disableCache) {
            return mode;
        }
        PrecompiledDBManager precompiledDBManager = PrecompiledDBManager.getInstance();
        mode = PrecompileGlobalMode.NO_GLOBAL_PRECOMPILE;
        if (BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_SAVE)) {
            mode = PrecompileGlobalMode.MANUAL_SAVE;
        } else if (BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO) && !precompiledDBManager.areAllLibrariesAvailable()) {
            mode = PrecompileGlobalMode.AUTO_SAVE;
        } else if (BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO) && precompiledDBManager.areAllLibrariesAvailable()) {
            mode = PrecompileGlobalMode.AUTO_LOAD;
        } else if (!PrecompiledDBManager.getInstance().getLibraryHomesMap().isEmpty() && !precompiledDBManager.areAllLibrariesAvailable()) {
            mode = PrecompileGlobalMode.XILINX_ALTERA_SAVE;
        } else if (!PrecompiledDBManager.getInstance().getLibraryHomesMap().isEmpty() && precompiledDBManager.areAllLibrariesAvailable()) {
            mode = PrecompileGlobalMode.XILINX_ALTERA_LOAD;
        }
        fPrecompileMode.put(project, mode);
        return mode;
    }

    public static boolean isPrecompiledDbSaveMode(IProject project) {
        PrecompileGlobalMode precompiledDbMode = BuildConfigManager.getPrecompiledDbMode(project);
        if (!DVTNature.hasNature(project, "ro.amiq.vlogdt.VlogNature")) {
            return false;
        }
        return precompiledDbMode.isAny(PrecompileGlobalMode.MANUAL_SAVE, PrecompileGlobalMode.AUTO_SAVE, PrecompileGlobalMode.XILINX_ALTERA_SAVE);
    }

    public static boolean needsPrecompiledLoadAutoTrigger(IProject project) {
        PrecompileGlobalMode mode = BuildConfigManagerCommon.getPrecompiledDbMode(project);
        return mode.isAny(PrecompileGlobalMode.AUTO_SAVE, PrecompileGlobalMode.XILINX_ALTERA_SAVE);
    }

    protected static String getPrecompiledDbLoadPersistenceLocation(IProject project, Invocation invocation, String subpathToFile) {
        if (project == null) {
            return null;
        }
        String precompiledDbPath = null;
        PrecompileGlobalMode precompiledMode = BuildConfigManagerCommon.getPrecompiledDbMode(project);
        if (BuildConfigManagerCommon.isPrecompiledDbLoadInvocation(invocation)) {
            precompiledDbPath = BuildConfigManagerCommon.getPrecompiledDbLoadLocation(project, invocation);
        } else if (precompiledMode == PrecompileGlobalMode.AUTO_LOAD) {
            precompiledDbPath = BuildConfigManagerCommon.getPrecompiledDbAutoLocation(project);
        } else if (precompiledMode.isAny(PrecompileGlobalMode.XILINX_ALTERA_SAVE, PrecompileGlobalMode.XILINX_ALTERA_LOAD)) {
            precompiledDbPath = BuildConfigManagerCommon.getPrecompiledDbDVTDataLocation(project);
        }
        if (precompiledDbPath == null) {
            return null;
        }
        return BuildConfigManagerCommon.postProcessModelPersistenceLocation(subpathToFile, new File(precompiledDbPath));
    }

    protected static String getPrecompiledDbSavePersistenceLocation(IProject project, String subpathToFile) {
        if (project == null) {
            return null;
        }
        String precompiledDbPath = BuildConfigManagerCommon.getPrecompiledDbSaveLocation(project);
        if (precompiledDbPath == null) {
            return null;
        }
        File precompiledDbDirectory = new File(precompiledDbPath);
        if (!precompiledDbDirectory.isDirectory()) {
            return null;
        }
        return BuildConfigManagerCommon.postProcessModelPersistenceLocation(subpathToFile, new File(precompiledDbPath));
    }

    public static String getPrecompiledDbLoadLocation(IProject project, Invocation invocation) {
        if (invocation == null) {
            return null;
        }
        if (!BuildConfigManagerCommon.isPrecompiledDbLoadInvocation(invocation)) {
            return null;
        }
        if (BuildConfigManagerCommon.hasDirective(project, invocation.getProperties(), IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_LOCATION_STRICT)) {
            return (String)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_LOCATION_STRICT);
        }
        if (!BuildConfigManagerCommon.hasDirective(project, invocation.getProperties(), IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_LOCATION)) {
            return null;
        }
        String precompiledDbPathFromDVTConfig = (String)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_LOCATION);
        if (precompiledDbPathFromDVTConfig == null) {
            return null;
        }
        String versionOfDVT = DVTPlugin.getDefault().getVersion();
        if (versionOfDVT.isEmpty()) {
            return null;
        }
        return Paths.get(precompiledDbPathFromDVTConfig, versionOfDVT).toString();
    }

    public static boolean isPrecompiledDbLoadInvocation(Invocation invocation) {
        return invocation.getState().isPrecompiledDBInit();
    }

    public static boolean projectHasPrecompiledLoadInvocation(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null || invocations.isEmpty()) {
            return false;
        }
        for (Invocation invoc : invocations) {
            if (!BuildConfigManagerCommon.isPrecompiledDbLoadInvocation(invoc)) continue;
            return true;
        }
        return false;
    }

    public static String getPrecompiledDbSaveLocation(IProject project) {
        String versionOfDVT;
        PrecompileGlobalMode mode = BuildConfigManagerCommon.getPrecompiledDbMode(project, true);
        if (mode == PrecompileGlobalMode.AUTO_SAVE || mode == PrecompileGlobalMode.AUTO_LOAD) {
            return BuildConfigManagerCommon.getPrecompiledDbAutoLocation(project);
        }
        if (mode == PrecompileGlobalMode.XILINX_ALTERA_SAVE) {
            return BuildConfigManagerCommon.getPrecompiledDbDVTDataLocation(project);
        }
        String precompiledDbPath = (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_SAVE);
        if (precompiledDbPath == null) {
            return null;
        }
        if (!Paths.get(precompiledDbPath, new String[0]).isAbsolute()) {
            precompiledDbPath = project.getLocation().append(precompiledDbPath).toOSString();
        }
        if ((versionOfDVT = DVTPlugin.getDefault().getVersion()).isEmpty()) {
            return null;
        }
        return Paths.get(precompiledDbPath, versionOfDVT).toString();
    }

    public static String getPrecompiledDbAutoLocation(IProject project) {
        String versionOfDVT;
        String precompiledDbPath = (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO);
        if (precompiledDbPath == null) {
            return null;
        }
        if (!Paths.get(precompiledDbPath, new String[0]).isAbsolute()) {
            precompiledDbPath = project.getLocation().append(precompiledDbPath).toOSString();
        }
        if ((versionOfDVT = DVTPlugin.getDefault().getVersion()).isEmpty()) {
            return null;
        }
        return Paths.get(precompiledDbPath, versionOfDVT).toString();
    }

    public static String getPrecompiledDbDVTDataLocation(IProject project) {
        String dvtDataPath = IBuildConfigParserConstants.getDVTDataPath(project).toString();
        String versionOfDVT = DVTPlugin.getDefault().getVersion();
        if (versionOfDVT.isEmpty()) {
            return null;
        }
        return Paths.get(dvtDataPath, "precompiled_libraries", versionOfDVT).toString();
    }

    public static boolean isPrecompiledDbMD5ChecksumDisabled(IProject project, Invocation invocation) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_DISABLE_MD5_CHANGE_DETECTION);
    }

    public static List<String> getPrecompiledDbAutoExcludedLibraries(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        AdditiveValueStringList excludedLibraries = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO_EXCLUDE_LIBRARY);
        if (excludedLibraries == null || excludedLibraries.length() == 0) {
            return result;
        }
        for (String libName : excludedLibraries) {
            result.add(libName.trim());
        }
        return result;
    }

    public static List<String> getPrecompiledDbAutoExcludedPaths(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        AdditiveValueStringList excludedPaths = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO_EXCLUDE_PATH);
        if (excludedPaths == null || excludedPaths.length() == 0) {
            return result;
        }
        for (String excludedPath : excludedPaths) {
            result.add(excludedPath.trim());
        }
        return result;
    }

    public static Boolean isPrecompiledDbAutoExcluded(IProject project, Invocation invocation) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_AUTO_EXCLUDE);
    }

    public static String getPrecompiledDbBuildCmd(IProject project, Invocation invocation) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, invocation.getProperties(), IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_BUILD_CMD);
    }

    public static int getPrecompiledDbBuildCmdMaxJobs(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_BUILD_CMD_MAX_JOBS);
    }

    public static int getPrecompiledDbMaxNofThreads(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_MAX_NOF_THREADS);
    }

    public static Boolean isPrecompiledDbDebugMode(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_PRECOMPILED_DB_DEBUG);
    }

    public static Map<String, String> getPrecompiledSrcMap(IProject project) {
        Map map = (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PRECOMPILED_DB_SRC_MAP);
        if (map != null) {
            return map.entrySet().stream().sorted((e1, e2) -> Integer.compare(((String)e2.getKey()).length(), ((String)e1.getKey()).length())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        return Collections.emptyMap();
    }

    public static List<IBuildConfigParserConstants.DisableXilinxAlteraPrecompilation> getDisableLibraryPrecompilation(IProject project, List<BuildConfigProperty> properties) {
        AdditiveValueEnumList disabledPrecompilationLibraries = (AdditiveValueEnumList)BuildConfigManagerCommon.getDVTConfig(project, properties, IBuildConfigParserConstants.Directive.DVT_DISABLE_LIBRARY_PRECOMPILATION);
        if (disabledPrecompilationLibraries == null || disabledPrecompilationLibraries.length() == 0) {
            return new ArrayList<IBuildConfigParserConstants.DisableXilinxAlteraPrecompilation>();
        }
        return disabledPrecompilationLibraries.getData();
    }

    public static String getDbLocation(IProject project) {
        if (!BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.DVT_DB_LOCATION)) {
            return null;
        }
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_DB_LOCATION);
    }

    protected static String getActiveBuildConfigPrefix(IProject project) {
        String activeBuildConfigPrefix = BuildConfigManagerCommon.getActiveBuildConfigName(project);
        if (activeBuildConfigPrefix == null || activeBuildConfigPrefix.equals(DEFAULT)) {
            return "";
        }
        return DVTStringUtil.appendString("bc_", activeBuildConfigPrefix);
    }

    protected static File getDefaultModelPersistenceFile(IProject project) {
        if (project == null) {
            return null;
        }
        String activeBuildConfigPrefix = BuildConfigManagerCommon.getActiveBuildConfigPrefix(project);
        IPath workingLocation = project.getWorkingLocation("dict");
        if (workingLocation == null) {
            return null;
        }
        File defaultLocation = workingLocation.append(activeBuildConfigPrefix).toFile();
        return defaultLocation;
    }

    protected static String postProcessModelPersistenceLocation(String subpathToFile, File location) {
        IPath result = new Path(location.getAbsolutePath()).append(subpathToFile);
        result.removeLastSegments(1).toFile().mkdirs();
        return result.toOSString();
    }

    public static Object getDVTConfig(IProject project, IBuildConfigParserConstants.Directive directive) {
        if (project == null) {
            return directive.getDefaultValue();
        }
        return BuildConfigManagerCommon.getDVTConfig(project, BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project), directive);
    }

    public static boolean hasDirective(IProject project, IBuildConfigParserConstants.Directive directive) {
        if (project == null) {
            return false;
        }
        return BuildConfigManagerCommon.hasDirective(project, BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project), directive);
    }

    private static Object getDVTConfig(IProject project, IBuildConfigParserConstants.Directive directive, int fileLine) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        Invocation relevantInvocation = null;
        for (Invocation invocation : invocations) {
            if (invocation.getLine() > fileLine) break;
            if (relevantInvocation != null && (invocation.getLine() > fileLine || invocation.getLine() <= relevantInvocation.getLine())) continue;
            relevantInvocation = invocation;
        }
        if (relevantInvocation == null) {
            return null;
        }
        return BuildConfigManagerCommon.getDVTConfig(project, relevantInvocation.getProperties(), directive);
    }

    public static Object getDVTConfig(IProject project, Invocation invocation, IBuildConfigParserConstants.Directive directive) {
        if (invocation == null) {
            return directive.getDefaultValue();
        }
        String projectLocation = invocation.getState().getProjectLocation();
        if (projectLocation != null) {
            return BuildConfigManagerCommon.getDVTConfig(invocation.getProperties(), directive, projectLocation);
        }
        return BuildConfigManagerCommon.getDVTConfig(project, invocation.getProperties(), directive);
    }

    private static Object getDVTConfig(List<BuildConfigProperty> properties, IBuildConfigParserConstants.Directive directive, String projectPath) {
        Object result = directive.getDefaultValue();
        if (result == null) {
            return result;
        }
        if (properties != null) {
            for (BuildConfigProperty p : properties) {
                if (p.getKind() != 11 || !p.hasAttribute(directive.toString())) continue;
                result = p.getAttribute(directive.toString());
                break;
            }
        }
        if (directive.resolveAsPath() && result instanceof String) {
            if (((String)result).isEmpty() && directive.fLocationType == IBuildConfigParserConstants.PathType.FILE) {
                return result;
            }
            if (!new File((String)result).isAbsolute()) {
                return Paths.get(String.valueOf(projectPath) + "/" + (String)result, new String[0]).toString();
            }
        }
        return result;
    }

    private static Object getDVTConfig(IProject project, List<BuildConfigProperty> properties, IBuildConfigParserConstants.Directive directive) {
        Object result = directive.getDefaultValue();
        if (project == null || result == null || project.getLocation() == null || !project.isAccessible()) {
            return result;
        }
        if (properties != null) {
            for (BuildConfigProperty p : properties) {
                if (p.getKind() != 11 || !p.hasAttribute(directive.toString())) continue;
                result = p.getAttribute(directive.toString());
                break;
            }
        }
        if (directive.resolveAsPath() && result instanceof String) {
            if (((String)result).isEmpty() && directive.fLocationType == IBuildConfigParserConstants.PathType.FILE) {
                return result;
            }
            if (!new File((String)result).isAbsolute()) {
                return project.getLocation().append((String)result).toOSString();
            }
        }
        return result;
    }

    public static boolean hasDirective(IProject project, List<BuildConfigProperty> properties, IBuildConfigParserConstants.Directive directive) {
        if (properties == null || project == null) {
            return false;
        }
        for (BuildConfigProperty p : properties) {
            if (p.getKind() != 11 || !p.hasAttribute(directive.toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisableMD5ChangeDetection(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_MD5_CHANGE_DETECTION);
    }

    public static boolean isDisableNewHyperlinkTooltipEngine(IProject project) {
        boolean internalPreferenceOverride = Utils.isInternalPreferenceDisableNewHyperlinkTooltipEngine();
        if (internalPreferenceOverride) {
            return true;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_NEW_HYPERLINK_TOOLTIP_ENGINE);
    }

    public static boolean isDebugHyperlinkRunTimeInfo(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEBUG_HYPERLINK_RUN_TIME_INFO);
    }

    public static boolean isAutoLinkedResources(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.AUTO_LINK);
    }

    public static SplitInvocationConfig getAutoSplitInvocation(IProject project) {
        Map splitInvocationArgs = (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.AUTO_SPLIT_INVOCATION);
        if (splitInvocationArgs == null || splitInvocationArgs.isEmpty()) {
            return null;
        }
        boolean splitDesignVerification = false;
        boolean splitLineCount = false;
        Long lineCount = 0L;
        boolean splitLibraries = false;
        for (Map.Entry splitInvocationArg : splitInvocationArgs.entrySet()) {
            SplitInvocationUtils.SplitInvocationArg splitArg = (SplitInvocationUtils.SplitInvocationArg)((Object)splitInvocationArg.getKey());
            String splitArgValue = (String)splitInvocationArg.getValue();
            if (splitArg == SplitInvocationUtils.SplitInvocationArg.DV) {
                splitDesignVerification = true;
                continue;
            }
            if (splitArg == SplitInvocationUtils.SplitInvocationArg.NOF_LINES) {
                splitLineCount = true;
                lineCount = Long.parseLong(splitArgValue);
                continue;
            }
            if (splitArg != SplitInvocationUtils.SplitInvocationArg.LIBRARIES) continue;
            splitLibraries = true;
        }
        return new SplitInvocationConfig(splitDesignVerification, splitLineCount, lineCount, splitLibraries);
    }

    public static boolean isHideDuplicateTypesView(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.HIDE_DUPLICATE_TYPES_VIEW);
    }

    public static int getDisableIncrementalBuildNumberOfLines(IProject project) {
        if (PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE")) {
            return 0;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_MAX_LINES);
    }

    public static int getMaxNofSemanticProblemsPerFile(IProject project) {
        Integer override = (Integer)IBuildConfigParserConstants.Directive.SEMANTIC_PROBLEMS_PER_FILE.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.SEMANTIC_PROBLEMS_PER_FILE);
    }

    public static int getMaxNofSyntacticProblemsPerFile(IProject project) {
        Integer override = (Integer)IBuildConfigParserConstants.Directive.SYNTACTIC_PROBLEMS_PER_FILE.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.SYNTACTIC_PROBLEMS_PER_FILE);
    }

    public static AdditiveValueStringList getVipsFor(IProject project, Invocation invocation) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.E_SN_WHICH);
        if (stringList == null) {
            return new AdditiveValueStringList();
        }
        return stringList;
    }

    public static Set<String> getGlobalPseudomethods(IProject project) {
        AdditiveValueStringList pseudomethods = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_GLOBAL_PSEUDO_METHOD);
        if (pseudomethods == null || pseudomethods.length() == 0) {
            return Collections.emptySet();
        }
        return new HashSet<String>(pseudomethods.getData());
    }

    public static boolean isAddSnVersionDefs(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_SN_EXTRACT_DEFINES);
    }

    public static boolean isStrictCheckingEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_MACRO_STRICT_EXP_CHECKING);
    }

    public static boolean isAsComputedAutoMethodsTranslateDisable(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_AUTO_AS_COMPUTED_METHODS_TRANSLATE_DISABLE);
    }

    public static boolean isBackTrackingEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_MACRO_EXP_BACK_TRACKING);
    }

    public static Set<String> getWavedromFileExtensions(IProject project) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.WAVEDROM_FILE_EXTENSION);
        if (stringList == null) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(stringList.getData());
    }

    public static Set<String> getWavedromFilesLocations(IProject project) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.WAVEDROM_FILES_LOCATION);
        if (stringList == null) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(stringList.getData());
    }

    public static Set<String> getNaturalDocsImagesLocations(IProject project) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.NATURAL_DOCS_IMAGE_LOCATIONS);
        if (stringList == null) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(stringList.getData());
    }

    public static Set<String> getDocumentationResourceLocations(IProject project) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DOCUMENTATION_RESOURCE_LOCATIONS);
        if (stringList == null) {
            return new LinkedHashSet<String>();
        }
        return new LinkedHashSet<String>(stringList.getData());
    }

    public static DVTThreadDumpCollectorAttributes getProfilingAttributes(IProject project) {
        return (DVTThreadDumpCollectorAttributes)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PROFILE);
    }

    public static boolean isNamingConventionChecksDisabled(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.DISABLE_NAMING_CONVENTIONS.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_NAMING_CONVENTIONS);
    }

    public static boolean isNonStandardCheckEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_ENABLE_NON_STANDARD_CHECKS);
    }

    public static DVTCodeCommentsPreferences getCommentsPreferences(IProject project) {
        DVTCodeCommentsPreferences result = new DVTCodeCommentsPreferences();
        result.setAddMulti2LineComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_BCD));
        result.setAddMultiLineComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ML));
        result.setAddSingleLineComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_SL));
        result.setUseInlineComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_INLINE));
        result.setUseAboveComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ABOVE));
        result.setUseHeaderComment((Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_HEADER));
        List extractHeaderIgnorePatterns = (List)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_HEADER_IGNORE_PATTERN);
        for (String pattern : extractHeaderIgnorePatterns) {
            if (pattern == null) continue;
            if (pattern.startsWith("regex+")) {
                result.addExtractHeaderCommentIgnoreRegex(pattern.substring("regex+".length()));
                continue;
            }
            result.addExtractHeaderCommentIgnorePattern(pattern);
        }
        int skipMaxEmptyLinesAbove = (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EXTRACT_COMMENT_ABOVE_MAX_EMPTY_LINES);
        result.setEmptyLinesAboveToSkip(skipMaxEmptyLinesAbove < 0 ? 0 : skipMaxEmptyLinesAbove);
        return result;
    }

    public static boolean isDisableParallelLexParse(IProject project) {
        String envDisableParallelLexParseVal = System.getenv("DVT_DISABLE_PARALLEL_LEX_PARSE");
        if (envDisableParallelLexParseVal != null && "false".equalsIgnoreCase(envDisableParallelLexParseVal)) {
            return false;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_PARALLEL_LEX_PARSE);
    }

    public static boolean isRefScriptsDebug(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.REF_SCRIPTS_DEBUG);
    }

    public static Boolean autolinkUsingLinks(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.AUTOLINK_USING_LINKS);
    }

    public static ParserPath getActiveTest(IProject project, Invocation invocation) {
        ParserPath result = new ParserPath((String)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.ACTIVE_TEST));
        if (result.path == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static String getCompilationRoot(IProject project, Invocation invocation) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.COMPILATION_ROOT);
    }

    public static String getCompilationRoot(IProject project, int fileLine) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.COMPILATION_ROOT, fileLine);
    }

    public static boolean isDisablePreprocOptimize(IProject project, Invocation invocation) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, invocation.getProperties(), IBuildConfigParserConstants.Directive.DISABLE_PREPROC_OPTIMIZE);
    }

    public static boolean getAOPSupport(IProject project, Invocation invocation) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, invocation.getProperties(), IBuildConfigParserConstants.Directive.ENABLE_AOP_MODE);
    }

    public static Map<String, AutoLinkRoot> getAutoLinkedRoots(IProject project) {
        return (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.AUTO_LINK_ROOT);
    }

    public static Map<StringMatcher, OverrideEditor> getEditorAssociationOverrides(IProject project) {
        return (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.EDITOR_ASSOCIATION_OVERRIDE);
    }

    public static String getFileSubstitute(IProject project, String filePath) {
        return BuildConfigManagerCommon.getFileSubstitute(project, BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project), filePath);
    }

    public static String getFileSubstitute(IProject project, List<BuildConfigProperty> properties, String filePath) {
        if (filePath == null) {
            return null;
        }
        Map map = (Map)BuildConfigManagerCommon.getDVTConfig(project, properties, IBuildConfigParserConstants.Directive.FILE_SUBSTITUTE);
        String result = null;
        if (map != null) {
            result = (String)map.get(Utils.canonicPath(filePath));
        }
        if (result == null) {
            result = filePath;
        }
        return result;
    }

    public static Map<String, String> getFileSubstituteMap(IProject project) {
        Map map = (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.FILE_SUBSTITUTE);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public static Map<String, String> getDirectorySubstituteMap(IProject project) {
        Map map = (Map)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DIRECTORY_SUBSTITUTE);
        if (map != null) {
            return map.entrySet().stream().sorted(Map.Entry.comparingByKey(Comparator.comparingInt(String::length))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
        return Collections.emptyMap();
    }

    public static Boolean isMemoryMonitorDisabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_MEM_STARVATION_HANDLING);
    }

    public static Boolean isMemoryMonitorDebugMode(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_MEM_STARVATION_HANDLING_DEBUG);
    }

    public static Boolean isMemoryMonitorProactiveMode(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_MEM_STARVATION_PROACTIVE_MODE);
    }

    public static Boolean isMemoryMonitorHeapHistogramEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_MEM_STARVATION_HEAP_HISTOGRAM);
    }

    public static Svp2SvExtMap getSvp2SvExtMap(IProject project) {
        return (Svp2SvExtMap)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_EXT_MAP);
    }

    public static Set<File> getCompileWaiversFiles(IProject project) {
        return (Set)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.COMPILE_WAIVERS_FILE);
    }

    public static Svp2SvPathMap getSvp2SvPathMap(IProject project) {
        return (Svp2SvPathMap)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_PATH_MAP);
    }

    public static Svp2SvCommentMap getSvp2SvCommentMap(IProject project) {
        return (Svp2SvCommentMap)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_COMMENT_MAP);
    }

    public static Svp2SvDirectMap getSvp2SvDirectMap(IProject project) {
        return (Svp2SvDirectMap)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_DIRECT_MAP);
    }

    public static Svp2SvPatternTagMap getSvp2SvPatternTagMap(IProject project) {
        return (Svp2SvPatternTagMap)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_PATTERN_TAG_MAP);
    }

    public static PVlogCompilePreprocDebugKind getPVerilogCompilePreprocDebugKind(IProject project) {
        return (PVlogCompilePreprocDebugKind)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_COMPILE_PREPROC_DEBUG);
    }

    public static String getPVerilogRunConfigOnSave(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_RUN_ON_SAVE);
    }

    public static Set<String> getPVerilogScanLocations(IProject project) {
        return (Set)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_SCAN_LOCATION_ADD);
    }

    public static Set<String> getPVerilogSkippedScanLocations(IProject project) {
        return (Set)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PVERILOG_SCAN_LOCATION_SKIP);
    }

    public static boolean shouldFlushLPPM(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.CLEAN_LPPM);
    }

    public static boolean isSvxMode(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_SVX_MODE);
    }

    public static boolean isDisableIncrementalSave(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_INCREMENTAL_DB_SAVE) == false;
    }

    public static boolean isDisableProfileElab(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_PROFILE_ELAB);
    }

    public static boolean isNonTopFileCompilationDisabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVT_DISABLE_NONTOP_FILE_COMPILATION);
    }

    public static Integer getFileCompileTimeout(IProject project) {
        Integer override = (Integer)IBuildConfigParserConstants.Directive.FILE_COMPILE_TIMEOUT.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.FILE_COMPILE_TIMEOUT);
    }

    public static Integer getSemanticChecksTimeout(IProject project) {
        Integer override = (Integer)IBuildConfigParserConstants.Directive.SEMANTIC_CHECKS_TIMEOUT.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.SEMANTIC_CHECKS_TIMEOUT);
    }

    public static Integer getIncrementalCompileTimeout(IProject project) {
        if (PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE")) {
            return 0;
        }
        Integer override = (Integer)IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT);
    }

    public static Integer getIncrementalCompileTimeout(IProject project, int noFiles) {
        if (PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE")) {
            return 0;
        }
        Integer override = (Integer)IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        Integer result = (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_TIMEOUT);
        if (result == 0) {
            return result;
        }
        return result + noFiles / 2;
    }

    public static Integer getMaxNofThreads(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.MAX_NOF_THREADS);
    }

    public static IncrementalChecksKind getIncrementalCompileChecks(IProject project, boolean isLintingEnabled) {
        return isLintingEnabled ? IncrementalChecksKind.ON : (IncrementalChecksKind)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.INCREMENTAL_COMPILE_CHECKS);
    }

    public static boolean getDisableRTLChecks(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_RTL_CHECKS);
    }

    public static FullChecksAndLibs getFullCompileChecks(IProject project) {
        return (FullChecksAndLibs)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.FULL_COMPILE_CHECKS);
    }

    public static EnumSet<CheckIdKind> getDisabledChecks(IProject project) {
        EnumSet<CheckIdKind> result = EnumSet.noneOf(CheckIdKind.class);
        AdditiveValueEnumList debugKinds = (AdditiveValueEnumList)BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_CHECKS);
        if (debugKinds == null) {
            return result;
        }
        debugKinds.forEach(e -> {
            boolean bl = result.add((CheckIdKind)((Object)e));
        });
        return result;
    }

    public static List<CdtBuildKind> getRunCodan(IProject project) {
        AdditiveValueEnumList runCodan = (AdditiveValueEnumList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.RUN_CODAN);
        if (runCodan == null) {
            return new ArrayList<CdtBuildKind>();
        }
        return runCodan.getData();
    }

    public static String getUvmTestname(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.UVM_TESTNAME);
    }

    public static String getOvmTestname(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.OVM_TESTNAME);
    }

    public static String getUvmTimeout(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.UVM_TIMEOUT);
    }

    public static String getUvmMaxQuitCount(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.UVM_MAX_QUIT_COUNT);
    }

    public static String getDesignHierarchyTop(IProject project) {
        return BuildConfigXml.load(project).getDesignHierarchyTop();
    }

    public static String getVerificationHierarchyTop(IProject project) {
        return BuildConfigXml.load(project).getVerificationHierarchyTop();
    }

    public static LanguageKind getVerificationHierarchyTopLanguage(IProject project) {
        String verificationHierarchyTopLanguage;
        block3: {
            try {
                verificationHierarchyTopLanguage = BuildConfigXml.load(project).getVerificationHierarchyTopLanguage();
                if (verificationHierarchyTopLanguage != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return LanguageKind.valueOf(verificationHierarchyTopLanguage);
    }

    public static LanguageKind getDesignHierarchyTopLanguage(IProject project) {
        String designHierarchyTopLanguage;
        block3: {
            try {
                designHierarchyTopLanguage = BuildConfigXml.load(project).getDesignHierarchyTopLanguage();
                if (designHierarchyTopLanguage != null) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        return LanguageKind.valueOf(designHierarchyTopLanguage);
    }

    public static boolean setDesignHierarchyTop(IProject project, String topString, boolean isElab, LanguageKind languageKind) {
        return BuildConfigXml.load(project).setDesignHierarchyTop(topString).setDesignHierarchyTopLanguage(languageKind.toString()).save();
    }

    public static boolean removeDesignHierarchyTop(IProject project, boolean isElab) {
        return BuildConfigXml.load(project).removeElement(project, isElab ? "design-hierarchy-top-elab" : "design-hierarchy-top");
    }

    public static boolean setVerificationHierarchyTop(IProject project, String topString, LanguageKind languageKind) {
        return BuildConfigXml.load(project).setVerificationHierarchyTop(topString).setVerificationHierarchyTopLanguage(languageKind.toString()).save();
    }

    public static boolean isCpreprocEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.CPREPROC_ENABLE);
    }

    public static boolean isBenchmarkSerdes(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.BENCHMARK_SERDES.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.BENCHMARK_SERDES);
    }

    public static boolean isCacheIncdirsEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.CACHE_INCDIRS_CONTENT);
    }

    public static boolean isAsComputedDisabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_AS_COMPUTED_DISABLE);
    }

    public static boolean isAsComputedLogEnabled(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_AS_COMPUTED_ENABLE_LOG);
    }

    public static boolean isEnableExtendedSemanticChecks(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.DISABLE_EXPR_EVALUATE_E.getEnvVarOverride();
        if (override != null) {
            return override == false;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DISABLE_EXPR_EVALUATE_E) == false;
    }

    public static boolean isElaborationSkipLongExpressions(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ELABORATION_SKIP_LONG_EXPRESSIONS.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_SKIP_LONG_EXPRESSIONS);
    }

    public static boolean isElaborationFilterWidthMismatch(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ELABORATION_FILTER_WIDTH_MISMATCH.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_FILTER_WIDTH_MISMATCH);
    }

    public static boolean isEncryptedCodeDebug(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ENABLE_ENCRYPTED_CODE_DEBUG.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_ENCRYPTED_CODE_DEBUG);
    }

    public static boolean isElaborationWidthMismatchDisabled(IProject project) {
        EnumSet<CheckIdKind> disabledChecks = BuildConfigManager.getDisabledChecks(project);
        return disabledChecks.contains((Object)CheckIdKind.ELABORATION_WIDTH_MISMATCH);
    }

    public static boolean isElaborationSkipDefparams(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ELABORATION_SKIP_DEFPARAMS.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_SKIP_DEFPARAMS);
    }

    public static IncrementalElaborationKind getIncrementalElaborationKind(IProject project) {
        try {
            Object override = IBuildConfigParserConstants.Directive.ENABLE_ELABORATION_INCREMENTAL.getEnvVarOverride();
            if (override instanceof IncrementalElaborationKind) {
                return (IncrementalElaborationKind)override;
            }
            Object value = BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_ELABORATION_INCREMENTAL);
            if (value instanceof IncrementalElaborationKind) {
                return (IncrementalElaborationKind)value;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return (IncrementalElaborationKind)IBuildConfigParserConstants.Directive.ENABLE_ELABORATION_INCREMENTAL.fDefaultValue;
    }

    public static boolean isEnableElaborationEmptyTops(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ENABLE_ELABORATION_EMPTY_TOPS.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_ELABORATION_EMPTY_TOPS);
    }

    public static ElaborationKind getElaborationKind(IProject project) {
        try {
            Object override = IBuildConfigParserConstants.Directive.ELABORATION_KIND.getEnvVarOverride();
            if (override instanceof ElaborationKind) {
                return (ElaborationKind)override;
            }
            Object value = BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_KIND);
            if (value instanceof ElaborationKind) {
                return (ElaborationKind)value;
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return (ElaborationKind)IBuildConfigParserConstants.Directive.ELABORATION_KIND.fDefaultValue;
    }

    public static boolean shouldPrintLibScanDebug(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.PRINT_LIB_SCAN_DEBUG.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PRINT_LIB_SCAN_DEBUG);
    }

    public static boolean isCompactMacros(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.COMPACT_MACROS);
    }

    public static UnelaboratedChecksKind getUnelaboratedCompileChecksKind(IProject project) {
        try {
            Object override = IBuildConfigParserConstants.Directive.UNELABORATED_COMPILE_CHECKS.getEnvVarOverride();
            if (override instanceof UnelaboratedChecksKind) {
                return (UnelaboratedChecksKind)((Object)override);
            }
            Object value = BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.UNELABORATED_COMPILE_CHECKS);
            if (BuildConfigManager.isPrecompiledDbSaveMode(project)) {
                value = UnelaboratedChecksKind.FULL;
            }
            if (value instanceof UnelaboratedChecksKind) {
                return (UnelaboratedChecksKind)((Object)value);
            }
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
        }
        return (UnelaboratedChecksKind)((Object)IBuildConfigParserConstants.Directive.UNELABORATED_COMPILE_CHECKS.fDefaultValue);
    }

    @NotNull
    public static EnumSet<ElaborationControl> getElaborationControl(IProject project) {
        try {
            ElaborationControl[] override = (ElaborationControl[])IBuildConfigParserConstants.Directive.ELABORATION_CONTROL.getEnvVarOverride();
            if (override != null) {
                EnumSet<ElaborationControl> result = EnumSet.noneOf(ElaborationControl.class);
                Collections.addAll(result, override);
                return result;
            }
            Object dvtConfig = BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_CONTROL);
            if (dvtConfig instanceof AdditiveValueEnumList) {
                AdditiveValueEnumList enums = (AdditiveValueEnumList)dvtConfig;
                EnumSet<ElaborationControl> result = EnumSet.noneOf(ElaborationControl.class);
                for (ElaborationControl e : enums) {
                    result.add(e);
                }
                return result;
            }
            return EnumSet.noneOf(ElaborationControl.class);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return EnumSet.noneOf(ElaborationControl.class);
        }
    }

    @NotNull
    public static Set<String> getElaborationExpressionOperatorControl(IProject project) {
        try {
            String[] controls = null;
            Object dvtConfig = BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_EXPRESSION_OPERATOR_CONTROL);
            if (dvtConfig instanceof AdditiveValueStringList) {
                controls = ((AdditiveValueStringList)dvtConfig).toArray();
            } else if (dvtConfig instanceof String) {
                controls = new String[]{(String)dvtConfig};
            }
            if (controls == null || controls.length == 0) {
                return Collections.emptySet();
            }
            HashSet<String> result = new HashSet<String>();
            Collections.addAll(result, controls);
            return result;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return Collections.emptySet();
        }
    }

    @NotNull
    public static Set<ElaborationExpressionControl> getElaborationExpressionControl(IProject project) {
        try {
            ElaborationExpressionControl[] override = (ElaborationExpressionControl[])IBuildConfigParserConstants.Directive.ELABORATION_EXPRESSION_CONTROL.getEnvVarOverride();
            if (override != null) {
                EnumSet<ElaborationExpressionControl> result = EnumSet.noneOf(ElaborationExpressionControl.class);
                Collections.addAll(result, override);
                return result;
            }
            Object dvtConfig = BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_EXPRESSION_CONTROL);
            if (dvtConfig instanceof AdditiveValueEnumList) {
                AdditiveValueEnumList enums = (AdditiveValueEnumList)dvtConfig;
                EnumSet<ElaborationExpressionControl> result = EnumSet.noneOf(ElaborationExpressionControl.class);
                for (ElaborationExpressionControl e : enums) {
                    result.add(e);
                }
                return result;
            }
            return EnumSet.noneOf(ElaborationExpressionControl.class);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return EnumSet.noneOf(ElaborationExpressionControl.class);
        }
    }

    @NotNull
    public static EnumSet<ElaborationDebugZone> getElaborationDebug(IProject project) {
        try {
            ElaborationDebugZone[] debugZones = (ElaborationDebugZone[])IBuildConfigParserConstants.Directive.ELABORATION_DEBUG.getEnvVarOverride();
            if (debugZones == null) {
                Object dvtConfig = BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_DEBUG);
                if (dvtConfig instanceof AdditiveValueEnumList) {
                    AdditiveValueEnumList enums = (AdditiveValueEnumList)dvtConfig;
                    EnumSet<ElaborationDebugZone> result = EnumSet.noneOf(ElaborationDebugZone.class);
                    for (ElaborationDebugZone e : enums) {
                        result.add(e);
                    }
                    return result;
                }
                return EnumSet.noneOf(ElaborationDebugZone.class);
            }
            EnumSet<ElaborationDebugZone> result = EnumSet.noneOf(ElaborationDebugZone.class);
            ElaborationDebugZone[] elaborationDebugZoneArray = debugZones;
            int n = debugZones.length;
            int n2 = 0;
            while (n2 < n) {
                ElaborationDebugZone zone = elaborationDebugZoneArray[n2];
                if (zone == ElaborationDebugZone.ALL) {
                    return EnumSet.allOf(ElaborationDebugZone.class);
                }
                result.add(zone);
                ++n2;
            }
            return result;
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return EnumSet.noneOf(ElaborationDebugZone.class);
        }
    }

    public static int getElaborationMaxNofBindPasses(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_RESOLVE_BINDS_PASSES.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_RESOLVE_BINDS_PASSES);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_RESOLVE_BINDS_PASSES.fDefaultValue;
        }
    }

    public static int getElaborationMaxRecurrenceDepth(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_RECURRENCE_DEPTH.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_MAX_RECURRENCE_DEPTH);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_RECURRENCE_DEPTH.fDefaultValue;
        }
    }

    public static int getElaborationMaxNofProblemsPerZone(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_PROBLEMS_PER_ZONE.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_PROBLEMS_PER_ZONE);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.ELABORATION_MAX_NOF_PROBLEMS_PER_ZONE.fDefaultValue;
        }
    }

    public static int getElaborationMaxNofRecursionThreads(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.MAX_NOF_THREADS.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.MAX_NOF_THREADS);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.MAX_NOF_THREADS.fDefaultValue;
        }
    }

    public static int getElaborationLoopBlockCutoff(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.ELABORATION_LOOP_BLOCK_CUTOFF.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_LOOP_BLOCK_CUTOFF);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.ELABORATION_LOOP_BLOCK_CUTOFF.fDefaultValue;
        }
    }

    public static int getElaborationLoopStatementCutoff(IProject project) {
        try {
            Integer override = (Integer)IBuildConfigParserConstants.Directive.ELABORATION_LOOP_STATEMENT_CUTOFF.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_LOOP_STATEMENT_CUTOFF);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Integer)IBuildConfigParserConstants.Directive.ELABORATION_LOOP_STATEMENT_CUTOFF.fDefaultValue;
        }
    }

    public static boolean isElabDisabledMethodEvaluation(IProject project) {
        try {
            Boolean override = (Boolean)IBuildConfigParserConstants.Directive.ELABORATION_DISABLE_METHOD_EVAL.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_DISABLE_METHOD_EVAL);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Boolean)IBuildConfigParserConstants.Directive.ELABORATION_DISABLE_METHOD_EVAL.fDefaultValue;
        }
    }

    public static boolean isUnelaboratedDisabledPackageConstants(IProject project) {
        try {
            Boolean override = (Boolean)IBuildConfigParserConstants.Directive.UNELABORATED_DISABLE_PACKAGE_CONSTANTS.getEnvVarOverride();
            if (override != null) {
                return override;
            }
            return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.UNELABORATED_DISABLE_PACKAGE_CONSTANTS);
        }
        catch (Exception ex) {
            DVTLogger.INSTANCE.logError((Throwable)ex);
            return (Boolean)IBuildConfigParserConstants.Directive.UNELABORATED_DISABLE_PACKAGE_CONSTANTS.fDefaultValue;
        }
    }

    public static String getAsComputedDumpPath(IProject project) {
        if (BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.E_AS_COMPUTED_DUMP_PATH)) {
            return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_AS_COMPUTED_DUMP_PATH);
        }
        return null;
    }

    public static boolean isEnableIncludeEnvVarExpansion(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ENABLE_INCLUDE_ENV_VAR_EXPANSION);
    }

    public static boolean isStrictNonStandardChecks(IProject project) {
        Boolean override = (Boolean)IBuildConfigParserConstants.Directive.STRICT_NON_STANDARD_CHECKS.getEnvVarOverride();
        if (override != null) {
            return override;
        }
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.STRICT_NON_STANDARD_CHECKS);
    }

    private static List<String> getVIPSpecmanPath(IProject project, Invocation invocation) {
        ArrayList<String> vipNames = new ArrayList<String>(BuildConfigManagerCommon.getVipsFor(project, invocation).getData());
        if (vipNames.isEmpty()) {
            return new ArrayList<String>(0);
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Boolean isSnWhichEmulation = (Boolean)BuildConfigManagerCommon.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.E_SN_WHICH_EMULATION);
        if (isSnWhichEmulation.booleanValue()) {
            DVTExternalProgramOutputCache.DVTExternalProgram cadenceLocation = DVTExternalProgramOutputCache.getInstance().get("xrun -location -nolog -nohistory");
            DVTExternalProgramOutputCache.DVTExternalProgram.Result cadenceLocationResult = cadenceLocation.getResult(true);
            if (!cadenceLocationResult.isValid()) {
                DVTLogger.INSTANCE.logInfo("Unable to use sn_which xrun emulation because '" + cadenceLocation.getCommandLine() + "' status is: " + cadenceLocationResult.getInvalidReason());
                cadenceLocation = DVTExternalProgramOutputCache.getInstance().get("irun -location -nolog -nohistory");
                cadenceLocationResult = cadenceLocation.getResult(true);
            }
            if (cadenceLocationResult.isValid()) {
                Iterator vit = vipNames.iterator();
                block0: while (vit.hasNext()) {
                    String vipName = (String)vit.next();
                    for (String path : IBuildConfigParserConstants.PREDEFINED_VIP_SEARCH_PATHS) {
                        if (!new File(path = DVTStringUtil.replaceFirst(IUS_INSTALL_LOCATION_PATTERN, path, cadenceLocationResult.value), vipName).exists()) continue;
                        result.add(path);
                        vit.remove();
                        continue block0;
                    }
                }
            } else {
                DVTLogger.INSTANCE.logInfo("Unable to use sn_which irun emulation because '" + cadenceLocation.getCommandLine() + "' status is: " + cadenceLocationResult.getInvalidReason());
            }
        }
        if (vipNames.isEmpty()) {
            return Arrays.asList(result.toArray(new String[result.size()]));
        }
        for (String vipName : vipNames) {
            DVTExternalProgramOutputCache.getInstance().get("sn_which.sh " + vipName);
        }
        for (String vipName : vipNames) {
            DVTExternalProgramOutputCache.DVTExternalProgram p = DVTExternalProgramOutputCache.getInstance().get("sn_which.sh " + vipName);
            if (p == null) continue;
            DVTExternalProgramOutputCache.DVTExternalProgram.Result snWhichResult = p.getResult(true);
            if (!snWhichResult.isValid()) {
                DVTLogger.INSTANCE.logInfo("Could not find location of VIP " + vipName + " sn_which status is: " + snWhichResult.getInvalidReason());
                continue;
            }
            String output = Path.fromOSString((String)snWhichResult.value.trim()).removeLastSegments(1).toOSString();
            DVTLogger.INSTANCE.logInfo("Adding to SPECMAN_PATH " + output + " for VIP " + vipName);
            result.add(output);
        }
        return Arrays.asList(result.toArray(new String[result.size()]));
    }

    protected static List<String> internalGetSpecmanPath(IProject project, Invocation invocation, DVTUtilsCommon.IEnvironmentProvider envProvider, IBuildConfigParserConstants.SpecmanPathSource ... sources) {
        ArrayList<String> result = new ArrayList<String>();
        IBuildConfigParserConstants.SpecmanPathSource[] specmanPathSourceArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildConfigParserConstants.SpecmanPathSource source = specmanPathSourceArray[n2];
            switch (source) {
                case COMPILATION_ROOT: {
                    result.add(BuildConfigManagerCommon.getCompilationRoot(project, invocation));
                    break;
                }
                case SPECMAN_PATH: {
                    result.addAll(BuildConfigManagerCommon.conditionSpecmanPath(project, invocation, envProvider.getenv(SPECMAN_PATH)));
                    break;
                }
                case DVT_SPECMAN_PATH: {
                    result.addAll(BuildConfigManagerCommon.conditionSpecmanPath(project, invocation, envProvider.getenv(DVT_SPECMAN_PATH)));
                    break;
                }
                case PERSPEC_PATH: {
                    result.addAll(BuildConfigManagerCommon.conditionSpecmanPath(project, invocation, envProvider.getenv(PERSPEC_PATH)));
                    break;
                }
                case SVR_PATH: {
                    result.addAll(BuildConfigManagerCommon.conditionSpecmanPath(project, invocation, envProvider.getenv(SVR_PATH)));
                    break;
                }
                case DVT_SN_WHICH: {
                    result.addAll(BuildConfigManagerCommon.getVIPSpecmanPath(project, invocation));
                    break;
                }
                default: {
                    DVTLogger.INSTANCE.logInfo("Unknown SpecmanPathSource: " + (Object)((Object)source));
                }
            }
            ++n2;
        }
        return result;
    }

    public static List<String> getSpecmanPath(IProject project, Invocation invocation, IBuildConfigParserConstants.SpecmanPathSource ... sources) {
        DVTUtilsCommon.IEnvironmentProvider environmentProvider = name -> BuildConfigManager.getenv(invocation, name);
        return BuildConfigManagerCommon.internalGetSpecmanPath(project, invocation, environmentProvider, sources);
    }

    private static List<String> conditionSpecmanPath(IProject project, Invocation invocation, String aSpecmanPath) {
        ArrayList<String> result = new ArrayList<String>();
        if (aSpecmanPath == null) {
            return result;
        }
        String[] envvarValues = DVTStringUtil.split(PATHSEPARATOR_PATTERN, aSpecmanPath);
        boolean windows = System.getProperty("os.name").toLowerCase().indexOf("win") >= 0;
        int i = 0;
        while (i < envvarValues.length) {
            if (!envvarValues[i].isEmpty()) {
                if (windows && envvarValues[i].length() == 1 && i < envvarValues.length - 1 && envvarValues[i + 1].startsWith("\\")) {
                    envvarValues[i + 1] = String.valueOf(envvarValues[i]) + File.pathSeparator + envvarValues[i + 1];
                } else if (!Path.fromOSString((String)envvarValues[i]).isAbsolute()) {
                    result.add(new Path(BuildConfigManagerCommon.getCompilationRoot(project, invocation)).append(envvarValues[i]).toOSString());
                } else {
                    result.add(envvarValues[i]);
                }
            }
            ++i;
        }
        return result;
    }

    public static String getSpecmanVersionDefines(IProject project) {
        block16: {
            String string;
            if (!BuildConfigManager.isAddSnVersionDefs(project)) {
                return "";
            }
            BufferedReader br = null;
            try {
                String line;
                String pathToSpecmanH = null;
                Boolean isSnWhichEmulation = (Boolean)BuildConfigManagerCommon.getDVTConfig(project, BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project), IBuildConfigParserConstants.Directive.E_SN_WHICH_EMULATION);
                if (isSnWhichEmulation.booleanValue()) {
                    DVTExternalProgramOutputCache.DVTExternalProgram cadenceLocation = DVTExternalProgramOutputCache.getInstance().get("xrun -location -nolog -nohistory");
                    DVTExternalProgramOutputCache.DVTExternalProgram.Result cadenceLocationResult = cadenceLocation.getResult(true);
                    if (!cadenceLocationResult.isValid()) {
                        DVTLogger.INSTANCE.logInfo("Unable to use sn_which xrun emulation because '" + cadenceLocation.getCommandLine() + "' status is: " + cadenceLocationResult.getInvalidReason());
                        cadenceLocation = DVTExternalProgramOutputCache.getInstance().get("irun -location -nolog -nohistory");
                        cadenceLocationResult = cadenceLocation.getResult(true);
                    }
                    if (cadenceLocationResult.isValid()) {
                        for (String path : IBuildConfigParserConstants.PREDEFINED_VIP_SEARCH_PATHS) {
                            File sh = new File(path = DVTStringUtil.replaceFirst(IUS_INSTALL_LOCATION_PATTERN, path, cadenceLocationResult.value), SPECMAN_H);
                            if (!sh.exists()) continue;
                            pathToSpecmanH = sh.getAbsolutePath();
                            break;
                        }
                    } else {
                        DVTLogger.INSTANCE.logInfo("Unable to use sn_which irun emulation because '" + cadenceLocation.getCommandLine() + "' status is: " + cadenceLocationResult.getInvalidReason());
                    }
                }
                if (pathToSpecmanH == null) {
                    DVTExternalProgramOutputCache.DVTExternalProgram p = DVTExternalProgramOutputCache.getInstance().get("sn_which.sh specman.h");
                    DVTExternalProgramOutputCache.DVTExternalProgram.Result snWhichSpHResult = p.getResult(true);
                    if (!snWhichSpHResult.isValid()) {
                        DVTLogger.INSTANCE.logInfo("Could not set the SPECMAN_VERSION defines, sn_which specman.h status is: " + snWhichSpHResult.getInvalidReason());
                        DVTUtilsCommon.INSTANCE.closeClosable(br);
                        return "";
                    }
                    pathToSpecmanH = snWhichSpHResult.value.trim();
                }
                br = new BufferedReader(new FileReader(pathToSpecmanH));
                StringBuilder result = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    if (line.indexOf("SPECMAN_VERSION_") < 0 || line.indexOf("#define ") < 0) continue;
                    result.append(String.valueOf(line) + ";\n");
                }
                DVTLogger.INSTANCE.logInfo("Set SPECMAN_VERSION defines.");
                br.close();
                string = result.toString();
                DVTUtilsCommon.INSTANCE.closeClosable(br);
            }
            catch (Exception exception) {
                break block16;
            }
            finally {
                DVTUtilsCommon.INSTANCE.closeClosable(br);
            }
            return string;
        }
        return "";
    }

    public static boolean saveBuildConfig(ActiveBuildConfig activeBuildConfig, Path buildConfigsDirectoryPath) {
        return BuildConfigManagerCommon.saveBuildConfig(activeBuildConfig, buildConfigsDirectoryPath, activeBuildConfig.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveBuildConfig(ActiveBuildConfig activeBuildConfig, Path buildConfigsDirectoryPath, String serializedName) {
        if (!buildConfigsDirectoryPath.toFile().exists() && !buildConfigsDirectoryPath.toFile().mkdirs()) {
            return false;
        }
        String activeBuildConfigPath = buildConfigsDirectoryPath.append(serializedName).toOSString();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                BufferedOutputStream os1 = new BufferedOutputStream(new FileOutputStream(new File(activeBuildConfigPath)));
                try {
                    block21: {
                        BufferedOutputStream os2 = new BufferedOutputStream(new DeflaterOutputStream((OutputStream)os1, new Deflater(1)));
                        try {
                            try (ObjectOutputStream oos = new ObjectOutputStream(os2);){
                                oos.writeObject(activeBuildConfig);
                            }
                            if (os2 == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (os2 == null) throw throwable;
                            ((OutputStream)os2).close();
                            throw throwable;
                        }
                        ((OutputStream)os2).close();
                    }
                    if (os1 == null) return true;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (os1 == null) throw throwable;
                    ((OutputStream)os1).close();
                    throw throwable;
                }
                ((OutputStream)os1).close();
                return true;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError(e.getCause());
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static ActiveBuildConfig loadBuildConfig(Path buildConfigsDirectoryPath, String buildConfigName, IProject fProject) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void setDeserializationInfo(ActiveBuildConfig activeBuildConfig, IProject fProject) {
        activeBuildConfig.setProject(fProject);
        activeBuildConfig.setLastCacheUpdate(new Object());
        if (activeBuildConfig.getCachedInfo() == null) {
            return;
        }
        for (Invocation invocation : activeBuildConfig.getCachedInfo()) {
            invocation.getState().setInfoAfterDeserialization(fProject);
        }
    }

    public static void parseAfterSplit(IProject project, boolean full) {
        BuildConfigParser.parse(BuildConfigManagerCommon.getBuildConfig(project), full, true);
    }

    public static void parse(IProject project, boolean full) {
        BuildConfigParser.parse(BuildConfigManagerCommon.getBuildConfig(project), full, false);
    }

    public static BuildConfigParser parseSimArgs(IProject project) {
        return BuildConfigParser.parseSimArgs(BuildConfigManagerCommon.getBuildConfig(project));
    }

    public static boolean isBuildConfigFile(IProject project, ParserPath parserPath) {
        if (parserPath == null || parserPath.path == null) {
            return false;
        }
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        if (allProperties == null) {
            return false;
        }
        for (BuildConfigProperty p : allProperties) {
            if (p.getKind() != 12 || !parserPath.path.equals(p.getValue())) continue;
            return true;
        }
        return false;
    }

    public static boolean isBatchMode() {
        return fBatchMode;
    }

    public static void setBatchMode() {
        fBatchMode = true;
    }

    public static List<BuildConfigProperty> getVerificationTopConfigurationProperties(IProject project) {
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        if (allProperties == null) {
            return result;
        }
        for (BuildConfigProperty p : allProperties) {
            if (p.getKind() != 22) continue;
            result.add(p);
        }
        return result;
    }

    public static BuildConfigProperty getTimescaleConfigurationProperty(IProject project) {
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        if (allProperties == null) {
            return null;
        }
        for (BuildConfigProperty p : allProperties) {
            if (p.getKind() != 24) continue;
            return p;
        }
        return null;
    }

    public static BuildConfigProperty getOverrideTimescaleConfigurationProperty(IProject project) {
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        if (allProperties == null) {
            return null;
        }
        for (BuildConfigProperty p : allProperties) {
            if (p.getKind() != 25) continue;
            return p;
        }
        return null;
    }

    public static List<BuildConfigProperty> getTopConfigurationProperties(IProject project) {
        List<BuildConfigProperty> allProperties = BuildConfigManagerCommon.getActiveBuildConfigCompactedCachedInfo(project);
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        if (allProperties == null) {
            return result;
        }
        for (BuildConfigProperty p : allProperties) {
            if (p.getKind() != 15) continue;
            result.add(p);
        }
        return result;
    }

    public static List<String> getTopConfigurationPropertiesForLib(IProject project, String libName, boolean negate) {
        ArrayList<String> result = new ArrayList<String>();
        List<Invocation> invocationsList = BuildConfigManagerCommon.getInvocations(project);
        if (invocationsList == null) {
            return result;
        }
        for (Invocation invocation : invocationsList.stream().filter(inv -> !negate && inv.getLibName().equals(libName) || negate && !inv.getLibName().equals(libName)).collect(Collectors.toList())) {
            for (BuildConfigProperty p : invocation.getProperties()) {
                if (p.getKind() != 15) continue;
                result.add(p.getValue());
            }
        }
        return result;
    }

    public static List<BuildConfigProperty> getAllTopFiles(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> properties = invocation.getProperties();
            if (properties == null) continue;
            for (BuildConfigProperty buildConfigProperty : properties) {
                IBuildConfigParserConstants.LanguageSyntax syntax;
                if (buildConfigProperty.getKind() != 0 || (syntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)buildConfigProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX"))) == null) continue;
                result.add(buildConfigProperty);
            }
        }
        return result;
    }

    public static List<BuildConfigProperty> getTopFiles(Invocation invocation, LanguageKind lk) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            IBuildConfigParserConstants.LanguageSyntax syntax;
            if (buildConfigProperty.getKind() != 0 || buildConfigProperty.getAttribute("ATTRIBUTE_IGNORE_TOP", false).booleanValue() || (syntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)buildConfigProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX"))) == null || syntax.languageKind != lk) continue;
            result.add(buildConfigProperty);
        }
        return result;
    }

    public static List<String> getIncdirs(IProject project, Invocation invocation) {
        ArrayList<String> result = new ArrayList<String>();
        LinkedHashSet<String> incdirPaths = new LinkedHashSet<String>();
        try {
            List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
            if (invocation == null && invocations == null) {
                return Collections.emptyList();
            }
            if (invocation == null) {
                for (Invocation inv : invocations) {
                    incdirPaths.add(BuildConfigManagerCommon.getCompilationRoot(project, inv));
                }
            } else {
                incdirPaths.add(BuildConfigManagerCommon.getCompilationRoot(project, invocation));
            }
            List<BuildConfigProperty> properties = invocation != null ? invocation.getProperties() : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project);
            for (BuildConfigProperty buildConfigProperty : properties) {
                if (buildConfigProperty.getKind() != 2) continue;
                String value = buildConfigProperty.getValue();
                incdirPaths.add(value);
            }
            if (invocation == null) {
                for (Invocation inv : invocations) {
                    incdirPaths.add(BuildConfigManagerCommon.getVamsIncdir(inv));
                }
            } else {
                incdirPaths.add(BuildConfigManagerCommon.getVamsIncdir(invocation));
            }
            for (String incdirPath : incdirPaths) {
                if (incdirPath == null) continue;
                incdirPath = DVTFileUtils.getInstance().pathOf(incdirPath).toOSString();
                result.add(incdirPath.endsWith(File.separator) ? incdirPath : String.valueOf(incdirPath) + File.separator);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static List<LanguageKind> getLanguageKindOfTopFiles(IProject project, Set<LanguageKind> searchedLanguageKinds) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        ArrayList<LanguageKind> result = new ArrayList<LanguageKind>();
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> properties = invocation.getProperties();
            if (properties == null) continue;
            for (BuildConfigProperty buildConfigProperty : properties) {
                LanguageKind currentLanguageKind;
                IBuildConfigParserConstants.LanguageSyntax syntax;
                if (buildConfigProperty.getKind() != 0 || (syntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)buildConfigProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX"))) == null || !searchedLanguageKinds.contains((Object)(currentLanguageKind = syntax.languageKind))) continue;
                searchedLanguageKinds.remove((Object)currentLanguageKind);
                result.add(currentLanguageKind);
            }
        }
        return result;
    }

    public static SkipCompileFilter getSkipCompileFilter(IProject project) {
        SkipCompileFilter result = fSkipCompileFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getSkipCompileFilter(project, buildConfig.getCompactedCachedInfo());
            }
            fSkipCompileFilters.put(project, result);
        }
        return result;
    }

    public static Map<ElementPath, ELBuildConfigOverriddenParameter> getBuildConfigOverriddenParameters(IProject project) {
        ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
        if (buildConfig == null) {
            return Collections.emptyMap();
        }
        List<BuildConfigProperty> properties = buildConfig.getCompactedCachedInfo();
        if (properties != null) {
            HashMap<ElementPath, ELBuildConfigOverriddenParameter> result = new HashMap<ElementPath, ELBuildConfigOverriddenParameter>();
            for (BuildConfigProperty p : properties) {
                if (!p.hasAttribute("ATTRIBUTE_OVERRIDE_PARAMETERS")) continue;
                result.putAll((Map)p.getAttribute("ATTRIBUTE_OVERRIDE_PARAMETERS"));
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public static SkipCompileFilter getSkipCompileFilter(IProject project, Invocation invocation) {
        if (invocation == null) {
            return new SkipCompileFilter(project);
        }
        return BuildConfigManagerCommon.getSkipCompileFilter(project, invocation.getProperties());
    }

    public static ShallowCompileFilter getShallowCompileFilter(Invocation invocation) {
        if (invocation == null) {
            return new ShallowCompileFilter();
        }
        return BuildConfigManagerCommon.getShallowCompileFilter(invocation.getProperties());
    }

    public static Set<ShallowCompileMode> getShallowCompileModes(Invocation invocation) {
        if (invocation == null) {
            return EnumSet.noneOf(ShallowCompileMode.class);
        }
        return BuildConfigManagerCommon.getShallowCompileModes(invocation.getProperties());
    }

    public static EncryptedCodeAutoFilter getEncryptedCodeAutoCloseFilter(IProject project) {
        EncryptedCodeAutoFilter result = fEncryptedCodeAutoCloseFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getEncryptedCodeFilter(project, buildConfig.getCompactedCachedInfo());
            }
            fEncryptedCodeAutoCloseFilters.put(project, result);
        }
        return result;
    }

    public static EncryptedCodeAutoFilter getEncryptedCodeAutoDefineFilter(IProject project) {
        EncryptedCodeAutoFilter result = fEncryptedCodeAutoDefineFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getEncryptedCodeAutoDefineFilter(project, buildConfig.getCompactedCachedInfo());
            }
            fEncryptedCodeAutoDefineFilters.put(project, result);
        }
        return result;
    }

    public static EncryptedCodeAutoDefineByNameFilter getEncryptedCodeAutoDefineByNameFilter(IProject project) {
        EncryptedCodeAutoDefineByNameFilter result = fEncryptedCodeAutoDefineNameFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getEncryptedCodeNameFilter(project, buildConfig.getCompactedCachedInfo());
            }
            fEncryptedCodeAutoDefineNameFilters.put(project, result);
        }
        return result;
    }

    public static ElabLiblist getElabLiblist(IProject project) {
        return (ElabLiblist)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.ELABORATION_LIBLIST);
    }

    public static ElaborationSkipModuleFilter getElaborationSkipModulesFilter(IProject project) {
        ElaborationSkipModuleFilter result = fElaborationSkipModuleFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationSkipModulesFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationSkipModuleFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static ElaborationSkipPathFilter getElaborationSkipPathsFilter(IProject project) {
        ElaborationSkipPathFilter result = fElaborationSkipPathFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationSkipPathsFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationSkipPathFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static ElaborationSkipInstanceFilter getElaborationSkipInstancesFilter(IProject project) {
        ElaborationSkipInstanceFilter result = fElaborationSkipInstanceFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationSkipInstancesFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationSkipInstanceFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static ElaborationSkipModuleFilter getElaborationBBoxModulesFilter(IProject project) {
        ElaborationSkipModuleFilter result = fElaborationBBoxModuleFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationBBoxModulesFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationBBoxModuleFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static ElaborationSkipPathFilter getElaborationBBoxPathsFilter(IProject project) {
        ElaborationSkipPathFilter result = fElaborationBBoxPathFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationBBoxPathsFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationBBoxPathFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static ElaborationSkipInstanceFilter getElaborationBBoxInstancesFilter(IProject project) {
        ElaborationSkipInstanceFilter result = fElaborationBBoxInstanceFilters.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getElaborationBBoxInstancesFilter(buildConfig.getCompactedCachedInfo());
            }
            fElaborationBBoxInstanceFilters.put(project, result);
        }
        return result == null || !result.isEnabled() ? null : result;
    }

    public static IncrementalProfilingWrapper getIncrementalProfilingWrapper(IProject project) {
        if (DVTLogger.INSTANCE.isJVMDebugMode()) {
            return null;
        }
        IncrementalProfilingWrapper result = fIncrementalProfilingWrappers.get(project);
        if (result == null) {
            ActiveBuildConfig buildConfig = BuildConfigManagerCommon.getBuildConfig(project);
            if (buildConfig == null) {
                return result;
            }
            if (buildConfig.getCompactedCachedInfo() != null) {
                result = BuildConfigManagerCommon.getIncrementalProfilingWrapper(buildConfig.getCompactedCachedInfo());
            }
            if (result == null) {
                return null;
            }
            fIncrementalProfilingWrappers.put(project, result);
        }
        if (result.isEnabled() && result.isDummy() && PreferenceUtils.INSTANCE.getBoolean("ro.amiq.dvt.CANCEL_ONGOING_INCREMENTAL_ENABLE")) {
            result.setDefaultValues();
        }
        return result;
    }

    private static EncryptedCodeAutoFilter getEncryptedCodeFilter(IProject project, List<BuildConfigProperty> properties) {
        EncryptedCodeAutoFilter result = new EncryptedCodeAutoFilter(project);
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_CLOSE")) continue;
            result.addEncryptedCodeAutoFilter((EncryptedCodeAutoFilter)p.getAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_CLOSE"));
        }
        return result;
    }

    private static EncryptedCodeAutoFilter getEncryptedCodeAutoDefineFilter(IProject project, List<BuildConfigProperty> properties) {
        EncryptedCodeAutoFilter result = new EncryptedCodeAutoFilter(project);
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_DEFINE")) continue;
            result.addEncryptedCodeAutoFilter((EncryptedCodeAutoFilter)p.getAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_DEFINE"));
        }
        return result;
    }

    private static EncryptedCodeAutoDefineByNameFilter getEncryptedCodeNameFilter(IProject project, List<BuildConfigProperty> properties) {
        EncryptedCodeAutoDefineByNameFilter result = new EncryptedCodeAutoDefineByNameFilter(project);
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_DEFINE_BY_NAME")) continue;
            result.addEncryptedCodeAutoFilter((EncryptedCodeAutoDefineByNameFilter)p.getAttribute("ATTRIBUTE_ENCRYPTED_CODE_AUTO_DEFINE_BY_NAME"));
        }
        return result;
    }

    private static ElaborationSkipModuleFilter getElaborationSkipModulesFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipModuleFilter result = new ElaborationSkipModuleFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_SKIP_MODULES_NAME")) continue;
            result.mergeFilter((ElaborationSkipModuleFilter)p.getAttribute("ATTRIBUTE_ELABORATION_SKIP_MODULES_NAME"));
        }
        return result;
    }

    private static ElaborationSkipPathFilter getElaborationSkipPathsFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipPathFilter result = new ElaborationSkipPathFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_SKIP_PATHS_NAME")) continue;
            result.mergeFilter((ElaborationSkipPathFilter)p.getAttribute("ATTRIBUTE_ELABORATION_SKIP_PATHS_NAME"));
        }
        return result;
    }

    private static ElaborationSkipInstanceFilter getElaborationSkipInstancesFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipInstanceFilter result = new ElaborationSkipInstanceFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_SKIP_INSTANCES_NAME")) continue;
            result.mergeFilter((ElaborationSkipInstanceFilter)p.getAttribute("ATTRIBUTE_ELABORATION_SKIP_INSTANCES_NAME"));
        }
        return result;
    }

    private static ElaborationSkipModuleFilter getElaborationBBoxModulesFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipModuleFilter result = new ElaborationSkipModuleFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_BBOX_MODULES_NAME")) continue;
            result.mergeFilter((ElaborationSkipModuleFilter)p.getAttribute("ATTRIBUTE_ELABORATION_BBOX_MODULES_NAME"));
        }
        return result;
    }

    private static ElaborationSkipPathFilter getElaborationBBoxPathsFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipPathFilter result = new ElaborationSkipPathFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_BBOX_PATHS_NAME")) continue;
            result.mergeFilter((ElaborationSkipPathFilter)p.getAttribute("ATTRIBUTE_ELABORATION_BBOX_PATHS_NAME"));
        }
        return result;
    }

    private static ElaborationSkipInstanceFilter getElaborationBBoxInstancesFilter(List<BuildConfigProperty> properties) {
        ElaborationSkipInstanceFilter result = new ElaborationSkipInstanceFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_ELABORATION_BBOX_INSTANCES_NAME")) continue;
            result.mergeFilter((ElaborationSkipInstanceFilter)p.getAttribute("ATTRIBUTE_ELABORATION_BBOX_INSTANCES_NAME"));
        }
        return result;
    }

    private static IncrementalProfilingWrapper getIncrementalProfilingWrapper(List<BuildConfigProperty> properties) {
        IncrementalProfilingWrapper result = null;
        if (properties == null) {
            return null;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_INCREMENTAL_PROFILE")) continue;
            IncrementalProfilingWrapper attribute = (IncrementalProfilingWrapper)p.getAttribute("ATTRIBUTE_INCREMENTAL_PROFILE");
            if (result == null) {
                result = new IncrementalProfilingWrapper();
            }
            result.copyValuesFrom(attribute);
        }
        return result;
    }

    private static SkipCompileFilter getSkipCompileFilter(IProject project, List<BuildConfigProperty> properties) {
        SkipCompileFilter result = new SkipCompileFilter(project);
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_SKIP_COMPILE")) continue;
            result.add((SkipCompileFilter)p.getAttribute("ATTRIBUTE_SKIP_COMPILE"));
        }
        return result;
    }

    private static ShallowCompileFilter getShallowCompileFilter(List<BuildConfigProperty> properties) {
        ShallowCompileFilter result = new ShallowCompileFilter();
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_SHALLOW_COMPILE")) continue;
            result.add((ShallowCompileFilter)p.getAttribute("ATTRIBUTE_SHALLOW_COMPILE"));
        }
        return result;
    }

    private static Set<ShallowCompileMode> getShallowCompileModes(List<BuildConfigProperty> properties) {
        Set<ShallowCompileMode> result = EnumSet.noneOf(ShallowCompileMode.class);
        if (properties == null) {
            return result;
        }
        for (BuildConfigProperty p : properties) {
            if (!p.hasAttribute("ATTRIBUTE_SHALLOW_COMPILE_MODE")) continue;
            result = (Set)p.getAttribute("ATTRIBUTE_SHALLOW_COMPILE_MODE");
        }
        return result;
    }

    public static boolean isLibRescan(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 10) continue;
            return true;
        }
        return false;
    }

    public static boolean isDisableCollectPortconnections(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 11 || !buildConfigProperty.hasAttribute("ATTRIBUTE_DISABLE_COLLECT_PORTCONNECTIONS")) continue;
            return true;
        }
        return false;
    }

    public static void clearCanonicalPathCache() {
        canonicalPathCache.clear();
    }

    public static List<BuildConfigProperty> getLibs(Invocation invocation) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        HashSet<String> checkDuplicates = new HashSet<String>();
        try {
            for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
                String path = buildConfigProperty.getValue();
                if (path == null) continue;
                String canonicalPath = canonicalPathCache.get(path);
                if (canonicalPath == null) {
                    canonicalPath = new File(path).getCanonicalPath();
                    canonicalPathCache.put(path, canonicalPath);
                }
                if (buildConfigProperty.getKind() == 4 && !checkDuplicates.contains(canonicalPath)) {
                    checkDuplicates.add(canonicalPath);
                    result.add(buildConfigProperty);
                }
                if (buildConfigProperty.getKind() != 5 || checkDuplicates.contains(canonicalPath)) continue;
                checkDuplicates.add(canonicalPath);
                result.add(buildConfigProperty);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static List<BuildConfigProperty> getLibmapProperties(Invocation invocation) {
        LinkedHashSet<BuildConfigProperty> result = new LinkedHashSet<BuildConfigProperty>();
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 14) continue;
            result.add(buildConfigProperty);
        }
        return new ArrayList<BuildConfigProperty>(result);
    }

    public static List<String> getLibExts(Invocation invocation) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 3) continue;
            result.add(buildConfigProperty.getValue());
        }
        return new ArrayList<String>(result);
    }

    public static boolean getIncludedObeysExtension(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 16) continue;
            return (Boolean)buildConfigProperty.getAttribute("ATTRIBUTE_INCLUDED_OBEYS_EXTENSION");
        }
        return false;
    }

    public static Map<String, String> getExtensionKeywordSetMap(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 16) continue;
            return (Map)buildConfigProperty.getAttribute("ATTRIBUTE_EXTENSION_KEYWORDSET_MAP");
        }
        return null;
    }

    public static String getDefaultKeywordSet(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            if (buildConfigProperty.getKind() != 16) continue;
            return (String)buildConfigProperty.getAttribute("ATTRIBUTE_DEFAULT_KEYWORDSET");
        }
        return null;
    }

    public static AmsMode getAmsMode(Invocation invocation) {
        for (BuildConfigProperty buildConfigProperty : invocation.getProperties()) {
            Object result;
            if (buildConfigProperty.getKind() != 16 || (result = buildConfigProperty.getAttribute("ATTRIBUTE_AMS_MODE")) == null) continue;
            return (AmsMode)((Object)result);
        }
        return null;
    }

    public static Set<String> getPreprocessTranslatePragmas(IProject project) {
        Set<String> translatePragmas = fTranslatePragmaMap.get(project);
        if (translatePragmas != null) {
            return translatePragmas;
        }
        HashSet<String> result = new HashSet<String>();
        String attr = "ATTRIBUTE_DVT_PREPROCESS_TRANSLATE_PRAGMAS";
        for (BuildConfigProperty p : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project)) {
            if (p.getKind() != 17 || !p.hasAttribute(attr)) continue;
            result.addAll((Collection)p.getAttribute(attr));
        }
        fTranslatePragmaMap.put(project, result);
        return result;
    }

    public static List<CustomPragma> getCustomPragmas(IProject project) {
        List<CustomPragma> customPramgas = fCustomPragmaMap.get(project);
        if (customPramgas == null) {
            BuildConfigManagerCommon.loadCustomPragmas(project);
        }
        return fCustomPragmaMap.get(project);
    }

    public static void loadCustomPragmas(IProject project) {
        List<CustomPragma> customPragmas = CustomPragmaStoreUtil.load(project);
        fCustomPragmaMap.put(project, customPragmas);
    }

    public static List<String> getUserDefinedSystemFunctions(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        AdditiveValueStringList userDefinedSystemTasks = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEFINE_SYSTEM_FUNCTION);
        if (userDefinedSystemTasks == null) {
            return result;
        }
        for (String userDefinedSystemTask : userDefinedSystemTasks) {
            if (userDefinedSystemTask == null) continue;
            result.add("$".concat(userDefinedSystemTask));
        }
        return result;
    }

    public static List<String> getUserDefinedSystemTasks(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        AdditiveValueStringList userDefinedSystemTasks = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEFINE_SYSTEM_TASK);
        if (userDefinedSystemTasks == null) {
            return result;
        }
        for (String userDefinedSystemTask : userDefinedSystemTasks) {
            if (userDefinedSystemTask == null) continue;
            result.add("$".concat(userDefinedSystemTask));
        }
        return result;
    }

    public static List<BuildConfigProperty> getCmdFileCalls(IProject project) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        for (BuildConfigProperty property : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project)) {
            if (property.getKind() != 12) continue;
            result.add(property);
        }
        return result;
    }

    public static List<String> getShellCommands(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<BuildConfigProperty> properties = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project);
            for (BuildConfigProperty property : properties) {
                if (property.getKind() != 7) continue;
                result.add(property.getValue());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static List<String> getIncrBuildCommands(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<BuildConfigProperty> properties = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project);
            for (BuildConfigProperty property : properties) {
                if (property.getKind() != 8) continue;
                result.add(property.getValue());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static List<String> getFullBuildCommands(IProject project) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            List<BuildConfigProperty> properties = BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project);
            for (BuildConfigProperty property : properties) {
                if (property.getKind() != 9) continue;
                result.add(property.getValue());
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public static Invocation getFirstInvocation(IProject project) {
        if (project == null) {
            return null;
        }
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null || invocations.isEmpty()) {
            return null;
        }
        return invocations.get(0);
    }

    public static String getVamsIncdir(Invocation invocation) {
        String result;
        DVTExternalProgramOutputCache.DVTExternalProgram xrunLocation;
        DVTExternalProgramOutputCache.DVTExternalProgram.Result xrunLocationResult;
        if ((invocation.getToolCompat() == IBuildConfigParserConstants.ToolCompat.XCELIUM_XRUN || invocation.getToolCompat() == IBuildConfigParserConstants.ToolCompat.IUS_IRUN) && (xrunLocationResult = (xrunLocation = DVTExternalProgramOutputCache.getInstance().get("xrun -location -nolog -nohistory")).getResult(true)).isValid() && new File(result = Path.fromOSString((String)DVTStringUtil.replaceFirst(IUS_INSTALL_LOCATION_PATTERN, "<IUS_install_location>/tools/spectre/etc/ahdl", xrunLocationResult.value)).toOSString()).exists()) {
            return result;
        }
        String result2 = BuildConfigManagerCommon.getenv(invocation, "DVT_VAMS_HOME");
        if (result2 != null) {
            return result2;
        }
        String distroRelPath = IBuildConfigParserConstants.DVT_DISTRO_LIB_HOMES.get("DVT_VAMS_HOME");
        if (distroRelPath == null) {
            return null;
        }
        String dvtHome = System.getenv("DVT_HOME");
        if (dvtHome == null) {
            return null;
        }
        return Path.fromOSString((String)dvtHome).append(distroRelPath).toOSString();
    }

    public static boolean isProgressMonitorCanceled(IProject project) {
        return BuildConfigManagerCommon.getProgressMonitor(project).isCanceled();
    }

    public static void setProgressMonitor(IProject project, IProgressMonitor monitor) {
        fProgressMonitorMap.put(project, monitor);
    }

    public static void removeProgressMonitor(IProject project) {
        fProgressMonitorMap.remove(project);
    }

    public static IProgressMonitor getProgressMonitor(IProject project) {
        if (!fProgressMonitorMap.containsKey(project)) {
            fProgressMonitorMap.put(project, (IProgressMonitor)new NullProgressMonitor());
        }
        return fProgressMonitorMap.get(project);
    }

    public static Map<String, String> getenv(IProject project, String file, int line, int column, boolean includingSystem) {
        HashMap<String, String> result = includingSystem ? new HashMap<String, String>(System.getenv()) : new HashMap();
        Invocation invocation = BuildConfigManager.getInvocation(project, file, line, column);
        if (invocation == null) {
            return result;
        }
        result.putAll(invocation.getEnvVarCache());
        return result;
    }

    public static Invocation getInvocation(IProject project, String file, int line, int column) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        Token bestToken = null;
        Invocation bestInvocation = null;
        for (Invocation invocation : invocations) {
            for (BuildConfigProperty property : invocation.getProperties()) {
                Token token = (Token)property.getAttribute("ATTRIBUTE_TOKEN");
                if (token == null || !BuildConfigManagerCommon.isCloser(file, line, column, token, bestToken)) continue;
                bestToken = token;
                bestInvocation = invocation;
            }
        }
        return bestInvocation == null ? invocations.get(0) : bestInvocation;
    }

    private static boolean isCloser(String file, int line, int column, Token candidate, Token best) {
        if (!candidate.getFilename().equals(file)) {
            return false;
        }
        if (best == null) {
            return true;
        }
        if (Math.abs(candidate.getLine() - line) < Math.abs(best.getLine() - line)) {
            return true;
        }
        if (Math.abs(candidate.getLine() - line) > Math.abs(best.getLine() - line)) {
            return false;
        }
        if (Math.abs(candidate.getColumn() - column) < Math.abs(best.getColumn() - column)) {
            return true;
        }
        if (Math.abs(candidate.getColumn() - column) > Math.abs(best.getColumn() - column)) {
            return false;
        }
        return false;
    }

    public static void skip(IProject project, ParserPath path, boolean skipped) {
        Boolean wasSkipped;
        HashMap<ParserPath, Boolean> map = fSkipCompileMap.get(project);
        if (map == null) {
            map = new HashMap();
            fSkipCompileMap.put(project, map);
        }
        if ((wasSkipped = map.get(path)) == null) {
            map.put(path, skipped);
        } else {
            map.put(path, skipped && wasSkipped != false);
        }
    }

    public static boolean isSkip(IResource resource) {
        IProject project = resource.getProject();
        if (project == null) {
            return false;
        }
        ParserPath parserPath = DVTFileUtils.getInstance().resource2parser(resource);
        return BuildConfigManagerCommon.isSkip(project, parserPath);
    }

    public static boolean isSkip(IProject project, ParserPath path) {
        HashMap<ParserPath, Boolean> map = fSkipCompileMap.get(project);
        if (map == null) {
            return false;
        }
        Boolean result = map.get(path);
        if (result == null) {
            return false;
        }
        return result;
    }

    public static Cflags getCflags(IProject project) {
        Cflags result = new Cflags();
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return result;
        }
        for (Invocation i : BuildConfigManagerCommon.getInvocations(project)) {
            result.merge(i.getState().fCflags);
        }
        return result;
    }

    public static String getGccPath(IProject project) {
        String result = (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.GCC);
        if (result == null || result.isEmpty()) {
            return null;
        }
        return result;
    }

    public static String getGccArgs(IProject project) {
        String result = (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.GCC_ARGS);
        if (BuildConfigManager.isPssCpp(project)) {
            result = "--std=c++11 " + result;
        }
        return result;
    }

    public static boolean isEnableEncryptedCodeAutoDefine(IProject project) {
        EncryptedCodeAutoFilter filter = BuildConfigManagerCommon.getEncryptedCodeAutoDefineFilter(project);
        return filter != null && filter.hasEnabledEncryptedCodeAuto();
    }

    public static int getGccTimeout(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.GCC_TIMEOUT);
    }

    public static int getReadelfTimeout(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.READELF_TIMEOUT);
    }

    public static List<File> getExtraWaiverFiles(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (Invocation invocation : invocations) {
            if (invocation.getExtraWaivers() == null) continue;
            result.addAll(invocation.getExtraWaivers());
        }
        return result;
    }

    public static List<String> getAutoLinkFiles(IProject project) {
        return (List)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.AUTO_LINK_FILE);
    }

    public static boolean isSkipProtectedCode(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.SKIP_PROTECTED_CODE);
    }

    public static boolean isPfDebug(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PF_DEBUG);
    }

    public static boolean isTagMemoryConsumptionDebug(IProject project) {
        AdditiveValueEnumList debugKinds = (AdditiveValueEnumList)BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEBUG_MEMORY_CONSUMPTION);
        return debugKinds != null && debugKinds.getData().contains(MemoryConsumptionDebugKind.TAGS);
    }

    public static boolean isCommentMemoryConsumptionDebug(IProject project) {
        AdditiveValueEnumList debugKinds = (AdditiveValueEnumList)BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEBUG_MEMORY_CONSUMPTION);
        return debugKinds != null && debugKinds.getData().contains(MemoryConsumptionDebugKind.COMMENTS);
    }

    public static boolean isWarningMemoryConsumptionDebug(IProject project) {
        AdditiveValueEnumList debugKinds = (AdditiveValueEnumList)BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEBUG_MEMORY_CONSUMPTION);
        return debugKinds != null && debugKinds.getData().contains(MemoryConsumptionDebugKind.WARNINGS);
    }

    public static Invocation getPowerFormatInvocation(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        for (Invocation invocation : invocations) {
            if (invocation.getState() == null || invocation.getState().fPowerFormatBCInfo == null) continue;
            return invocation;
        }
        return null;
    }

    public static boolean isVhdlAms(IProject project) {
        List<IBuildConfigParserConstants.LanguageSyntax> amsSyntaxes = Arrays.asList(IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999, IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_2007);
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return false;
        }
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> topFiles = BuildConfigManager.getTopFiles(invocation, LanguageKind.VHDL);
            for (BuildConfigProperty topProperty : topFiles) {
                IBuildConfigParserConstants.LanguageSyntax languageSyntax;
                if (topProperty.getKind() != 0 || !amsSyntaxes.contains((Object)(languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)topProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX"))))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isVhdl08(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return false;
        }
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> topFiles = BuildConfigManager.getTopFiles(invocation, LanguageKind.VHDL);
            for (BuildConfigProperty topProperty : topFiles) {
                IBuildConfigParserConstants.LanguageSyntax languageSyntax;
                if (topProperty.getKind() != 0 || !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2008.equals((Object)(languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)topProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX"))))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNonVhdl08(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return false;
        }
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> topFiles = BuildConfigManager.getTopFiles(invocation, LanguageKind.VHDL);
            for (BuildConfigProperty topProperty : topFiles) {
                IBuildConfigParserConstants.LanguageSyntax languageSyntax;
                if (topProperty.getKind() != 0 || !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1987.equals((Object)(languageSyntax = (IBuildConfigParserConstants.LanguageSyntax)((Object)topProperty.getAttribute("ATTRIBUTE_LANGUAGE_SYNTAX")))) && !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1993.equals((Object)languageSyntax) && !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_1999.equals((Object)languageSyntax) && !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_1_2007.equals((Object)languageSyntax) && !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2000.equals((Object)languageSyntax) && !IBuildConfigParserConstants.LanguageSyntax.VHDL_1076_2002.equals((Object)languageSyntax)) continue;
                return true;
            }
        }
        return false;
    }

    public static Set<String> getPkgSearchLibraries(IProject project, String libraryName) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (BuildConfigProperty p : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project)) {
            Object invocationLibrary;
            int kind = p.getKind();
            if (kind != 20 || (invocationLibrary = p.getAttribute("ATTRIBUTE_INVOCATION_LIBRARY")) != null && !invocationLibrary.equals(libraryName)) continue;
            result.add(p.getValue());
        }
        return result;
    }

    public static Set<String> getLibListLibraries(IProject project, String libraryName) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        result.add(libraryName);
        boolean found = false;
        for (BuildConfigProperty p : BuildConfigManager.getActiveBuildConfigCompactedCachedInfo(project)) {
            Object invocationLibrary;
            int kind = p.getKind();
            if (kind != 21 || (invocationLibrary = p.getAttribute("ATTRIBUTE_INVOCATION_LIBRARY")) != null && !invocationLibrary.equals(libraryName)) continue;
            result.add(p.getValue());
            found = true;
        }
        return found ? result : Collections.emptySet();
    }

    public static Set<String> getSoTopFiles(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (Invocation invocation : invocations) {
            for (BuildConfigProperty property : BuildConfigManagerCommon.getTopFiles(invocation, LanguageKind.SO)) {
                result.add(property.getValue());
            }
        }
        return result;
    }

    public static int getPssSolverMaxInferenceLimit(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_MAX_INFERENCE_LIMIT);
    }

    public static int getPssSolverMaxRepeatLimit(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_MAX_REPEAT_LIMIT);
    }

    public static int getPssSolverSolutionCost(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_SOLUTION_COST);
    }

    public static int getPssSolverDebugLevel(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_SCENARIO_DEBUG_LEVEL);
    }

    public static boolean getPssUseEnumInExpressions(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_USE_ENUM_IN_EXPRESSIONS);
    }

    public static boolean getPssEnableCoverage(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_ENABLE_COVERAGE);
    }

    public static String getPssSolverTargetFilePrefix(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_TARGET_FILE_PREFIX);
    }

    public static String getPssSolverTargetFileDir(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_TARGET_FILE_DIR);
    }

    public static String getPssSolverTargetTemplateDir(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_TARGET_TEMPLATE_DIR);
    }

    public static String getPssSolverTargetLanguage(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_TARGET_LANG);
    }

    public static int getPssSolverPrintRadix(IProject project) {
        PSSPrintRadix pssPrintRadix = (PSSPrintRadix)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_PRINT_RADIX);
        return pssPrintRadix == null ? PSSPrintRadix.DEC.value() : pssPrintRadix.value();
    }

    public static boolean isIrunRNMTech(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return false;
        }
        for (Invocation invocation : invocations) {
            if (!invocation.getState().fIrunRnmTech) continue;
            return true;
        }
        return false;
    }

    public static boolean isPssCpp(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PSS_CPP);
    }

    public static boolean isPrintDebugDeltaInfo(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PRINT_INCREMENTAL_DELTA_DEBUG);
    }

    public static CdtFileTypeAutoMapKind getCdtFileTypeAutoMapKind(IProject project) {
        return (CdtFileTypeAutoMapKind)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.CDT_FILE_TYPE_AUTO_MAP);
    }

    public static Map<String, IBuildConfigParserConstants.CdtFileType> getCdtFileTypeMap(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        for (Invocation invocation : invocations) {
            if (invocation.getState().fCdtFileTypeMap == null) continue;
            return invocation.getState().fCdtFileTypeMap;
        }
        return null;
    }

    public static AdditiveValueStringList getAutoconfigScanDirs(IProject project, Invocation invocation) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.AUTOCONFIG_SCAN_ROOT);
        if (stringList == null) {
            return new AdditiveValueStringList();
        }
        return stringList;
    }

    public static long getSimLogBufferMaxSize(IProject project, Invocation invocation) {
        int value = (Integer)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_SIMLOG_BUFFER_MAX_SIZE);
        return 1000000L * (long)value;
    }

    public static List<Pattern> getSimLogUserSpecifiedPatterns(IProject project, Invocation invocation) {
        List userSpecifiedRegexList = (List)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_SIMLOG_PATTERN);
        if (userSpecifiedRegexList == null || userSpecifiedRegexList.isEmpty()) {
            return null;
        }
        List patterns = userSpecifiedRegexList.stream().map(x -> Pattern.compile(x, 32)).collect(Collectors.toList());
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        return Collections.unmodifiableList(patterns);
    }

    public static Map<Pattern, String> getSimLogReplaceMap(IProject project, Invocation invocation) {
        Map replaceStringMap = (Map)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_SIMLOG_REPLACE);
        if (replaceStringMap == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Pattern, String> replaceMap = new LinkedHashMap<Pattern, String>();
        replaceStringMap.forEach((regex, str) -> replaceMap.put(Pattern.compile(regex), (String)str));
        return replaceMap;
    }

    public static EnumSet<AutoconfigDebugKind> getAutoconfigDebugKind(IProject project, Invocation invocation) {
        EnumSet<AutoconfigDebugKind> result = EnumSet.noneOf(AutoconfigDebugKind.class);
        AdditiveValueEnumList debugKinds = (AdditiveValueEnumList)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.AUTOCONFIG_DEBUG_KIND);
        if (debugKinds == null) {
            return result;
        }
        debugKinds.forEach(e -> {
            boolean bl = result.add((AutoconfigDebugKind)e);
        });
        return result;
    }

    public static List<String> getSkipIncrementalCompileDeps(IProject project) {
        return (List)BuildConfigManager.getDVTConfig(project, IBuildConfigParserConstants.Directive.E_SKIP_INCR_DEP);
    }

    public static List<String> getAlteraAutoconfigQipFiles(IProject project, Invocation invocation) {
        return (List)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_QUARTUS_QIP);
    }

    public static List<String> getAlteraAutoconfigQipSearchPaths(IProject project, Invocation invocation) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManager.getDVTConfig(project, invocation, IBuildConfigParserConstants.Directive.DVT_AUTOCONFIG_QUARTUS_QIP_SEARCH_PATH);
        if (stringList == null) {
            return new ArrayList<String>();
        }
        return stringList.getData();
    }

    public static IBuildConfigParserConstants.UsageBeforeDeclarationScope getUsageBeforeDeclarationScope(IProject project) {
        boolean hasDirective = BuildConfigManagerCommon.hasDirective(project, IBuildConfigParserConstants.Directive.DEF_BEFORE_USE_CHECK);
        if (!hasDirective) {
            return IBuildConfigParserConstants.UsageBeforeDeclarationScope.INVOCATION;
        }
        IBuildConfigParserConstants.UsageBeforeDeclarationScope value = (IBuildConfigParserConstants.UsageBeforeDeclarationScope)((Object)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DEF_BEFORE_USE_CHECK));
        if (value == null) {
            return IBuildConfigParserConstants.UsageBeforeDeclarationScope.INVOCATION;
        }
        return value;
    }

    public static boolean getXStepIntoInitialization(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_STEP_INTO_INITIALIZATION);
    }

    public static boolean getXStepIntoNewThreads(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_STEP_INTO_NEW_THREADS);
    }

    public static boolean getXLogExecutedStatement(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_LOG_EXECUTED_STATEMENT);
    }

    public static boolean getXAddExtraDebugInfo(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_ADD_EXTRA_DEBUG_INFO);
    }

    public static boolean getXStepIntoAssigns(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_STEP_INTO_ASSIGNS);
    }

    public static boolean getXShowOnlyCurrentThread(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_SHOW_ONLY_CURRENT_THREAD);
    }

    public static boolean getXBreakLastExecutedStatement(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_BREAK_LAST_EXECUTED_STATEMENT);
    }

    public static boolean getXIgnoreFinish(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_IGNORE_FINISH);
    }

    public static int getXTimeoutFinish(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_TIMEOUT_FINISH);
    }

    public static int getXVcdDumpMaxMemSize(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_VCD_DUMP_MAX_ARRAY_SIZE);
    }

    public static int getXRuntimeElabMaxDepth(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_ELAB_MAX_DEPTH);
    }

    public static boolean getXDemoteUserErrors(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_DEMOTE_USER_ERRORS);
    }

    public static int getXRuntimeElabUniqueIssuesTerminateThreshold(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_ELAB_UNIQUE_ISSUES_TERMINATE_THRESHOLD);
    }

    public static List<Pattern> getXRuntimeElabIssueFilterPatterns(IProject project) {
        ArrayList<Pattern> issueFilterPatterns = new ArrayList<Pattern>();
        issueFilterPatterns.addAll((List)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_ELAB_ISSUE_FILTER_REGEX));
        return issueFilterPatterns;
    }

    public static List<ElementPath> getXRuntimeElabBBoxFilterPrefixes(IProject project) {
        ArrayList<ElementPath> prefixPaths = new ArrayList<ElementPath>();
        prefixPaths.addAll((List)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_ELAB_BBOX_INSTANCE_PREFIX));
        return prefixPaths;
    }

    public static int getXRuntimeElabMaxLoopIterations(IProject project) {
        return (Integer)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_ELAB_MAX_LOOP_ITERATIONS);
    }

    public static boolean getXInheritBuildEnvVars(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_INHERIT_BUILD_ENV_VARS);
    }

    public static String getXRuntimeNativeDir(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_RUNTIME_NATIVE_DIR);
    }

    public static boolean getXDisablePortOptimizations(IProject project) {
        return (Boolean)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.DVTX_DISABLE_PORT_OPTIMIZATIONS);
    }

    public static VerissimoCompilationChecks getVerissimoChecks(IProject project) {
        return (VerissimoCompilationChecks)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.VERISSIMO_CHECKS);
    }

    public static String getVerissimoRulesetPath(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.VERISSIMO_RULESET);
    }

    public static String getVerissimoWaiversPath(IProject project) {
        return (String)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.VERISSIMO_WAIVERS);
    }

    public static AdditiveValueStringList getParserProfile(IProject project) {
        AdditiveValueStringList stringList = (AdditiveValueStringList)BuildConfigManagerCommon.getDVTConfig(project, IBuildConfigParserConstants.Directive.PROFILE_PARSER);
        if (stringList == null) {
            return new AdditiveValueStringList();
        }
        return stringList;
    }

    public static void removeProject(IProject dummyProject) {
        fBuildConfigMap.remove(dummyProject);
    }

    public static String nativeFindProperty(IProject project, String propertyName) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return null;
        }
        for (Invocation invocation : invocations) {
            List<BuildConfigProperty> properties = invocation.getProperties();
            for (BuildConfigProperty property : properties) {
                if (11 != property.getKind() || !propertyName.equals(property.getName())) continue;
                return property.getValue();
            }
        }
        return null;
    }

    public static MinTypMax getMinTypMaxSelection(IProject project) {
        List<Invocation> invocations = BuildConfigManagerCommon.getInvocations(project);
        if (invocations == null) {
            return MinTypMax.TYP;
        }
        for (Invocation invocation : invocations) {
            if (invocation.getState().fMinTypMax == null) continue;
            return invocation.getState().fMinTypMax;
        }
        return MinTypMax.TYP;
    }

    public static Map<IProject, ActiveBuildConfig> getBuildConfigMap() {
        return fBuildConfigMap;
    }

    public static enum EnvVarReplacementPriorityPolicy {
        FIRST_INVOCATION,
        LAST_INVOCATION,
        NO_INVOCATION;

    }

    public static enum PersistenceMode {
        REGULAR,
        PRECOMPILED_DB_SAVE,
        PRECOMPILED_DB_LOAD;

    }

    public static class PersistenceModeWrapper {
        public PersistenceMode persistenceMode;
        public Invocation invocation;
        public String libraryName;

        private PersistenceModeWrapper() {
        }

        public static PersistenceModeWrapper regular() {
            PersistenceModeWrapper result = new PersistenceModeWrapper();
            result.persistenceMode = PersistenceMode.REGULAR;
            return result;
        }

        public static PersistenceModeWrapper precompiledDbManualSave() {
            return PersistenceModeWrapper.precompiledDbSave(null);
        }

        public static PersistenceModeWrapper precompiledDbSave(String libName) {
            PersistenceModeWrapper result = new PersistenceModeWrapper();
            result.persistenceMode = PersistenceMode.PRECOMPILED_DB_SAVE;
            result.libraryName = libName;
            return result;
        }

        public static PersistenceModeWrapper precompiledDbManualLoad(Invocation invocation) {
            return PersistenceModeWrapper.precompiledDbLoad(invocation, null);
        }

        public static PersistenceModeWrapper precompiledDbLoad(Invocation invocation, String libName) {
            PersistenceModeWrapper result = new PersistenceModeWrapper();
            result.persistenceMode = PersistenceMode.PRECOMPILED_DB_LOAD;
            result.invocation = invocation;
            result.libraryName = libName;
            return result;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
            result = 31 * result + (this.libraryName == null ? 0 : this.libraryName.hashCode());
            result = 31 * result + (this.persistenceMode == null ? 0 : this.persistenceMode.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PersistenceModeWrapper)) {
                return false;
            }
            PersistenceModeWrapper other = (PersistenceModeWrapper)obj;
            if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
                return false;
            }
            if (this.libraryName == null ? other.libraryName != null : !this.libraryName.equals(other.libraryName)) {
                return false;
            }
            return this.persistenceMode == other.persistenceMode;
        }

        public String toString() {
            return String.format("[Persistence mode %s, Invocation %d, library name \"%s\"]", this.persistenceMode.toString(), this.invocation == null ? null : Integer.valueOf(this.invocation.getState().invocationNumber), this.libraryName);
        }
    }

    public static enum PrecompileGlobalMode {
        NO_GLOBAL_PRECOMPILE,
        MANUAL_SAVE,
        AUTO_SAVE,
        AUTO_LOAD,
        XILINX_ALTERA_SAVE,
        XILINX_ALTERA_LOAD;


        public boolean isAny(PrecompileGlobalMode ... modes) {
            PrecompileGlobalMode[] precompileGlobalModeArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                PrecompileGlobalMode mode = precompileGlobalModeArray[n2];
                if (this == mode) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

