/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class BuildConfigProperty
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int PATH = 0;
    public static final int DEFINE = 1;
    public static final int INCDIR = 2;
    public static final int LIBEXT = 3;
    public static final int LIBDIR = 4;
    public static final int LIBFILE = 5;
    public static final int READLIB = 6;
    public static final int SHELL = 7;
    public static final int INCRBUILD = 8;
    public static final int FULLBUILD = 9;
    public static final int LIBRESCAN = 10;
    public static final int DVT_CONFIG = 11;
    public static final int CMD_FILE_CALL = 12;
    public static final int ENV_VAR_DEFS = 13;
    public static final int LIBMAP = 14;
    public static final int ELAB_TOP = 15;
    public static final int KEYWORDSET_SETTINGS = 16;
    public static final int ATTRIBUTE_HOLDER = 17;
    public static final int UNDEFINE = 18;
    public static final int POWER_FORMAT_FILE = 19;
    public static final int PKGSEARCH = 20;
    public static final int LIBLIST = 21;
    public static final int VERIFICATION_TOP = 22;
    public static final int COMPILE_WAIVERS_FILE = 23;
    public static final int TIMESCALE = 24;
    public static final int OVERRIDE_TIMESCALE = 25;
    private String fValue;
    private String fName;
    private int fKind;
    private Map<String, Serializable> fAttributes = new HashMap<String, Serializable>();

    public BuildConfigProperty(int kind, String name, String value) {
        this.fKind = kind;
        this.fName = name;
        this.fValue = value;
    }

    public BuildConfigProperty(int kind, String path) {
        this.fKind = kind;
        this.fValue = path;
    }

    public BuildConfigProperty setName(String name) {
        this.fName = name;
        return this;
    }

    public int getKind() {
        return this.fKind;
    }

    public String getName() {
        return this.fName;
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String path) {
        this.fValue = path;
    }

    public void setKind(int kind) {
        this.fKind = kind;
    }

    public <T> T getAttribute(String key, T defaultVal) {
        if (defaultVal == null) {
            return null;
        }
        Serializable result = this.fAttributes.get(key);
        if (defaultVal.getClass().isInstance(result)) {
            return (T)result;
        }
        return defaultVal;
    }

    public Object getAttribute(String key) {
        return this.fAttributes.get(key);
    }

    public boolean hasAttribute(String key) {
        return this.fAttributes.containsKey(key);
    }

    public BuildConfigProperty setAttribute(String key, Serializable value) {
        this.fAttributes.put(key, value);
        return this;
    }

    public String toString() {
        return String.valueOf(BuildConfigProperty.getKindName(this.fKind)) + " : " + this.fName + " " + this.fValue + ", Attr:" + this.fAttributes;
    }

    private static String getKindName(int kind) {
        switch (kind) {
            case 0: {
                return "PATH";
            }
            case 1: {
                return "DEFINE";
            }
            case 2: {
                return "INCDIR";
            }
            case 3: {
                return "LIBEXT";
            }
            case 4: {
                return "LIBDIR";
            }
            case 5: {
                return "LIBFILE";
            }
            case 6: {
                return "READLIB";
            }
            case 7: {
                return "SHELL";
            }
            case 8: {
                return "INCRBUILD";
            }
            case 9: {
                return "FULLBUILD";
            }
            case 10: {
                return "LIBRESCAN";
            }
            case 11: {
                return "DVT_CONFIG";
            }
            case 12: {
                return "CMD_FILE_CALL";
            }
            case 13: {
                return "ENV_VAR_DEFS";
            }
            case 14: {
                return "LIBMAP";
            }
            case 15: {
                return "ELAB_TOP";
            }
            case 16: {
                return "KEYWORDSET_SETTINGS";
            }
            case 17: {
                return "ATTRIBUTE_HOLDER";
            }
            case 19: {
                return "UPF_FILE";
            }
            case 22: {
                return "VERIFICATION_TOP";
            }
        }
        return "UNKNOWN";
    }

    public Map<String, Serializable> getAttributes() {
        return this.fAttributes;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAttributes == null ? 0 : this.fAttributes.hashCode());
        result = 31 * result + this.fKind;
        result = 31 * result + (this.fName == null ? 0 : this.fName.hashCode());
        result = 31 * result + (this.fValue == null ? 0 : this.fValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BuildConfigProperty)) {
            return false;
        }
        BuildConfigProperty other = (BuildConfigProperty)obj;
        if (this.fAttributes == null ? other.fAttributes != null : !this.fAttributes.equals(other.fAttributes)) {
            return false;
        }
        if (this.fKind != other.fKind) {
            return false;
        }
        if (this.fName == null ? other.fName != null : !this.fName.equals(other.fName)) {
            return false;
        }
        return !(this.fValue == null ? other.fValue != null : !this.fValue.equals(other.fValue));
    }
}

