/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class BuildConfigXml {
    public static final String BUILD_CONFIG_XML = ".dvt/build.config.xml";
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    public static final String LATEST_VERSION = "2";
    public static final String TAG_BUILD_CONFIG = "build-config";
    public static final String TAG_CURRENT_BUILD_NAME = "current-build-name";
    public static final String TAG_INSTANCE_TREE_TOP = "instance-tree-top";
    public static final String TAG_VERIFICATION_HIERARCHY_TOP = "verification-hierarchy-top";
    public static final String TAG_DESIGN_HIERARCHY_TOP = "design-hierarchy-top";
    public static final String TAG_DESIGN_HIERARCHY_TOP_ELAB = "design-hierarchy-top-elab";
    public static final String ATTR_VERSION = "version";
    private static final String ATTR_LANGUAGE = "language";
    private String fActiveBuildConfigName;
    @Deprecated
    private String fInstanceTreeTop;
    @Deprecated
    private String fInstanceTreeTopLanguage;
    private String fVerificationHierarchyTop;
    private String fVerificationHierarchyTopLanguage;
    private String fDesignHierarchyTop;
    private String fDesignHierarchyTopElab;
    private String fDesignHierarchyTopLanguage;
    private String fVersion;
    private IProject fProject;

    public String getActiveBuildConfigName() {
        return this.fActiveBuildConfigName;
    }

    public BuildConfigXml setActiveBuildConfigName(String activeBuildConfigName) {
        this.fActiveBuildConfigName = activeBuildConfigName;
        return this;
    }

    @Deprecated
    public String getInstanceTreeTop() {
        return this.fInstanceTreeTop;
    }

    @Deprecated
    public BuildConfigXml setInstanceTreeTop(String instanceTreeTop) {
        this.fInstanceTreeTop = instanceTreeTop;
        return this;
    }

    public String getVerificationHierarchyTop() {
        return this.fVerificationHierarchyTop;
    }

    public BuildConfigXml setVerificationHierarchyTop(String verificationHierarchyTop) {
        this.fVerificationHierarchyTop = verificationHierarchyTop;
        return this;
    }

    public String getDesignHierarchyTop() {
        return this.fDesignHierarchyTopElab;
    }

    public BuildConfigXml setDesignHierarchyTop(String designHierarchyTop) {
        this.fDesignHierarchyTopElab = designHierarchyTop;
        return this;
    }

    @Deprecated
    public String getInstanceTreeTopLanguage() {
        return this.fInstanceTreeTopLanguage;
    }

    @Deprecated
    public BuildConfigXml setInstanceTreeTopLanguage(String language) {
        this.fInstanceTreeTopLanguage = language;
        return this;
    }

    public String getVerificationHierarchyTopLanguage() {
        return this.fVerificationHierarchyTopLanguage;
    }

    public BuildConfigXml setVerificationHierarchyTopLanguage(String verificationHierarchyTopLanguage) {
        this.fVerificationHierarchyTopLanguage = verificationHierarchyTopLanguage;
        return this;
    }

    public String getDesignHierarchyTopLanguage() {
        return this.fDesignHierarchyTopLanguage;
    }

    public BuildConfigXml setDesignHierarchyTopLanguage(String designHierarchyTopLanguage) {
        this.fDesignHierarchyTopLanguage = designHierarchyTopLanguage;
        return this;
    }

    public IProject getProject() {
        return this.fProject;
    }

    public BuildConfigXml setProject(IProject project) {
        this.fProject = project;
        return this;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public BuildConfigXml setVersion(String version) {
        this.fVersion = version;
        return this;
    }

    public static BuildConfigXml load(IProject project) {
        BuildConfigXml result = new BuildConfigXml();
        result.fProject = project;
        if (project == null || project.getLocation() == null) {
            return result;
        }
        File file = project.getLocation().append(BUILD_CONFIG_XML).toFile();
        if (!file.exists()) {
            return result;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(XMLErrorHandler.INSTANCE);
            Document document = builder.parse(file);
            NodeList rootList = document.getElementsByTagName(TAG_BUILD_CONFIG);
            if (rootList.getLength() < 1) {
                return result;
            }
            Element root = (Element)rootList.item(0);
            result.fVersion = root.getAttribute(ATTR_VERSION);
            if ("2".equals(result.fVersion)) {
                BuildConfigXml.loadV2(root, result);
            } else {
                BuildConfigXml.loadV1(root, result);
            }
            BuildConfigXml.loadV1CompatibilityMode(root, result);
        }
        catch (ParserConfigurationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (SAXException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static void loadV1(Element root, BuildConfigXml result) {
        NodeList instanceTreeTopTags;
        NodeList buildConfigTags = root.getElementsByTagName(TAG_CURRENT_BUILD_NAME);
        if (buildConfigTags.getLength() != 0) {
            String textContent = buildConfigTags.item(0).getTextContent();
            String string = result.fActiveBuildConfigName = textContent == null ? "" : textContent.trim();
        }
        if ((instanceTreeTopTags = root.getElementsByTagName(TAG_INSTANCE_TREE_TOP)).getLength() != 0) {
            String textContent = instanceTreeTopTags.item(0).getTextContent();
            result.fInstanceTreeTop = textContent == null ? "" : textContent.trim();
            Node namedItem = instanceTreeTopTags.item(0).getAttributes().getNamedItem(ATTR_LANGUAGE);
            result.fInstanceTreeTopLanguage = namedItem == null ? "" : namedItem.getNodeValue();
        }
    }

    private static void loadV1CompatibilityMode(Element root, BuildConfigXml result) {
        NodeList instanceTreeTopTags = root.getElementsByTagName(TAG_INSTANCE_TREE_TOP);
        if (instanceTreeTopTags.getLength() != 0) {
            String languageTop;
            String textContent = instanceTreeTopTags.item(0).getTextContent();
            Node namedItem = instanceTreeTopTags.item(0).getAttributes().getNamedItem(ATTR_LANGUAGE);
            String top = textContent == null ? "" : textContent.trim();
            String string = languageTop = namedItem == null ? "" : namedItem.getNodeValue();
            if (LanguageKind.VLOG.toString().equals(languageTop) || LanguageKind.VHDL.toString().equals(languageTop)) {
                if (result.fDesignHierarchyTop == null || result.fDesignHierarchyTop.isEmpty()) {
                    result.fDesignHierarchyTop = top;
                    result.fDesignHierarchyTopLanguage = languageTop;
                }
            } else if (LanguageKind.E.toString().equals(languageTop) && (result.fVerificationHierarchyTop == null || result.fVerificationHierarchyTop.isEmpty())) {
                result.fVerificationHierarchyTop = top;
                result.fVerificationHierarchyTopLanguage = languageTop;
            }
        }
    }

    private static void loadV2(Element root, BuildConfigXml result) {
        NodeList verificationHierarchyTopTags;
        NodeList designHierarchyTopElabTags;
        NodeList designHierarchyTopTags;
        NodeList buildConfigTags = root.getElementsByTagName(TAG_CURRENT_BUILD_NAME);
        if (buildConfigTags.getLength() != 0) {
            String textContent = buildConfigTags.item(0).getTextContent();
            String string = result.fActiveBuildConfigName = textContent == null ? "" : textContent.trim();
        }
        if ((designHierarchyTopTags = root.getElementsByTagName(TAG_DESIGN_HIERARCHY_TOP)).getLength() != 0) {
            String textContent = designHierarchyTopTags.item(0).getTextContent();
            result.fDesignHierarchyTop = textContent == null ? "" : textContent.trim();
            Node namedItem = designHierarchyTopTags.item(0).getAttributes().getNamedItem(ATTR_LANGUAGE);
            String string = result.fDesignHierarchyTopLanguage = namedItem == null ? "" : namedItem.getNodeValue();
        }
        if ((designHierarchyTopElabTags = root.getElementsByTagName(TAG_DESIGN_HIERARCHY_TOP_ELAB)).getLength() != 0) {
            String textContent = designHierarchyTopElabTags.item(0).getTextContent();
            result.fDesignHierarchyTopElab = textContent == null ? "" : textContent.trim();
            Node namedItem = designHierarchyTopElabTags.item(0).getAttributes().getNamedItem(ATTR_LANGUAGE);
            String string = result.fDesignHierarchyTopLanguage = namedItem == null ? "" : namedItem.getNodeValue();
        }
        if ((verificationHierarchyTopTags = root.getElementsByTagName(TAG_VERIFICATION_HIERARCHY_TOP)).getLength() != 0) {
            String textContent = verificationHierarchyTopTags.item(0).getTextContent();
            result.fVerificationHierarchyTop = textContent == null ? "" : textContent.trim();
            Node namedItem = verificationHierarchyTopTags.item(0).getAttributes().getNamedItem(ATTR_LANGUAGE);
            result.fVerificationHierarchyTopLanguage = namedItem == null ? "" : namedItem.getNodeValue();
        }
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element rootElem = document.createElement(TAG_BUILD_CONFIG);
        document.appendChild(rootElem);
        rootElem.setAttribute(ATTR_VERSION, "2");
        Element currentBuildNameElem = document.createElement(TAG_CURRENT_BUILD_NAME);
        currentBuildNameElem.setTextContent(this.fActiveBuildConfigName);
        rootElem.appendChild(currentBuildNameElem);
        Element designHierarchyTopElem = document.createElement(TAG_DESIGN_HIERARCHY_TOP);
        designHierarchyTopElem.setTextContent(this.fDesignHierarchyTop);
        designHierarchyTopElem.setAttribute(ATTR_LANGUAGE, this.fDesignHierarchyTopLanguage);
        rootElem.appendChild(designHierarchyTopElem);
        Element designHierarchyTopElabElem = document.createElement(TAG_DESIGN_HIERARCHY_TOP_ELAB);
        designHierarchyTopElabElem.setTextContent(this.fDesignHierarchyTopElab);
        designHierarchyTopElabElem.setAttribute(ATTR_LANGUAGE, this.fDesignHierarchyTopLanguage);
        rootElem.appendChild(designHierarchyTopElabElem);
        Element verificationHierarchyTopElem = document.createElement(TAG_VERIFICATION_HIERARCHY_TOP);
        verificationHierarchyTopElem.setTextContent(this.fVerificationHierarchyTop);
        verificationHierarchyTopElem.setAttribute(ATTR_LANGUAGE, this.fVerificationHierarchyTopLanguage);
        rootElem.appendChild(verificationHierarchyTopElem);
        return document;
    }

    public boolean save() {
        block12: {
            try {
                if (this.fProject != null && this.fProject.isAccessible()) break block12;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        File file = this.fProject.getLocation().append(BUILD_CONFIG_XML).toFile();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.getTransformer().transform(new DOMSource(this.getDocument()), new StreamResult(writer));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    public boolean removeElement(IProject project, String ... tagsToRemove) {
        Node document;
        File file;
        block14: {
            block13: {
                try {
                    if (this.fProject != null && this.fProject.isAccessible()) break block13;
                    return false;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return false;
                }
            }
            file = this.fProject.getLocation().append(BUILD_CONFIG_XML).toFile();
            document = this.removeTags(project, tagsToRemove);
            if (document != null) break block14;
            return false;
        }
        Throwable throwable = null;
        Object var6_8 = null;
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
            this.getTransformer().transform(new DOMSource(document), new StreamResult(writer));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return true;
    }

    private Node removeTags(IProject project, String ... tagsToRemove) {
        NodeList rootList;
        Document document;
        block13: {
            if (tagsToRemove == null || project == null || project.getLocation() == null) {
                return null;
            }
            File file = project.getLocation().append(BUILD_CONFIG_XML).toFile();
            if (!file.exists()) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(XMLErrorHandler.INSTANCE);
            document = builder.parse(file);
            rootList = document.getElementsByTagName(TAG_BUILD_CONFIG);
            if (rootList.getLength() >= 1) break block13;
            return null;
        }
        try {
            Element root = (Element)rootList.item(0);
            if (VERSION_1.equals(root.getAttribute(ATTR_VERSION))) {
                int i = 0;
                while (i < tagsToRemove.length) {
                    if (tagsToRemove[i].equals(TAG_DESIGN_HIERARCHY_TOP)) {
                        tagsToRemove[i] = TAG_INSTANCE_TREE_TOP;
                        break;
                    }
                    ++i;
                }
            }
            String[] stringArray = tagsToRemove;
            int n = tagsToRemove.length;
            int n2 = 0;
            while (n2 < n) {
                String tagToRemove = stringArray[n2];
                NodeList nodesToRemove = root.getElementsByTagName(tagToRemove);
                if (nodesToRemove != null && nodesToRemove.getLength() != 0) {
                    int i = 0;
                    while (i < nodesToRemove.getLength()) {
                        Node item = nodesToRemove.item(i);
                        root.removeChild(item);
                        ++i;
                    }
                }
                ++n2;
            }
            return document;
        }
        catch (ParserConfigurationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (SAXException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public String toXmlString() {
        StringWriter sw = new StringWriter();
        try {
            this.getTransformer().transform(new DOMSource(this.getDocument()), new StreamResult(sw));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return sw.toString();
    }

    private Transformer getTransformer() throws TransformerConfigurationException, TransformerFactoryConfigurationError {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        return transformer;
    }
}

