/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Cflags
implements Serializable {
    private static final long serialVersionUID = 1L;
    public Map<String, String> defines = new LinkedHashMap<String, String>();
    public Set<String> incdirs = new LinkedHashSet<String>();
    public Set<String> libdirs = new LinkedHashSet<String>();
    public Set<String> libs = new LinkedHashSet<String>();
    public Set<String> includes = new LinkedHashSet<String>();
    public Set<String> imacros = new LinkedHashSet<String>();

    public String toString() {
        return "Cflags\n\n=defines=\n" + this.defines.toString().replaceAll(",", "\n") + "\n\n=incdirs=\n" + DVTStringUtil.join(this.incdirs, "\n") + "\n\n=libdirs=\n" + DVTStringUtil.join(this.libdirs, "\n") + "\n\n=libs=\n" + DVTStringUtil.join(this.libs, "\n") + "\n\n=includes=\n" + DVTStringUtil.join(this.includes, "\n") + "\n\n=imacros=\n" + DVTStringUtil.join(this.imacros, "\n");
    }

    public void merge(Cflags with) {
        this.defines.putAll(with.defines);
        this.incdirs.addAll(with.incdirs);
        this.libdirs.addAll(with.libdirs);
        this.libs.addAll(with.libs);
        this.includes.addAll(with.includes);
        this.imacros.addAll(with.imacros);
    }

    public static List<String> getCTopFiles(IProject project) {
        LinkedHashSet<String> topCFiles = new LinkedHashSet<String>();
        for (Invocation invocation : BuildConfigManager.getInvocations(project)) {
            for (BuildConfigProperty topFile : Cflags.getCTopProperties(invocation)) {
                topCFiles.add(topFile.getValue());
            }
        }
        return new ArrayList<String>(topCFiles);
    }

    private static List<BuildConfigProperty> getCTopProperties(Invocation invocation) {
        ArrayList<BuildConfigProperty> result = new ArrayList<BuildConfigProperty>();
        for (BuildConfigProperty property : BuildConfigParser.compact(Arrays.asList(invocation), LanguageKind.CPP)) {
            if (property.getKind() != 0) continue;
            result.add(property);
        }
        return result;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.defines == null ? 0 : this.defines.hashCode());
        result = 31 * result + (this.imacros == null ? 0 : this.imacros.hashCode());
        result = 31 * result + (this.incdirs == null ? 0 : this.incdirs.hashCode());
        result = 31 * result + (this.includes == null ? 0 : this.includes.hashCode());
        result = 31 * result + (this.libdirs == null ? 0 : this.libdirs.hashCode());
        result = 31 * result + (this.libs == null ? 0 : this.libs.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Cflags)) {
            return false;
        }
        Cflags other = (Cflags)obj;
        if (this.defines == null ? other.defines != null : !this.defines.equals(other.defines)) {
            return false;
        }
        if (this.imacros == null ? other.imacros != null : !this.imacros.equals(other.imacros)) {
            return false;
        }
        if (this.incdirs == null ? other.incdirs != null : !this.incdirs.equals(other.incdirs)) {
            return false;
        }
        if (this.includes == null ? other.includes != null : !this.includes.equals(other.includes)) {
            return false;
        }
        if (this.libdirs == null ? other.libdirs != null : !this.libdirs.equals(other.libdirs)) {
            return false;
        }
        return !(this.libs == null ? other.libs != null : !this.libs.equals(other.libs));
    }
}

