/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.io.FileNotFoundException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.CommentsPreferencesXmlParser1;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;

public abstract class CommentsPreferencesXmlParser {
    private final File fFile;
    protected static String TAG_COMMENTS_PREFERENCES = "comments-preferences";
    protected static final String ATTR_VERSION = "version";
    public static final String VLOG_COMMENTS_PREFERENCES_FILE = "vlog_comments_preferences.xml";
    private static final String LAST_VERSION = "1";

    protected CommentsPreferencesXmlParser(File file) {
        this.fFile = file;
    }

    public abstract void save(DVTCodeCommentsPreferences var1) throws Exception;

    public abstract void load(DVTCodeCommentsPreferences var1) throws Exception;

    public static void save(IProject project, DVTCodeCommentsPreferences model) {
        try {
            File f = project.getLocation().append(".dvt").append(VLOG_COMMENTS_PREFERENCES_FILE).toFile();
            CommentsPreferencesXmlParser parser = CommentsPreferencesXmlParser.newParser(f, true);
            parser.save(model);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static DVTCodeCommentsPreferences load(IProject project) {
        DVTCodeCommentsPreferences result = new DVTCodeCommentsPreferences();
        try {
            File f = project.getLocation().append(".dvt").append(VLOG_COMMENTS_PREFERENCES_FILE).toFile();
            CommentsPreferencesXmlParser parser = CommentsPreferencesXmlParser.newParser(f, true);
            parser.load(result);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    public File getFile() {
        return this.fFile;
    }

    public static CommentsPreferencesXmlParser newParser(File file, boolean useLastVersion) throws Exception {
        if (useLastVersion) {
            return CommentsPreferencesXmlParser.newParser(file, LAST_VERSION);
        }
        String version = CommentsPreferencesXmlParser.detectVersion(file);
        return CommentsPreferencesXmlParser.newParser(file, version);
    }

    private static CommentsPreferencesXmlParser newParser(File file, String version) throws Exception {
        if (LAST_VERSION.equals(version)) {
            return new CommentsPreferencesXmlParser1(file);
        }
        throw new IllegalArgumentException("Unknown Export HTML Documentation preference file version " + version + ".");
    }

    private static String detectVersion(File file) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(file);
        NodeList waiversNodes = document.getElementsByTagName(TAG_COMMENTS_PREFERENCES);
        if (waiversNodes.getLength() < 1) {
            return null;
        }
        Element waiversNode = (Element)waiversNodes.item(0);
        return waiversNode.getAttribute(ATTR_VERSION);
    }
}

