/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.amiq.dvt.buildconfig.CommentsPreferencesXmlParser;
import ro.amiq.dvt.utils.XMLErrorHandler;
import ro.amiq.dvt.utils.parser.DVTCodeCommentsPreferences;

public class CommentsPreferencesXmlParser1
extends CommentsPreferencesXmlParser {
    public static final String VERSION_ID = "1";
    private static final String TAG_SKIP_N_EMPTY_LINES_ABOVE = "skip_n_empty_lines_above";
    private static final String TAG_USE_INLINE_COMMENT = "use_inline_comment";
    private static final String TAG_USE_ABOVE_COMMENT = "use_above_comment";
    private static final String TAG_USE_SLASH_SLASH = "use_slash_slash";
    private static final String TAG_USE_SLASH_STAR = "use_slash_star";
    private static final String TAG_USE_SLASH_STAR_STAR = "use_slash_star_star";

    public CommentsPreferencesXmlParser1(File file) {
        super(file);
    }

    @Override
    public void save(DVTCodeCommentsPreferences model) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.newDocument();
        Element elem = document.createElement(TAG_COMMENTS_PREFERENCES);
        document.appendChild(elem);
        elem.setAttribute("version", VERSION_ID);
        this.appendNodes(model, elem, document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        Throwable throwable = null;
        Object var8_9 = null;
        try (BufferedWriter output = new BufferedWriter(new FileWriter(this.getFile()));){
            StreamResult result = new StreamResult(output);
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void appendNodes(DVTCodeCommentsPreferences model, Element root, Document document) {
        this.appendIntegerNode(document, root, TAG_SKIP_N_EMPTY_LINES_ABOVE, model.getEmptyLinesAboveToSkip());
        this.appendBooleanNode(document, root, TAG_USE_INLINE_COMMENT, model.getUseInlineComment());
        this.appendBooleanNode(document, root, TAG_USE_ABOVE_COMMENT, model.getUseAboveComment());
        this.appendBooleanNode(document, root, TAG_USE_SLASH_SLASH, model.getAddSingleLineComment());
        this.appendBooleanNode(document, root, TAG_USE_SLASH_STAR, model.getAddMultiLineComment());
        this.appendBooleanNode(document, root, TAG_USE_SLASH_STAR_STAR, model.getAddMulti2LineComment());
    }

    private void appendBooleanNode(Document document, Element root, String tag, boolean b) {
        this.appendTextNode(document, root, tag, b ? "true" : "false");
    }

    private void appendIntegerNode(Document document, Element root, String tag, int n) {
        this.appendTextNode(document, root, tag, Integer.toString(n));
    }

    private void appendTextNode(Document document, Element root, String tag, String textContent) {
        Element elem = document.createElement(tag);
        elem.setTextContent(textContent);
        root.appendChild(elem);
    }

    @Override
    public void load(DVTCodeCommentsPreferences model) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        builder.setErrorHandler(XMLErrorHandler.INSTANCE);
        Document document = builder.parse(this.getFile());
        model.setEmptyLinesAboveToSkip(this.getTagIntegerContent(document, TAG_SKIP_N_EMPTY_LINES_ABOVE));
        model.setUseInlineComment(this.getTagBooleanContent(document, TAG_USE_INLINE_COMMENT));
        model.setUseAboveComment(this.getTagBooleanContent(document, TAG_USE_ABOVE_COMMENT));
        model.setAddSingleLineComment(this.getTagBooleanContent(document, TAG_USE_SLASH_SLASH));
        model.setAddMultiLineComment(this.getTagBooleanContent(document, TAG_USE_SLASH_STAR));
        model.setAddMulti2LineComment(this.getTagBooleanContent(document, TAG_USE_SLASH_STAR_STAR));
    }

    private String getTagTextContent(Document document, String tag) {
        NodeList nodes = document.getElementsByTagName(tag);
        if (nodes.getLength() > 0) {
            return nodes.item(0).getTextContent();
        }
        return "";
    }

    private Boolean getTagBooleanContent(Document document, String tag) {
        return Boolean.parseBoolean(this.getTagTextContent(document, tag));
    }

    private int getTagIntegerContent(Document document, String tag) {
        try {
            return Integer.parseInt(this.getTagTextContent(document, tag));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

