/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.utils.StringMatcher;

public abstract class ElaborationSkipFilter<T>
implements Serializable {
    private static final long serialVersionUID = 2L;
    protected List<ElaborationSkipEntry> posSkip = new ArrayList<ElaborationSkipEntry>(4);
    protected List<ElaborationSkipEntry> negSkip = new ArrayList<ElaborationSkipEntry>(4);

    public abstract String adjustInputPattern(String var1);

    public void add(String pattern, boolean exclude) {
        if (pattern == null) {
            return;
        }
        pattern = this.adjustInputPattern(pattern);
        if (exclude) {
            this.negSkip.add(new ElaborationSkipEntry(pattern));
        } else {
            this.posSkip.add(new ElaborationSkipEntry(pattern));
        }
    }

    public void mergeFilter(ElaborationSkipFilter<T> pathFilter) {
        this.posSkip.addAll(pathFilter.posSkip);
        this.negSkip.addAll(pathFilter.negSkip);
    }

    public boolean isEnabled() {
        return !this.posSkip.isEmpty() || !this.negSkip.isEmpty();
    }

    public abstract String getStringFromValue(T var1);

    public boolean apply(T value) {
        if (value == null) {
            return false;
        }
        String stringValue = this.getStringFromValue(value);
        for (ElaborationSkipEntry skipPath : this.posSkip) {
            if (!skipPath.stringMatcher.match(stringValue)) continue;
            return true;
        }
        if (this.negSkip.isEmpty()) {
            return false;
        }
        boolean negMatch = false;
        for (ElaborationSkipEntry skipPath : this.negSkip) {
            negMatch |= skipPath.stringMatcher.match(stringValue);
        }
        return !negMatch;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("pos:");
        for (ElaborationSkipEntry skipPath : this.posSkip) {
            sb.append("[");
            sb.append(skipPath.stringMatcher.toString());
            sb.append("]");
        }
        sb.append("\nneg:");
        for (ElaborationSkipEntry skipPath : this.negSkip) {
            sb.append("[");
            sb.append(skipPath.stringMatcher.toString());
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ElaborationSkipFilter other = (ElaborationSkipFilter)obj;
        return this.posSkip.equals(other.posSkip) && this.negSkip.equals(other.negSkip);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.posSkip.hashCode();
        result = 31 * result + this.negSkip.hashCode();
        return result;
    }

    protected static class ElaborationSkipEntry
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected StringMatcher stringMatcher;
        protected StringMatcher[] segmentMatchers;

        private ElaborationSkipEntry(String pattern) {
            this.stringMatcher = new StringMatcher(pattern, false, false, true);
            String[] temp = pattern.split("\\.");
            this.segmentMatchers = new StringMatcher[temp.length];
            int i = 0;
            while (i < temp.length) {
                this.segmentMatchers[i] = new StringMatcher(temp[i], false, false, true);
                ++i;
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ElaborationSkipEntry other = (ElaborationSkipEntry)obj;
            if ((this.stringMatcher == null || other.stringMatcher == null) && this.stringMatcher != other.stringMatcher) {
                return false;
            }
            return this.stringMatcher == null || this.stringMatcher.equals(other.stringMatcher);
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + (this.stringMatcher != null ? this.stringMatcher.hashCode() : 0);
            return result;
        }
    }
}

