/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.utils.StringMatcher;

public class EncryptedCodeAutoDefineByNameFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<EncryptedCodeAutoPattern> encryptedCodeAutoNamePatterns = new ArrayList<EncryptedCodeAutoPattern>();
    private int nOfDefinedMacros = 0;
    private boolean debug;

    public EncryptedCodeAutoDefineByNameFilter(IProject project) {
        this.debug = BuildConfigManager.isEncryptedCodeDebug(project);
    }

    public void incrementDefinedMacros() {
        ++this.nOfDefinedMacros;
    }

    public int getNofDefinedMacros() {
        return this.nOfDefinedMacros;
    }

    public void add(String pattern) {
        this.encryptedCodeAutoNamePatterns.add(new EncryptedCodeAutoPattern(pattern));
    }

    public void addEncryptedCodeAutoFilter(EncryptedCodeAutoDefineByNameFilter skipCompileFilter) {
        this.encryptedCodeAutoNamePatterns.addAll(skipCompileFilter.encryptedCodeAutoNamePatterns);
    }

    public boolean hasEncryptedCodeAutoPath(String name) {
        if (name == null) {
            return false;
        }
        return this.internalHasEncryptedCodeAutoPath(name);
    }

    public boolean hasEnabledEncryptedCodeAuto() {
        return this.encryptedCodeAutoNamePatterns != null && !this.encryptedCodeAutoNamePatterns.isEmpty();
    }

    private boolean internalHasEncryptedCodeAutoPath(String name) {
        for (EncryptedCodeAutoPattern autoCorrectScopePath : this.encryptedCodeAutoNamePatterns) {
            boolean matches;
            boolean bl = matches = autoCorrectScopePath.stringMatcher != null && autoCorrectScopePath.stringMatcher.match(name);
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.encryptedCodeAutoNamePatterns == null || this.encryptedCodeAutoNamePatterns.isEmpty()) {
            return result.toString();
        }
        for (EncryptedCodeAutoPattern encryptedCodeAutoPath : this.encryptedCodeAutoNamePatterns) {
            result.append("[");
            result.append(encryptedCodeAutoPath.stringMatcher.toString());
            result.append("]");
        }
        return result.toString();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedCodeAutoDefineByNameFilter other = (EncryptedCodeAutoDefineByNameFilter)obj;
        if (!this.encryptedCodeAutoNamePatterns.equals(other.encryptedCodeAutoNamePatterns)) {
            return false;
        }
        return this.nOfDefinedMacros == other.nOfDefinedMacros && this.debug == other.debug;
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.encryptedCodeAutoNamePatterns.hashCode();
        result = 31 * result + this.nOfDefinedMacros;
        result = 31 * result + (this.debug ? 1 : 0);
        return result;
    }

    private static class EncryptedCodeAutoPattern
    implements Serializable {
        private static final long serialVersionUID = 1L;
        StringMatcher stringMatcher;

        EncryptedCodeAutoPattern(String pattern) {
            this.stringMatcher = new StringMatcher(pattern, false, false, true);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            EncryptedCodeAutoPattern other = (EncryptedCodeAutoPattern)obj;
            if (this.stringMatcher == null || other.stringMatcher == null) {
                return this.stringMatcher != other.stringMatcher;
            }
            return this.stringMatcher.equals(other.stringMatcher);
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + (this.stringMatcher != null ? this.stringMatcher.hashCode() : 0);
            return result;
        }
    }
}

