/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.AutoDefineAPIWrapper;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class EncryptedCodeAutoFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<EncryptedCodeAutoPath> encryptedCodeAutoPaths = new ArrayList<EncryptedCodeAutoPath>();
    private Map<String, Boolean> encryptedCodePathsCache;
    private List<AutoDefineAPIWrapper> hidWrappers = new ArrayList<AutoDefineAPIWrapper>();
    private List<AutoDefineAPIWrapper> hidOperatorWrappers = new ArrayList<AutoDefineAPIWrapper>();
    private int nOfFields;
    private int nOfFunctions;
    private int nOfArguments;
    private int nOfConstraints;
    private int nOfClosedScopes;
    private boolean debug;

    public EncryptedCodeAutoFilter(IProject project) {
        this.encryptedCodePathsCache = new HashMap<String, Boolean>();
        this.debug = BuildConfigManager.isEncryptedCodeDebug(project);
        this.nOfArguments = 0;
        this.nOfFunctions = 0;
        this.nOfFields = 0;
        this.nOfConstraints = 0;
        this.nOfClosedScopes = 0;
    }

    public int getNofArguments() {
        return this.nOfArguments;
    }

    public int getNofFields() {
        return this.nOfFields;
    }

    public int getNofFunctions() {
        return this.nOfFunctions;
    }

    public int getNofConstraints() {
        return this.nOfConstraints;
    }

    public void incrementArguments() {
        ++this.nOfArguments;
    }

    public void incrementConstraints() {
        ++this.nOfConstraints;
    }

    public void incrementFunctions() {
        ++this.nOfFunctions;
    }

    public void incrementFields() {
        ++this.nOfFields;
    }

    public void incrementClosedScopes() {
        ++this.nOfClosedScopes;
    }

    public int getNOfClosedScopes() {
        return this.nOfClosedScopes;
    }

    public void add(String pattern, boolean exclude) {
        pattern = DVTStringUtil.translatePathPatternToLinuxPattern(pattern);
        this.encryptedCodeAutoPaths.add(new EncryptedCodeAutoPath(pattern, exclude));
    }

    public void addEncryptedCodeAutoFilter(EncryptedCodeAutoFilter skipCompileFilter) {
        this.encryptedCodeAutoPaths.addAll(skipCompileFilter.encryptedCodeAutoPaths);
    }

    public boolean hasEncryptedCodeAutoPath(ParserPath path) {
        if (path == null) {
            return false;
        }
        return this.internalHasEncryptedCodeAutoPath(path.path);
    }

    public boolean hasEnabledEncryptedCodeAuto() {
        return this.encryptedCodeAutoPaths != null && !this.encryptedCodeAutoPaths.isEmpty();
    }

    private boolean internalHasEncryptedCodeAutoPath(String initialPath) {
        Boolean hasEncryptedCodeAutoPath = this.encryptedCodePathsCache.get(initialPath);
        if (hasEncryptedCodeAutoPath != null) {
            return hasEncryptedCodeAutoPath;
        }
        String path = DVTStringUtil.translatePathPatternToLinuxPattern(initialPath);
        String filename = Path.fromOSString((String)path).lastSegment();
        if (filename != null && (filename.startsWith("__edt__") || filename.startsWith("__sln__") || filename.startsWith("__msdl__") || filename.startsWith("__pss__") || filename.startsWith("__vlog__"))) {
            return false;
        }
        boolean includeMatch = false;
        for (EncryptedCodeAutoPath autoCorrectScopePath : this.encryptedCodeAutoPaths) {
            if (autoCorrectScopePath.exclude) {
                if (!autoCorrectScopePath.stringMatcher.match(path)) continue;
                this.encryptedCodePathsCache.put(initialPath, false);
                return false;
            }
            if (!autoCorrectScopePath.stringMatcher.match(path)) continue;
            includeMatch = true;
        }
        this.encryptedCodePathsCache.put(initialPath, includeMatch);
        return includeMatch;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.encryptedCodeAutoPaths == null || this.encryptedCodeAutoPaths.isEmpty()) {
            return result.toString();
        }
        for (EncryptedCodeAutoPath encryptedCodeAutoPath : this.encryptedCodeAutoPaths) {
            result.append("[");
            result.append(encryptedCodeAutoPath.stringMatcher.toString());
            result.append("]");
        }
        return result.toString();
    }

    public void addHidWrapper(AutoDefineAPIWrapper wrapper) {
        this.hidWrappers.add(wrapper);
    }

    public void addHidOperatorWrapper(AutoDefineAPIWrapper wrapper) {
        this.hidOperatorWrappers.add(wrapper);
    }

    public List<AutoDefineAPIWrapper> getHidWrappers() {
        return this.hidWrappers;
    }

    public List<AutoDefineAPIWrapper> getHidOperatorWrappers() {
        return this.hidOperatorWrappers;
    }

    public void clear() {
        this.hidOperatorWrappers.clear();
        this.hidWrappers.clear();
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EncryptedCodeAutoFilter that = (EncryptedCodeAutoFilter)obj;
        if (this.nOfFields != that.nOfFields || this.nOfFunctions != that.nOfFunctions || this.nOfArguments != that.nOfArguments || this.nOfConstraints != that.nOfConstraints || this.nOfClosedScopes != that.nOfClosedScopes || this.debug != that.debug) {
            return false;
        }
        if (this.encryptedCodeAutoPaths == null ? that.encryptedCodeAutoPaths != null : !this.encryptedCodeAutoPaths.equals(that.encryptedCodeAutoPaths)) {
            return false;
        }
        if (this.encryptedCodePathsCache == null ? that.encryptedCodePathsCache != null : !this.encryptedCodePathsCache.equals(that.encryptedCodePathsCache)) {
            return false;
        }
        if (this.hidWrappers == null ? that.hidWrappers != null : !this.hidWrappers.equals(that.hidWrappers)) {
            return false;
        }
        return !(this.hidOperatorWrappers == null ? that.hidOperatorWrappers != null : !this.hidOperatorWrappers.equals(that.hidOperatorWrappers));
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.nOfFields;
        result = 31 * result + this.nOfFunctions;
        result = 31 * result + this.nOfArguments;
        result = 31 * result + this.nOfConstraints;
        result = 31 * result + this.nOfClosedScopes;
        result = 31 * result + (this.debug ? 1 : 0);
        result = 31 * result + (this.encryptedCodeAutoPaths != null ? this.encryptedCodeAutoPaths.hashCode() : 0);
        result = 31 * result + (this.encryptedCodePathsCache != null ? this.encryptedCodePathsCache.hashCode() : 0);
        result = 31 * result + (this.hidWrappers != null ? this.hidWrappers.hashCode() : 0);
        result = 31 * result + (this.hidOperatorWrappers != null ? this.hidOperatorWrappers.hashCode() : 0);
        return result;
    }

    private static class EncryptedCodeAutoPath
    implements Serializable {
        private static final long serialVersionUID = 1L;
        StringMatcher stringMatcher;
        boolean exclude;

        EncryptedCodeAutoPath(String pattern, boolean exclude) {
            this.stringMatcher = new StringMatcher(pattern, false, false, true);
            this.exclude = exclude;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.exclude ? 1231 : 1237);
            result = 31 * result + (this.stringMatcher == null ? 0 : this.stringMatcher.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof EncryptedCodeAutoPath)) {
                return false;
            }
            EncryptedCodeAutoPath other = (EncryptedCodeAutoPath)obj;
            if (this.exclude != other.exclude) {
                return false;
            }
            return !(this.stringMatcher == null ? other.stringMatcher != null : !this.stringMatcher.equals(other.stringMatcher));
        }
    }
}

