/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.lang.reflect.Field;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import ro.amiq.dvt.buildconfig.OverrideEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.EclipseUtils;

public class ExternalOverrideEditor
extends OverrideEditor {
    public ExternalOverrideEditor(String editorId, IEditorDescriptor descriptor) {
        super(editorId, descriptor);
    }

    public static ExternalOverrideEditor make(String editorString) {
        String[] paths;
        IPath iPath = Path.fromOSString((String)editorString);
        if (iPath.isAbsolute()) {
            File binary = iPath.toFile();
            if (binary.exists() && binary.canExecute()) {
                return new ExternalOverrideEditor(editorString, ExternalOverrideEditor.makeExternalDescriptor(binary.getAbsolutePath()));
            }
            return null;
        }
        String pathVarValue = System.getenv("PATH");
        if (pathVarValue == null) {
            return null;
        }
        String[] stringArray = paths = pathVarValue.split(File.pathSeparator);
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String pathEntry = stringArray[n2];
            File binary = new File(pathEntry, iPath.toOSString());
            if (binary.exists() && binary.canExecute()) {
                return new ExternalOverrideEditor(editorString, ExternalOverrideEditor.makeExternalDescriptor(binary.getAbsolutePath()));
            }
            ++n2;
        }
        return null;
    }

    private static IEditorDescriptor makeExternalDescriptor(String executablePath) {
        IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
        if (editorRegistry == null) {
            return null;
        }
        IEditorDescriptor platformDescriptor = editorRegistry.findEditor(executablePath);
        if (platformDescriptor != null) {
            return platformDescriptor;
        }
        try {
            EditorDescriptor descriptor = EditorDescriptor.createForProgram((String)executablePath);
            Field field = editorRegistry.getClass().getDeclaredField(EclipseUtils.isAtLeastEclipse422() ? "mapIDtoOSEditors" : "mapIDtoEditor");
            field.setAccessible(true);
            Map mapIDtoEditor = (Map)field.get(editorRegistry);
            mapIDtoEditor.put(descriptor.getId(), descriptor);
            return descriptor;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " (external)";
    }
}

