/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.buildconfig.FullChecksKind;
import ro.amiq.dvt.buildconfig.IEnumProvider;

public class FullChecksAndLibs
implements IEnumProvider,
Serializable {
    private static final long serialVersionUID = 1L;
    private FullChecksKind checksKind;
    private Map<String, Set<String>> libraryAndPackageNames;

    public FullChecksAndLibs(FullChecksKind value, Set<String> names) {
        this.checksKind = value;
        if (names != null) {
            if (this.checksKind.isLibs()) {
                this.libraryAndPackageNames = new HashMap<String, Set<String>>(names.size());
                for (String name : names) {
                    if (this.libraryAndPackageNames.containsKey(name)) continue;
                    this.libraryAndPackageNames.put(name, null);
                }
            } else if (this.checksKind.isPkgs()) {
                this.libraryAndPackageNames = new HashMap<String, Set<String>>(names.size());
                for (String name : names) {
                    int index = name.indexOf("::");
                    if (index > 0) {
                        String libraryName = name.substring(0, index);
                        Set<String> packages = this.libraryAndPackageNames.get(libraryName);
                        if (packages == null) {
                            packages = new HashSet<String>();
                            this.libraryAndPackageNames.put(libraryName, packages);
                        }
                        packages.add(name.substring(index + 2));
                        continue;
                    }
                    HashSet packages = new HashSet(0);
                    this.libraryAndPackageNames.put(name, packages);
                }
            }
        } else if (this.checksKind != FullChecksKind.FULL) {
            this.libraryAndPackageNames = new HashMap<String, Set<String>>();
        }
    }

    public FullChecksKind getFullChecksKind(boolean isLintingEnabled) {
        if (isLintingEnabled) {
            return FullChecksKind.FULL;
        }
        return this.checksKind;
    }

    public Map<String, Set<String>> getLibraryAndPackageNames(boolean isLintingEnabled) {
        if (isLintingEnabled) {
            return null;
        }
        return this.libraryAndPackageNames;
    }

    @Override
    public Class<?> getEnumClass() {
        return FullChecksKind.class;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.checksKind.toString());
        if (this.libraryAndPackageNames == null || this.libraryAndPackageNames.isEmpty()) {
            return result.toString();
        }
        result.append(this.libraryAndPackageNames.toString());
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.checksKind == null ? 0 : this.checksKind.hashCode());
        result = 31 * result + (this.libraryAndPackageNames == null ? 0 : this.libraryAndPackageNames.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FullChecksAndLibs)) {
            return false;
        }
        FullChecksAndLibs other = (FullChecksAndLibs)obj;
        if (this.checksKind != other.checksKind) {
            return false;
        }
        return !(this.libraryAndPackageNames == null ? other.libraryAndPackageNames != null : !this.libraryAndPackageNames.equals(other.libraryAndPackageNames));
    }
}

