/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigToken;
import ro.amiq.dvt.buildconfig.DirTok;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;

public class IncludeConfigHandler
implements IBuildConfigParserConstants {
    private BuildConfig currentIncludedConfig;
    private List<BuildConfig> includedConfigs = new ArrayList<BuildConfig>(2);
    private boolean isGenerateing;
    private boolean isRecording;
    private static final List<String> IGNORED_DIRECTIVES = Arrays.asList("-top", "+nctop", "+xmtop");

    protected boolean isRecording() {
        return this.isRecording;
    }

    void addConfig(DirTok dirTok, String compilationRootConsideringMinusF, String buildFilePath, String projectPath) {
        BuildConfig config = new BuildConfig(dirTok, compilationRootConsideringMinusF);
        config.buildFilePath = buildFilePath;
        config.projectPath = projectPath;
        this.includedConfigs.add(config);
        this.currentIncludedConfig = config;
    }

    public List<BuildConfig> getIncludedConfigs() {
        return this.includedConfigs;
    }

    void setCurrentIncludedConfig(BuildConfig currentIncludedConfig) {
        this.currentIncludedConfig = currentIncludedConfig;
    }

    boolean shouldIncludeConfig() {
        return !this.includedConfigs.isEmpty();
    }

    boolean shouldIgnoreDirective(String fullDirective) {
        return this.isIn(fullDirective, IGNORED_DIRECTIVES);
    }

    private boolean isIn(String fullDirective, List<String> directives) {
        for (String directive : directives) {
            if (!fullDirective.startsWith(directive) || fullDirective.length() != directive.length() && Character.isJavaIdentifierPart(fullDirective.charAt(directive.length()))) continue;
            return true;
        }
        return false;
    }

    public void reset() {
        this.includedConfigs.clear();
        this.currentIncludedConfig = null;
        this.isGenerateing = false;
    }

    public BuildConfig getCurrentIncludedConfig() {
        return this.currentIncludedConfig;
    }

    public boolean isGenerating() {
        return this.isGenerateing;
    }

    public void setGenerating(boolean isGenerateing) {
        this.isGenerateing = isGenerateing;
    }

    public String getProjectPath() {
        return this.currentIncludedConfig == null ? null : this.currentIncludedConfig.projectPath;
    }

    public String getBuildFilePath() {
        return this.currentIncludedConfig == null ? null : this.currentIncludedConfig.buildFilePath;
    }

    public void setRecording(boolean isRecording) {
        this.isRecording = isRecording;
    }

    static class BuildConfig {
        DirTok startDirTok;
        private String buildFilePath;
        private String projectPath;
        String fCompilationRootConsideringMinusF;
        private BuildConfigParser.InvocationState invocationState;
        public BuildConfigToken token;

        public BuildConfig(DirTok dirTok, String compilationRootConsideringMinusF) {
            this.startDirTok = dirTok;
            this.fCompilationRootConsideringMinusF = compilationRootConsideringMinusF;
        }

        public String getBuildFilePath() {
            return this.buildFilePath;
        }

        public void setBuildFilePath(String buildFilePath) {
            this.buildFilePath = buildFilePath;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public void setProjectPath(String projectPath) {
            this.projectPath = projectPath;
        }

        public void setInvocationState(BuildConfigParser.InvocationState invocationState) {
            this.invocationState = invocationState;
        }

        public BuildConfigParser.InvocationState getInvocationState() {
            return this.invocationState;
        }
    }
}

