/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.BuildConfigProperty;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.problems.DVTProblem;

public class Invocation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BuildConfigParser.InvocationState fState;
    private Map<String, String> fEnvVarCache;
    private int fIndex;

    public Invocation(BuildConfigParser.InvocationState state, int index) {
        this.fState = state;
        this.fIndex = index;
    }

    public List<BuildConfigProperty> getProperties() {
        if (this.fState.fProperties == null) {
            return Collections.emptyList();
        }
        return this.fState.fProperties;
    }

    public List<DVTProblem> getProblems() {
        if (this.fState.fProblems == null) {
            return Collections.emptyList();
        }
        return this.fState.fProblems;
    }

    public int getLine() {
        return this.fState.fStartLine;
    }

    public int getEndLine() {
        return this.fState.fEndLine;
    }

    public String getFilename() {
        return this.fState.fStartFile;
    }

    public IBuildConfigParserConstants.ToolCompat getToolCompat() {
        return this.fState.fToolCompat;
    }

    public String getLibName() {
        if (this.fState.fLibrary == null) {
            return "work";
        }
        return this.fState.fLibrary;
    }

    public String getPrecompiledLibName() {
        if (this.fState.fPrecompiledLibrary == null) {
            return this.getLibName();
        }
        return this.fState.fPrecompiledLibrary;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fState.fStartFile == null ? 0 : this.fState.fStartFile.hashCode());
        result = 31 * result + this.fState.fStartLine;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Invocation other = (Invocation)obj;
        if (this.fState.fStartFile == null ? other.fState.fStartFile != null : !this.fState.fStartFile.equals(other.fState.fStartFile)) {
            return false;
        }
        if (this.fState.fStartLine != other.fState.fStartLine) {
            return false;
        }
        return this.fState.fEndLine == other.fState.fEndLine;
    }

    public Map<String, String> getEnvVarCache() {
        if (this.fEnvVarCache == null) {
            this.fEnvVarCache = new HashMap<String, String>();
            for (BuildConfigProperty p : this.fState.fProperties) {
                if (p.getKind() != 13) continue;
                for (String k : p.getAttributes().keySet()) {
                    this.fEnvVarCache.put(k, (String)p.getAttribute(k));
                }
            }
        }
        return this.fEnvVarCache;
    }

    public boolean hasTopFiles() {
        for (BuildConfigProperty p : this.fState.fProperties) {
            if (p.getKind() != 0) continue;
            return true;
        }
        return false;
    }

    public IBuildConfigParserConstants.LanguageSyntax getSyntaxForUnmapped() {
        return this.fState.fSyntaxForUnmapped;
    }

    public Map<String, IBuildConfigParserConstants.LanguageSyntax> getExtensionSyntax() {
        return this.fState.fExtensionSyntax;
    }

    public BuildConfigParser.InvocationState getState() {
        return this.fState;
    }

    public String toString() {
        return this.fState.toString();
    }

    public Collection<File> getExtraWaivers() {
        return this.fState.fExtraWaivers;
    }

    public boolean hasEFiles() {
        return this.fState.fHasEFiles;
    }

    public int getIndex() {
        return this.fIndex;
    }

    protected void setIndex(int i) {
        this.fIndex = i;
    }
}

