/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.DirTok;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;

public class MakelibHandler
implements IBuildConfigParserConstants {
    private List<Makelib> makelibs = new ArrayList<Makelib>();
    private List<DirTok> invocationDirToks = new ArrayList<DirTok>();
    private Makelib currentMakelib;
    private BuildConfigParser parser;
    private DirTok uvmDirTok;
    private static final List<String> ILLEGAL_DIRECTIVES_INSIDE_MAKELIB = Arrays.asList("-work", "-uvm", "-uvmhome", "-uvmexthome", "-ml_uvm", "-ovm", "-ovmhome", "DVT_COMPILATION_ROOT", "-top", "+nctop", "+xmtop");
    private static final List<String> NON_REUSABLE_INVOCATION_DIRECTIVES = Arrays.asList("-top", "+nctop", "+xmtop");

    public MakelibHandler(BuildConfigParser buildConfigParser) {
        this.parser = buildConfigParser;
    }

    private void startRecording(String libname, DirTok dirTok, String compilationRootConsideringMinusF) {
        this.currentMakelib = new Makelib(libname, dirTok, compilationRootConsideringMinusF);
    }

    private void stopRecording(DirTok dirTok) {
        this.currentMakelib.endDirTok = dirTok;
        this.makelibs.add(this.currentMakelib);
        this.currentMakelib = null;
    }

    boolean shouldMakelib() {
        return !this.makelibs.isEmpty();
    }

    boolean doRecord(DirTok dirTok, String compilationRootConsideringMinusF) {
        if (this.isRecording()) {
            if (dirTok.directive.startsWith(this.getDirectiveStartString())) {
                this.stopRecording(dirTok);
                return this.doRecord(dirTok, compilationRootConsideringMinusF);
            }
            if (MAKELIB_ENDERS.contains(dirTok.directive)) {
                this.stopRecording(dirTok);
                return false;
            }
            if (this.isIn(dirTok.directive, ILLEGAL_DIRECTIVES_INSIDE_MAKELIB)) {
                this.parser.reportProblem(1, String.valueOf(dirTok.directive) + " cannot be used inside active " + this.getDirectiveStartString(), dirTok.token);
                return true;
            }
            if (dirTok.directive.startsWith("-F") || dirTok.directive.startsWith("-f")) {
                return false;
            }
            this.currentMakelib.toks.add(dirTok);
            return true;
        }
        if (dirTok.directive.startsWith(this.getDirectiveStartString())) {
            this.startRecording(this.computeLibName(dirTok), dirTok, compilationRootConsideringMinusF);
        } else if ("-endlib".equals(dirTok.directive)) {
            this.parser.reportProblem(1, String.valueOf(dirTok.directive) + " used outside active " + this.getDirectiveStartString(), dirTok.token);
        } else {
            if (!this.isIn(dirTok.directive, NON_REUSABLE_INVOCATION_DIRECTIVES)) {
                this.invocationDirToks.add(dirTok);
            }
            if (dirTok.directive.equals("-uvm") || dirTok.directive.startsWith("-uvmhome") || dirTok.directive.startsWith("-ml_uvm") || dirTok.directive.startsWith("-uvmexthome")) {
                this.uvmDirTok = dirTok;
            }
        }
        return false;
    }

    protected String getDirectiveStartString() {
        return "-makelib";
    }

    private boolean isIn(String fullDirective, List<String> directives) {
        for (String directive : directives) {
            if (!fullDirective.startsWith(directive) || fullDirective.length() != directive.length() && Character.isJavaIdentifierPart(fullDirective.charAt(directive.length()))) continue;
            return true;
        }
        return false;
    }

    private String computeLibName(DirTok dirTok) {
        String path = this.getLibPath(dirTok);
        if (path.isEmpty()) {
            return "work";
        }
        String pathName = path.contains(":") ? path.substring(path.lastIndexOf(58) + 1) : Path.fromOSString((String)path).lastSegment();
        if (!pathName.matches("[a-zA-Z]\\w*")) {
            this.parser.reportProblem(2, "Bad logical library name: " + pathName, dirTok.token);
        }
        return pathName;
    }

    protected String getLibPath(DirTok dirTok) {
        return dirTok.directive.substring("-makelib".length()).trim();
    }

    public boolean isRecording() {
        return this.currentMakelib != null;
    }

    void preparePlayback() {
        for (Makelib makelib : this.makelibs) {
            makelib.toks.addAll(0, this.invocationDirToks);
        }
    }

    List<Makelib> getMakelibs() {
        return this.makelibs;
    }

    public void ignore(DirTok dirTok) {
        if (!this.isRecording()) {
            this.invocationDirToks.remove(dirTok);
        }
    }

    public void reset() {
        this.makelibs.clear();
        this.invocationDirToks.clear();
        this.currentMakelib = null;
    }

    public DirTok getUvmDirTok() {
        return this.uvmDirTok;
    }

    public List<DirTok> getInvocationDirToks() {
        return this.invocationDirToks;
    }

    public Makelib getCurrentMakelib() {
        return this.currentMakelib;
    }

    BuildConfigParser.InvocationKind getKind() {
        return BuildConfigParser.InvocationKind.MAKELIB;
    }

    static class Makelib {
        DirTok startDirTok;
        DirTok endDirTok;
        String lib;
        List<DirTok> toks = new ArrayList<DirTok>();
        String fCompilationRootConsideringMinusF;

        public Makelib(String lib, DirTok dirTok, String compilationRootConsideringMinusF) {
            this.startDirTok = dirTok;
            this.lib = lib;
            this.fCompilationRootConsideringMinusF = compilationRootConsideringMinusF;
        }

        public void updateCompilationRootConsideringMinusF(String compilationRootConsideringMinusF) {
            this.fCompilationRootConsideringMinusF = compilationRootConsideringMinusF;
        }

        public String toString() {
            return String.valueOf(this.lib) + " : " + this.toks.stream().limit(3L).map(e -> e.directive).collect(Collectors.joining(" "));
        }
    }
}

