/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.ExternalOverrideEditor;
import ro.amiq.dvt.buildconfig.PredefinedOverrideEditor;

public class OverrideEditor {
    private String editorId;
    private IEditorDescriptor descriptor;

    public OverrideEditor(String editorId, IEditorDescriptor descriptor) {
        this.descriptor = descriptor;
        this.editorId = editorId;
    }

    public static OverrideEditor make(String editorString) {
        if (editorString == null) {
            return null;
        }
        PredefinedOverrideEditor predefOverrideEditor = PredefinedOverrideEditor.from(editorString);
        if (predefOverrideEditor != null) {
            return predefOverrideEditor;
        }
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        IEditorRegistry editorRegistry = workbench.getEditorRegistry();
        if (editorRegistry == null) {
            return null;
        }
        IEditorDescriptor editorDescriptor = editorRegistry.findEditor(editorString);
        if (editorDescriptor != null) {
            if (editorDescriptor.isOpenExternal()) {
                return new ExternalOverrideEditor(editorString, editorDescriptor);
            }
            return new OverrideEditor(editorString, editorDescriptor);
        }
        ExternalOverrideEditor externalOverrideEditor = ExternalOverrideEditor.make(editorString);
        if (externalOverrideEditor != null) {
            return externalOverrideEditor;
        }
        return null;
    }

    public IEditorDescriptor getEditorDescriptor() {
        return this.descriptor;
    }

    public String toString() {
        return String.valueOf(this.editorId) + (this.descriptor == null ? " (non-exsiting)" : "");
    }

    protected void setDescriptor(IEditorDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getEditorId() {
        return this.editorId;
    }
}

