/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import antlr.Token;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.buildconfig.IVarArgsHandler;
import ro.amiq.dvt.buildconfig.VarArgsHandlerStatus;

class PrecompilePragmaHandler
implements IVarArgsHandler {
    private static final Pattern LIB_PATTERN = Pattern.compile("([a-zA-Z0-9_]+)(.[a-zA-Z0-9_]+)?");
    Map<String, IBuildConfigParserConstants.LanguageSyntax> exts;

    PrecompilePragmaHandler() {
    }

    @Override
    public boolean isCompat(IBuildConfigParserConstants.ToolCompat toolCompat) {
        return IBuildConfigParserConstants.ToolCompat.QUESTA_QRUN == toolCompat;
    }

    @Override
    public boolean isArg(String arg) {
        Matcher libMatcher = LIB_PATTERN.matcher(arg);
        if (!libMatcher.matches()) {
            return false;
        }
        if (libMatcher.group(2) == null) {
            return true;
        }
        String extension = libMatcher.group(2);
        if (this.exts != null) {
            return !this.exts.containsKey(extension);
        }
        return true;
    }

    @Override
    public VarArgsHandlerStatus handle(String directive, BuildConfigParser parser) {
        if (!this.isCompat(parser.getToolCompat())) {
            return new VarArgsHandlerStatus(directive, false);
        }
        Token token = parser.getNextTokenApi();
        if (token == null) {
            return null;
        }
        this.exts = parser.getExtensionSyntaxMap();
        if (!this.isArg(token.getText())) {
            return new VarArgsHandlerStatus(token.getText(), true);
        }
        return new VarArgsHandlerStatus(token.getText(), false);
    }
}

