/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.buildconfig.OverrideEditor;

public class PredefinedOverrideEditor
extends OverrideEditor {
    private static final Map<String, PredefinedOverrideEditor> PREDEFINED_EDITORS_MAP = new LinkedHashMap<String, PredefinedOverrideEditor>();
    private String name;
    private final String pluginName;
    private boolean cached;

    static {
        new PredefinedOverrideEditor("SV", "ro.amiq.vlogdt.ui.editor.VlogEditor", "DVT");
        new PredefinedOverrideEditor("VHDL", "ro.amiq.vhdldt.ui.editor.VhdlEditor", "DVT");
        new PredefinedOverrideEditor("E", "ro.amiq.edt.ui.editor.EEditor", "DVT");
        new PredefinedOverrideEditor("SLN", "ro.amiq.slndt.ui.editor.SLNEditor", "DVT");
        new PredefinedOverrideEditor("PSS", "ro.amiq.pssdt.ui.editor.PSSEditor", "DVT");
        new PredefinedOverrideEditor("M-SDL", "ro.amiq.msdldt.ui.editor.MSDLEditor", "DVT");
        new PredefinedOverrideEditor("BC", "ro.amiq.dvt.ui.editor.BuildConfigEditor", "DVT");
        new PredefinedOverrideEditor("CPP", "org.eclipse.cdt.ui.editor.CEditor", "CDT");
        new PredefinedOverrideEditor("BASH", "basheditor.editors.BashEditor", "BASH");
        new PredefinedOverrideEditor("JAVA", "org.eclipse.jdt.ui.CompilationUnitEditor", "JDT");
        new PredefinedOverrideEditor("LUA", "org.eclipse.ldt.ui.editor", "LUA");
        new PredefinedOverrideEditor("PERL", "org.epic.perleditor.editors.PerlEditor", "PERL");
        new PredefinedOverrideEditor("PYTHON", "org.python.pydev.editor.PythonEditor", "PYTHON");
        new PredefinedOverrideEditor("RUBY", "org.eclipse.dltk.ruby.ui.editor.RubyEditor", "RUBY");
        new PredefinedOverrideEditor("TCL", "org.eclipse.dltk.tcl.ui.editor.TclEditor", "TCL");
    }

    public static final Set<String> names() {
        return PREDEFINED_EDITORS_MAP.keySet();
    }

    private PredefinedOverrideEditor(String name, String editorId, String pluginName) {
        super(editorId, null);
        this.pluginName = pluginName;
        this.name = name;
        PREDEFINED_EDITORS_MAP.put(name, this);
    }

    public static PredefinedOverrideEditor from(String name) {
        PredefinedOverrideEditor result = PREDEFINED_EDITORS_MAP.get(name);
        if (result == null) {
            return null;
        }
        if (!result.cached) {
            result.cached = true;
            IWorkbench workbench = PlatformUI.getWorkbench();
            if (workbench == null) {
                return null;
            }
            IEditorRegistry editorRegistry = workbench.getEditorRegistry();
            if (editorRegistry == null) {
                return null;
            }
            result.setDescriptor(editorRegistry.findEditor(result.getEditorId()));
        }
        return result;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public String toString() {
        return String.valueOf(this.name);
    }
}

