/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.util.ArrayList;
import java.util.List;
import ro.amiq.dvt.utils.DVTPair;

public class ResolvedDirective {
    private String directive;
    private List<DVTPair<String, List<String>>> fullPaths = new ArrayList<DVTPair<String, List<String>>>();
    private boolean isFromPrepend;
    private boolean hasWildcard;
    private boolean isInexistentPath;

    public ResolvedDirective(String directive) {
        this.directive = directive;
        this.isFromPrepend = false;
        this.isInexistentPath = false;
    }

    public ResolvedDirective(String directive, boolean isFromPrepend) {
        this.directive = directive;
        this.isFromPrepend = isFromPrepend;
        this.hasWildcard = false;
    }

    public String getDirective() {
        return this.directive;
    }

    public void setDirective(String directive) {
        this.directive = directive;
    }

    public List<DVTPair<String, List<String>>> getFullPaths() {
        return this.fullPaths;
    }

    public void addFullPath(String key, String fullPathValue) {
        ArrayList<String> fullPathsList = new ArrayList<String>();
        fullPathsList.add(fullPathValue);
        this.fullPaths.add(new DVTPair(key, fullPathsList));
    }

    public void addFullPath(String key, List<String> fullPathValues) {
        this.hasWildcard = true;
        ArrayList<String> fullPathsList = new ArrayList<String>();
        if (fullPathValues.isEmpty()) {
            fullPathsList.add(null);
        } else {
            fullPathsList.addAll(fullPathValues);
        }
        this.fullPaths.add(new DVTPair(key, fullPathsList));
    }

    public boolean isFromPrepend() {
        return this.isFromPrepend;
    }

    public boolean hasWildcard() {
        return this.hasWildcard;
    }

    public boolean isInexistentPath() {
        return this.isInexistentPath;
    }

    public void setInexistentPath(boolean isInexistentPath) {
        this.isInexistentPath = isInexistentPath;
    }

    public ResolvedDirective createDirectiveFromDirectiveName(String newDirective) {
        ResolvedDirective copyDirPath = new ResolvedDirective(newDirective, this.isFromPrepend);
        copyDirPath.hasWildcard = this.hasWildcard;
        copyDirPath.fullPaths = new ArrayList<DVTPair<String, List<String>>>(this.fullPaths);
        copyDirPath.isInexistentPath = this.isInexistentPath;
        return copyDirPath;
    }
}

