/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.ShallowCompileMode;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class ShallowCompileFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<ShallowCompile> shallowCompiles = new ArrayList<ShallowCompile>();

    public void add(String pattern, boolean regex, boolean allExcept, ShallowCompileMode mode) {
        if (pattern == null || pattern.isEmpty()) {
            return;
        }
        if (mode == ShallowCompileMode.FILE && ((pattern = DVTStringUtil.translatePathPatternToLinuxPattern(pattern)) == null || pattern.isEmpty())) {
            return;
        }
        this.shallowCompiles.add(new ShallowCompile(pattern, regex, allExcept, mode));
    }

    public void add(ShallowCompileFilter skipCompileFilter) {
        this.shallowCompiles.addAll(skipCompileFilter.shallowCompiles);
    }

    public boolean shouldShallow(String path, String fullyQualifiedName, ShallowCompileMode mode) {
        if (this.shallowCompiles.isEmpty()) {
            return false;
        }
        String workingPath = DVTStringUtil.translatePathPatternToLinuxPattern(path);
        String filename = Path.fromOSString((String)workingPath).lastSegment();
        if (filename != null && (filename.startsWith("__edt__") || filename.startsWith("__sln__") || filename.startsWith("__msdl__") || filename.startsWith("__pss__") || filename.startsWith("__vlog__") || filename.startsWith("__vhdl__"))) {
            return false;
        }
        boolean isFirstDirectiveShallowNot = this.shallowCompiles.get((int)0).allExcept;
        boolean shouldSkip = false;
        boolean matchFound = false;
        for (ShallowCompile shallow : this.shallowCompiles) {
            if (shallow.mode != ShallowCompileMode.FILE && shallow.mode != mode || matchFound && !(shouldSkip ^ !shallow.allExcept)) continue;
            String workingPattern = shallow.mode == ShallowCompileMode.FILE ? workingPath : fullyQualifiedName;
            boolean matches = shallow.pattern != null && shallow.pattern.matcher(workingPattern).matches();
            boolean bl = matches = matches || shallow.stringMatcher != null && shallow.stringMatcher.match(workingPattern);
            if (!matches) continue;
            matchFound = true;
            boolean bl2 = shouldSkip = !shallow.allExcept;
        }
        if (isFirstDirectiveShallowNot && !matchFound) {
            return true;
        }
        return shouldSkip;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (ShallowCompile shallowCompile : this.shallowCompiles) {
            result.append("[");
            if (shallowCompile.allExcept) {
                result.append("ALL_EXCEPT:");
            }
            if (shallowCompile.pattern != null) {
                result.append(shallowCompile.pattern.pattern());
            } else {
                result.append(shallowCompile.stringMatcher.toString());
            }
            result.append("]");
        }
        return result.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.shallowCompiles == null ? 0 : this.shallowCompiles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShallowCompileFilter)) {
            return false;
        }
        ShallowCompileFilter other = (ShallowCompileFilter)obj;
        return !(this.shallowCompiles == null ? other.shallowCompiles != null : !this.shallowCompiles.equals(other.shallowCompiles));
    }

    private static class ShallowCompile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean allExcept;
        Pattern pattern;
        StringMatcher stringMatcher;
        ShallowCompileMode mode;

        ShallowCompile(String pattern, boolean regex, boolean allExcept, ShallowCompileMode mode) {
            if (regex) {
                this.pattern = Pattern.compile(pattern);
            } else {
                this.stringMatcher = new StringMatcher(pattern, false, false, true);
            }
            this.allExcept = allExcept;
            this.mode = mode;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.allExcept ? 1231 : 1237);
            result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
            result = 31 * result + (this.stringMatcher == null ? 0 : this.stringMatcher.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ShallowCompile)) {
                return false;
            }
            ShallowCompile other = (ShallowCompile)obj;
            if (this.allExcept != other.allExcept) {
                return false;
            }
            if (this.mode != other.mode) {
                return false;
            }
            return !(this.stringMatcher == null ? other.stringMatcher != null : !this.stringMatcher.equals(other.stringMatcher));
        }
    }
}

