/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.StringMatcher;

public class SkipCompileFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient IProject project;
    private List<SkipCompile> skipCompiles = new ArrayList<SkipCompile>();

    public SkipCompileFilter(IProject project) {
        this.project = project;
    }

    public void add(String pattern, boolean regex, boolean allExcept) {
        if ((pattern = DVTStringUtil.translatePathPatternToLinuxPattern(pattern)) == null || pattern.isEmpty()) {
            return;
        }
        this.skipCompiles.add(new SkipCompile(pattern, regex, allExcept));
    }

    public void add(SkipCompileFilter skipCompileFilter) {
        this.skipCompiles.addAll(skipCompileFilter.skipCompiles);
    }

    public boolean shouldSkip(ParserPath path, boolean isFile) {
        boolean result = this.internalShouldSkip(path.path, isFile);
        BuildConfigManager.skip(this.project, path, result);
        return result;
    }

    private boolean internalShouldSkip(String path, boolean isFile) {
        String filename;
        if (this.skipCompiles.isEmpty()) {
            return false;
        }
        path = DVTStringUtil.translatePathPatternToLinuxPattern(path);
        if (!isFile && !path.endsWith("/")) {
            path = path.concat("/");
        }
        if ((filename = Path.fromOSString((String)path).lastSegment()) != null && (filename.startsWith("__edt__") || filename.startsWith("__sln__") || filename.startsWith("__msdl__") || filename.startsWith("__pss__") || filename.startsWith("__vlog__"))) {
            return false;
        }
        boolean isFirstDirectiveSkipNot = !this.skipCompiles.isEmpty() && this.skipCompiles.get((int)0).allExcept;
        boolean shouldSkip = false;
        boolean matchFound = false;
        for (SkipCompile skipCompile : this.skipCompiles) {
            boolean matches = skipCompile.pattern != null && skipCompile.pattern.matcher(path).matches();
            boolean bl = matches = matches || skipCompile.stringMatcher != null && skipCompile.stringMatcher.match(path);
            if (!matches) continue;
            matchFound = true;
            boolean bl2 = shouldSkip = !skipCompile.allExcept;
        }
        if (isFirstDirectiveSkipNot && !matchFound) {
            return true;
        }
        return shouldSkip;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (SkipCompile skipCompile : this.skipCompiles) {
            result.append("[");
            if (skipCompile.allExcept) {
                result.append("ALL_EXCEPT:");
            }
            if (skipCompile.pattern != null) {
                result.append(skipCompile.pattern.pattern());
            } else {
                result.append(skipCompile.stringMatcher.toString());
            }
            result.append("]");
        }
        return result.toString();
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.skipCompiles == null ? 0 : this.skipCompiles.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SkipCompileFilter)) {
            return false;
        }
        SkipCompileFilter other = (SkipCompileFilter)obj;
        return !(this.skipCompiles == null ? other.skipCompiles != null : !this.skipCompiles.equals(other.skipCompiles));
    }

    private static class SkipCompile
    implements Serializable {
        private static final long serialVersionUID = 1L;
        boolean allExcept;
        Pattern pattern;
        StringMatcher stringMatcher;

        SkipCompile(String pattern, boolean regex, boolean allExcept) {
            if (regex) {
                this.pattern = Pattern.compile(pattern);
            } else {
                this.stringMatcher = new StringMatcher(pattern, false, false, true);
            }
            this.allExcept = allExcept;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.allExcept ? 1231 : 1237);
            result = 31 * result + (this.stringMatcher == null ? 0 : this.stringMatcher.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SkipCompile)) {
                return false;
            }
            SkipCompile other = (SkipCompile)obj;
            if (this.allExcept != other.allExcept) {
                return false;
            }
            return !(this.stringMatcher == null ? other.stringMatcher != null : !this.stringMatcher.equals(other.stringMatcher));
        }
    }
}

