/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.builders.DVTBuildConsoleRegistry;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.utils.parser.Comment;

public class Svp2SvCommentMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PFILE = "PFILE";
    private static final String PFILE_GROUP = "(?<PFILE>";
    private Map<ParserPath, Set<ParserPath>> fSvp2SvMap = new HashMap<ParserPath, Set<ParserPath>>();
    private Set<ParserPath> fSvSet = new HashSet<ParserPath>();
    private Map<String, Pattern> fPatterns = new HashMap<String, Pattern>();
    private boolean fDebug;
    private transient IProject fProject;

    Svp2SvCommentMap(IProject project) {
        this.fProject = project;
    }

    public String findPFileSubstitute(String rawComment, ParserPath gCandidateParserPath) {
        if (this.fSvSet.contains(gCandidateParserPath)) {
            return null;
        }
        for (Pattern pattern : this.fPatterns.values()) {
            MatchResult matchResult = this.getMatchResult(pattern, rawComment);
            if (!matchResult.matched || matchResult.pfile == null) continue;
            ParserPath pfileParserPath = new ParserPath(matchResult.pfile);
            if (this.fSvp2SvMap.containsKey(pfileParserPath)) {
                return null;
            }
            IFileInfo fileInfo = DVTAutoLinkManager.getInstance().fetchFileInfo(Path.fromOSString((String)pfileParserPath.path));
            if (!fileInfo.exists() || fileInfo.isDirectory()) continue;
            LinkedHashSet<ParserPath> svs = new LinkedHashSet<ParserPath>();
            svs.add(gCandidateParserPath);
            this.fSvp2SvMap.put(pfileParserPath, svs);
            this.fSvSet.add(gCandidateParserPath);
            return pfileParserPath.path;
        }
        return null;
    }

    private void printDebug(Comment comment, ParserPath parserPath, Pattern pattern, String pfile) {
        String debugMessage = "*** PVLOG COMMENT MAP ***\nMatched pattern:\n'" + pattern.pattern() + "'" + (pfile == null ? "\nHowever the (?<PFILE> capturing group did not match any part of the input sequence!" : "\nMapping PVlog file:\n" + pfile + "\nto:" + "\n" + parserPath.path) + "\nGo to: " + parserPath + " at line " + comment.getStartLine() + "\n=================================== COMMENT ====================================\n" + comment.getComment() + "\n" + "================================================================================\n";
        DVTBuildConsoleRegistry.getConsole(this.fProject).print(debugMessage);
    }

    public String putWithErrorReporting(String patternString) {
        Pattern pattern = null;
        try {
            pattern = Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            return "Pattern '" + patternString + "' is not valid: " + e.getDescription();
        }
        if (pattern == null) {
            return "Pattern '" + patternString + "' is not valid";
        }
        if (!pattern.pattern().contains(PFILE_GROUP)) {
            return "Pattern '" + patternString + "' doesn't contain a " + PFILE_GROUP + " group";
        }
        this.fPatterns.put(patternString, pattern);
        return null;
    }

    public boolean hasPatterns() {
        return this.fProject != null && !this.fPatterns.isEmpty();
    }

    public boolean isEmpty() {
        return this.fProject == null || this.fSvp2SvMap.isEmpty();
    }

    public Set<ParserPath> get(ParserPath svpPath) {
        return this.fSvp2SvMap.get(svpPath);
    }

    public Set<ParserPath> keySet() {
        return this.fSvp2SvMap.keySet();
    }

    public void setDebug() {
        this.fDebug = true;
    }

    public String test(String testString) {
        if (testString.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (Pattern p : this.fPatterns.values()) {
            MatchResult matchResult = this.getMatchResult(p, testString);
            result.append("\n");
            if (matchResult.matched) {
                result.append("Pattern '" + p.pattern() + "'" + " matched.");
                if (matchResult.pfile != null) {
                    result.append(" PFILE is '" + matchResult.pfile + "'.");
                    continue;
                }
                result.append(" However the (?<PFILE> capturing group did not match any part of the input sequence!");
                continue;
            }
            result.append("Pattern '" + p.pattern() + "'" + " did not match.");
        }
        if (result.toString().isEmpty()) {
            return null;
        }
        return result.toString();
    }

    private MatchResult getMatchResult(Pattern p, String s) {
        Matcher m = p.matcher(s);
        String pfile = null;
        boolean matched = m.find();
        if (matched) {
            pfile = m.group(PFILE);
        }
        return new MatchResult(matched, pfile);
    }

    public String toString() {
        return "no mapping";
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    private static class MatchResult {
        boolean matched;
        String pfile;

        public MatchResult(boolean matched, String pfile) {
            this.matched = matched;
            this.pfile = pfile;
        }
    }
}

