/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Svp2SvDirectMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, Set<String>> fSv2SvpMap = new HashMap();
    private HashMap<String, Set<String>> fSvp2SvMap = new HashMap();

    public String putWithErrorReporting(String sv, String svp) {
        if (this.fSv2SvpMap.containsKey(sv)) {
            return String.valueOf(sv) + " already mapped as generated by the following PVerilog files: " + DVTStringUtil.join((Iterable<? extends Object>)this.fSv2SvpMap.get(sv), ", ");
        }
        if (this.fSvp2SvMap.containsKey(svp)) {
            return String.valueOf(svp) + " already mapped as PVerilog for generating the following files: " + DVTStringUtil.join((Iterable<? extends Object>)this.fSvp2SvMap.get(svp), ", ");
        }
        Set<String> svpList = this.fSv2SvpMap.get(sv);
        if (svpList == null) {
            svpList = new LinkedHashSet<String>();
            this.fSv2SvpMap.put(sv, svpList);
        }
        svpList.add(svp);
        Set<String> svList = this.fSvp2SvMap.get(svp);
        if (svList == null) {
            svList = new LinkedHashSet<String>();
            this.fSvp2SvMap.put(svp, svList);
        }
        svList.add(sv);
        return null;
    }

    public Set<String> getSvsFromFilename(String svpFilePath) {
        if (this.fSvp2SvMap.containsKey(svpFilePath)) {
            return this.fSvp2SvMap.get(svpFilePath);
        }
        return null;
    }

    public Set<String> getSvpsFromFileAbsolutePath(String svFilePath) {
        if (this.fSv2SvpMap.containsKey(svFilePath)) {
            return this.fSv2SvpMap.get(svFilePath);
        }
        return null;
    }

    public Set<String> getAllSvps() {
        return this.fSvp2SvMap.keySet();
    }

    public Set<String> getAllSvs() {
        return this.fSv2SvpMap.keySet();
    }

    public String toString() {
        if (this.fSvp2SvMap.isEmpty()) {
            return "No mapping";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.fSvp2SvMap.keySet().iterator();
        while (iterator.hasNext()) {
            String svp = iterator.next();
            sb.append(svp).append("=");
            sb.append("{");
            sb.append(DVTStringUtil.join(new ArrayList(this.fSvp2SvMap.get(svp)), ", "));
            sb.append("}");
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.fSvp2SvMap.isEmpty();
    }
}

