/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Svp2SvExtMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final transient Comparator<String> STRLEN_COMPARATOR = new ExtMapComparator();
    private TreeMap<String, Set<String>> fSv2SvpMap = new TreeMap(STRLEN_COMPARATOR);
    private TreeMap<String, Set<String>> fSvp2SvMap = new TreeMap(STRLEN_COMPARATOR);

    public String putWithErrorReporting(String sv, String svp) {
        if (this.fSv2SvpMap.containsKey(svp)) {
            return String.valueOf(svp) + " already mapped as generated by the following PVerilog files: " + DVTStringUtil.join((Iterable<? extends Object>)this.fSv2SvpMap.get(svp), ", ");
        }
        if (this.fSvp2SvMap.containsKey(sv)) {
            return String.valueOf(sv) + " already mapped as PVerilog for generating the following files: " + DVTStringUtil.join((Iterable<? extends Object>)this.fSvp2SvMap.get(sv), ", ");
        }
        Set<String> svpList = this.fSv2SvpMap.get(sv);
        if (svpList == null) {
            svpList = new LinkedHashSet<String>();
            this.fSv2SvpMap.put(sv, svpList);
        }
        svpList.add(svp);
        Set<String> svList = this.fSvp2SvMap.get(svp);
        if (svList == null) {
            svList = new LinkedHashSet<String>();
            this.fSvp2SvMap.put(svp, svList);
        }
        svList.add(sv);
        return null;
    }

    public Map.Entry<String, Set<String>> getSvsFromFilename(String svpFileName) {
        NavigableMap<String, Set<String>> descendingMap = this.fSvp2SvMap.descendingMap();
        for (Map.Entry<String, Set<String>> entry : descendingMap.entrySet()) {
            if (!svpFileName.endsWith("." + (String)entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public Map.Entry<String, Set<String>> getSvpsFromFilename(String svFileName) {
        NavigableMap<String, Set<String>> descendingMap = this.fSv2SvpMap.descendingMap();
        for (Map.Entry<String, Set<String>> entry : descendingMap.entrySet()) {
            if (!svFileName.endsWith("." + (String)entry.getKey())) continue;
            return entry;
        }
        return null;
    }

    public Set<String> getSvpExtensions() {
        return this.fSvp2SvMap.keySet();
    }

    public String toString() {
        if (this.fSvp2SvMap.isEmpty()) {
            return "No mapping";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = this.fSvp2SvMap.keySet().iterator();
        while (iterator.hasNext()) {
            String svp = iterator.next();
            sb.append(svp).append("=");
            sb.append("{");
            sb.append(DVTStringUtil.join(new ArrayList(this.fSvp2SvMap.get(svp)), ", "));
            sb.append("}");
            if (!iterator.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.fSvp2SvMap.isEmpty();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fSv2SvpMap == null ? 0 : this.fSv2SvpMap.hashCode());
        result = 31 * result + (this.fSvp2SvMap == null ? 0 : this.fSvp2SvMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Svp2SvExtMap)) {
            return false;
        }
        Svp2SvExtMap other = (Svp2SvExtMap)obj;
        if (this.fSv2SvpMap == null ? other.fSv2SvpMap != null : !this.fSv2SvpMap.equals(other.fSv2SvpMap)) {
            return false;
        }
        return !(this.fSvp2SvMap == null ? other.fSvp2SvMap != null : !this.fSvp2SvMap.equals(other.fSvp2SvMap));
    }

    private static class ExtMapComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private ExtMapComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.length() == o2.length()) {
                return o1.compareTo(o2);
            }
            return o1.length() - o2.length();
        }
    }
}

