/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.buildconfig;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.model.preproc.PreprocMappingsUtils;
import ro.amiq.dvt.utils.DVTStringUtil;

public class Svp2SvPatternTagMap
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final char TAG_START_CHAR = '<';
    private static final char TAG_END_CHAR = '>';
    private static final String ERROR_NO_PATTERN = "No pattern found";
    private static final String ERROR_UNBALANCED_BRACKETS = "Unbalanced angled brackets";
    private static final String ERROR_UNNAMED_TAG = "Unnamed tag";
    private static final String ERROR_SINGLE_TAG = "Pattern cannot be used without a constant part";
    private static final String ERROR_ADJACENT_TAGS = "Adjacent tags";
    private static final String DEFAULT_VALUE = "No mapping";
    private Map<TagPattern, TagPattern> fSv2SvpMap = new LinkedHashMap<TagPattern, TagPattern>();
    private Map<TagPattern, TagPattern> fSvp2SvMap = new LinkedHashMap<TagPattern, TagPattern>();

    public String putWithErrorReporting(String sv, String svp) {
        try {
            TagPattern svpPattern = new TagPattern(svp);
            TagPattern svPattern = new TagPattern(sv);
            this.testUsedTags(svpPattern, svPattern);
            this.fSv2SvpMap.put(svPattern, svpPattern);
            this.fSvp2SvMap.put(svpPattern, svPattern);
        }
        catch (BaseTagException ex) {
            return ex.getExplanation();
        }
        return null;
    }

    private void testPatternOverlap(TagPattern pattern) throws BaseTagException {
        String patternString = pattern.toString();
        for (Map.Entry<TagPattern, TagPattern> entry : this.fSv2SvpMap.entrySet()) {
            TagPattern existingPattern1 = entry.getKey();
            TagPattern existingPattern2 = entry.getValue();
            String existingPatternString1 = existingPattern1.toString();
            String existingPatternString2 = existingPattern2.toString();
            if (existingPattern1.parseTags(patternString) != null) {
                throw new PatternIsContainedException(patternString, existingPatternString1);
            }
            if (existingPattern2.parseTags(patternString) != null) {
                throw new PatternIsContainedException(patternString, existingPatternString2);
            }
            if (pattern.parseTags(existingPatternString1) != null) {
                throw new PatternContainsException(patternString, existingPatternString1);
            }
            if (pattern.parseTags(existingPatternString2) == null) continue;
            throw new PatternContainsException(patternString, existingPatternString2);
        }
    }

    private void testUsedTags(TagPattern pattern1, TagPattern pattern2) throws BaseTagException {
        LinkedHashSet<String> pattern1Tags = new LinkedHashSet<String>();
        LinkedHashSet<String> pattern2Tags = new LinkedHashSet<String>();
        for (BasePart part : pattern1.parts) {
            if (!(part instanceof TagPart)) continue;
            pattern1Tags.add(part.getContent());
        }
        for (BasePart part : pattern2.parts) {
            if (!(part instanceof TagPart)) continue;
            pattern2Tags.add(part.getContent());
        }
        LinkedHashSet<String> unusedTags = new LinkedHashSet<String>();
        for (String tag : pattern1Tags) {
            if (pattern2Tags.contains(tag)) continue;
            unusedTags.add(tag);
        }
        for (String tag : pattern2Tags) {
            if (pattern1Tags.contains(tag)) continue;
            unusedTags.add(tag);
        }
        if (!unusedTags.isEmpty()) {
            throw new UnusedTagsException(unusedTags);
        }
    }

    public String getFirstPairFileName(String fileName, PreprocMappingsUtils.PreprocMappingDirection mappingDirection) {
        List<String> pairFileNames = this.getPairFileNames(fileName, mappingDirection, 1);
        if (pairFileNames.isEmpty()) {
            return null;
        }
        return pairFileNames.get(0);
    }

    public List<String> getPairFileNames(String fileName, PreprocMappingsUtils.PreprocMappingDirection mappingDirection, int limit) {
        if (PreprocMappingsUtils.PreprocMappingDirection.G_TO_P.equals((Object)mappingDirection)) {
            return this.getPairFileNames(fileName, this.fSv2SvpMap, limit);
        }
        return this.getPairFileNames(fileName, this.fSvp2SvMap, limit);
    }

    private List<String> getPairFileNames(String fileName, Map<TagPattern, TagPattern> patternTagMap, int limit) {
        LinkedList<String> pairFileNames = new LinkedList<String>();
        for (Map.Entry<TagPattern, TagPattern> entry : patternTagMap.entrySet()) {
            if (limit <= 0) {
                return pairFileNames;
            }
            TagPattern pattern = entry.getKey();
            Map<String, String> tagToVariableMap = pattern.parseTags(fileName);
            if (tagToVariableMap == null) continue;
            pairFileNames.add(entry.getValue().fillTags(tagToVariableMap));
            --limit;
        }
        return pairFileNames;
    }

    public String toString() {
        return DEFAULT_VALUE;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fSv2SvpMap == null ? 0 : this.fSv2SvpMap.hashCode());
        result = 31 * result + (this.fSvp2SvMap == null ? 0 : this.fSvp2SvMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Svp2SvPatternTagMap)) {
            return false;
        }
        Svp2SvPatternTagMap other = (Svp2SvPatternTagMap)obj;
        if (this.fSv2SvpMap == null ? other.fSv2SvpMap != null : !this.fSv2SvpMap.equals(other.fSv2SvpMap)) {
            return false;
        }
        return !(this.fSvp2SvMap == null ? other.fSvp2SvMap != null : !this.fSvp2SvMap.equals(other.fSvp2SvMap));
    }

    private static class AdjacentTagsException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;

        public AdjacentTagsException(String extraDetails, int index) {
            super(extraDetails.substring(0, Math.min(index + 1, extraDetails.length())));
        }

        @Override
        protected String getErrorMessage() {
            return Svp2SvPatternTagMap.ERROR_ADJACENT_TAGS;
        }
    }

    public static abstract class BasePart
    implements Serializable {
        private static final long serialVersionUID = 1L;
        String content;

        protected BasePart(String content) {
            this.content = content;
        }

        public String getContent() {
            return this.content;
        }
    }

    private static abstract class BaseTagException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private String extraDetails;

        protected BaseTagException(String extraDetails) {
            this.extraDetails = extraDetails;
        }

        protected BaseTagException() {
        }

        public String getExplanation() {
            String extraDetailsString = "";
            if (this.extraDetails != null && !this.extraDetails.isEmpty()) {
                extraDetailsString = ": " + this.extraDetails;
            }
            return String.valueOf(this.getErrorMessage()) + extraDetailsString;
        }

        protected abstract String getErrorMessage();
    }

    private static class FixedPart
    extends BasePart {
        public FixedPart(String content) {
            super(content);
        }

        public String toString() {
            return this.getContent();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof FixedPart)) {
                return false;
            }
            return this.content.equals(((FixedPart)obj).getContent());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class NoPatternException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;

        public NoPatternException(String extraDetails) {
            super(extraDetails);
        }

        @Override
        protected String getErrorMessage() {
            return Svp2SvPatternTagMap.ERROR_NO_PATTERN;
        }
    }

    private static class PatternContainsException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;
        private String containingPattern;
        private String containedPattern;

        public PatternContainsException(String containingPattern, String containedPattern) {
            this.containingPattern = containingPattern;
            this.containedPattern = containedPattern;
        }

        @Override
        protected String getErrorMessage() {
            return "Pattern '" + this.containingPattern + "' overlaps '" + this.containedPattern + "'";
        }
    }

    private static class PatternIsContainedException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;
        private String containedPattern;
        private String containingPattern;

        public PatternIsContainedException(String containedPattern, String containingPattern) {
            this.containedPattern = containedPattern;
            this.containingPattern = containingPattern;
        }

        @Override
        protected String getErrorMessage() {
            return "Pattern '" + this.containedPattern + "' is overlapped by '" + this.containingPattern + "'";
        }
    }

    private static class SingleTagPatternException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;

        public SingleTagPatternException(String extraDetails) {
            super(extraDetails);
        }

        @Override
        protected String getErrorMessage() {
            return Svp2SvPatternTagMap.ERROR_SINGLE_TAG;
        }
    }

    private static class TagPart
    extends BasePart {
        public TagPart(String content) {
            super(content);
        }

        public String toString() {
            return String.valueOf('<') + this.getContent() + '>';
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TagPart)) {
                return false;
            }
            return this.content.equals(((TagPart)obj).getContent());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    private static class TagPattern
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final int DEFAULT_PATTERN_SIZE = 4;
        private List<BasePart> parts = new ArrayList<BasePart>(4);

        public TagPattern(String pattern) throws BaseTagException {
            this.createPartsFromPattern(pattern);
        }

        private void createPartsFromPattern(String pattern) throws BaseTagException {
            if (pattern == null || pattern.isEmpty()) {
                throw new NoPatternException(pattern);
            }
            int tagStartIndex = -1;
            int lastPartEndIndex = -1;
            int currIndex = 0;
            boolean atLeastOneFixedPart = false;
            while (currIndex < pattern.length()) {
                if (pattern.charAt(currIndex) == '<') {
                    if (lastPartEndIndex + 1 < currIndex) {
                        this.parts.add(new FixedPart(pattern.substring(lastPartEndIndex + 1, currIndex)));
                        atLeastOneFixedPart = true;
                    }
                    tagStartIndex = currIndex + 1;
                    ++currIndex;
                    continue;
                }
                if (pattern.charAt(currIndex) == '>') {
                    if (tagStartIndex == -1) {
                        throw new UnbalancedBracketsException(pattern, currIndex);
                    }
                    if (tagStartIndex == currIndex) {
                        throw new UnnamedTagException(pattern, currIndex);
                    }
                    int currSize = this.parts.size();
                    if (currSize >= 1 && this.parts.get(currSize - 1) instanceof TagPart) {
                        throw new AdjacentTagsException(pattern, currIndex);
                    }
                    this.parts.add(new TagPart(pattern.substring(tagStartIndex, currIndex)));
                    lastPartEndIndex = currIndex;
                    tagStartIndex = -1;
                }
                ++currIndex;
            }
            if (tagStartIndex != -1) {
                throw new UnbalancedBracketsException(pattern, currIndex);
            }
            if (lastPartEndIndex + 1 < currIndex) {
                this.parts.add(new FixedPart(pattern.substring(lastPartEndIndex + 1, currIndex)));
                atLeastOneFixedPart = true;
            }
            if (!atLeastOneFixedPart) {
                throw new SingleTagPatternException(pattern);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (BasePart part : this.parts) {
                sb.append(part.toString());
            }
            return sb.toString();
        }

        public Map<String, String> parseTags(String fileName) {
            HashMap<String, String> tagToVariableMap = new HashMap<String, String>();
            int tagStart = 0;
            int currIndex = 0;
            BasePart undiscoveredTagPart = null;
            for (BasePart part : this.parts) {
                if (part instanceof TagPart) {
                    tagStart = currIndex;
                    undiscoveredTagPart = (TagPart)part;
                    continue;
                }
                String partContent = part.getContent();
                int foundIndex = DVTStringUtil.matchFirstKMP(partContent, fileName, currIndex);
                if (foundIndex == -1) {
                    return null;
                }
                if (undiscoveredTagPart != null) {
                    String discoveredVariable = fileName.substring(tagStart, foundIndex);
                    if (discoveredVariable.isEmpty()) {
                        return null;
                    }
                    String tagString = undiscoveredTagPart.getContent();
                    String existingVariable = (String)tagToVariableMap.get(tagString);
                    if (existingVariable != null) {
                        if (!discoveredVariable.equals(existingVariable)) {
                            return null;
                        }
                    } else {
                        tagToVariableMap.put(tagString, discoveredVariable);
                    }
                    undiscoveredTagPart = null;
                }
                currIndex = foundIndex + partContent.length();
            }
            if (undiscoveredTagPart != null) {
                String discoveredVariable = fileName.substring(tagStart);
                String tagString = undiscoveredTagPart.getContent();
                String existingVariable = (String)tagToVariableMap.get(tagString);
                if (existingVariable != null) {
                    if (!discoveredVariable.equals(existingVariable)) {
                        return null;
                    }
                } else {
                    tagToVariableMap.put(tagString, discoveredVariable);
                }
                currIndex = fileName.length();
            }
            if (currIndex != fileName.length()) {
                return null;
            }
            return tagToVariableMap;
        }

        public String fillTags(Map<String, String> tagToVariableMap) {
            StringBuilder sb = new StringBuilder();
            for (BasePart part : this.parts) {
                if (part instanceof FixedPart) {
                    sb.append(part.getContent());
                    continue;
                }
                String variable = tagToVariableMap.get(part.getContent());
                if (variable == null) {
                    return null;
                }
                sb.append(variable);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof TagPattern)) {
                return false;
            }
            return this.parts.equals(((TagPattern)obj).parts);
        }

        public int hashCode() {
            return this.parts.hashCode();
        }
    }

    private static class UnbalancedBracketsException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;

        public UnbalancedBracketsException(String extraDetails, int index) {
            super(extraDetails.substring(0, Math.min(index + 1, extraDetails.length())));
        }

        @Override
        protected String getErrorMessage() {
            return Svp2SvPatternTagMap.ERROR_UNBALANCED_BRACKETS;
        }
    }

    private static class UnnamedTagException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;

        public UnnamedTagException(String extraDetails, int index) {
            super(extraDetails.substring(0, Math.min(index + 1, extraDetails.length())));
        }

        @Override
        protected String getErrorMessage() {
            return Svp2SvPatternTagMap.ERROR_UNNAMED_TAG;
        }
    }

    private static class UnusedTagsException
    extends BaseTagException {
        private static final long serialVersionUID = 1L;
        private Set<String> unusedTags;

        public UnusedTagsException(Set<String> unusedTags) {
            this.unusedTags = unusedTags;
        }

        @Override
        protected String getErrorMessage() {
            return "Unused tag" + (this.unusedTags.size() > 1 ? "s" : "") + ": " + DVTStringUtil.join(this.unusedTags, ", ");
        }
    }
}

